/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.utils.render;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.odinmain.OdinMain;
import me.odinmain.utils.VecUtilsKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.Colors;
import me.odinmain.utils.render.RenderUtils;
import me.odinmain.utils.render.RenderUtils2D;
import me.odinmain.utils.skyblock.WorldUtilsKt;
import me.odinmain.utils.ui.HudRenderUtilsKt;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016JR\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001cJF\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ2\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016J0\u0010\"\u001a\u00020\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J*\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010\u0015\u001a\u00020\u0016JP\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010-\u001a\u00020\u00162\b\b\u0002\u0010.\u001a\u00020\u00162\b\b\u0002\u0010/\u001a\u00020\u00162\b\b\u0002\u00100\u001a\u00020\u00162\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ>\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\u00052\u0006\u0010,\u001a\u00020%2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u00103\u001a\u00020'2\b\b\u0002\u00104\u001a\u00020\u0016J`\u00105\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020%2\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001e\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'J \u0010A\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u001f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\b\u0010E\u001a\u00020\fH\u0002J\u0010\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020HH\u0007J\u0010\u0010I\u001a\u00020\f2\u0006\u0010G\u001a\u00020JH\u0007J\u0010\u0010K\u001a\u00020\f2\u0006\u0010G\u001a\u00020LH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lme/odinmain/utils/render/Renderer;", "", "<init>", "()V", "DEFAULT_STYLE", "", "styles", "Ljava/util/ArrayList;", "getStyles", "()Ljava/util/ArrayList;", "STYLE_DESCRIPTION", "drawBox", "", "aabb", "Lnet/minecraft/util/AxisAlignedBB;", "color", "Lme/odinmain/utils/render/Color;", "outlineWidth", "", "outlineAlpha", "fillAlpha", "depth", "", "lineSmoothing", "drawBlock", "pos", "Lnet/minecraft/util/BlockPos;", "expand", "", "drawStyledBlock", "style", "", "width", "drawStyledBox", "draw3DLine", "points", "", "Lnet/minecraft/util/Vec3;", "lineWidth", "", "drawTracer", "goal", "drawCustomBeacon", "title", "vec3", "beacon", "increase", "noFade", "distance", "drawStringInWorld", "text", "scale", "shadow", "drawCylinder", "baseRadius", "topRadius", "height", "slices", "stacks", "rot1", "rot2", "rot3", "draw2DEntity", "entity", "Lnet/minecraft/entity/Entity;", "displayTitle", "titleTicks", "displayColor", "ticks", "clearTitle", "onOverlay", "event", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;", "onTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "worldLoad", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer.kt\nme/odinmain/utils/render/Renderer\n+ 2 RenderUtils.kt\nme/odinmain/utils/render/RenderUtils\n*L\n1#1,249:1\n69#2:250\n42#2,19:251\n*S KotlinDebug\n*F\n+ 1 Renderer.kt\nme/odinmain/utils/render/Renderer\n*L\n134#1:250\n134#1:251,19\n*E\n"})
public final class Renderer {
    @NotNull
    public static final Renderer INSTANCE = new Renderer();
    @NotNull
    public static final String DEFAULT_STYLE = "Outline";
    @NotNull
    private static final ArrayList<String> styles;
    @NotNull
    public static final String STYLE_DESCRIPTION = "How the box should be rendered.";
    @NotNull
    private static String displayTitle;
    private static int titleTicks;
    @NotNull
    private static Color displayColor;

    private Renderer() {
    }

    @NotNull
    public final ArrayList<String> getStyles() {
        return styles;
    }

    public final void drawBox(@NotNull AxisAlignedBB aabb, @NotNull Color color2, @NotNull Number outlineWidth, @NotNull Number outlineAlpha, @NotNull Number fillAlpha, boolean depth, boolean lineSmoothing2) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        Intrinsics.checkNotNullParameter(color2, "color");
        Intrinsics.checkNotNullParameter(outlineWidth, "outlineWidth");
        Intrinsics.checkNotNullParameter(outlineAlpha, "outlineAlpha");
        Intrinsics.checkNotNullParameter(fillAlpha, "fillAlpha");
        if (Intrinsics.areEqual(outlineAlpha, (Object)Float.valueOf(0.0f)) && Intrinsics.areEqual(fillAlpha, (Object)Float.valueOf(0.0f))) {
            return;
        }
        RenderUtils.INSTANCE.drawOutlinedAABB(aabb, Color.Companion.withAlpha$default(Color.Companion, color2, outlineAlpha.floatValue(), false, 2, null), outlineWidth, depth, lineSmoothing2);
        RenderUtils.INSTANCE.drawFilledAABB(aabb, Color.Companion.withAlpha$default(Color.Companion, color2, fillAlpha.floatValue(), false, 2, null), depth);
    }

    public static /* synthetic */ void drawBox$default(Renderer renderer, AxisAlignedBB axisAlignedBB, Color color2, Number number, Number number2, Number number3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            number = 3;
        }
        if ((n & 8) != 0) {
            number2 = 1;
        }
        if ((n & 0x10) != 0) {
            number3 = 1;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        renderer.drawBox(axisAlignedBB, color2, number, number2, number3, bl, bl2);
    }

    public final void drawBlock(@NotNull BlockPos pos, @NotNull Color color2, @NotNull Number outlineWidth, @NotNull Number outlineAlpha, @NotNull Number fillAlpha, boolean depth, boolean lineSmoothing2, double expand2) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(color2, "color");
        Intrinsics.checkNotNullParameter(outlineWidth, "outlineWidth");
        Intrinsics.checkNotNullParameter(outlineAlpha, "outlineAlpha");
        Intrinsics.checkNotNullParameter(fillAlpha, "fillAlpha");
        Block block = WorldUtilsKt.getBlockAt(pos);
        block.func_180654_a((IBlockAccess)OdinMain.INSTANCE.getMc().field_71441_e, pos);
        AxisAlignedBB axisAlignedBB = block.func_180646_a((World)OdinMain.INSTANCE.getMc().field_71441_e, pos);
        Intrinsics.checkNotNullExpressionValue(axisAlignedBB, "getSelectedBoundingBox(...)");
        AxisAlignedBB axisAlignedBB2 = RenderUtils.INSTANCE.outlineBounds(axisAlignedBB).func_72314_b(expand2, expand2, expand2);
        Intrinsics.checkNotNullExpressionValue(axisAlignedBB2, "expand(...)");
        this.drawBox(axisAlignedBB2, color2, outlineWidth, outlineAlpha, fillAlpha, depth, lineSmoothing2);
    }

    public static /* synthetic */ void drawBlock$default(Renderer renderer, BlockPos blockPos, Color color2, Number number, Number number2, Number number3, boolean bl, boolean bl2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            number = 3;
        }
        if ((n & 8) != 0) {
            number2 = 1;
        }
        if ((n & 0x10) != 0) {
            number3 = 1;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        if ((n & 0x80) != 0) {
            d = 0.0;
        }
        renderer.drawBlock(blockPos, color2, number, number2, number3, bl, bl2, d);
    }

    public final void drawStyledBlock(@NotNull BlockPos pos, @NotNull Color color2, int style2, @NotNull Number width, boolean depth, boolean lineSmoothing2, double expand2) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(color2, "color");
        Intrinsics.checkNotNullParameter(width, "width");
        switch (style2) {
            case 0: {
                this.drawBlock(pos, color2, width, 0, Float.valueOf(color2.getAlphaFloat()), depth, lineSmoothing2, expand2);
                break;
            }
            case 1: {
                this.drawBlock(pos, color2, width, Float.valueOf(color2.getAlphaFloat()), 0, depth, lineSmoothing2, expand2);
                break;
            }
            case 2: {
                this.drawBlock(pos, color2, width, Float.valueOf(color2.getAlphaFloat()), Float.valueOf(Color.Companion.multiplyAlpha(color2, 0.75f).getAlphaFloat()), depth, lineSmoothing2, expand2);
            }
        }
    }

    public static /* synthetic */ void drawStyledBlock$default(Renderer renderer, BlockPos blockPos, Color color2, int n, Number number, boolean bl, boolean bl2, double d, int n2, Object object) {
        if ((n2 & 8) != 0) {
            number = 3;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x40) != 0) {
            d = 0.0;
        }
        renderer.drawStyledBlock(blockPos, color2, n, number, bl, bl2, d);
    }

    public final void drawStyledBox(@NotNull AxisAlignedBB aabb, @NotNull Color color2, int style2, @NotNull Number width, boolean depth) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        Intrinsics.checkNotNullParameter(color2, "color");
        Intrinsics.checkNotNullParameter(width, "width");
        switch (style2) {
            case 0: {
                Renderer.drawBox$default(this, aabb, color2, width, 0, Float.valueOf(color2.getAlphaFloat()), depth, false, 64, null);
                break;
            }
            case 1: {
                Renderer.drawBox$default(this, aabb, color2, width, Float.valueOf(color2.getAlphaFloat()), 0, depth, false, 64, null);
                break;
            }
            case 2: {
                Renderer.drawBox$default(this, aabb, color2, width, Float.valueOf(color2.getAlphaFloat()), Float.valueOf(Color.Companion.multiplyAlpha(color2, 0.75f).getAlphaFloat()), depth, false, 64, null);
            }
        }
    }

    public static /* synthetic */ void drawStyledBox$default(Renderer renderer, AxisAlignedBB axisAlignedBB, Color color2, int n, Number number, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            number = 3;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        renderer.drawStyledBox(axisAlignedBB, color2, n, number, bl);
    }

    public final void draw3DLine(@NotNull Collection<? extends Vec3> points, @NotNull Color color2, float lineWidth2, boolean depth) {
        Intrinsics.checkNotNullParameter(points, "points");
        Intrinsics.checkNotNullParameter(color2, "color");
        RenderUtils.INSTANCE.drawLines(points, color2, lineWidth2, depth);
    }

    public static /* synthetic */ void draw3DLine$default(Renderer renderer, Collection collection, Color color2, float f, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            f = 3.0f;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        renderer.draw3DLine(collection, color2, f, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void drawTracer(@NotNull Vec3 goal, @NotNull Color color2, float lineWidth2, boolean depth) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(goal, "goal");
        Intrinsics.checkNotNullParameter(color2, "color");
        Vec3[] vec3Array = new Vec3[2];
        RenderUtils renderUtils = RenderUtils.INSTANCE;
        EntityPlayerSP entityPlayerSP = OdinMain.INSTANCE.getMc().field_71439_g;
        Intrinsics.checkNotNullExpressionValue(entityPlayerSP, "thePlayer");
        Entity $this$renderVec$iv = (Entity)entityPlayerSP;
        boolean $i$f$getRenderVec = false;
        void var9_9 = this_$iv;
        Entity $this$renderX$iv$iv = $this$renderVec$iv;
        boolean $i$f$getRenderX = false;
        double d = $this$renderX$iv$iv.field_70169_q + ($this$renderX$iv$iv.field_70165_t - $this$renderX$iv$iv.field_70169_q) * (double)this_$iv$iv.getPartialTicks();
        this_$iv$iv = this_$iv;
        Entity $this$renderY$iv$iv = $this$renderVec$iv;
        boolean $i$f$getRenderY = false;
        double d2 = $this$renderY$iv$iv.field_70167_r + ($this$renderY$iv$iv.field_70163_u - $this$renderY$iv$iv.field_70167_r) * (double)this_$iv$iv.getPartialTicks();
        this_$iv$iv = this_$iv;
        Entity $this$renderZ$iv$iv = $this$renderVec$iv;
        boolean $i$f$getRenderZ = false;
        vec3Array[0] = VecUtilsKt.addVec$default(new Vec3(d, d2, $this$renderZ$iv$iv.field_70166_s + ($this$renderZ$iv$iv.field_70161_v - $this$renderZ$iv$iv.field_70166_s) * (double)this_$iv$iv.getPartialTicks()), null, (Number)Float.valueOf(VecUtilsKt.fastEyeHeight()), null, 5, null);
        vec3Array[1] = goal;
        RenderUtils.INSTANCE.drawLines((Collection<? extends Vec3>)CollectionsKt.listOf(vec3Array), color2, lineWidth2, depth);
    }

    public static /* synthetic */ void drawTracer$default(Renderer renderer, Vec3 vec3, Color color2, float f, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            f = 3.0f;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        renderer.drawTracer(vec3, color2, f, bl);
    }

    public final void drawCustomBeacon(@NotNull String title, @NotNull Vec3 vec3, @NotNull Color color2, boolean beacon, boolean increase, boolean noFade, boolean distance2, int style2) {
        float alpha;
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(vec3, "vec3");
        Intrinsics.checkNotNullParameter(color2, "color");
        double dist = vec3.func_72438_d(OdinMain.INSTANCE.getMc().field_71439_g.func_174791_d());
        Renderer.drawStyledBox$default(this, VecUtilsKt.toAABB$default(vec3, 0.0, 1, null), color2, style2, null, false, 8, null);
        RenderUtils renderUtils = RenderUtils.INSTANCE;
        String string = distance2 ? title + " \u00a7r\u00a7f(\u00a73" + (int)dist + "m\u00a7f)" : title;
        Vec3 vec32 = VecUtilsKt.addVec(vec3, (Number)0.5, (Number)(1.7 + dist / (double)30), (Number)0.5);
        float f = increase ? (float)Math.max(0.03, dist / 200.0) : 0.06f;
        renderUtils.drawStringInWorld(string, vec32, color2, false, f, true);
        float f2 = alpha = noFade ? 1.0f : Math.min(1.0f, Math.max(0.0f, (float)dist) / 60.0f);
        if (beacon) {
            RenderUtils.drawBeaconBeam$default(RenderUtils.INSTANCE, vec3, Color.Companion.withAlpha$default(Color.Companion, color2, alpha, false, 2, null), true, 0, 8, null);
        }
    }

    public static /* synthetic */ void drawCustomBeacon$default(Renderer renderer, String string, Vec3 vec3, Color color2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl4 = true;
        }
        if ((n2 & 0x80) != 0) {
            n = 1;
        }
        renderer.drawCustomBeacon(string, vec3, color2, bl, bl2, bl3, bl4, n);
    }

    public final void drawStringInWorld(@NotNull String text, @NotNull Vec3 vec3, @NotNull Color color2, boolean depth, float scale, boolean shadow) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(vec3, "vec3");
        Intrinsics.checkNotNullParameter(color2, "color");
        RenderUtils.INSTANCE.drawStringInWorld(text, vec3, color2, depth, scale, shadow);
    }

    public static /* synthetic */ void drawStringInWorld$default(Renderer renderer, String string, Vec3 vec3, Color color2, boolean bl, float f, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            color2 = Colors.WHITE;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            f = 0.03f;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        renderer.drawStringInWorld(string, vec3, color2, bl, f, bl2);
    }

    public final void drawCylinder(@NotNull Vec3 pos, @NotNull Number baseRadius, @NotNull Number topRadius, @NotNull Number height, @NotNull Number slices, @NotNull Number stacks, @NotNull Number rot1, @NotNull Number rot2, @NotNull Number rot3, @NotNull Color color2, boolean depth) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(baseRadius, "baseRadius");
        Intrinsics.checkNotNullParameter(topRadius, "topRadius");
        Intrinsics.checkNotNullParameter(height, "height");
        Intrinsics.checkNotNullParameter(slices, "slices");
        Intrinsics.checkNotNullParameter(stacks, "stacks");
        Intrinsics.checkNotNullParameter(rot1, "rot1");
        Intrinsics.checkNotNullParameter(rot2, "rot2");
        Intrinsics.checkNotNullParameter(rot3, "rot3");
        Intrinsics.checkNotNullParameter(color2, "color");
        RenderUtils.INSTANCE.drawCylinder(pos, baseRadius, topRadius, height, slices, stacks, rot1, rot2, rot3, color2, depth);
    }

    public static /* synthetic */ void drawCylinder$default(Renderer renderer, Vec3 vec3, Number number, Number number2, Number number3, Number number4, Number number5, Number number6, Number number7, Number number8, Color color2, boolean bl, int n, Object object) {
        if ((n & 0x400) != 0) {
            bl = false;
        }
        renderer.drawCylinder(vec3, number, number2, number3, number4, number5, number6, number7, number8, color2, bl);
    }

    public final void draw2DEntity(@NotNull Entity entity, @NotNull Color color2, float lineWidth2) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(color2, "color");
        AxisAlignedBB axisAlignedBB = entity.func_174813_aQ();
        Intrinsics.checkNotNullExpressionValue(axisAlignedBB, "getEntityBoundingBox(...)");
        RenderUtils2D.INSTANCE.draw2DESP(axisAlignedBB, color2, lineWidth2);
    }

    public final void displayTitle(@NotNull String title, int ticks, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(color2, "color");
        displayTitle = title;
        titleTicks = ticks;
        displayColor = color2;
    }

    public static /* synthetic */ void displayTitle$default(Renderer renderer, String string, int n, Color color2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            color2 = Colors.WHITE;
        }
        renderer.displayTitle(string, n, color2);
    }

    private final void clearTitle() {
        displayTitle = "";
        titleTicks = 0;
    }

    @SubscribeEvent
    public final void onOverlay(@NotNull RenderGameOverlayEvent.Pre event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.type != RenderGameOverlayEvent.ElementType.ALL || titleTicks <= 0) {
            return;
        }
        OdinMain.INSTANCE.getMc().field_71460_t.func_78478_c();
        ScaledResolution sr = new ScaledResolution(OdinMain.INSTANCE.getMc());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)sr.func_78326_a() / 2.0f), (float)((float)sr.func_78328_b() / 2.5f), (float)1.0f);
        GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
        RenderUtils.drawText$default(RenderUtils.INSTANCE, displayTitle, 0.0f - (float)(HudRenderUtilsKt.getTextWidth(displayTitle) / 2), 0.0f, displayColor, false, 16, null);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public final void onTick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        int n = titleTicks;
        titleTicks = n + -1;
    }

    @SubscribeEvent
    public final void worldLoad(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.clearTitle();
    }

    static {
        String[] stringArray = new String[]{"Filled", DEFAULT_STYLE, "Filled Outline"};
        styles = CollectionsKt.arrayListOf(stringArray);
        displayTitle = "";
        displayColor = Colors.WHITE;
    }
}

