/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.utils.render;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.odinmain.OdinMain;
import me.odinmain.utils.VecUtilsKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.Colors;
import me.odinmain.utils.render.HighlightRenderer;
import me.odinmain.utils.render.RenderUtils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lme/odinmain/utils/render/RenderUtils2D;", "", "<init>", "()V", "modelViewMatrix", "Ljava/nio/FloatBuffer;", "projectionMatrix", "viewportDims", "Ljava/nio/IntBuffer;", "onRenderWorld", "", "event", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "worldToScreenPosition", "Lnet/minecraft/util/Vec3;", "vec3", "calculateBoundingBox", "Lme/odinmain/utils/render/RenderUtils2D$Box2D;", "aabb", "Lnet/minecraft/util/AxisAlignedBB;", "drawNameTag", "name", "", "draw2DESP", "color", "Lme/odinmain/utils/render/Color;", "thickness", "", "drawBox", "box", "lineWidth", "Box2D", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nRenderUtils2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderUtils2D.kt\nme/odinmain/utils/render/RenderUtils2D\n+ 2 RenderUtils.kt\nme/odinmain/utils/render/RenderUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VecUtils.kt\nme/odinmain/utils/VecUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n69#2:136\n42#2,19:137\n1#3:156\n340#4,2:157\n339#4,4:159\n1863#5,2:163\n*S KotlinDebug\n*F\n+ 1 RenderUtils2D.kt\nme/odinmain/utils/render/RenderUtils2D\n*L\n37#1:136\n37#1:137,19\n79#1:157,2\n79#1:159,4\n79#1:163,2\n*E\n"})
public final class RenderUtils2D {
    @NotNull
    public static final RenderUtils2D INSTANCE = new RenderUtils2D();
    @NotNull
    private static final FloatBuffer modelViewMatrix;
    @NotNull
    private static final FloatBuffer projectionMatrix;
    @NotNull
    private static IntBuffer viewportDims;

    private RenderUtils2D() {
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onRenderWorld(@NotNull RenderWorldLastEvent event) {
        IntBuffer intBuffer;
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        List<HighlightRenderer.HighlightEntity> list = HighlightRenderer.INSTANCE.getEntities().get((Object)HighlightRenderer.HighlightType.Box2d);
        boolean bl = list != null ? list.isEmpty() : false;
        if (bl) {
            return;
        }
        EntityPlayerSP entityPlayerSP = OdinMain.INSTANCE.getMc().field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        RenderUtils renderUtils = RenderUtils.INSTANCE;
        Entity $this$renderVec$iv = (Entity)entityPlayerSP;
        boolean $i$f$getRenderVec = false;
        void var8_9 = this_$iv;
        Entity $this$renderX$iv$iv = $this$renderVec$iv;
        boolean $i$f$getRenderX = false;
        double d = $this$renderX$iv$iv.field_70169_q + ($this$renderX$iv$iv.field_70165_t - $this$renderX$iv$iv.field_70169_q) * (double)this_$iv$iv.getPartialTicks();
        this_$iv$iv = this_$iv;
        Entity $this$renderY$iv$iv = $this$renderVec$iv;
        boolean $i$f$getRenderY = false;
        double d2 = $this$renderY$iv$iv.field_70167_r + ($this$renderY$iv$iv.field_70163_u - $this$renderY$iv$iv.field_70167_r) * (double)this_$iv$iv.getPartialTicks();
        this_$iv$iv = this_$iv;
        Entity $this$renderZ$iv$iv = $this$renderVec$iv;
        boolean $i$f$getRenderZ = false;
        Vec3 vec3 = new Vec3(d, d2, $this$renderZ$iv$iv.field_70166_s + ($this$renderZ$iv$iv.field_70161_v - $this$renderZ$iv$iv.field_70166_s) * (double)this_$iv$iv.getPartialTicks());
        double x = VecUtilsKt.component1(vec3);
        double y = VecUtilsKt.component2(vec3);
        double z = VecUtilsKt.component3(vec3);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        GL11.glGetFloat((int)2982, (FloatBuffer)modelViewMatrix);
        GL11.glGetFloat((int)2983, (FloatBuffer)projectionMatrix);
        GlStateManager.func_179121_F();
        IntBuffer $this$onRenderWorld_u24lambda_u240 = intBuffer = BufferUtils.createIntBuffer((int)4);
        boolean bl2 = false;
        $this$onRenderWorld_u24lambda_u240.put(0);
        $this$onRenderWorld_u24lambda_u240.put(0);
        $this$onRenderWorld_u24lambda_u240.put(OdinMain.INSTANCE.getMc().field_71443_c);
        $this$onRenderWorld_u24lambda_u240.put(OdinMain.INSTANCE.getMc().field_71440_d);
        $this$onRenderWorld_u24lambda_u240.flip();
        viewportDims = intBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Vec3 worldToScreenPosition(Vec3 vec3) {
        FloatBuffer coords2 = BufferUtils.createFloatBuffer((int)3);
        boolean success = Project.gluProject((float)((float)vec3.field_72450_a), (float)((float)vec3.field_72448_b), (float)((float)vec3.field_72449_c), (FloatBuffer)modelViewMatrix, (FloatBuffer)projectionMatrix, (IntBuffer)viewportDims, (FloatBuffer)coords2);
        Boolean bl = success;
        boolean it = bl;
        boolean bl2 = false;
        if (!it) return null;
        double d = coords2.get(2);
        if (!(0.0 <= d)) return null;
        if (!(d <= 1.0)) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        boolean bl4 = true;
        if (!bl4) return null;
        Boolean bl5 = bl;
        if (bl5 == null) return null;
        boolean $this$worldToScreenPosition_u24lambda_u242 = bl5;
        boolean bl6 = false;
        ScaledResolution sr = new ScaledResolution(OdinMain.INSTANCE.getMc());
        Vec3 vec32 = new Vec3((double)coords2.get(0) / (double)sr.func_78325_e(), (double)((float)sr.func_78328_b() - coords2.get(1) / (float)sr.func_78325_e()), (double)coords2.get(2));
        return vec32;
    }

    private final Box2D calculateBoundingBox(AxisAlignedBB aabb) {
        double x1 = 0.0;
        x1 = Double.MAX_VALUE;
        double x2 = 0.0;
        x2 = Double.MIN_VALUE;
        double y1 = 0.0;
        y1 = Double.MAX_VALUE;
        double y2 = 0.0;
        y2 = Double.MIN_VALUE;
        AxisAlignedBB $this$corners$iv = aabb;
        boolean $i$f$getCorners = false;
        Vec3[] vec3Array = new Vec3[]{new Vec3($this$corners$iv.field_72340_a, $this$corners$iv.field_72338_b, $this$corners$iv.field_72339_c), new Vec3($this$corners$iv.field_72340_a, $this$corners$iv.field_72337_e, $this$corners$iv.field_72339_c), new Vec3($this$corners$iv.field_72336_d, $this$corners$iv.field_72337_e, $this$corners$iv.field_72339_c), new Vec3($this$corners$iv.field_72336_d, $this$corners$iv.field_72338_b, $this$corners$iv.field_72339_c), new Vec3($this$corners$iv.field_72340_a, $this$corners$iv.field_72338_b, $this$corners$iv.field_72334_f), new Vec3($this$corners$iv.field_72340_a, $this$corners$iv.field_72337_e, $this$corners$iv.field_72334_f), new Vec3($this$corners$iv.field_72336_d, $this$corners$iv.field_72337_e, $this$corners$iv.field_72334_f), new Vec3($this$corners$iv.field_72336_d, $this$corners$iv.field_72338_b, $this$corners$iv.field_72334_f)};
        Iterable $this$forEach$iv = CollectionsKt.listOf(vec3Array);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vec3 vec;
            Vec3 vertex = (Vec3)element$iv;
            boolean bl = false;
            if (INSTANCE.worldToScreenPosition(vertex) == null) continue;
            boolean bl2 = false;
            x1 = RangesKt.coerceAtMost(x1, vec.field_72450_a);
            x2 = RangesKt.coerceAtLeast(x2, vec.field_72450_a);
            y1 = RangesKt.coerceAtMost(y1, vec.field_72448_b);
            y2 = RangesKt.coerceAtLeast(y2, vec.field_72448_b);
        }
        return !(x1 == Double.MAX_VALUE) ? new Box2D(x1, y1, x2, y2) : null;
    }

    public final void drawNameTag(@NotNull Vec3 vec3, @NotNull String name) {
        block0: {
            Intrinsics.checkNotNullParameter(vec3, "vec3");
            Intrinsics.checkNotNullParameter(name, "name");
            Vec3 vec32 = this.worldToScreenPosition(vec3);
            if (vec32 == null) break block0;
            Vec3 pos = vec32;
            boolean bl = false;
            OdinMain.INSTANCE.getMc().field_71466_p.func_175065_a(name, (float)pos.field_72450_a, (float)pos.field_72448_b, -1, true);
        }
    }

    public final void draw2DESP(@NotNull AxisAlignedBB aabb, @NotNull Color color2, float thickness2) {
        block0: {
            Intrinsics.checkNotNullParameter(aabb, "aabb");
            Intrinsics.checkNotNullParameter(color2, "color");
            Box2D box2D = this.calculateBoundingBox(aabb);
            if (box2D == null) break block0;
            Box2D box = box2D;
            boolean bl = false;
            INSTANCE.drawBox(box, color2, thickness2);
        }
    }

    public final void drawBox(@NotNull Box2D box, @NotNull Color color2, float lineWidth2) {
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(color2, "color");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)lineWidth2);
        RenderUtils.INSTANCE.bind(color2);
        RenderUtils.INSTANCE.getWorldRenderer().func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getX(), box.getY(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getW(), box.getY(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getW(), box.getY(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getW(), box.getH(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getW(), box.getH(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getX(), box.getH(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getX(), box.getH(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getWorldRenderer().func_181662_b(box.getX(), box.getY(), 0.0).func_181675_d();
        RenderUtils.INSTANCE.getTessellator().func_78381_a();
        RenderUtils.INSTANCE.bind(Colors.WHITE);
        GL11.glLineWidth((float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)2848);
        GlStateManager.func_179121_F();
    }

    static {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
        Intrinsics.checkNotNullExpressionValue(floatBuffer, "createFloatBuffer(...)");
        modelViewMatrix = floatBuffer;
        FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer((int)16);
        Intrinsics.checkNotNullExpressionValue(floatBuffer2, "createFloatBuffer(...)");
        projectionMatrix = floatBuffer2;
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)16);
        Intrinsics.checkNotNullExpressionValue(intBuffer, "createIntBuffer(...)");
        viewportDims = intBuffer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lme/odinmain/utils/render/RenderUtils2D$Box2D;", "", "x", "", "y", "w", "h", "<init>", "(DDDD)V", "getX", "()D", "getY", "getW", "getH", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "OdinMod"})
    public static final class Box2D {
        private final double x;
        private final double y;
        private final double w;
        private final double h;

        public Box2D(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getW() {
            return this.w;
        }

        public final double getH() {
            return this.h;
        }

        public final double component1() {
            return this.x;
        }

        public final double component2() {
            return this.y;
        }

        public final double component3() {
            return this.w;
        }

        public final double component4() {
            return this.h;
        }

        @NotNull
        public final Box2D copy(double x, double y, double w, double h) {
            return new Box2D(x, y, w, h);
        }

        public static /* synthetic */ Box2D copy$default(Box2D box2D, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = box2D.x;
            }
            if ((n & 2) != 0) {
                d2 = box2D.y;
            }
            if ((n & 4) != 0) {
                d3 = box2D.w;
            }
            if ((n & 8) != 0) {
                d4 = box2D.h;
            }
            return box2D.copy(d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "Box2D(x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.x);
            result = result * 31 + Double.hashCode(this.y);
            result = result * 31 + Double.hashCode(this.w);
            result = result * 31 + Double.hashCode(this.h);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Box2D)) {
                return false;
            }
            Box2D box2D = (Box2D)other;
            if (Double.compare(this.x, box2D.x) != 0) {
                return false;
            }
            if (Double.compare(this.y, box2D.y) != 0) {
                return false;
            }
            if (Double.compare(this.w, box2D.w) != 0) {
                return false;
            }
            return Double.compare(this.h, box2D.h) == 0;
        }
    }
}

