/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.utils.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import me.odinmain.utils.render.Colors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u001b\u0018\u0000 >2\u00020\u0001:\u0002=>B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u000bB+\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0007\u0010\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u00105\u001a\u00020$J\b\u00108\u001a\u00020\u0015H\u0016J\b\u00109\u001a\u00020\rH\u0016J\u0013\u0010:\u001a\u00020$2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010<\u001a\u00020\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR$\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001bR$\u0010 \u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0019\"\u0004\b\"\u0010\u001bR\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u00020\r8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0012R\u0012\u0010(\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b)\u0010&R\u0012\u0010*\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b+\u0010&R\u0012\u0010,\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b-\u0010&R\u0012\u0010\u0006\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b.\u0010&R\u0012\u0010/\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0019R\u0012\u00101\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0019R\u0012\u00103\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0019R\u0012\u00106\u001a\u00020$8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006?"}, d2={"Lme/odinmain/utils/render/Color;", "", "hue", "", "saturation", "brightness", "alpha", "<init>", "(FFFF)V", "hsb", "", "([FF)V", "r", "", "g", "b", "(IIIF)V", "rgba", "(I)V", "(IF)V", "hex", "", "(Ljava/lang/String;)V", "value", "getHue", "()F", "setHue", "(F)V", "getSaturation", "setSaturation", "getBrightness", "setBrightness", "alphaFloat", "getAlphaFloat", "setAlphaFloat", "needsUpdate", "", "getRgba", "()I", "setRgba", "red", "getRed", "green", "getGreen", "blue", "getBlue", "getAlpha", "redFloat", "getRedFloat", "greenFloat", "getGreenFloat", "blueFloat", "getBlueFloat", "includeAlpha", "isTransparent", "()Z", "toString", "hashCode", "equals", "other", "copy", "ColorSerializer", "Companion", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Color.kt\nme/odinmain/utils/render/Color\n+ 2 Color.kt\nme/odinmain/utils/render/Color$Companion\n*L\n1#1,179:1\n67#1:191\n68#1:193\n69#1:195\n67#1:197\n68#1:199\n69#1:201\n70#1:203\n122#2,4:180\n122#2,3:184\n122#2:187\n123#2:188\n124#2:189\n125#2:190\n122#2:192\n123#2:194\n124#2:196\n122#2:198\n123#2:200\n124#2:202\n125#2:204\n*S KotlinDebug\n*F\n+ 1 Color.kt\nme/odinmain/utils/render/Color\n*L\n72#1:191\n73#1:193\n74#1:195\n90#1:197\n90#1:199\n90#1:201\n90#1:203\n11#1:180,4\n12#1:184,3\n67#1:187\n68#1:188\n69#1:189\n70#1:190\n72#1:192\n73#1:194\n74#1:196\n90#1:198\n90#1:200\n90#1:202\n90#1:204\n*E\n"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float hue;
    private float saturation;
    private float brightness;
    private float alphaFloat;
    private transient boolean needsUpdate;
    private int rgba;

    public Color(float hue, float saturation, float brightness, float alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alphaFloat = alpha;
        this.needsUpdate = true;
    }

    public /* synthetic */ Color(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public Color(@NotNull float[] hsb, float alpha) {
        Intrinsics.checkNotNullParameter(hsb, "hsb");
        this(hsb[0], hsb[1], hsb[2], alpha);
    }

    public /* synthetic */ Color(float[] fArray, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(fArray, f);
    }

    public Color(int r, int g, int b, float alpha) {
        float[] fArray = java.awt.Color.RGBtoHSB(r, g, b, new float[3]);
        Intrinsics.checkNotNullExpressionValue(fArray, "RGBtoHSB(...)");
        this(fArray, alpha);
    }

    public /* synthetic */ Color(int n, int n2, int n3, float f, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, f);
    }

    public Color(int rgba) {
        Companion companion = Companion;
        int $this$red$iv = rgba;
        boolean $i$f$getRed = false;
        Companion this_$iv = Companion;
        int $this$green$iv = rgba;
        boolean $i$f$getGreen = false;
        this_$iv = Companion;
        int $this$blue$iv = rgba;
        boolean $i$f$getBlue = false;
        this_$iv = Companion;
        int $this$alpha$iv = rgba;
        boolean $i$f$getAlpha = false;
        this($this$red$iv >> 16 & 0xFF, $this$green$iv >> 8 & 0xFF, $this$blue$iv & 0xFF, (float)($this$alpha$iv >> 24 & 0xFF) / 255.0f);
    }

    public Color(int rgba, float alpha) {
        Companion companion = Companion;
        int $this$red$iv = rgba;
        boolean $i$f$getRed = false;
        Companion this_$iv = Companion;
        int $this$green$iv = rgba;
        boolean $i$f$getGreen = false;
        this_$iv = Companion;
        int $this$blue$iv = rgba;
        boolean $i$f$getBlue = false;
        this($this$red$iv >> 16 & 0xFF, $this$green$iv >> 8 & 0xFF, $this$blue$iv & 0xFF, alpha);
    }

    public Color(@NotNull String hex) {
        Intrinsics.checkNotNullParameter(hex, "hex");
        String string = hex.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        int n = Integer.parseInt(string, CharsKt.checkRadix(16));
        String string2 = hex.substring(2, 4);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        int n2 = Integer.parseInt(string2, CharsKt.checkRadix(16));
        String string3 = hex.substring(4, 6);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        int n3 = Integer.parseInt(string3, CharsKt.checkRadix(16));
        String string4 = hex.substring(6, 8);
        Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        this(n, n2, n3, (float)Integer.parseInt(string4, CharsKt.checkRadix(16)) / 255.0f);
    }

    public final float getHue() {
        return this.hue;
    }

    public final void setHue(float value) {
        this.hue = value;
        this.needsUpdate = true;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(float value) {
        this.saturation = value;
        this.needsUpdate = true;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(float value) {
        this.brightness = value;
        this.needsUpdate = true;
    }

    public final float getAlphaFloat() {
        return this.alphaFloat;
    }

    public final void setAlphaFloat(float value) {
        this.alphaFloat = value;
        this.needsUpdate = true;
    }

    public final int getRgba() {
        if (this.needsUpdate) {
            this.rgba = java.awt.Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF | (int)(this.alphaFloat * (float)255) << 24;
            this.needsUpdate = false;
        }
        return this.rgba;
    }

    public final void setRgba(int n) {
        this.rgba = n;
    }

    public final int getRed() {
        boolean $i$f$getRed = false;
        Companion companion = Companion;
        int $this$red$iv = this.getRgba();
        boolean $i$f$getRed2 = false;
        return $this$red$iv >> 16 & 0xFF;
    }

    public final int getGreen() {
        boolean $i$f$getGreen = false;
        Companion companion = Companion;
        int $this$green$iv = this.getRgba();
        boolean $i$f$getGreen2 = false;
        return $this$green$iv >> 8 & 0xFF;
    }

    public final int getBlue() {
        boolean $i$f$getBlue = false;
        Companion companion = Companion;
        int $this$blue$iv = this.getRgba();
        boolean $i$f$getBlue2 = false;
        return $this$blue$iv & 0xFF;
    }

    public final int getAlpha() {
        boolean $i$f$getAlpha = false;
        Companion companion = Companion;
        int $this$alpha$iv = this.getRgba();
        boolean $i$f$getAlpha2 = false;
        return $this$alpha$iv >> 24 & 0xFF;
    }

    public final float getRedFloat() {
        boolean $i$f$getRedFloat = false;
        Color this_$iv = this;
        boolean $i$f$getRed = false;
        Companion companion = Companion;
        int $this$red$iv$iv = this_$iv.getRgba();
        boolean $i$f$getRed2 = false;
        return (float)($this$red$iv$iv >> 16 & 0xFF) / 255.0f;
    }

    public final float getGreenFloat() {
        boolean $i$f$getGreenFloat = false;
        Color this_$iv = this;
        boolean $i$f$getGreen = false;
        Companion companion = Companion;
        int $this$green$iv$iv = this_$iv.getRgba();
        boolean $i$f$getGreen2 = false;
        return (float)($this$green$iv$iv >> 8 & 0xFF) / 255.0f;
    }

    public final float getBlueFloat() {
        boolean $i$f$getBlueFloat = false;
        Color this_$iv = this;
        boolean $i$f$getBlue = false;
        Companion companion = Companion;
        int $this$blue$iv$iv = this_$iv.getRgba();
        boolean $i$f$getBlue2 = false;
        return (float)($this$blue$iv$iv & 0xFF) / 255.0f;
    }

    @NotNull
    public final String hex(boolean includeAlpha) {
        String string;
        String hexString = HexExtensionsKt.toHexString(this.getRgba(), HexFormat.Companion.getUpperCase());
        if (includeAlpha) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = hexString.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            String string3 = hexString.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            string = stringBuilder2.append(string3).toString();
        } else {
            String string4 = hexString.substring(2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String hex$default(Color color2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return color2.hex(bl);
    }

    public final boolean isTransparent() {
        boolean $i$f$isTransparent = false;
        return this.getAlphaFloat() == 0.0f;
    }

    @NotNull
    public String toString() {
        Color this_$iv = this;
        boolean $i$f$getRed = false;
        Companion companion = Companion;
        int $this$red$iv$iv = this_$iv.getRgba();
        boolean $i$f$getRed2 = false;
        this_$iv = this;
        boolean $i$f$getGreen = false;
        Companion this_$iv$iv = Companion;
        int $this$green$iv$iv = this_$iv.getRgba();
        boolean $i$f$getGreen2 = false;
        this_$iv = this;
        boolean $i$f$getBlue = false;
        this_$iv$iv = Companion;
        int $this$blue$iv$iv = this_$iv.getRgba();
        boolean $i$f$getBlue2 = false;
        this_$iv = this;
        boolean $i$f$getAlpha = false;
        this_$iv$iv = Companion;
        int $this$alpha$iv$iv = this_$iv.getRgba();
        boolean $i$f$getAlpha2 = false;
        return "Color(red=" + ($this$red$iv$iv >> 16 & 0xFF) + ",green=" + ($this$green$iv$iv >> 8 & 0xFF) + ",blue=" + ($this$blue$iv$iv & 0xFF) + ",alpha=" + ($this$alpha$iv$iv >> 24 & 0xFF) + ')';
    }

    public int hashCode() {
        int result = (int)this.hue;
        result = 31 * result + (int)this.saturation;
        result = 31 * result + (int)this.brightness;
        result = 31 * result + (int)this.alphaFloat;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Color) {
            return this.getRgba() == ((Color)other).getRgba();
        }
        return false;
    }

    @NotNull
    public final Color copy() {
        return new Color(this.getRgba());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lme/odinmain/utils/render/Color$ColorSerializer;", "Lcom/google/gson/JsonSerializer;", "Lme/odinmain/utils/render/Color;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "OdinMod"})
    public static final class ColorSerializer
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        @NotNull
        public JsonElement serialize(@Nullable Color src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            StringBuilder stringBuilder = new StringBuilder().append('#');
            Object object = src;
            if (object == null || (object = Color.hex$default((Color)object, false, 1, null)) == null) {
                object = Color.hex$default(Colors.BLACK, false, 1, null);
            }
            return (JsonElement)new JsonPrimitive(stringBuilder.append((String)object).toString());
        }

        @NotNull
        public Color deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            Object object = json;
            if (object == null || (object = object.getAsString()) == null || (object = StringsKt.replace$default((String)object, "#", "", false, 4, null)) == null) {
                object = "00000000";
            }
            Object hexValue = object;
            return new Color((String)hexValue);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0014\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\n\u0010\u0018\u001a\u00020\u000f*\u00020\u000fR\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u0005*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\u00020\u0005*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0016\u0010\f\u001a\u00020\u0005*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lme/odinmain/utils/render/Color$Companion;", "", "<init>", "()V", "red", "", "getRed", "(I)I", "green", "getGreen", "blue", "getBlue", "alpha", "getAlpha", "brighter", "Lme/odinmain/utils/render/Color;", "factor", "", "hover", "darker", "withAlpha", "newInstance", "", "multiplyAlpha", "hsbMax", "OdinMod"})
    @SourceDebugExtension(value={"SMAP\nColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Color.kt\nme/odinmain/utils/render/Color$Companion\n+ 2 Color.kt\nme/odinmain/utils/render/Color\n*L\n1#1,179:1\n122#1:181\n123#1:183\n124#1:185\n122#1:187\n123#1:189\n124#1:191\n67#2:180\n68#2:182\n69#2:184\n67#2:186\n68#2:188\n69#2:190\n*S KotlinDebug\n*F\n+ 1 Color.kt\nme/odinmain/utils/render/Color$Companion\n*L\n140#1:181\n140#1:183\n140#1:185\n148#1:187\n148#1:189\n148#1:191\n140#1:180\n140#1:182\n140#1:184\n148#1:186\n148#1:188\n148#1:190\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getRed(int $this$red) {
            boolean $i$f$getRed = false;
            return $this$red >> 16 & 0xFF;
        }

        public final int getGreen(int $this$green) {
            boolean $i$f$getGreen = false;
            return $this$green >> 8 & 0xFF;
        }

        public final int getBlue(int $this$blue) {
            boolean $i$f$getBlue = false;
            return $this$blue & 0xFF;
        }

        public final int getAlpha(int $this$alpha) {
            boolean $i$f$getAlpha = false;
            return $this$alpha >> 24 & 0xFF;
        }

        @NotNull
        public final Color brighter(@NotNull Color $this$brighter, float factor) {
            Intrinsics.checkNotNullParameter($this$brighter, "<this>");
            return new Color($this$brighter.getHue(), $this$brighter.getSaturation(), RangesKt.coerceAtMost($this$brighter.getBrightness() * RangesKt.coerceAtLeast(factor, 1.0f), 1.0f), $this$brighter.getAlphaFloat());
        }

        public static /* synthetic */ Color brighter$default(Companion companion, Color color2, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 1.3f;
            }
            return companion.brighter(color2, f);
        }

        @NotNull
        public final Color hover(@NotNull Color $this$hover, float factor) {
            Intrinsics.checkNotNullParameter($this$hover, "<this>");
            return new Color($this$hover.getHue(), RangesKt.coerceAtMost($this$hover.getSaturation() * RangesKt.coerceAtLeast(factor, 1.0f), 1.0f), $this$hover.getBrightness(), $this$hover.getAlphaFloat());
        }

        public static /* synthetic */ Color hover$default(Companion companion, Color color2, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 1.2f;
            }
            return companion.hover(color2, f);
        }

        @NotNull
        public final Color darker(@NotNull Color $this$darker, float factor) {
            Intrinsics.checkNotNullParameter($this$darker, "<this>");
            return new Color($this$darker.getHue(), $this$darker.getSaturation(), $this$darker.getBrightness() * factor, $this$darker.getAlphaFloat());
        }

        public static /* synthetic */ Color darker$default(Companion companion, Color color2, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 0.7f;
            }
            return companion.darker(color2, f);
        }

        @NotNull
        public final Color withAlpha(@NotNull Color $this$withAlpha, float alpha, boolean newInstance) {
            Color color2;
            Intrinsics.checkNotNullParameter($this$withAlpha, "<this>");
            if (newInstance) {
                Color this_$iv = $this$withAlpha;
                boolean $i$f$getRed = false;
                Companion companion = Companion;
                int $this$red$iv$iv = this_$iv.getRgba();
                boolean $i$f$getRed2 = false;
                this_$iv = $this$withAlpha;
                boolean $i$f$getGreen = false;
                Companion this_$iv$iv = Companion;
                int $this$green$iv$iv = this_$iv.getRgba();
                boolean $i$f$getGreen2 = false;
                this_$iv = $this$withAlpha;
                boolean $i$f$getBlue = false;
                this_$iv$iv = Companion;
                int $this$blue$iv$iv = this_$iv.getRgba();
                boolean $i$f$getBlue2 = false;
                Color color3 = new Color($this$red$iv$iv >> 16 & 0xFF, $this$green$iv$iv >> 8 & 0xFF, $this$blue$iv$iv & 0xFF, alpha);
                color2 = color3;
            } else {
                $this$withAlpha.setAlphaFloat(alpha);
                color2 = $this$withAlpha;
            }
            return color2;
        }

        public static /* synthetic */ Color withAlpha$default(Companion companion, Color color2, float f, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.withAlpha(color2, f, bl);
        }

        @NotNull
        public final Color multiplyAlpha(@NotNull Color $this$multiplyAlpha, float factor) {
            Intrinsics.checkNotNullParameter($this$multiplyAlpha, "<this>");
            Color this_$iv = $this$multiplyAlpha;
            boolean $i$f$getRed = false;
            Companion companion = Companion;
            int $this$red$iv$iv = this_$iv.getRgba();
            boolean $i$f$getRed2 = false;
            this_$iv = $this$multiplyAlpha;
            boolean $i$f$getGreen = false;
            Companion this_$iv$iv = Companion;
            int $this$green$iv$iv = this_$iv.getRgba();
            boolean $i$f$getGreen2 = false;
            this_$iv = $this$multiplyAlpha;
            boolean $i$f$getBlue = false;
            this_$iv$iv = Companion;
            int $this$blue$iv$iv = this_$iv.getRgba();
            boolean $i$f$getBlue2 = false;
            return new Color($this$red$iv$iv >> 16 & 0xFF, $this$green$iv$iv >> 8 & 0xFF, $this$blue$iv$iv & 0xFF, RangesKt.coerceIn($this$multiplyAlpha.getAlphaFloat() * factor, 0.0f, 1.0f));
        }

        @NotNull
        public final Color hsbMax(@NotNull Color $this$hsbMax) {
            Intrinsics.checkNotNullParameter($this$hsbMax, "<this>");
            return new Color($this$hsbMax.getHue(), 1.0f, 1.0f, 0.0f, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

