/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.features.impl.dungeon.puzzlesolvers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.odinmain.OdinMain;
import me.odinmain.events.impl.RoomEnterEvent;
import me.odinmain.utils.Vec2;
import me.odinmain.utils.VecUtilsKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.Renderer;
import me.odinmain.utils.skyblock.ChatUtilsKt;
import me.odinmain.utils.skyblock.IceFillFloors;
import me.odinmain.utils.skyblock.WorldUtilsKt;
import me.odinmain.utils.skyblock.dungeon.DungeonListener;
import me.odinmain.utils.skyblock.dungeon.DungeonUtils;
import me.odinmain.utils.skyblock.dungeon.ScanUtils;
import me.odinmain.utils.skyblock.dungeon.tiles.Room;
import me.odinmain.utils.skyblock.dungeon.tiles.RoomData;
import me.odinmain.utils.skyblock.dungeon.tiles.Rotations;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010&\u001a\u00020\u0013R \u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0007j\b\u0012\u0004\u0012\u00020\u0006`\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lme/odinmain/features/impl/dungeon/puzzlesolvers/IceFillSolver;", "", "<init>", "()V", "currentPatterns", "Lkotlin/collections/ArrayList;", "Lnet/minecraft/util/Vec3;", "Ljava/util/ArrayList;", "Ljava/util/ArrayList;", "representativeFloors", "", "", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "isr", "Ljava/io/InputStreamReader;", "onRenderWorld", "", "color", "Lme/odinmain/utils/render/Color;", "onRoomEnter", "event", "Lme/odinmain/events/impl/RoomEnterEvent;", "optimizePatterns", "", "scanAllFloors", "pos", "rotation", "Lme/odinmain/utils/skyblock/dungeon/tiles/Rotations;", "transform", "Lme/odinmain/utils/Vec2;", "x", "z", "transformTo", "vec", "Lnet/minecraft/util/Vec3i;", "reset", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nIceFillSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceFillSolver.kt\nme/odinmain/features/impl/dungeon/puzzlesolvers/IceFillSolver\n+ 2 DungeonUtils.kt\nme/odinmain/utils/skyblock/dungeon/DungeonUtils\n+ 3 DungeonListener.kt\nme/odinmain/utils/skyblock/dungeon/DungeonListener\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n75#2:97\n39#3:98\n1872#4,2:99\n1557#4:101\n1628#4,3:102\n1874#4:105\n1#5:106\n*S KotlinDebug\n*F\n+ 1 IceFillSolver.kt\nme/odinmain/features/impl/dungeon/puzzlesolvers/IceFillSolver\n*L\n45#1:97\n45#1:98\n57#1:99,2\n69#1:101\n69#1:102,3\n57#1:105\n*E\n"})
public final class IceFillSolver {
    @NotNull
    public static final IceFillSolver INSTANCE;
    @NotNull
    private static ArrayList<Vec3> currentPatterns;
    @NotNull
    private static List<? extends List<? extends List<Integer>>> representativeFloors;
    private static final Gson gson;
    @Nullable
    private static final InputStreamReader isr;

    private IceFillSolver() {
    }

    public final void onRenderWorld(@NotNull Color color2) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(color2, "color");
                if (currentPatterns.isEmpty()) break block4;
                DungeonUtils this_$iv = DungeonUtils.INSTANCE;
                boolean $i$f$getCurrentRoomName = false;
                DungeonListener this_$iv$iv = DungeonListener.INSTANCE;
                boolean $i$f$getCurrentRoom = false;
                Object object = ScanUtils.INSTANCE.getCurrentRoom();
                if (object == null || (object = ((Room)object).getData()) == null || (object = ((RoomData)object).getName()) == null) {
                    object = "Unknown";
                }
                if (Intrinsics.areEqual(object, "Ice Fill")) break block5;
            }
            return;
        }
        Renderer.draw3DLine$default(Renderer.INSTANCE, currentPatterns, color2, 0.0f, true, 4, null);
    }

    public final void onRoomEnter(@NotNull RoomEnterEvent event, boolean optimizePatterns) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Room $this$onRoomEnter_u24lambda_u241 = event.getRoom();
        boolean bl = false;
        Object object = $this$onRoomEnter_u24lambda_u241;
        if (!Intrinsics.areEqual(object != null && (object = ((Room)object).getData()) != null ? ((RoomData)object).getName() : null, "Ice Fill") || !((Collection)currentPatterns).isEmpty()) {
            return;
        }
        INSTANCE.scanAllFloors(VecUtilsKt.toVec3(DungeonUtils.INSTANCE.getRealCoords($this$onRoomEnter_u24lambda_u241, 15, 70, 7)), $this$onRoomEnter_u24lambda_u241.getRotation(), optimizePatterns);
    }

    /*
     * WARNING - void declaration
     */
    private final void scanAllFloors(Vec3 pos, Rotations rotation, boolean optimizePatterns) {
        Vec3[] vec3Array = new Vec3[]{pos, pos.func_178787_e(this.transformTo(new Vec3i(5, 1, 0), rotation)), pos.func_178787_e(this.transformTo(new Vec3i(12, 2, 0), rotation))};
        Iterable $this$forEachIndexed$iv = CollectionsKt.listOf(vec3Array);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vec3 vec3 = (Vec3)item$iv;
            int floorIndex = n;
            boolean bl = false;
            List<? extends List<Integer>> floorHeight = representativeFloors.get(floorIndex);
            long startTime = System.nanoTime();
            int n2 = floorHeight.size();
            for (int patternIndex = 0; patternIndex < n2; ++patternIndex) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void startPosition;
                if (!WorldUtilsKt.isAir(VecUtilsKt.add(new BlockPos((Vec3)startPosition), INSTANCE.transform(((Number)floorHeight.get(patternIndex).get(0)).intValue(), ((Number)floorHeight.get(patternIndex).get(1)).intValue(), rotation))) || WorldUtilsKt.isAir(VecUtilsKt.add(new BlockPos((Vec3)startPosition), INSTANCE.transform(((Number)floorHeight.get(patternIndex).get(2)).intValue(), ((Number)floorHeight.get(patternIndex).get(3)).intValue(), rotation)))) continue;
                ChatUtilsKt.modMessage$default("Section " + floorIndex + " scan took " + (double)(System.nanoTime() - startTime) / 1000000.0 + "ms pattern: " + patternIndex, null, null, 6, null);
                List<Vec3i> it = ArraysKt.toMutableList(optimizePatterns ? IceFillFloors.INSTANCE.getAdvanced()[floorIndex][patternIndex] : IceFillFloors.INSTANCE.getIceFillFloors()[floorIndex][patternIndex]);
                boolean bl2 = false;
                Iterable iterable = it;
                ArrayList<Vec3> arrayList = currentPatterns;
                boolean $i$f$map = false;
                void var23_22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Vec3i vec3i = (Vec3i)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(startPosition);
                    collection.add(VecUtilsKt.addVec((Vec3)startPosition, (Number)0.5, (Number)0.1, (Number)0.5).func_178787_e(INSTANCE.transformTo((Vec3i)it2, rotation)));
                }
                arrayList.addAll((List)destination$iv$iv);
                continue block0;
            }
            ChatUtilsKt.modMessage$default("\u00a7cFailed to scan floor " + (floorIndex + 1), null, null, 6, null);
        }
    }

    private final Vec2 transform(int x, int z, Rotations rotation) {
        Vec2 vec2;
        switch (WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
            case 1: {
                vec2 = new Vec2(z, -x);
                break;
            }
            case 2: {
                vec2 = new Vec2(-x, -z);
                break;
            }
            case 3: {
                vec2 = new Vec2(-z, x);
                break;
            }
            case 4: {
                vec2 = new Vec2(x, z);
                break;
            }
            default: {
                vec2 = new Vec2(x, z);
            }
        }
        return vec2;
    }

    private final Vec3 transformTo(Vec3i vec, Rotations rotation) {
        Vec2 $this$transformTo_u24lambda_u245 = this.transform(vec.func_177958_n(), vec.func_177952_p(), rotation);
        boolean bl = false;
        return new Vec3((double)$this$transformTo_u24lambda_u245.getX(), (double)vec.func_177956_o(), (double)$this$transformTo_u24lambda_u245.getZ());
    }

    public final void reset() {
        currentPatterns.clear();
    }

    static {
        InputStreamReader inputStreamReader;
        INSTANCE = new IceFillSolver();
        currentPatterns = new ArrayList();
        gson = new GsonBuilder().setPrettyPrinting().create();
        Object object = INSTANCE.getClass().getResourceAsStream("/icefillFloors.json");
        if (object != null) {
            InputStream it = object;
            boolean bl = false;
            inputStreamReader = new InputStreamReader(it, StandardCharsets.UTF_8);
        } else {
            inputStreamReader = null;
        }
        isr = inputStreamReader;
        try {
            Unit unit;
            InputStreamReader inputStreamReader2 = isr;
            String text = inputStreamReader2 != null ? TextStreamsKt.readText(inputStreamReader2) : null;
            representativeFloors = (List)gson.fromJson(text, new TypeToken<List<? extends List<? extends List<? extends Integer>>>>(){}.getType());
            InputStreamReader inputStreamReader3 = isr;
            if (inputStreamReader3 != null) {
                inputStreamReader3.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = unit;
        }
        catch (Exception e) {
            OdinMain.INSTANCE.getLogger().error("Error loading ice fill floors", (Throwable)e);
            representativeFloors = CollectionsKt.emptyList();
            object = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Rotations.values().length];
            try {
                nArray[Rotations.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotations.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotations.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotations.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

