/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.features.impl.dungeon.puzzlesolvers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.odinmain.OdinMain;
import me.odinmain.features.impl.dungeon.puzzlesolvers.BlazeSolver;
import me.odinmain.features.impl.dungeon.puzzlesolvers.PuzzleSolvers;
import me.odinmain.utils.Utils;
import me.odinmain.utils.VecUtilsKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.RenderUtils;
import me.odinmain.utils.render.Renderer;
import me.odinmain.utils.skyblock.ChatUtilsKt;
import me.odinmain.utils.skyblock.Island;
import me.odinmain.utils.skyblock.LocationUtils;
import me.odinmain.utils.skyblock.dungeon.DungeonListener;
import me.odinmain.utils.skyblock.dungeon.DungeonUtils;
import me.odinmain.utils.skyblock.dungeon.Puzzle;
import me.odinmain.utils.skyblock.dungeon.PuzzleStatus;
import me.odinmain.utils.skyblock.dungeon.ScanUtils;
import me.odinmain.utils.skyblock.dungeon.tiles.Room;
import me.odinmain.utils.skyblock.dungeon.tiles.RoomData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJV\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/odinmain/features/impl/dungeon/puzzlesolvers/BlazeSolver;", "", "<init>", "()V", "blazes", "", "Lnet/minecraft/entity/item/EntityArmorStand;", "roomType", "", "lastBlazeCount", "blazeHealthRegex", "Lkotlin/text/Regex;", "getBlaze", "", "onRenderWorld", "blazeLineNext", "", "blazeLineAmount", "blazeStyle", "blazeFirstColor", "Lme/odinmain/utils/render/Color;", "blazeSecondColor", "blazeAllColor", "blazeWidth", "", "blazeHeight", "blazeSendComplete", "blazeLineWidth", "reset", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nBlazeSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlazeSolver.kt\nme/odinmain/features/impl/dungeon/puzzlesolvers/BlazeSolver\n+ 2 DungeonUtils.kt\nme/odinmain/utils/skyblock/dungeon/DungeonUtils\n+ 3 DungeonListener.kt\nme/odinmain/utils/skyblock/dungeon/DungeonListener\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Utils.kt\nme/odinmain/utils/Utils\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 RenderUtils.kt\nme/odinmain/utils/render/RenderUtils\n+ 8 VecUtils.kt\nme/odinmain/utils/VecUtilsKt\n*L\n1#1,76:1\n99#2:77\n24#2:79\n75#2:87\n75#2:90\n39#3:78\n39#3:88\n39#3:91\n1863#4:80\n1864#4:82\n1019#4,2:83\n1010#4,2:85\n1872#4,2:92\n1874#4:129\n36#5:81\n1#6:89\n69#7:94\n42#7,19:95\n78#7,2:114\n42#7:116\n80#7:117\n51#7:118\n81#7:119\n60#7:120\n82#7:121\n42#7:122\n83#7:123\n51#7:124\n84#7:125\n60#7:126\n85#7:127\n351#8:128\n*S KotlinDebug\n*F\n+ 1 BlazeSolver.kt\nme/odinmain/features/impl/dungeon/puzzlesolvers/BlazeSolver\n*L\n29#1:77\n30#1:79\n44#1:87\n49#1:90\n29#1:78\n44#1:88\n49#1:91\n33#1:80\n33#1:82\n39#1:83,2\n40#1:85,2\n55#1:92,2\n55#1:129\n35#1:81\n66#1:94\n66#1:95,19\n66#1:114,2\n66#1:116\n66#1:117\n66#1:118\n66#1:119\n66#1:120\n66#1:121\n66#1:122\n66#1:123\n66#1:124\n66#1:125\n66#1:126\n66#1:127\n66#1:128\n*E\n"})
public final class BlazeSolver {
    @NotNull
    public static final BlazeSolver INSTANCE = new BlazeSolver();
    @NotNull
    private static List<EntityArmorStand> blazes = new ArrayList();
    private static int roomType;
    private static int lastBlazeCount;
    @NotNull
    private static final Regex blazeHealthRegex;

    private BlazeSolver() {
    }

    public final void getBlaze() {
        Map hpMap;
        Room room;
        block17: {
            block16: {
                block15: {
                    DungeonUtils this_$iv = DungeonUtils.INSTANCE;
                    boolean $i$f$getCurrentRoom = false;
                    DungeonListener this_$iv$iv = DungeonListener.INSTANCE;
                    boolean $i$f$getCurrentRoom2 = false;
                    Room room2 = ScanUtils.INSTANCE.getCurrentRoom();
                    if (room2 == null) {
                        return;
                    }
                    room = room2;
                    Object[] this_$iv2 = DungeonUtils.INSTANCE;
                    boolean $i$f$getInDungeons = false;
                    if (!LocationUtils.INSTANCE.getCurrentArea().isArea(Island.Dungeon)) break block15;
                    this_$iv2 = new Object[]{"Lower Blaze", "Higher Blaze"};
                    if (Utils.equalsOneOf(room.getData().getName(), this_$iv2)) break block16;
                }
                return;
            }
            hpMap = new LinkedHashMap();
            blazes.clear();
            Object object = OdinMain.INSTANCE.getMc().field_71441_e;
            if (object == null || (object = object.field_72996_f) == null) break block17;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                String string;
                Entity entity;
                block19: {
                    block18: {
                        String string2;
                        entity = (Entity)element$iv;
                        boolean bl = false;
                        if (!(entity instanceof EntityArmorStand) || blazes.contains(entity)) continue;
                        String $this$noControlCodes$iv = ((EntityArmorStand)entity).func_70005_c_();
                        boolean $i$f$getNoControlCodes = false;
                        string = $this$noControlCodes$iv;
                        if (string == null) break block18;
                        CharSequence charSequence = string;
                        Regex regex = Utils.getFORMATTING_CODE_PATTERN();
                        string = regex.replace(charSequence, string2 = "");
                        if (string != null) break block19;
                    }
                    string = "";
                }
                if ((object2 = Regex.find$default(blazeHealthRegex, string, 0, 2, null)) == null || (object2 = object2.getGroups()) == null || (object2 = object2.get(1)) == null || (object2 = ((MatchGroup)object2).getValue()) == null || (object2 = StringsKt.replace$default((String)object2, ",", "", false, 4, null)) == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
                    continue;
                }
                int hp = (Integer)object2;
                Integer n = hp;
                hpMap.put(entity, n);
                blazes.add((EntityArmorStand)entity);
            }
        }
        if (Intrinsics.areEqual(room.getData().getName(), "Lower Blaze")) {
            List<EntityArmorStand> $this$sortByDescending$iv = blazes;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortByDescending$iv, new Comparator(hpMap){
                    final /* synthetic */ Map $hpMap$inlined;
                    {
                        this.$hpMap$inlined = map2;
                    }

                    public final int compare(T a, T b) {
                        EntityArmorStand it = (EntityArmorStand)b;
                        boolean bl = false;
                        Comparable comparable = (Integer)this.$hpMap$inlined.get(it);
                        it = (EntityArmorStand)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)this.$hpMap$inlined.get(it)));
                    }
                });
            }
        } else {
            List<EntityArmorStand> $this$sortBy$iv = blazes;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, new Comparator(hpMap){
                    final /* synthetic */ Map $hpMap$inlined;
                    {
                        this.$hpMap$inlined = map2;
                    }

                    public final int compare(T a, T b) {
                        EntityArmorStand it = (EntityArmorStand)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)this.$hpMap$inlined.get(it);
                        it = (EntityArmorStand)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)this.$hpMap$inlined.get(it)));
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onRenderWorld(boolean blazeLineNext2, int blazeLineAmount2, int blazeStyle2, @NotNull Color blazeFirstColor2, @NotNull Color blazeSecondColor2, @NotNull Color blazeAllColor2, float blazeWidth2, float blazeHeight2, boolean blazeSendComplete2, float blazeLineWidth2) {
        Intrinsics.checkNotNullParameter(blazeFirstColor2, "blazeFirstColor");
        Intrinsics.checkNotNullParameter(blazeSecondColor2, "blazeSecondColor");
        Intrinsics.checkNotNullParameter(blazeAllColor2, "blazeAllColor");
        Object this_$iv = DungeonUtils.INSTANCE;
        boolean $i$f$getCurrentRoomName = false;
        Object this_$iv$iv = DungeonListener.INSTANCE;
        boolean $i$f$getCurrentRoom2 = false;
        Object object = ScanUtils.INSTANCE.getCurrentRoom();
        if (object == null || (object = ((Room)object).getData()) == null || (object = ((RoomData)object).getName()) == null) {
            object = "Unknown";
        }
        if (!Utils.equalsOneOf(object, this_$iv = new Object[]{"Lower Blaze", "Higher Blaze"})) {
            return;
        }
        if (blazes.isEmpty()) {
            return;
        }
        CollectionsKt.removeAll(blazes, (Function1)onRenderWorld.1.INSTANCE);
        if (blazes.isEmpty() && lastBlazeCount == 1) {
            Object v1;
            block14: {
                this_$iv$iv = DungeonListener.INSTANCE.getPuzzles();
                Iterator $i$f$getCurrentRoom2 = this_$iv$iv.iterator();
                while ($i$f$getCurrentRoom2.hasNext()) {
                    Object t = $i$f$getCurrentRoom2.next();
                    Puzzle it = (Puzzle)((Object)t);
                    boolean bl = false;
                    if (!(it == Puzzle.BLAZE)) continue;
                    v1 = t;
                    break block14;
                }
                v1 = null;
            }
            Puzzle puzzle = v1;
            if (puzzle != null) {
                puzzle.setStatus(PuzzleStatus.Completed.INSTANCE);
            }
            this_$iv = DungeonUtils.INSTANCE;
            $i$f$getCurrentRoomName = false;
            this_$iv$iv = DungeonListener.INSTANCE;
            boolean $i$f$getCurrentRoom3 = false;
            Object object2 = ScanUtils.INSTANCE.getCurrentRoom();
            if (object2 == null || (object2 = ((Room)object2).getData()) == null || (object2 = ((RoomData)object2).getName()) == null) {
                object2 = "Unknown";
            }
            PuzzleSolvers.INSTANCE.onPuzzleComplete(Intrinsics.areEqual(object2, "Higher Blaze") ? "Higher Blaze" : "Lower Blaze");
            if (blazeSendComplete2) {
                ChatUtilsKt.partyMessage("Blaze puzzle solved!");
            }
            lastBlazeCount = 0;
            return;
        }
        lastBlazeCount = blazes.size();
        Iterable $this$forEachIndexed$iv = blazes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$middle$iv;
            RenderUtils this_$iv$iv2;
            RenderUtils this_$iv2;
            void entity;
            Color color2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityArmorStand bl = (EntityArmorStand)item$iv;
            int index = n;
            boolean bl2 = false;
            switch (index) {
                case 0: {
                    color2 = blazeFirstColor2;
                    break;
                }
                case 1: {
                    color2 = blazeSecondColor2;
                    break;
                }
                default: {
                    color2 = blazeAllColor2;
                }
            }
            Color color3 = color2;
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(-blazeWidth2) / 2.0, (double)-1 - (double)blazeHeight2 / 2.0, (double)(-blazeWidth2) / 2.0, (double)blazeWidth2 / 2.0, (double)blazeHeight2 / 2.0 - 1.0, (double)blazeWidth2 / 2.0);
            Vec3 vec3 = entity.func_174791_d();
            Intrinsics.checkNotNullExpressionValue(vec3, "getPositionVector(...)");
            AxisAlignedBB aabb = VecUtilsKt.offset(axisAlignedBB, vec3);
            Renderer.drawStyledBox$default(Renderer.INSTANCE, aabb, color3, blazeStyle2, null, true, 8, null);
            if (!blazeLineNext2 || index <= 0 || index > blazeLineAmount2) continue;
            Vec3[] vec3Array = new Vec3[2];
            RenderUtils renderUtils = RenderUtils.INSTANCE;
            Entity $this$renderVec$iv = (Entity)blazes.get(index - 1);
            boolean $i$f$getRenderVec = false;
            void var26_34 = this_$iv2;
            Entity $this$renderX$iv$iv = $this$renderVec$iv;
            boolean $i$f$getRenderX = false;
            double d = $this$renderX$iv$iv.field_70169_q + ($this$renderX$iv$iv.field_70165_t - $this$renderX$iv$iv.field_70169_q) * (double)this_$iv$iv2.getPartialTicks();
            this_$iv$iv2 = this_$iv2;
            Entity $this$renderY$iv$iv = $this$renderVec$iv;
            boolean $i$f$getRenderY = false;
            double d2 = $this$renderY$iv$iv.field_70167_r + ($this$renderY$iv$iv.field_70163_u - $this$renderY$iv$iv.field_70167_r) * (double)this_$iv$iv2.getPartialTicks();
            this_$iv$iv2 = this_$iv2;
            Entity $this$renderZ$iv$iv = $this$renderVec$iv;
            boolean $i$f$getRenderZ = false;
            vec3Array[0] = new Vec3(d, d2, $this$renderZ$iv$iv.field_70166_s + ($this$renderZ$iv$iv.field_70161_v - $this$renderZ$iv$iv.field_70166_s) * (double)this_$iv$iv2.getPartialTicks());
            this_$iv2 = RenderUtils.INSTANCE;
            Entity $this$renderBoundingBox$iv = (Entity)entity;
            boolean $i$f$getRenderBoundingBox = false;
            this_$iv$iv2 = this_$iv2;
            $this$renderX$iv$iv = $this$renderBoundingBox$iv;
            $i$f$getRenderX = false;
            double d3 = $this$renderX$iv$iv.field_70169_q + ($this$renderX$iv$iv.field_70165_t - $this$renderX$iv$iv.field_70169_q) * (double)this_$iv$iv2.getPartialTicks() - (double)($this$renderBoundingBox$iv.field_70130_N / (float)2);
            this_$iv$iv2 = this_$iv2;
            $this$renderY$iv$iv = $this$renderBoundingBox$iv;
            $i$f$getRenderY = false;
            double d4 = $this$renderY$iv$iv.field_70167_r + ($this$renderY$iv$iv.field_70163_u - $this$renderY$iv$iv.field_70167_r) * (double)this_$iv$iv2.getPartialTicks();
            this_$iv$iv2 = this_$iv2;
            $this$renderZ$iv$iv = $this$renderBoundingBox$iv;
            $i$f$getRenderZ = false;
            double d5 = $this$renderZ$iv$iv.field_70166_s + ($this$renderZ$iv$iv.field_70161_v - $this$renderZ$iv$iv.field_70166_s) * (double)this_$iv$iv2.getPartialTicks() - (double)($this$renderBoundingBox$iv.field_70130_N / (float)2);
            this_$iv$iv2 = this_$iv2;
            $this$renderX$iv$iv = $this$renderBoundingBox$iv;
            $i$f$getRenderX = false;
            double d6 = $this$renderX$iv$iv.field_70169_q + ($this$renderX$iv$iv.field_70165_t - $this$renderX$iv$iv.field_70169_q) * (double)this_$iv$iv2.getPartialTicks() + (double)($this$renderBoundingBox$iv.field_70130_N / (float)2);
            this_$iv$iv2 = this_$iv2;
            $this$renderY$iv$iv = $this$renderBoundingBox$iv;
            $i$f$getRenderY = false;
            double d7 = $this$renderY$iv$iv.field_70167_r + ($this$renderY$iv$iv.field_70163_u - $this$renderY$iv$iv.field_70167_r) * (double)this_$iv$iv2.getPartialTicks() + (double)$this$renderBoundingBox$iv.field_70131_O;
            this_$iv$iv2 = this_$iv2;
            $this$renderZ$iv$iv = $this$renderBoundingBox$iv;
            $i$f$getRenderZ = false;
            this_$iv2 = new AxisAlignedBB(d3, d4, d5, d6, d7, $this$renderZ$iv$iv.field_70166_s + ($this$renderZ$iv$iv.field_70161_v - $this$renderZ$iv$iv.field_70166_s) * (double)this_$iv$iv2.getPartialTicks() + (double)($this$renderBoundingBox$iv.field_70130_N / (float)2));
            boolean $i$f$getMiddle = false;
            vec3Array[1] = new Vec3($this$middle$iv.field_72340_a + ($this$middle$iv.field_72336_d - $this$middle$iv.field_72340_a) / (double)2, $this$middle$iv.field_72338_b + ($this$middle$iv.field_72337_e - $this$middle$iv.field_72338_b) / (double)2, $this$middle$iv.field_72339_c + ($this$middle$iv.field_72334_f - $this$middle$iv.field_72339_c) / (double)2);
            Renderer.INSTANCE.draw3DLine((Collection<? extends Vec3>)CollectionsKt.listOf(vec3Array), color3, blazeLineWidth2, true);
        }
    }

    public final void reset() {
        lastBlazeCount = 10;
        blazes.clear();
        roomType = 0;
    }

    static {
        lastBlazeCount = 10;
        blazeHealthRegex = new Regex("^\\[Lv15] \u2668 Blaze [\\d,]+/([\\d,]+)\u2764$");
    }
}

