/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.features.impl.dungeon.puzzlesolvers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.odinmain.OdinMain;
import me.odinmain.events.impl.BlockChangeEvent;
import me.odinmain.events.impl.RoomEnterEvent;
import me.odinmain.features.impl.dungeon.puzzlesolvers.PuzzleSolvers;
import me.odinmain.utils.Utils;
import me.odinmain.utils.VecUtilsKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.Colors;
import me.odinmain.utils.render.Renderer;
import me.odinmain.utils.skyblock.WorldUtilsKt;
import me.odinmain.utils.skyblock.dungeon.DungeonListener;
import me.odinmain.utils.skyblock.dungeon.DungeonUtils;
import me.odinmain.utils.skyblock.dungeon.ScanUtils;
import me.odinmain.utils.skyblock.dungeon.tiles.Room;
import me.odinmain.utils.skyblock.dungeon.tiles.RoomData;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00130\u00120\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lme/odinmain/features/impl/dungeon/puzzlesolvers/BeamsSolver;", "", "<init>", "()V", "scanned", "", "lanternPairs", "", "", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "isr", "Ljava/io/InputStreamReader;", "currentLanternPairs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/minecraft/util/BlockPos;", "Lkotlin/Pair;", "Lme/odinmain/utils/render/Color;", "onRoomEnter", "", "event", "Lme/odinmain/events/impl/RoomEnterEvent;", "onRenderWorld", "beamStyle", "beamsTracer", "beamsAlpha", "", "onBlockChange", "Lme/odinmain/events/impl/BlockChangeEvent;", "reset", "colors", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nBeamsSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeamsSolver.kt\nme/odinmain/features/impl/dungeon/puzzlesolvers/BeamsSolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DungeonUtils.kt\nme/odinmain/utils/skyblock/dungeon/DungeonUtils\n+ 5 DungeonListener.kt\nme/odinmain/utils/skyblock/dungeon/DungeonListener\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,89:1\n1863#2:90\n1864#2:92\n1863#2,2:95\n1#3:91\n75#4:93\n75#4:97\n99#4:99\n39#5:94\n39#5:98\n39#5:100\n216#6,2:101\n*S KotlinDebug\n*F\n+ 1 BeamsSolver.kt\nme/odinmain/features/impl/dungeon/puzzlesolvers/BeamsSolver\n*L\n49#1:90\n49#1:92\n60#1:95,2\n58#1:93\n72#1:97\n73#1:99\n58#1:94\n72#1:98\n73#1:100\n74#1:101,2\n*E\n"})
public final class BeamsSolver {
    @NotNull
    public static final BeamsSolver INSTANCE;
    private static boolean scanned;
    @NotNull
    private static List<? extends List<Integer>> lanternPairs;
    private static final Gson gson;
    @Nullable
    private static final InputStreamReader isr;
    @NotNull
    private static ConcurrentHashMap<BlockPos, Pair<BlockPos, Color>> currentLanternPairs;
    @NotNull
    private static final List<Color> colors;

    private BeamsSolver() {
    }

    public final void onRoomEnter(@NotNull RoomEnterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Room $this$onRoomEnter_u24lambda_u244 = event.getRoom();
        boolean bl = false;
        Object object = $this$onRoomEnter_u24lambda_u244;
        if (!Intrinsics.areEqual(object != null && (object = ((Room)object).getData()) != null ? ((RoomData)object).getName() : null, "Creeper Beams")) {
            INSTANCE.reset();
            return;
        }
        currentLanternPairs.clear();
        Iterable $this$forEach$iv = lanternPairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos pos2;
            BlockPos blockPos;
            BlockPos pos;
            BlockPos blockPos2;
            List list = (List)element$iv;
            boolean bl2 = false;
            BlockPos it = blockPos2 = DungeonUtils.INSTANCE.getRealCoords($this$onRoomEnter_u24lambda_u244, ((Number)list.get(0)).intValue(), ((Number)list.get(1)).intValue(), ((Number)list.get(2)).intValue());
            boolean bl3 = false;
            Integer n = WorldUtilsKt.getBlockIdAt(it);
            int n2 = 169;
            if ((n != null && n == n2 ? blockPos2 : null) == null) continue;
            pos = pos;
            BlockPos it2 = blockPos = DungeonUtils.INSTANCE.getRealCoords($this$onRoomEnter_u24lambda_u244, ((Number)list.get(3)).intValue(), ((Number)list.get(4)).intValue(), ((Number)list.get(5)).intValue());
            boolean bl4 = false;
            Integer n3 = WorldUtilsKt.getBlockIdAt(it2);
            int n4 = 169;
            if ((n3 != null && n3 == n4 ? blockPos : null) == null) continue;
            pos2 = pos2;
            ((Map)currentLanternPairs).put(pos, TuplesKt.to(pos2, colors.get(currentLanternPairs.size())));
        }
    }

    public final void onRenderWorld(int beamStyle2, boolean beamsTracer2, float beamsAlpha2) {
        DungeonUtils this_$iv = DungeonUtils.INSTANCE;
        boolean $i$f$getCurrentRoomName = false;
        DungeonListener this_$iv$iv = DungeonListener.INSTANCE;
        boolean $i$f$getCurrentRoom = false;
        Object object = ScanUtils.INSTANCE.getCurrentRoom();
        if (object == null || (object = ((Room)object).getData()) == null || (object = ((RoomData)object).getName()) == null) {
            object = "Unknown";
        }
        if (!Intrinsics.areEqual(object, "Creeper Beams") || currentLanternPairs.isEmpty()) {
            return;
        }
        Set<Map.Entry<BlockPos, Pair<BlockPos, Color>>> set = currentLanternPairs.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry positions2 = (Map.Entry)element$iv;
            boolean bl = false;
            Color color2 = Color.Companion.withAlpha$default(Color.Companion, (Color)((Pair)positions2.getValue()).getSecond(), beamsAlpha2, false, 2, null);
            Renderer renderer = Renderer.INSTANCE;
            Object k = positions2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            Renderer.drawStyledBlock$default(renderer, (BlockPos)k, color2, beamStyle2, null, true, false, 0.0, 104, null);
            renderer = Renderer.INSTANCE;
            Renderer.drawStyledBlock$default(renderer, (BlockPos)((Pair)positions2.getValue()).getFirst(), color2, beamStyle2, null, true, false, 0.0, 104, null);
            if (!beamsTracer2) continue;
            renderer = Renderer.INSTANCE;
            Vec3[] vec3Array = new Vec3[2];
            Object k2 = positions2.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, "<get-key>(...)");
            vec3Array[0] = VecUtilsKt.addVec(VecUtilsKt.toVec3((BlockPos)k2), (Number)0.5, (Number)0.5, (Number)0.5);
            vec3Array[1] = VecUtilsKt.addVec(VecUtilsKt.toVec3((BlockPos)((Pair)positions2.getValue()).getFirst()), (Number)0.5, (Number)0.5, (Number)0.5);
            renderer.draw3DLine((Collection<? extends Vec3>)CollectionsKt.listOf(vec3Array), color2, 2.0f, false);
        }
    }

    public final void onBlockChange(@NotNull BlockChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        DungeonUtils this_$iv = DungeonUtils.INSTANCE;
        boolean $i$f$getCurrentRoomName = false;
        DungeonListener this_$iv$iv = DungeonListener.INSTANCE;
        boolean $i$f$getCurrentRoom = false;
        Object object = ScanUtils.INSTANCE.getCurrentRoom();
        if (object == null || (object = ((Room)object).getData()) == null || (object = ((RoomData)object).getName()) == null) {
            object = "Unknown";
        }
        if (!Intrinsics.areEqual(object, "Creeper Beams")) {
            return;
        }
        DungeonUtils this_$iv2 = DungeonUtils.INSTANCE;
        boolean $i$f$getCurrentRoom2 = false;
        DungeonListener this_$iv$iv2 = DungeonListener.INSTANCE;
        boolean $i$f$getCurrentRoom3 = false;
        Room room = ScanUtils.INSTANCE.getCurrentRoom();
        if (Intrinsics.areEqual(event.getPos(), room != null ? DungeonUtils.INSTANCE.getRealCoords(room, 15, 69, 15) : null) && Intrinsics.areEqual(event.getOld().func_177230_c(), Blocks.field_150350_a) && Intrinsics.areEqual(event.getUpdated().func_177230_c(), Blocks.field_150486_ae)) {
            PuzzleSolvers.INSTANCE.onPuzzleComplete("Creeper Beams");
        }
        Map $this$forEach$iv = currentLanternPairs;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            BlockPos key = (BlockPos)entry.getKey();
            Pair value = (Pair)entry.getValue();
            Object[] objectArray = new Object[]{key, value.getFirst()};
            if (!Utils.equalsOneOf(event.getPos(), objectArray) || Intrinsics.areEqual(event.getUpdated().func_177230_c(), Blocks.field_180398_cJ) || !Intrinsics.areEqual(event.getOld().func_177230_c(), Blocks.field_180398_cJ)) continue;
            currentLanternPairs.remove(key);
        }
    }

    public final void reset() {
        scanned = false;
        currentLanternPairs.clear();
    }

    static {
        InputStreamReader inputStreamReader;
        INSTANCE = new BeamsSolver();
        gson = new GsonBuilder().setPrettyPrinting().create();
        Object object = INSTANCE.getClass().getResourceAsStream("/creeperBeamsSolutions.json");
        if (object != null) {
            InputStream it = object;
            boolean bl = false;
            inputStreamReader = new InputStreamReader(it, StandardCharsets.UTF_8);
        } else {
            inputStreamReader = null;
        }
        isr = inputStreamReader;
        try {
            Unit unit;
            InputStreamReader inputStreamReader2 = isr;
            String text = inputStreamReader2 != null ? TextStreamsKt.readText(inputStreamReader2) : null;
            lanternPairs = (List)gson.fromJson(text, new TypeToken<List<? extends List<? extends Integer>>>(){}.getType());
            InputStreamReader inputStreamReader3 = isr;
            if (inputStreamReader3 != null) {
                inputStreamReader3.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = unit;
        }
        catch (Exception e) {
            OdinMain.INSTANCE.getLogger().error("Error loading creeper beams solutions", (Throwable)e);
            lanternPairs = CollectionsKt.emptyList();
            object = Unit.INSTANCE;
        }
        currentLanternPairs = new ConcurrentHashMap();
        object = new Color[]{Colors.MINECRAFT_GOLD, Colors.MINECRAFT_GREEN, Colors.MINECRAFT_LIGHT_PURPLE, Colors.MINECRAFT_DARK_AQUA, Colors.MINECRAFT_YELLOW, Colors.MINECRAFT_DARK_RED, Colors.WHITE, Colors.MINECRAFT_DARK_PURPLE};
        colors = CollectionsKt.listOf(object);
    }
}

