/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.commands.impl;

import com.github.stivais.commodore.Commodore;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.odinmain.commands.impl.PosMsgCommandKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.Colors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"PosMsgCommand", "Lcom/github/stivais/commodore/Commodore;", "getPosMsgCommand", "()Lcom/github/stivais/commodore/Commodore;", "hexRegex", "Lkotlin/text/Regex;", "getHexRegex", "()Lkotlin/text/Regex;", "getColorFromString", "Lme/odinmain/utils/render/Color;", "color", "", "OdinMod"})
public final class PosMsgCommandKt {
    @NotNull
    private static final Commodore PosMsgCommand;
    @NotNull
    private static final Regex hexRegex;

    @NotNull
    public static final Commodore getPosMsgCommand() {
        return PosMsgCommand;
    }

    @NotNull
    public static final Regex getHexRegex() {
        return hexRegex;
    }

    @Nullable
    public static final Color getColorFromString(@NotNull String color2) {
        Color color3;
        Intrinsics.checkNotNullParameter(color2, "color");
        Object object = Regex.find$default(hexRegex, color2, 0, 2, null);
        if (object != null) {
            MatchResult it = object;
            boolean bl = false;
            String hex = StringsKt.replace$default(it.getValue(), "#", "", false, 4, null);
            return hex.length() == 6 ? new Color(hex + "FF") : new Color(hex);
        }
        String string = color2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        switch (string) {
            case "DARKBLUE": {
                color3 = Colors.MINECRAFT_DARK_BLUE;
                break;
            }
            case "DARKGREEN": {
                color3 = Colors.MINECRAFT_DARK_GREEN;
                break;
            }
            case "DARKAQUA": {
                color3 = Colors.MINECRAFT_DARK_AQUA;
                break;
            }
            case "DARKRED": {
                color3 = Colors.MINECRAFT_DARK_RED;
                break;
            }
            case "DARKPURPLE": {
                color3 = Colors.MINECRAFT_DARK_PURPLE;
                break;
            }
            case "GOLD": {
                color3 = Colors.MINECRAFT_GOLD;
                break;
            }
            case "GRAY": {
                color3 = Colors.MINECRAFT_GRAY;
                break;
            }
            case "DARKGRAY": {
                color3 = Colors.MINECRAFT_DARK_GRAY;
                break;
            }
            case "BLUE": {
                color3 = Colors.MINECRAFT_BLUE;
                break;
            }
            case "GREEN": {
                color3 = Colors.MINECRAFT_GREEN;
                break;
            }
            case "AQUA": {
                color3 = Colors.MINECRAFT_AQUA;
                break;
            }
            case "RED": {
                color3 = Colors.MINECRAFT_RED;
                break;
            }
            case "LIGHTPURPLE": {
                color3 = Colors.MINECRAFT_LIGHT_PURPLE;
                break;
            }
            case "YELLOW": {
                color3 = Colors.MINECRAFT_YELLOW;
                break;
            }
            case "WHITE": {
                color3 = Colors.WHITE;
                break;
            }
            case "BLACK": {
                color3 = Colors.BLACK;
                break;
            }
            default: {
                color3 = null;
            }
        }
        return color3;
    }

    static {
        String[] stringArray = new String[]{"posmsg"};
        PosMsgCommand = new Commodore(stringArray, PosMsgCommand.1.INSTANCE);
        hexRegex = new Regex("^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$");
    }
}

