/*
 * Decompiled with CFR 0.152.
 */
package me.odinclient.mixin.mixins;

import me.odinmain.events.impl.GuiEvent;
import me.odinmain.utils.Utils;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GuiScreen.class})
public class MixinGuiScreen {
    @Unique
    private final GuiScreen odin$gui = (GuiScreen)this;

    @Inject(method={"handleMouseInput"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiScreen;mouseReleased(III)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void injectMouseRelease(CallbackInfo ci, int mouseX, int mouseY, int mouseButton) {
        if (Utils.postAndCatch(new GuiEvent.MouseRelease(this.odin$gui, mouseButton, mouseX, mouseY))) {
            ci.cancel();
        }
    }

    @Inject(method={"handleMouseInput"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiScreen;mouseClicked(III)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void injectMouseClick(CallbackInfo ci, int mouseX, int mouseY, int mouseButton) {
        if (Utils.postAndCatch(new GuiEvent.MouseClick(this.odin$gui, mouseButton, mouseX, mouseY))) {
            ci.cancel();
        }
    }

    @Inject(method={"handleKeyboardInput"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiScreen;keyTyped(CI)V")}, cancellable=true)
    private void injectKeyboardClick(CallbackInfo ci) {
        if (Utils.postAndCatch(new GuiEvent.KeyPress(this.odin$gui, Keyboard.getEventKey(), Keyboard.getEventCharacter()))) {
            ci.cancel();
        }
    }
}

