/*
 * Decompiled with CFR 0.152.
 */
package com.github.stivais.commodore.parsers.impl;

import com.github.stivais.commodore.functions.FunctionInvoker;
import com.github.stivais.commodore.functions.Parameter;
import com.github.stivais.commodore.parsers.CommandParser;
import com.mojang.brigadier.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u000bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002`\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/github/stivais/commodore/parsers/impl/FunctionParser;", "T", "Lcom/github/stivais/commodore/parsers/CommandParser;", "function", "Lkotlin/Function;", "<init>", "(Lkotlin/Function;)V", "funInvoker", "Lcom/github/stivais/commodore/functions/FunctionInvoker;", "parsers", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "Ljava/util/ArrayList;", "parse", "reader", "Lcom/mojang/brigadier/StringReader;", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Object;", "Commodore legacy"})
@SourceDebugExtension(value={"SMAP\nFunctionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionParser.kt\ncom/github/stivais/commodore/parsers/impl/FunctionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class FunctionParser<T>
implements CommandParser<T> {
    @NotNull
    private final FunctionInvoker<T> funInvoker;
    @NotNull
    private final ArrayList<CommandParser<?>> parsers;

    public FunctionParser(@NotNull Function<? extends T> function) {
        Intrinsics.checkNotNullParameter(function, "function");
        this.funInvoker = FunctionInvoker.Companion.from(function);
        this.parsers = new ArrayList();
        for (Parameter<?> parameter : this.funInvoker.getParameters()) {
            CommandParser<?> parser2;
            if (CommandParser.Companion.getParser(parameter.getType()) == null) {
                throw new IllegalStateException("No parser found for parameter: " + parameter.getName() + "(type=" + parameter.getType() + ')');
            }
            this.parsers.add(parser2);
        }
        if (!(this.parsers.size() != 0)) {
            boolean bl = false;
            String string = "You need at least one parameter in the function for this parser.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public T parse(@NotNull StringReader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        List arguments2 = new ArrayList();
        Iterator<CommandParser<?>> iterator2 = this.parsers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<CommandParser<?>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CommandParser<?> parser2;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            reader.skipWhitespace();
            arguments2.add(parser2.parse(reader));
        }
        return this.funInvoker.invoke(arguments2);
    }

    @Override
    @NotNull
    public Collection<String> suggestions() {
        return CommandParser.DefaultImpls.suggestions(this);
    }

    @Override
    @NotNull
    public Collection<String> examples() {
        return CommandParser.DefaultImpls.examples(this);
    }
}

