/*
 * Decompiled with CFR 0.152.
 */
package com.github.stivais.commodore.parsers;

import com.github.stivais.commodore.functions.Parameter;
import com.github.stivais.commodore.parsers.CommandParser;
import com.github.stivais.commodore.utils.SyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ0\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\"\n\b\u0001\u0010\u001f*\u0004\u0018\u00010\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\u000b\u001a\u00020\"H\u0016J\u001d\u0010#\u001a\u0004\u0018\u00018\u00002\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0!\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u0013J\u0006\u0010'\u001a\u00020(R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u001f\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lcom/github/stivais/commodore/parsers/ParserArgumentType;", "T", "Lcom/mojang/brigadier/arguments/ArgumentType;", "parameter", "Lcom/github/stivais/commodore/functions/Parameter;", "parser", "Lcom/github/stivais/commodore/parsers/CommandParser;", "<init>", "(Lcom/github/stivais/commodore/functions/Parameter;Lcom/github/stivais/commodore/parsers/CommandParser;)V", "getParser$annotations", "()V", "builder", "Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "", "getBuilder", "()Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "suggestionCallback", "Lkotlin/Function0;", "", "", "getSuggestionCallback", "()Lkotlin/jvm/functions/Function0;", "setSuggestionCallback", "(Lkotlin/jvm/functions/Function0;)V", "parse", "reader", "Lcom/mojang/brigadier/StringReader;", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Object;", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "context", "Lcom/mojang/brigadier/context/CommandContext;", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "getValue", "ctx", "(Lcom/mojang/brigadier/context/CommandContext;)Ljava/lang/Object;", "name", "optional", "", "Commodore legacy"})
public final class ParserArgumentType<T>
implements ArgumentType<T> {
    @NotNull
    private final Parameter<T> parameter;
    @NotNull
    private final CommandParser<T> parser;
    @NotNull
    private final RequiredArgumentBuilder<Object, T> builder;
    @Nullable
    private Function0<? extends Collection<String>> suggestionCallback;

    public ParserArgumentType(@NotNull Parameter<T> parameter, @NotNull CommandParser<?> parser2) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(parser2, "parser");
        this.parameter = parameter;
        this.parser = parser2;
        RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument(this.parameter.getName(), this);
        Intrinsics.checkNotNullExpressionValue(requiredArgumentBuilder, "argument(...)");
        this.builder = requiredArgumentBuilder;
    }

    private static /* synthetic */ void getParser$annotations() {
    }

    @NotNull
    public final RequiredArgumentBuilder<Object, T> getBuilder() {
        return this.builder;
    }

    @Nullable
    public final Function0<Collection<String>> getSuggestionCallback() {
        return this.suggestionCallback;
    }

    public final void setSuggestionCallback(@Nullable Function0<? extends Collection<String>> function0) {
        this.suggestionCallback = function0;
    }

    @Override
    public T parse(@NotNull StringReader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        try {
            return this.parser.parse(reader);
        }
        catch (SyntaxException e) {
            throw new CommandSyntaxException(new CommandExceptionType(){}, () -> ParserArgumentType.parse$lambda$0(e), reader.getString(), reader.getCursor());
        }
    }

    @Override
    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Object object = this.suggestionCallback;
        if (object == null || (object = object.invoke()) == null) {
            object = this.parser.suggestions();
        }
        Collection<String> suggestions = object;
        for (String str : suggestions) {
            String string = builder.getRemaining();
            Intrinsics.checkNotNullExpressionValue(string, "getRemaining(...)");
            if (!StringsKt.startsWith$default(str, string, false, 2, null)) continue;
            builder.suggest(str);
        }
        CompletableFuture<Suggestions> completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    @Nullable
    public final T getValue(@NotNull CommandContext<Object> ctx) {
        T t;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        try {
            System.out.println((Object)(this.parameter.getName() + ' ' + this.parameter.getType()));
            t = ctx.getArgument(this.parameter.getName(), this.parameter.getType());
        }
        catch (IllegalArgumentException e) {
            t = null;
        }
        return t;
    }

    @NotNull
    public final String name() {
        return this.parameter.getName();
    }

    public final boolean optional() {
        return this.parameter.isNullable();
    }

    private static final String parse$lambda$0(SyntaxException $e) {
        Intrinsics.checkNotNullParameter($e, "$e");
        return $e.getMessage();
    }
}

