/*
 * Decompiled with CFR 0.152.
 */
package com.github.stivais.commodore.parsers;

import com.github.stivais.commodore.parsers.CommandParsable;
import com.github.stivais.commodore.parsers.CommandParser;
import com.github.stivais.commodore.parsers.impl.BooleanParser;
import com.github.stivais.commodore.parsers.impl.DoubleParser;
import com.github.stivais.commodore.parsers.impl.FloatParser;
import com.github.stivais.commodore.parsers.impl.FunctionParser;
import com.github.stivais.commodore.parsers.impl.GreedyStringParser;
import com.github.stivais.commodore.parsers.impl.IntParser;
import com.github.stivais.commodore.parsers.impl.LongParser;
import com.github.stivais.commodore.parsers.impl.StringParser;
import com.github.stivais.commodore.utils.GreedyString;
import com.github.stivais.commodore.utils.SyntaxException;
import com.mojang.brigadier.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u0000 \u000b*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u000bJ\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/github/stivais/commodore/parsers/CommandParser;", "T", "", "parse", "reader", "Lcom/mojang/brigadier/StringReader;", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Object;", "suggestions", "", "", "examples", "Companion", "Commodore legacy"})
public interface CommandParser<T> {
    @NotNull
    public static final Companion Companion = com.github.stivais.commodore.parsers.CommandParser$Companion.$$INSTANCE;

    public T parse(@NotNull StringReader var1);

    @NotNull
    public Collection<String> suggestions();

    @NotNull
    public Collection<String> examples();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b\"\u0004\b\u0001\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006J\u0018\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000bR \u0010\u0004\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/stivais/commodore/parsers/CommandParser$Companion;", "", "<init>", "()V", "parsers", "", "Lcom/github/stivais/commodore/parsers/CommandParser;", "registerParser", "", "T", "clazz", "Ljava/lang/Class;", "builder", "getParser", "type", "Commodore legacy"})
    @SourceDebugExtension(value={"SMAP\nCommandParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandParser.kt\ncom/github/stivais/commodore/parsers/CommandParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Map<Object, CommandParser<?>> parsers;

        private Companion() {
        }

        public final <T> void registerParser(@NotNull Class<T> clazz, @NotNull CommandParser<T> builder) {
            Intrinsics.checkNotNullParameter(clazz, "clazz");
            Intrinsics.checkNotNullParameter(builder, "builder");
            parsers.put(clazz, builder);
        }

        @Nullable
        public final CommandParser<?> getParser(@NotNull Class<?> type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            CommandParser<?> commandParser = parsers.get(type2);
            if (commandParser != null) {
                CommandParser<?> it = commandParser;
                boolean bl = false;
                return it;
            }
            CommandParsable annotation = type2.getAnnotation(CommandParsable.class);
            if (annotation != null) {
                boolean bl = type2.isEnum();
                System.out.println(bl);
                if (type2.isEnum()) {
                    CommandParser<Object> parser2 = new CommandParser<Object>(type2){
                        private final Map<String, Object> enumMap;
                        {
                            Map<K, V> map2;
                            Map<K, V> map3 = map2 = MapsKt.createMapBuilder();
                            getParser.parser.1 var8_4 = this;
                            boolean bl = false;
                            Iterator<?> iterator2 = ArrayIteratorKt.iterator($type.getEnumConstants());
                            while (iterator2.hasNext()) {
                                void $this$enumMap_u24lambda_u240;
                                ? constant = iterator2.next();
                                String string = constant.toString().toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                                String str = StringsKt.replace$default(string, "_", " ", false, 4, null);
                                Intrinsics.checkNotNull(constant);
                                $this$enumMap_u24lambda_u240.put(str, constant);
                            }
                            var8_4.enumMap = MapsKt.build(map2);
                        }

                        public final Map<String, Object> getEnumMap() {
                            return this.enumMap;
                        }

                        public Object parse(StringReader reader) {
                            Intrinsics.checkNotNullParameter(reader, "reader");
                            StringBuilder builder = new StringBuilder();
                            while (reader.canRead()) {
                                Object value;
                                builder.append(reader.read());
                                Object object = value = this.enumMap.get(builder.toString());
                                if (object == null) continue;
                                return object;
                            }
                            throw new SyntaxException("Invalid argument (valid arguments: " + CollectionsKt.joinToString$default(this.enumMap.keySet(), ", ", null, null, 0, null, getParser.parser.parse.1.INSTANCE, 30, null) + ") for command");
                        }

                        public Collection<String> suggestions() {
                            return this.enumMap.keySet();
                        }

                        public Collection<String> examples() {
                            return DefaultImpls.examples(this);
                        }
                    };
                    this.registerParser(type2, parser2);
                    return parser2;
                }
                KFunction<?> kFunction = KClasses.getPrimaryConstructor(JvmClassMappingKt.getKotlinClass(type2));
                if (kFunction == null) {
                    throw new IllegalArgumentException();
                }
                KFunction<?> primaryConstructor2 = kFunction;
                FunctionParser parser3 = new FunctionParser((Function)primaryConstructor2);
                this.registerParser(type2, parser3);
                return parser3;
            }
            return null;
        }

        static {
            $$INSTANCE = new Companion();
            Pair[] pairArray = new Pair[]{TuplesKt.to(String.class, StringParser.INSTANCE), TuplesKt.to(GreedyString.class, GreedyStringParser.INSTANCE), TuplesKt.to(Integer.class, IntParser.INSTANCE), TuplesKt.to(Integer.TYPE, IntParser.INSTANCE), TuplesKt.to(Long.class, LongParser.INSTANCE), TuplesKt.to(Long.TYPE, LongParser.INSTANCE), TuplesKt.to(Float.class, FloatParser.INSTANCE), TuplesKt.to(Float.TYPE, FloatParser.INSTANCE), TuplesKt.to(Double.class, DoubleParser.INSTANCE), TuplesKt.to(Double.TYPE, DoubleParser.INSTANCE), TuplesKt.to(Boolean.class, BooleanParser.INSTANCE), TuplesKt.to(Boolean.TYPE, BooleanParser.INSTANCE)};
            parsers = MapsKt.mutableMapOf(pairArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static <T> Collection<String> suggestions(@NotNull CommandParser<T> $this) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
            return list;
        }

        @NotNull
        public static <T> Collection<String> examples(@NotNull CommandParser<T> $this) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
            return list;
        }
    }
}

