/*
 * Decompiled with CFR 0.152.
 */
package com.volcaddons.volcaddonsmod;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.volcaddons.volcaddonsmod.CommandUpdateVA;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

@Mod(modid="VolcAddons", version="1.1", clientSideOnly=true, acceptedMinecraftVersions="[1.8.9]")
public class VolcAddons {
    public static final String MODID = "VolcAddons";
    public static final String VERSION = "1.1";
    public static VolcAddons INSTANCE;
    private static final String separator;
    private static String modDir;
    private static String moduleDir;
    private static final String UPDATE_CHECK_URL = "https://api.github.com/repos/zhenga8533/VolcAddons/releases/latest";
    private boolean updateChecked = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INSTANCE = this;
        EventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandUpdateVA());
        modDir = event.getModConfigurationDirectory().getAbsolutePath();
        moduleDir = modDir + separator + "ChatTriggers" + separator + "modules" + separator + MODID;
    }

    @SubscribeEvent
    public void onClientConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!this.updateChecked) {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    VolcAddons.this.checkForUpdates((EntityPlayer)player);
                    VolcAddons.this.updateChecked = true;
                }
            }, 3L, TimeUnit.SECONDS);
            scheduler.shutdown();
        }
    }

    private String getCurrentVersion() {
        try {
            String line;
            String metadataPath = moduleDir + separator + "metadata.json";
            BufferedReader reader = new BufferedReader(new FileReader(metadataPath));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            reader.close();
            JsonObject metadata = new JsonParser().parse(content.toString()).getAsJsonObject();
            return metadata.get("version").getAsString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "1.0.0";
        }
    }

    private boolean isNewerVersion(String version1, String version2) {
        String[] splitVersion1 = version1.split("\\.");
        String[] splitVersion2 = version2.split("\\.");
        for (int i = 0; i < Math.min(splitVersion1.length, splitVersion2.length); ++i) {
            int v2;
            int v1 = Integer.parseInt(splitVersion1[i]);
            if (v1 > (v2 = Integer.parseInt(splitVersion2[i]))) {
                return true;
            }
            if (v1 >= v2) continue;
            return false;
        }
        return splitVersion1.length > splitVersion2.length;
    }

    private void checkForUpdates(EntityPlayer player) {
        try {
            URL url = new URL(UPDATE_CHECK_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (connection.getResponseCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                connection.disconnect();
                String jsonResponse = response.toString();
                JsonParser jsonParser = new JsonParser();
                JsonObject releaseJson = jsonParser.parse(jsonResponse).getAsJsonObject();
                String latestVersion = releaseJson.get("tag_name").getAsString();
                latestVersion = latestVersion.startsWith("v") ? latestVersion.substring(1) : latestVersion;
                String currentVersion = this.getCurrentVersion();
                if (this.isNewerVersion(latestVersion, currentVersion)) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "\n[" + EnumChatFormatting.GOLD + MODID + EnumChatFormatting.GRAY + "] " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + "A new update is available: " + EnumChatFormatting.WHITE + EnumChatFormatting.BOLD + "v" + latestVersion));
                    player.func_145747_a(new ChatComponentText(EnumChatFormatting.GREEN + "Click here or run '" + EnumChatFormatting.WHITE + "/updateva" + EnumChatFormatting.GREEN + "' to update!\n").func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/updateva"){

                        public ClickEvent.Action func_150669_a() {
                            return ClickEvent.Action.RUN_COMMAND;
                        }
                    })));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Error checking for updates: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadAndExtractUpdate(EntityPlayer player) {
        InputStream inputStream = null;
        try {
            InputStream trustStoreInputStream = VolcAddons.class.getResourceAsStream("/skytilscacerts.jks");
            if (trustStoreInputStream == null) {
                throw new FileNotFoundException("Truststore file not found");
            }
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(trustStoreInputStream, "skytilsontop".toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            URL apiUrl = new URL(UPDATE_CHECK_URL);
            HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (connection.getResponseCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonObject releaseJson = new JsonParser().parse(response.toString()).getAsJsonObject();
                String latestVersion = releaseJson.get("tag_name").getAsString();
                JsonArray assets = releaseJson.get("assets").getAsJsonArray();
                String zipUrl = null;
                for (int i = 0; i < assets.size(); ++i) {
                    JsonObject asset = assets.get(i).getAsJsonObject();
                    if (!asset.get("name").getAsString().equals("VolcAddons.zip")) continue;
                    zipUrl = asset.get("browser_download_url").getAsString();
                    break;
                }
                if (zipUrl != null) {
                    try {
                        ZipEntry entry;
                        int bytesRead;
                        inputStream = new URL(zipUrl).openStream();
                        FileOutputStream fileOutputStream = new FileOutputStream("VolcAddons.zip");
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            fileOutputStream.write(buffer, 0, bytesRead);
                        }
                        fileOutputStream.close();
                        inputStream.close();
                        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream("VolcAddons.zip"));
                        while ((entry = zipInputStream.getNextEntry()) != null) {
                            String entryName = entry.getName();
                            String entryPath = moduleDir + separator + entryName;
                            if (entry.isDirectory()) continue;
                            File entryFile = new File(entryPath);
                            File parentDir = new File(entryFile.getParent());
                            if (!parentDir.exists()) {
                                parentDir.mkdirs();
                            }
                            FileOutputStream fileOutputStreamEntry = new FileOutputStream(entryFile);
                            while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                                fileOutputStreamEntry.write(buffer, 0, bytesRead);
                            }
                            fileOutputStreamEntry.close();
                        }
                        zipInputStream.close();
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Update successful: New version " + latestVersion + " downloaded!"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Error: VolcAddons.zip not found in the latest release assets!"));
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Error fetching latest release information from GitHub API!"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Update failed: " + e));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        separator = File.separator;
        modDir = System.getProperty("user.home");
        moduleDir = modDir + separator + "ChatTriggers" + separator + "modules" + separator + MODID;
    }
}

