/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;
import org.mozilla.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T extends Comparable<T>>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    private static final long serialVersionUID = -4963053773152251274L;
    protected final int length;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_get = 3;
    private static final int Id_set = 4;
    private static final int Id_subarray = 5;
    private static final int Id_join = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_slice = 9;
    private static final int Id_every = 10;
    private static final int Id_filter = 11;
    private static final int Id_forEach = 12;
    private static final int Id_map = 13;
    private static final int Id_reduce = 14;
    private static final int Id_reduceRight = 15;
    private static final int Id_reverse = 16;
    private static final int Id_some = 17;
    private static final int Id_copyWithin = 18;
    private static final int Id_find = 19;
    private static final int Id_findIndex = 20;
    private static final int Id_fill = 21;
    private static final int Id_keys = 22;
    private static final int Id_values = 23;
    private static final int Id_entries = 24;
    private static final int Id_sort = 25;
    private static final int Id_includes = 26;
    private static final int SymbolId_iterator = 27;
    protected static final int MAX_PROTOTYPE_ID = 27;
    private static final int Id_length = 4;
    private static final int Id_BYTES_PER_ELEMENT = 5;
    private static final int MAX_INSTANCE_ID = 5;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer ab, int off, int len, int byteLen) {
        super(ab, off, byteLen);
        this.length = len;
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        if (id == 27) {
            this.initPrototypeMethod((Object)this.getClassName(), id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 1;
                s = "get";
                break;
            }
            case 4: {
                arity = 2;
                s = "set";
                break;
            }
            case 5: {
                arity = 2;
                s = "subarray";
                break;
            }
            case 6: {
                arity = 1;
                s = "join";
                break;
            }
            case 7: {
                arity = 1;
                s = "indexOf";
                break;
            }
            case 8: {
                arity = 1;
                s = "lastIndexOf";
                break;
            }
            case 9: {
                arity = 2;
                s = "slice";
                break;
            }
            case 10: {
                arity = 2;
                s = "every";
                break;
            }
            case 11: {
                arity = 2;
                s = "filter";
                break;
            }
            case 12: {
                arity = 2;
                s = "forEach";
                break;
            }
            case 13: {
                arity = 2;
                s = "map";
                break;
            }
            case 14: {
                arity = 2;
                s = "reduce";
                break;
            }
            case 15: {
                arity = 2;
                s = "reduceRight";
                break;
            }
            case 16: {
                arity = 0;
                s = "reverse";
                break;
            }
            case 17: {
                arity = 2;
                s = "some";
                break;
            }
            case 18: {
                arity = 3;
                s = "copyWithin";
                break;
            }
            case 19: {
                arity = 2;
                s = "find";
                break;
            }
            case 20: {
                arity = 2;
                s = "findIndex";
                break;
            }
            case 21: {
                arity = 3;
                s = "fill";
                break;
            }
            case 22: {
                arity = 0;
                s = "keys";
                break;
            }
            case 23: {
                arity = 0;
                s = "values";
                break;
            }
            case 24: {
                arity = 0;
                s = "entries";
                break;
            }
            case 25: {
                arity = 1;
                s = "sort";
                break;
            }
            case 26: {
                arity = 1;
                s = "includes";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod((Object)this.getClassName(), id, s, fnName, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(this.getClassName())) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj != null) {
                    throw ScriptRuntime.typeError1("msg.builtin.no.new", "TypedArray");
                }
                return this.js_constructor(cx, scope, args);
            }
            case 2: {
                NativeTypedArrayView<T> realThis = this.realThis(thisObj, f);
                int arrayLength = realThis.getArrayLength();
                StringBuilder builder = new StringBuilder();
                if (arrayLength > 0) {
                    builder.append(ScriptRuntime.toString(realThis.js_get(0)));
                }
                for (int i = 1; i < arrayLength; ++i) {
                    builder.append(',');
                    builder.append(ScriptRuntime.toString(realThis.js_get(i)));
                }
                return builder.toString();
            }
            case 3: {
                if (args.length > 0) {
                    return this.realThis(thisObj, f).js_get(ScriptRuntime.toInt32(args[0]));
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 4: {
                if (args.length > 0) {
                    NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                    if (args[0] instanceof NativeTypedArrayView) {
                        int offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
                        super.setRange((NativeTypedArrayView)args[0], offset);
                        return Undefined.instance;
                    }
                    if (args[0] instanceof NativeArray) {
                        int offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
                        super.setRange((NativeArray)args[0], offset);
                        return Undefined.instance;
                    }
                    if (args[0] instanceof Scriptable) {
                        return Undefined.instance;
                    }
                    if (NativeTypedArrayView.isArg(args, 2)) {
                        return self.js_set(ScriptRuntime.toInt32(args[0]), args[1]);
                    }
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 5: {
                if (args.length > 0) {
                    NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                    int start = ScriptRuntime.toInt32(args[0]);
                    int end = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : self.length;
                    return super.js_subarray(cx, scope, start, end);
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 6: {
                return super.js_join(args.length > 0 ? args[0] : null);
            }
            case 7: {
                return super.js_indexOf(args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : Integer.valueOf(0));
            }
            case 8: {
                return super.js_lastIndexOf(args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : Integer.valueOf(0));
            }
            case 9: {
                return super.js_slice(cx, scope, args.length > 0 ? args[0] : Integer.valueOf(0), args.length > 1 ? args[1] : Integer.valueOf(((NativeTypedArrayView)thisObj).length));
            }
            case 10: {
                return super.js_every(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
            }
            case 11: {
                return super.js_filter(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
            }
            case 12: {
                super.js_forEach(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
                return Undefined.instance;
            }
            case 13: {
                return super.js_map(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
            }
            case 14: {
                return super.js_reduce(cx, scope, args.length > 0 ? args[0] : null, thisObj, args.length > 1 ? args[1] : null);
            }
            case 15: {
                return super.js_reduceRight(cx, scope, args.length > 0 ? args[0] : null, thisObj, args.length > 1 ? args[1] : null);
            }
            case 16: {
                return super.js_reverse(cx, scope);
            }
            case 17: {
                return super.js_some(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
            }
            case 18: {
                return super.js_copyWithin(args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : Integer.valueOf(0), args.length > 2 ? args[2] : Integer.valueOf(((NativeTypedArrayView)thisObj).length));
            }
            case 19: {
                return super.js_find(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
            }
            case 20: {
                return super.js_findIndex(cx, scope, args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : thisObj);
            }
            case 21: {
                return super.js_fill(args.length > 0 ? args[0] : null, args.length > 1 ? args[1] : Integer.valueOf(0), args.length > 2 ? args[2] : Integer.valueOf(((NativeTypedArrayView)thisObj).length));
            }
            case 25: {
                return super.js_sort(cx, scope, thisObj, args.length > 0 ? args[0] : null);
            }
            case 26: {
                return super.js_includes(args.length >= 1 ? args[0] : Undefined.instance, args.length >= 2 ? (int)ScriptRuntime.toNumber(args[1]) : 0);
            }
            case 22: {
                return new NativeArrayIterator(scope, thisObj, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
            }
            case 23: 
            case 27: {
                return new NativeArrayIterator(scope, thisObj, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
            }
            case 24: {
                return new NativeArrayIterator(scope, thisObj, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    public Object get(int index, Scriptable start) {
        return this.js_get(index);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return !this.checkIndex(index);
    }

    @Override
    public void put(int index, Scriptable start, Object val) {
        this.js_set(index, val);
    }

    @Override
    public void delete(int index) {
    }

    @Override
    public Object[] getIds() {
        Object[] ret = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    protected boolean checkIndex(int index) {
        return index < 0 || index >= this.length;
    }

    public abstract int getBytesPerElement();

    protected abstract NativeTypedArrayView<T> construct(NativeArrayBuffer var1, int var2, int var3);

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    protected abstract NativeTypedArrayView<T> realThis(Scriptable var1, IdFunctionObject var2);

    private NativeArrayBuffer makeArrayBuffer(Context cx, Scriptable scope, int length) {
        return (NativeArrayBuffer)cx.newObject(scope, "ArrayBuffer", new Object[]{length});
    }

    private NativeTypedArrayView<T> js_constructor(Context cx, Scriptable scope, Object[] args) {
        if (!NativeTypedArrayView.isArg(args, 0)) {
            return this.construct(NativeArrayBuffer.EMPTY_BUFFER, 0, 0);
        }
        Object arg0 = args[0];
        if (arg0 == null) {
            return this.construct(NativeArrayBuffer.EMPTY_BUFFER, 0, 0);
        }
        if (arg0 instanceof Number || arg0 instanceof String) {
            int length = ScriptRuntime.toInt32(arg0);
            NativeArrayBuffer buffer = this.makeArrayBuffer(cx, scope, length * this.getBytesPerElement());
            return this.construct(buffer, 0, length);
        }
        if (arg0 instanceof NativeTypedArrayView) {
            NativeTypedArrayView src = (NativeTypedArrayView)arg0;
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, src.length * this.getBytesPerElement());
            NativeTypedArrayView<T> v = this.construct(na, 0, src.length);
            for (int i = 0; i < src.length; ++i) {
                v.js_set(i, src.js_get(i));
            }
            return v;
        }
        if (arg0 instanceof NativeArrayBuffer) {
            NativeArrayBuffer na = (NativeArrayBuffer)arg0;
            int byteOff = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
            int byteLen = NativeTypedArrayView.isArg(args, 2) ? ScriptRuntime.toInt32(args[2]) * this.getBytesPerElement() : na.getLength() - byteOff;
            if (byteOff < 0 || byteOff > na.buffer.length) {
                throw ScriptRuntime.constructError("RangeError", "offset out of range");
            }
            if (byteLen < 0 || byteOff + byteLen > na.buffer.length) {
                throw ScriptRuntime.constructError("RangeError", "length out of range");
            }
            if (byteOff % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.constructError("RangeError", "offset must be a multiple of the byte size");
            }
            if (byteLen % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.constructError("RangeError", "offset and buffer must be a multiple of the byte size");
            }
            return this.construct(na, byteOff, byteLen / this.getBytesPerElement());
        }
        if (arg0 instanceof NativeArray) {
            NativeArray array = (NativeArray)arg0;
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, array.size() * this.getBytesPerElement());
            NativeTypedArrayView<T> v = this.construct(na, 0, array.size());
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i, (Scriptable)array);
                if (value == Scriptable.NOT_FOUND || value == Undefined.instance) {
                    v.js_set(i, Double.NaN);
                    continue;
                }
                if (value instanceof Wrapper) {
                    v.js_set(i, ((Wrapper)value).unwrap());
                    continue;
                }
                v.js_set(i, value);
            }
            return v;
        }
        if (ScriptRuntime.isArray(arg0)) {
            Object[] arrayElements = ScriptRuntime.getArrayElements((Scriptable)arg0);
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, arrayElements.length * this.getBytesPerElement());
            NativeTypedArrayView<T> v = this.construct(na, 0, arrayElements.length);
            for (int i = 0; i < arrayElements.length; ++i) {
                v.js_set(i, arrayElements[i]);
            }
            return v;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView<T> v, int off) {
        if (off >= this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        if (v.length > this.length - off) {
            throw ScriptRuntime.constructError("RangeError", "source array too long");
        }
        if (v.arrayBuffer == this.arrayBuffer) {
            int i;
            Object[] tmp = new Object[v.length];
            for (i = 0; i < v.length; ++i) {
                tmp[i] = v.js_get(i);
            }
            for (i = 0; i < v.length; ++i) {
                this.js_set(i + off, tmp[i]);
            }
        } else {
            for (int i = 0; i < v.length; ++i) {
                this.js_set(i + off, v.js_get(i));
            }
        }
    }

    private void setRange(NativeArray a, int off) {
        if (off > this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        if (off + a.size() > this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset + length out of range");
        }
        int pos = off;
        for (Object val : a) {
            this.js_set(pos, val);
            ++pos;
        }
    }

    private Object js_subarray(Context cx, Scriptable scope, int s, int e) {
        int start = s < 0 ? this.length + s : s;
        int end = e < 0 ? this.length + e : e;
        start = Math.max(0, start);
        end = Math.min(this.length, end);
        int len = Math.max(0, end - start);
        int byteOff = Math.min(start * this.getBytesPerElement(), this.arrayBuffer.getLength());
        return cx.newObject(scope, this.getClassName(), new Object[]{this.arrayBuffer, byteOff, len});
    }

    private String js_join(Object separator) {
        if (separator == null) {
            separator = ",";
        } else if (!(separator instanceof String)) {
            separator = ScriptRuntime.toString(separator);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(ScriptRuntime.toString(this.getArrayElement(i)));
            if (i == this.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    private int js_indexOf(Object object, Object start) {
        if (!(start instanceof Number)) {
            start = ScriptRuntime.toNumber(start);
        }
        for (int i = ((Integer)start).intValue(); i < this.length; ++i) {
            if (!ScriptRuntime.shallowEq(this.getArrayElement(i), object)) continue;
            return i;
        }
        return -1;
    }

    private int js_lastIndexOf(Object object, Object start) {
        if (!(start instanceof Number)) {
            start = ScriptRuntime.toNumber(start);
        }
        for (int i = this.length; i > (Integer)start; --i) {
            if (!ScriptRuntime.shallowEq(this.getArrayElement(i), object)) continue;
            return i;
        }
        return -1;
    }

    private NativeTypedArrayView<T> js_slice(Context cx, Scriptable scope, Object _start, Object _end) {
        if (!(_start instanceof Number)) {
            _start = (int)ScriptRuntime.toNumber(_start);
        } else if (_start instanceof Double) {
            _start = ((Double)_start).intValue();
        }
        if (!(_end instanceof Number)) {
            _end = (int)ScriptRuntime.toNumber(_end);
        } else if (_end instanceof Double) {
            _end = ((Double)_end).intValue();
        }
        int start = (Integer)_start;
        int end = (Integer)_end;
        if (start < 0) {
            start = this.length + start;
        }
        if (end < 0) {
            end = this.length + end;
        }
        int length = Math.max(end - start, 0);
        NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, length);
        NativeTypedArrayView<T> view = this.construct(na, 0, length);
        for (int i = start; i < end; ++i) {
            view.js_set(start - i, this.getArrayElement(i));
        }
        return view;
    }

    private boolean isFalsey(Object obj) {
        return obj == null || obj == Undefined.instance || obj instanceof Boolean && (Boolean)obj == false;
    }

    private boolean js_every(Context cx, Scriptable scope, Object cb, Object _thisObj) {
        this.validateFunctionalArgs(cb, _thisObj, "%TypedArray%.prototype.every");
        Callable fn = (Callable)cb;
        Scriptable thisObj = (Scriptable)_thisObj;
        for (int i = 0; i < this.length; ++i) {
            Object result = fn.call(cx, scope, thisObj, new Object[]{this.getArrayElement(i), i, _thisObj});
            if (!this.isFalsey(result)) continue;
            return false;
        }
        return true;
    }

    private NativeTypedArrayView<T> js_filter(Context cx, Scriptable scope, Object cb, Object thisObj) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.filter");
        Callable fn = (Callable)cb;
        LinkedList<Comparable> ll = new LinkedList<Comparable>();
        for (int i = 0; i < this.length; ++i) {
            Comparable el = (Comparable)this.getArrayElement(i);
            Object result = fn.call(cx, scope, (Scriptable)thisObj, new Object[]{el, i, thisObj});
            if (this.isFalsey(result)) continue;
            ll.add(el);
        }
        int length = ll.size();
        NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, length);
        NativeTypedArrayView<T> view = this.construct(na, 0, length);
        Iterator ite = ll.iterator();
        int index = 0;
        while (ite.hasNext()) {
            view.setArrayElement(index, ite.next());
            ++index;
        }
        return view;
    }

    private void js_forEach(Context cx, Scriptable scope, Object cb, Object thisObj) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.forEach");
        Callable fn = (Callable)cb;
        for (int i = 0; i < this.length; ++i) {
            fn.call(cx, scope, (Scriptable)thisObj, new Object[]{this.getArrayElement(i), i, thisObj});
        }
    }

    private NativeTypedArrayView<T> js_map(Context cx, Scriptable scope, Object cb, Object thisObj) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.map");
        Callable fn = (Callable)cb;
        for (int i = 0; i < this.length; ++i) {
            Object[] args = new Object[]{this.getArrayElement(i), i, thisObj};
            this.setArrayElement(i, fn.call(cx, scope, (Scriptable)thisObj, args));
        }
        return this;
    }

    private Object js_reduce(Context cx, Scriptable scope, Object cb, Object thisObj, Object initialValue) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.reduce");
        int start = 0;
        if (initialValue == null) {
            start = 1;
            initialValue = this.getArrayElement(0);
        }
        Callable fn = (Callable)cb;
        for (int i = start; i < this.length; ++i) {
            Object[] args = new Object[]{initialValue, this.getArrayElement(i), i, thisObj};
            initialValue = fn.call(cx, scope, (Scriptable)thisObj, args);
        }
        return initialValue;
    }

    private Object js_reduceRight(Context cx, Scriptable scope, Object cb, Object thisObj, Object initialValue) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.reduceRight");
        int start = this.length - 1;
        if (initialValue == null) {
            --start;
            initialValue = this.getArrayElement(0);
        }
        Callable fn = (Callable)cb;
        for (int i = start; i >= 0; --i) {
            Object[] args = new Object[]{initialValue, this.getArrayElement(i), i, thisObj};
            initialValue = fn.call(cx, scope, (Scriptable)thisObj, args);
        }
        return initialValue;
    }

    private NativeTypedArrayView<T> js_reverse(Context cx, Scriptable scope) {
        NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, this.length);
        NativeTypedArrayView<T> view = this.construct(na, 0, this.length);
        for (int i = 0; i < this.length; ++i) {
            view.setArrayElement(i, this.getArrayElement(this.length - i - 1));
        }
        return view;
    }

    private boolean js_some(Context cx, Scriptable scope, Object cb, Object thisObj) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.some");
        Callable fn = (Callable)cb;
        for (int i = 0; i < this.length; ++i) {
            Object result = fn.call(cx, scope, (Scriptable)thisObj, new Object[]{this.getArrayElement(i), i, thisObj});
            if (this.isFalsey(result)) continue;
            return true;
        }
        return false;
    }

    private NativeTypedArrayView<T> js_copyWithin(Object _target, Object _start, Object _end) {
        int i;
        if (_target == null) {
            return this;
        }
        int target = (int)ScriptRuntime.toNumber(_target);
        int start = (int)ScriptRuntime.toNumber(_start);
        int end = (int)ScriptRuntime.toNumber(_end);
        int copyLength = Math.max(end - start, 0);
        if (copyLength == 0) {
            return this;
        }
        if (target + copyLength >= this.length) {
            copyLength = this.length - target;
        }
        LinkedList<Object> ll = new LinkedList<Object>();
        for (i = 0; i < copyLength; ++i) {
            ll.add(this.getArrayElement(start + i));
        }
        i = 0;
        for (Object e : ll) {
            this.setArrayElement(target + i++, e);
        }
        return this;
    }

    private Object js_find(Context cx, Scriptable scope, Object cb, Object thisObj) {
        int index = this.js_findIndex(cx, scope, cb, thisObj);
        if (index == -1) {
            return Undefined.instance;
        }
        return this.getArrayElement(index);
    }

    private int js_findIndex(Context cx, Scriptable scope, Object cb, Object thisObj) {
        this.validateFunctionalArgs(cb, thisObj, "%TypedArray%.prototype.findIndex");
        Callable fn = (Callable)cb;
        for (int i = 0; i < this.length; ++i) {
            Object el = this.getArrayElement(i);
            Object[] args = new Object[]{el, i, thisObj};
            Object result = fn.call(cx, scope, (Scriptable)thisObj, args);
            if (this.isFalsey(result)) continue;
            return i;
        }
        return -1;
    }

    private NativeTypedArrayView<T> js_fill(Object value, Object _start, Object _end) {
        if (value == null) {
            return this;
        }
        int start = (int)ScriptRuntime.toNumber(_start);
        int end = (int)ScriptRuntime.toNumber(_end);
        for (int i = start; i < end; ++i) {
            this.setArrayElement(i, value);
        }
        return this;
    }

    private NativeTypedArrayView<T> js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object sorter) {
        boolean sorted;
        Comparator cmp;
        if (sorter == null) {
            cmp = Comparable::compareTo;
        } else {
            if (!(sorter instanceof Callable)) {
                throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(sorter));
            }
            Callable fn = (Callable)sorter;
            cmp = (a, b) -> {
                Object result = fn.call(cx, scope, thisObj, new Object[]{a, b});
                if (result instanceof Scriptable) {
                    return this.isFalsey(result) ? 0 : 1;
                }
                return (int)ScriptRuntime.toNumber(result);
            };
        }
        do {
            sorted = true;
            for (int i = 0; i < this.length - 1; ++i) {
                Object el2;
                Object el1 = this.getArrayElement(i);
                int res = cmp.compare((Comparable)el1, (Comparable)(el2 = this.getArrayElement(i + 1)));
                if (res <= 0) continue;
                sorted = false;
                this.setArrayElement(i, el2);
                this.setArrayElement(i + 1, el1);
            }
        } while (!sorted);
        return this;
    }

    private boolean js_includes(Object searchElement, int fromIndex) {
        int k;
        if (this.length <= 0) {
            return false;
        }
        int n = k = fromIndex >= 0 ? fromIndex : this.length + fromIndex;
        if (k < 0) {
            k = 0;
        }
        while (k < this.length) {
            if (ScriptRuntime.shallowEq(this.getArrayElement(k), searchElement)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private void validateFunctionalArgs(Object cb, Object thisObj, String errorStr) {
        if (cb == null) {
            throw ScriptRuntime.typeError2("msg.typed.array.missing.argument", "0", errorStr);
        }
        if (!(cb instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(cb));
        }
        if (!(thisObj instanceof Scriptable)) {
            throw ScriptRuntime.typeError2("msg.typed.array.invalid.argument", "1", errorStr);
        }
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (SymbolKey.ITERATOR.equals(k)) {
            return 27;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'g') {
                    if (s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                    return 3;
                }
                if (c == 'm') {
                    if (s.charAt(2) != 'p' || s.charAt(1) != 'a') break;
                    return 13;
                }
                if (c != 's' || s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                return 4;
            }
            case 4: {
                switch (s.charAt(2)) {
                    case 'i': {
                        X = "join";
                        id = 6;
                        break block0;
                    }
                    case 'l': {
                        X = "fill";
                        id = 21;
                        break block0;
                    }
                    case 'm': {
                        X = "some";
                        id = 17;
                        break block0;
                    }
                    case 'n': {
                        X = "find";
                        id = 19;
                        break block0;
                    }
                    case 'r': {
                        X = "sort";
                        id = 25;
                        break block0;
                    }
                    case 'y': {
                        X = "keys";
                        id = 22;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(0);
                if (c == 'e') {
                    X = "every";
                    id = 10;
                    break;
                }
                if (c != 's') break;
                X = "slice";
                id = 9;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'f') {
                    X = "filter";
                    id = 11;
                    break;
                }
                if (c == 'r') {
                    X = "reduce";
                    id = 14;
                    break;
                }
                if (c != 'v') break;
                X = "values";
                id = 23;
                break;
            }
            case 7: {
                switch (s.charAt(0)) {
                    case 'e': {
                        X = "entries";
                        id = 24;
                        break block0;
                    }
                    case 'f': {
                        X = "forEach";
                        id = 12;
                        break block0;
                    }
                    case 'i': {
                        X = "indexOf";
                        id = 7;
                        break block0;
                    }
                    case 'r': {
                        X = "reverse";
                        id = 16;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'i') {
                    X = "includes";
                    id = 26;
                    break;
                }
                if (c == 's') {
                    X = "subarray";
                    id = 5;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 9: {
                X = "findIndex";
                id = 20;
                break;
            }
            case 10: {
                X = "copyWithin";
                id = 18;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "constructor";
                    id = 1;
                    break;
                }
                if (c == 'l') {
                    X = "lastIndexOf";
                    id = 8;
                    break;
                }
                if (c != 'r') break;
                X = "reduceRight";
                id = 15;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        ctor.put("BYTES_PER_ELEMENT", (Scriptable)ctor, (Object)ScriptRuntime.wrapInt(this.getBytesPerElement()));
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id) {
            case 4: {
                return "length";
            }
            case 5: {
                return "BYTES_PER_ELEMENT";
            }
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 4: {
                return ScriptRuntime.wrapInt(this.length);
            }
            case 5: {
                return ScriptRuntime.wrapInt(this.getBytesPerElement());
            }
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 6) {
            X = "length";
            id = 4;
        } else if (s_length == 17) {
            X = "BYTES_PER_ELEMENT";
            id = 5;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        return NativeTypedArrayView.instanceIdInfo(5, id);
    }

    @Override
    public Object getArrayElement(int index) {
        return this.js_get(index);
    }

    @Override
    public void setArrayElement(int index, Object value) {
        this.js_set(index, value);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.length; ++i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            a[i] = this.js_get(i);
        }
        return a;
    }

    @Override
    public <U> U[] toArray(U[] ts) {
        Object[] a = ts.length >= this.length ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), this.length);
        for (int i = 0; i < this.length; ++i) {
            try {
                a[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException cce) {
                throw new ArrayStoreException();
            }
        }
        return a;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        try {
            NativeTypedArrayView v = (NativeTypedArrayView)o;
            if (this.length != v.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.js_get(i).equals(v.js_get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.length; ++i) {
            hc += this.js_get(i).hashCode();
        }
        return hc;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int start) {
        if (this.checkIndex(start)) {
            throw new IndexOutOfBoundsException();
        }
        return new NativeTypedArrayIterator(this, start);
    }

    @Override
    public List<T> subList(int i, int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }
}

