/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.proxy.NativeProxyCtor;

public class NativeProxy
extends IdScriptableObject
implements Function {
    private static final long serialVersionUID = -5164128569432516845L;
    private ScriptableObject target;
    private ScriptableObject handler;
    private List<Object> handlerIds;
    private boolean revoked;

    public static void init(Scriptable scope, boolean sealed) {
        NativeProxyCtor ctor = new NativeProxyCtor();
        ctor.setParentScope(scope);
        ctor.setPrototype(NativeProxy.getObjectPrototype(scope));
        ScriptableObject.deleteProperty((Scriptable)ctor, "prototype");
        if (sealed) {
            ctor.sealObject();
        }
        NativeProxy.defineProperty(scope, "Proxy", (Object)ctor, 2);
    }

    NativeProxy(ScriptableObject target, ScriptableObject handler) {
        this.target = target;
        this.handler = handler;
        this.handlerIds = handler == null ? Collections.emptyList() : Arrays.asList(handler.getIds());
    }

    public ScriptableObject getTarget() {
        return this.target;
    }

    public ScriptableObject getHandler() {
        return this.handler;
    }

    void revoke() {
        this.revoked = true;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    private void ensureNotRevoked() {
        if (this.revoked) {
            throw ScriptRuntime.typeError0("msg.proxy.revocable.illegal.operation");
        }
    }

    @Override
    public String getClassName() {
        return this.target.getClassName();
    }

    @Override
    protected void initPrototypeId(int id) {
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object targetRes;
        int attributes;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("get")) {
            return this.target.get(name, (Scriptable)this.target);
        }
        Object get = this.handler.get("get");
        if (get == null) {
            return null;
        }
        if (!(get instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "get");
        }
        Function fn = (Function)get;
        Object result = fn.call(Context.getContext(), this, start, new Object[]{this.target, name, start});
        if (this.target.has(name, (Scriptable)this.target) && ((attributes = this.target.getAttributes(name)) & 4) != 0 && (attributes & 1) != 0 && result != (targetRes = this.target.get(name))) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.get", name);
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        Object targetRes;
        int attributes;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("get")) {
            return this.target.get(index, (Scriptable)this.target);
        }
        Object get = this.handler.get("get");
        if (get == null) {
            return null;
        }
        if (!(get instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "get");
        }
        Function fn = (Function)get;
        Object result = fn.call(Context.getContext(), this, start, new Object[]{this.target, ScriptRuntime.toString(index), start});
        if (this.target.has(index, (Scriptable)this.target) && ((attributes = this.target.getAttributes(index)) & 4) != 0 && (attributes & 1) != 0 && result != (targetRes = this.target.get(index))) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.get", index);
        }
        return result;
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        Object targetRes;
        int attributes;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("get")) {
            return this.target.get(key, (Scriptable)this.target);
        }
        Object get = this.handler.get("get");
        if (get == null) {
            return null;
        }
        if (!(get instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "get");
        }
        Function fn = (Function)get;
        Object result = fn.call(Context.getContext(), this, start, new Object[]{this.target, key, start});
        if (this.target.has(key, (Scriptable)this.target) && ((attributes = this.target.getAttributes(key)) & 4) != 0 && (attributes & 1) != 0 && result != (targetRes = this.target.get(key))) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.get", key);
        }
        return result;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        Object setter;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("set")) {
            this.target.put(name, (Scriptable)this.target, value);
            return;
        }
        if (this.target.has(name, (Scriptable)this.target)) {
            Object oldVal;
            int attributes = this.target.getAttributes(name);
            Object getter = this.target.getGetterOrSetter(name, 0, false);
            if ((attributes & 4) != 0 && (getter != null || getter != Undefined.instance) && ScriptableObject.hasProperty((Scriptable)this.target, "set")) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.set.accessor", name);
            }
            if ((attributes & 4) != 0 && (attributes & 1) != 0 && (oldVal = this.target.get(name)) != value) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.set.property", name);
            }
        }
        if ((setter = this.handler.get("set")) == null) {
            return;
        }
        if (!(setter instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "set");
        }
        ((Function)setter).call(Context.getContext(), this, start, new Object[]{this.target, name, value, start});
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        Object setter;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("set")) {
            this.target.put(index, (Scriptable)this.target, value);
            return;
        }
        if (this.target.has(index, (Scriptable)this.target)) {
            Object oldVal;
            int attributes = this.target.getAttributes(index);
            Object getter = this.target.getGetterOrSetter((String)null, index, false);
            if ((attributes & 4) != 0 && (getter != null || getter != Undefined.instance) && ScriptableObject.hasProperty((Scriptable)this.target, "set")) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.set.accessor", index);
            }
            if ((attributes & 4) != 0 && (attributes & 1) != 0 && (oldVal = this.target.get(index)) != value) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.set.property", index);
            }
        }
        if ((setter = this.handler.get("set")) == null) {
            return;
        }
        if (!(setter instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "set");
        }
        ((Function)setter).call(Context.getContext(), this, start, new Object[]{this.target, index, value, start});
    }

    @Override
    public void put(Symbol key, Scriptable start, Object value) {
        Object setter;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("set")) {
            this.target.put(key, (Scriptable)this.target, value);
        }
        if (this.target.has(key, (Scriptable)this.target)) {
            Object oldVal;
            int attributes = this.target.getAttributes(key);
            Object getter = this.target.getGetterOrSetter(key, 0, false);
            if ((attributes & 4) != 0 && (getter != null || getter != Undefined.instance) && ScriptableObject.hasProperty((Scriptable)this.target, "set")) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.set.accessor", key);
            }
            if ((attributes & 4) != 0 && (attributes & 1) != 0 && (oldVal = this.target.get(key)) != value) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.set.property", key);
            }
        }
        if ((setter = this.handler.get("set")) == null) {
            return;
        }
        if (!(setter instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "put");
        }
        ((Function)setter).call(Context.getContext(), this, start, new Object[]{this.target, key, value, start});
    }

    @Override
    public boolean has(String name, Scriptable start) {
        boolean handlerResult;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("has")) {
            return this.target.has(name, (Scriptable)this.target);
        }
        Object handlerHas = this.handler.get("has");
        if (handlerHas == null) {
            return false;
        }
        if (!(handlerHas instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "has");
        }
        Function fn = (Function)handlerHas;
        Object _handlerResult = fn.call(Context.getContext(), this, this, new Object[]{this.target, name});
        if (!(_handlerResult instanceof Boolean) && _handlerResult != Undefined.instance) {
            throw Kit.codeBug();
        }
        boolean bl = handlerResult = _handlerResult != Undefined.instance && (Boolean)_handlerResult != false;
        if (this.target.has(name, (Scriptable)this.target)) {
            int attributes = this.target.getAttributes(name);
            if ((attributes & 4) != 0 && !handlerResult) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.has.non.configurable", name);
            }
            if (!this.target.isExtensible() && !handlerResult) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.has.non.extensible", name);
            }
        }
        return handlerResult;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        boolean handlerResult;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("has")) {
            return this.target.has(index, (Scriptable)this.target);
        }
        Object handlerHas = this.handler.get("has");
        if (handlerHas == null) {
            return false;
        }
        if (!(handlerHas instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "has");
        }
        Function fn = (Function)handlerHas;
        Object _handlerResult = fn.call(Context.getContext(), this, this, new Object[]{this.target, index});
        if (!(_handlerResult instanceof Boolean) && _handlerResult != Undefined.instance) {
            throw Kit.codeBug();
        }
        boolean bl = handlerResult = _handlerResult != Undefined.instance && (Boolean)_handlerResult != false;
        if (this.target.has(index, (Scriptable)this.target)) {
            int attributes = this.target.getAttributes(index);
            if ((attributes & 4) != 0 && !handlerResult) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.has.non.configurable", index);
            }
            if (!this.target.isExtensible() && !handlerResult) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.has.non.extensible", index);
            }
        }
        return handlerResult;
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        boolean handlerResult;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("has")) {
            return this.target.has(key, (Scriptable)this.target);
        }
        Object handlerHas = this.handler.get("has");
        if (handlerHas == null) {
            return false;
        }
        if (!(handlerHas instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "has");
        }
        Function fn = (Function)handlerHas;
        Object _handlerResult = fn.call(Context.getContext(), this, this, new Object[]{this.target, key});
        if (!(_handlerResult instanceof Boolean) && _handlerResult != Undefined.instance) {
            throw Kit.codeBug();
        }
        boolean bl = handlerResult = _handlerResult != Undefined.instance && (Boolean)_handlerResult != false;
        if (this.target.has(key, (Scriptable)this.target)) {
            int attributes = this.target.getAttributes(key);
            if ((attributes & 4) != 0 && !handlerResult) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.has.non.configurable", key);
            }
            if (!this.target.isExtensible() && !handlerResult) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.has.non.extensible", key);
            }
        }
        return handlerResult;
    }

    @Override
    public void delete(String name) {
        int attributes;
        boolean result;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("deleteProperty")) {
            this.target.delete(name);
            return;
        }
        Object deleteProperty = this.handler.get("deleteProperty");
        if (deleteProperty == null) {
            return;
        }
        if (!(deleteProperty instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "deleteProperty");
        }
        Object _result = ((Function)deleteProperty).call(Context.getContext(), this, this, new Object[]{this.target, name});
        if (!(_result instanceof Boolean) && _result != Undefined.instance) {
            throw Kit.codeBug();
        }
        boolean bl = result = _result != Undefined.instance && (Boolean)_result != false;
        if (result && this.target.has(name, (Scriptable)this.target) && ((attributes = this.target.getAttributes(name)) & 4) != 0) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.delete", name);
        }
    }

    @Override
    public void delete(Symbol key) {
        int attributes;
        boolean result;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("deleteProperty")) {
            this.target.delete(key);
            return;
        }
        Object deleteProperty = this.handler.get("deleteProperty");
        if (deleteProperty == null) {
            return;
        }
        if (!(deleteProperty instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "deleteProperty");
        }
        Object _result = ((Function)deleteProperty).call(Context.getContext(), this, this, new Object[]{this.target, key});
        if (!(_result instanceof Boolean) && _result != Undefined.instance) {
            throw Kit.codeBug();
        }
        boolean bl = result = _result != Undefined.instance && (Boolean)_result != false;
        if (result && this.target.has(key, (Scriptable)this.target) && ((attributes = this.target.getAttributes(key)) & 4) != 0) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.delete", key);
        }
    }

    @Override
    public ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        int targetDesc;
        boolean exists;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("getOwnPropertyDescriptor")) {
            return this.target.getOwnPropertyDescriptor(cx, id);
        }
        Object getOwnPropertyDescriptor = this.handler.get("getOwnPropertyDescriptor");
        if (getOwnPropertyDescriptor == null) {
            return null;
        }
        if (!(getOwnPropertyDescriptor instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "getOwnPropertyDescriptor");
        }
        Object _result = ((Function)getOwnPropertyDescriptor).call(cx, this, this, new Object[]{this.target, id});
        if (_result != Undefined.instance && !(_result instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.getdescriptor.inv1", ScriptRuntime.toString(id));
        }
        if (id instanceof String) {
            exists = this.target.has((String)id, (Scriptable)this.target);
            targetDesc = exists ? this.target.getAttributes((String)id) : -1;
        } else if (ScriptRuntime.isSymbol(id)) {
            exists = this.target.has((Symbol)id, (Scriptable)this.target);
            targetDesc = exists ? this.target.getAttributes((Symbol)id) : -1;
        } else {
            throw Kit.codeBug();
        }
        if (_result == Undefined.instance && exists && (targetDesc & 4) != 0) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.getdescriptor.inv2", ScriptRuntime.toString(id));
        }
        if (_result == Undefined.instance && exists && !this.target.isExtensible()) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.getdescriptor.inv3", ScriptRuntime.toString(id));
        }
        if (_result == Undefined.instance) {
            return null;
        }
        if (!exists && !this.target.isExtensible()) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.getdescriptor.inv4", ScriptRuntime.toString(id));
        }
        ScriptableObject handlerDesc = (ScriptableObject)_result;
        boolean configurable = NativeProxy.isConfigurable(handlerDesc);
        if (!configurable) {
            if (!exists) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.getdescriptor.inv5.non.existant", ScriptRuntime.toString(id));
            }
            if ((targetDesc & 4) == 0) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.getdescriptor.inv5.existant", ScriptRuntime.toString(id));
            }
        }
        if (!handlerDesc.has("configurable", (Scriptable)handlerDesc)) {
            NativeProxy.putProperty((Scriptable)handlerDesc, "configurable", (Object)false);
        }
        if (!handlerDesc.has("writable", (Scriptable)handlerDesc)) {
            NativeProxy.putProperty((Scriptable)handlerDesc, "writable", (Object)false);
        }
        if (!handlerDesc.has("enumerable", (Scriptable)handlerDesc)) {
            NativeProxy.putProperty((Scriptable)handlerDesc, "enumerable", (Object)false);
        }
        return handlerDesc;
    }

    @Override
    public void defineOwnProperty(Context cx, Object id, ScriptableObject desc) {
        int attributes;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("defineProperty")) {
            this.target.defineOwnProperty(cx, id, desc);
            return;
        }
        Object defineProperty = this.handler.get("defineProperty");
        if (defineProperty == null) {
            return;
        }
        if (!(defineProperty instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "defineOwnProperty");
        }
        Object result = ((Function)defineProperty).call(cx, this, this, new Object[]{this.target, id, desc});
        if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.defineprop.returned.false", ScriptRuntime.toString(id));
        }
        if (!this.target.isExtensible()) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.defineprop.not.extensible", ScriptRuntime.toString(id));
        }
        boolean isConfigurable = NativeProxy.isConfigurable(desc);
        if (!isConfigurable && (attributes = NativeProxy.getAttributes(this.target, id)) != -1 && (attributes & 4) == 0) {
            throw ScriptRuntime.typeError1("msg.proxy.invariant.defineprop.non.configurable", ScriptRuntime.toString(id));
        }
    }

    @Override
    public Scriptable getPrototype() {
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("getPrototypeOf")) {
            return this.target.getPrototype();
        }
        Object getPrototypeOf = this.handler.get("getPrototypeOf");
        if (getPrototypeOf == null) {
            return null;
        }
        if (!(getPrototypeOf instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "getPrototypeOf");
        }
        Object result = ((Function)getPrototypeOf).call(Context.getContext(), this, this, new Object[]{this.target});
        if (result != null && !(result instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError0("msg.proxy.invariant.getproto.invalid.return");
        }
        if (!this.target.isExtensible() && result != this.target.getPrototype()) {
            throw ScriptRuntime.typeError0("msg.proxy.invariant.getproto.non.extensible");
        }
        return (ScriptableObject)result;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("setPrototypeOf")) {
            this.target.setPrototype(m);
            return;
        }
        Object setPrototypeOf = this.handler.get("setPrototypeOf");
        if (setPrototypeOf == null) {
            return;
        }
        if (!(setPrototypeOf instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "setPrototypeOf");
        }
        Object result = ((Function)setPrototypeOf).call(Context.getContext(), this, this, new Object[]{this.target, m});
        if (result instanceof Boolean && ((Boolean)result).booleanValue() && !this.target.isExtensible() && m != this.target.getPrototype()) {
            throw ScriptRuntime.typeError0("msg.proxy.invariant.setproto.invalid.parameter");
        }
    }

    @Override
    public boolean isExtensible() {
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("isExtensible")) {
            return this.target.isExtensible();
        }
        Object isExtensible = this.handler.get("isExtensible");
        if (isExtensible == null) {
            return false;
        }
        if (!(isExtensible instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "isExtensible");
        }
        Object result = ((Function)isExtensible).call(Context.getContext(), this, this, new Object[]{this.target});
        if (!(result instanceof Boolean) || ((Boolean)result).booleanValue() != this.target.isExtensible()) {
            throw ScriptRuntime.typeError0("msg.proxy.invariant.isextensible");
        }
        return (Boolean)result;
    }

    @Override
    public void preventExtensions() {
        Object preventExtensions;
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("preventExtensions")) {
            this.target.preventExtensions();
        }
        if ((preventExtensions = this.handler.get("preventExtensions")) == null) {
            return;
        }
        if (!(preventExtensions instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "preventExtensions");
        }
        Object result = ((Function)preventExtensions).call(Context.getContext(), this, this, new Object[]{this.target});
        if (result instanceof Boolean && ((Boolean)result).booleanValue() && this.isExtensible()) {
            throw ScriptRuntime.typeError0("msg.proxy.invariant.prevent.extensible");
        }
    }

    @Override
    public Object[] getIds(boolean getNonEnumerable, boolean getSymbols) {
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("ownKeys")) {
            return this.target.getIds(getNonEnumerable, getSymbols);
        }
        Object ownKeys = this.handler.get("ownKeys");
        if (!(ownKeys instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "setPrototypeOf");
        }
        Object result = ((Function)ownKeys).call(Context.getContext(), this, this, new Object[]{this.target});
        if (!(result instanceof NativeArray)) {
            throw ScriptRuntime.typeError0("msg.proxy.invariant.ownkeys.invalid.array");
        }
        Object[] resultIds = ((NativeArray)result).toArray();
        boolean extensible = this.target.isExtensible();
        List<Object> targetIds = Arrays.asList(this.target.getIds());
        for (Object resultId : resultIds) {
            if (!(resultId instanceof String) && !ScriptRuntime.isSymbol(resultId)) {
                throw ScriptRuntime.typeError0("msg.proxy.invariant.ownkeys.invalid.array");
            }
            if (!extensible && !targetIds.contains(resultId)) {
                throw ScriptRuntime.typeError1("msg.proxy.invariant.ownkeys.invalid.element", ScriptRuntime.toString(resultId));
            }
            targetIds.remove(resultId);
        }
        for (Object e : targetIds) {
            int attributes = NativeProxy.getAttributes(this.target, e);
            if (attributes == -1 || (attributes & 4) == 0) continue;
            throw ScriptRuntime.typeError1("msg.proxy.invariant.ownkeys.skip.prop", ScriptRuntime.toString(e));
        }
        return resultIds;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("apply")) {
            if (this.target instanceof Callable) {
                return ((Callable)((Object)this.target)).call(cx, scope, this.target, args);
            }
            throw ScriptRuntime.typeError0("msg.proxy.not.callable");
        }
        if (!(this.target instanceof Callable)) {
            throw ScriptRuntime.typeError0("msg.proxy.target.not.callable");
        }
        Object apply = this.handler.get("apply");
        if (!(apply instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "call");
        }
        return ((Function)apply).call(cx, scope, thisObj, new Object[]{this.target, thisObj, cx.newArray(scope, args)});
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        this.ensureNotRevoked();
        if (!this.handlerIds.contains("construct")) {
            if (this.target instanceof BaseFunction) {
                return ((BaseFunction)this.target).construct(cx, scope, args);
            }
            throw ScriptRuntime.typeError0("msg.proxy.not.constructable");
        }
        if (!(this.target instanceof Function)) {
            throw ScriptRuntime.typeError0("msg.proxy.target.not.constructable");
        }
        Object construct = this.handler.get("construct");
        if (construct == null) {
            return null;
        }
        if (!(construct instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.proxy.invalid.handler", "preventExtensions");
        }
        Object result = ((Function)construct).call(cx, scope, this, new Object[]{this.target, cx.newArray(scope, args), this});
        if (!(result instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError0("msg.proxy.result.not.constructable");
        }
        return (ScriptableObject)result;
    }

    public int getArity() {
        this.ensureNotRevoked();
        if (this.handlerIds.contains("construct")) {
            return ((BaseFunction)this.handler.get("construct")).getArity();
        }
        if (this.handlerIds.contains("apply")) {
            return ((BaseFunction)this.handler.get("apply")).getArity();
        }
        if (this.target instanceof BaseFunction) {
            return ((BaseFunction)this.target).getArity();
        }
        throw ScriptRuntime.typeError0("msg.proxy.not.callable");
    }

    private static int getAttributes(ScriptableObject obj, Object id) {
        if (id instanceof String) {
            String s = (String)id;
            if (!obj.has(s, (Scriptable)obj)) {
                return -1;
            }
            return obj.getAttributes(s);
        }
        if (ScriptRuntime.isSymbol(id)) {
            Symbol s = (Symbol)id;
            if (!obj.has(s, (Scriptable)obj)) {
                return -1;
            }
            return obj.getAttributes(s);
        }
        throw Kit.codeBug();
    }

    private static boolean isConfigurable(ScriptableObject desc) {
        Object result;
        Object object = result = NativeProxy.hasProperty((Scriptable)desc, "configurable") ? NativeProxy.getProperty((Scriptable)desc, "configurable") : Boolean.valueOf(false);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }
}

