/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.ClassElement;
import org.mozilla.javascript.ast.ClassField;
import org.mozilla.javascript.ast.ClassMethod;
import org.mozilla.javascript.ast.ClassNode;
import org.mozilla.javascript.ast.DecoratorDeclarationNode;
import org.mozilla.javascript.ast.DecoratorNode;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.ExportNode;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.ImportNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.TemplateLiteral;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.decorators.Decorator;
import org.mozilla.javascript.decorators.DecoratorType;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;

class BodyCodegen {
    private static final int JAVASCRIPT_EXCEPTION = 0;
    private static final int EVALUATOR_EXCEPTION = 1;
    private static final int ECMAERROR_EXCEPTION = 2;
    private static final int THROWABLE_EXCEPTION = 3;
    private static final int FINALLY_EXCEPTION = 4;
    private static final int EXCEPTION_MAX = 5;
    private ExceptionManager exceptionManager = new ExceptionManager();
    private static final String SCRIPTABLE = "Lorg/mozilla/javascript/Scriptable;";
    private static final String SCRIPTABLE_OBJECT = "Lorg/mozilla/javascript/ScriptableObject;";
    private static final String CALLABLE = "Lorg/mozilla/javascript/Callable;";
    private static final String NATIVE_FUNCTION = "Lorg/mozilla/javascript/NativeFunction;";
    private static final String FUNCTION = "Lorg/mozilla/javascript/Function;";
    private static final String REF = "Lorg/mozilla/javascript/Ref;";
    private static final String CONTEXT = "Lorg/mozilla/javascript/Context;";
    private static final String OBJECT = "Ljava/lang/Object;";
    private static final String OBJECT_ARRAY = "[Ljava/lang/Object;";
    private static final String INTEGER = "I";
    private static final String BOOLEAN = "Z";
    private static final String VOID = "V";
    private static final String LONG = "J";
    private static final String DOUBLE = "D";
    private static final String STRING = "Ljava/lang/String;";
    private static final String STRING_ARRAY = "[Ljava/lang/String;";
    static final int GENERATOR_TERMINATE = -1;
    static final int GENERATOR_START = 0;
    static final int GENERATOR_YIELD_START = 1;
    boolean currentCtorClass = false;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptNode scriptOrFn;
    public int scriptOrFnIndex;
    private int savedCodeOffset;
    private OptFunctionNode fnCurrent;
    private static final int MAX_LOCALS = 1024;
    private int[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private short[] varRegisters;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int enterAreaStartLabel;
    private int epilogueLabel;
    private boolean inLocalBlock;
    private short variableObjectLocal;
    private short popvLocal;
    private short contextLocal;
    private short argsLocal;
    private short operationLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private short generatorStateLocal;
    private boolean isGenerator;
    private int generatorSwitch;
    private Node generatorReturnNode;
    private int maxLocals = 0;
    private int maxStack = 0;
    private Map<Node, FinallyReturnPoint> finallys;
    private List<Node> literals;

    BodyCodegen() {
    }

    void generateBodyCode() {
        this.isGenerator = Codegen.isGenerator(this.scriptOrFn);
        this.initBodyGeneration();
        if (this.isGenerator) {
            String type = "(" + this.codegen.mainClassSignature + "Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;";
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn) + "_gen", type, (short)10);
        } else {
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        }
        this.generatePrologue();
        Node treeTop = this.fnCurrent != null && !(this.scriptOrFn instanceof DecoratorDeclarationNode) ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateStatement(treeTop);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1));
        if (this.isGenerator) {
            this.generateGenerator();
        }
        if (this.literals != null) {
            block4: for (int i = 0; i < this.literals.size(); ++i) {
                Node node = this.literals.get(i);
                int type = node.getType();
                switch (type) {
                    case 70: {
                        this.generateObjectLiteralFactory(node, i + 1);
                        continue block4;
                    }
                    case 69: {
                        this.generateArrayLiteralFactory(node, i + 1);
                        continue block4;
                    }
                    default: {
                        Kit.codeBug(Token.typeToName(type));
                    }
                }
            }
        }
    }

    private void generateGenerator() {
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        this.cfw.addALoad(this.funObjLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addPush(this.scriptOrFn.isInStrictMode());
        this.cfw.addPush(false);
        this.addScriptRuntimeInvoke("createFunctionActivation", SCRIPTABLE, NATIVE_FUNCTION, SCRIPTABLE, OBJECT_ARRAY, BOOLEAN, BOOLEAN);
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(this.scriptOrFnIndex);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        this.generateNestedFunctionInits();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.thisObjLocal);
        this.cfw.addLoadConstant(this.maxLocals);
        this.cfw.addLoadConstant(this.maxStack);
        this.addOptRuntimeInvoke("createNativeGenerator", SCRIPTABLE, NATIVE_FUNCTION, SCRIPTABLE, SCRIPTABLE, INTEGER, INTEGER);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateNestedFunctionInits() {
        int functionCount = this.scriptOrFn.getFunctionCount();
        for (int i = 0; i != functionCount; ++i) {
            OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, i);
            if (ofn.fnode.getFunctionType() != 1) continue;
            this.visitFunction(ofn, 1);
        }
    }

    private void initBodyGeneration() {
        this.varRegisters = null;
        if (this.scriptOrFn.getType() == 114 || this.scriptOrFn.getType() == 135) {
            int n;
            this.fnCurrent = OptFunctionNode.get(this.scriptOrFn);
            boolean bl = this.hasVarsInRegs = !this.fnCurrent.fnode.requiresActivation();
            if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getParamAndVarCount()) != 0) {
                this.varRegisters = new short[n];
            }
            this.inDirectCallFunction = this.fnCurrent.isTargetOfDirectCall();
            if (this.inDirectCallFunction && !this.hasVarsInRegs) {
                Codegen.badTree();
            }
        } else {
            this.fnCurrent = null;
            this.hasVarsInRegs = false;
            this.inDirectCallFunction = false;
        }
        this.locals = new int[1024];
        this.funObjLocal = 0;
        this.contextLocal = 1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.epilogueLabel = -1;
        this.enterAreaStartLabel = -1;
        this.generatorStateLocal = (short)-1;
    }

    private void generatePrologue() {
        String debugVariableName;
        if (this.inDirectCallFunction) {
            int i;
            int directParameterCount = this.scriptOrFn.getParamCount();
            if (this.firstFreeLocal != 4) {
                Kit.codeBug();
            }
            for (i = 0; i != directParameterCount; ++i) {
                this.varRegisters[i] = this.firstFreeLocal;
                this.firstFreeLocal = (short)(this.firstFreeLocal + 3);
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (i = 0; i != directParameterCount; ++i) {
                    short reg = this.varRegisters[i];
                    this.cfw.addALoad(reg);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isObjectLabel = this.cfw.acquireLabel();
                    this.cfw.add(166, isObjectLabel);
                    this.cfw.addDLoad(reg + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(reg);
                    this.cfw.markLabel(isObjectLabel);
                }
            }
        }
        if (this.currentCtorClass) {
            ClassNode cls = ((FunctionNode)this.scriptOrFn).getParentClass();
            Node child = cls.getFirstChild().getNext();
            while (child != null) {
                List<DecoratorNode> decorators;
                if (child instanceof ClassElement) {
                    decorators = ((ClassElement)((Object)child)).getDecorators();
                } else if (child instanceof ClassNode) {
                    decorators = ((ClassNode)child).getDecorators();
                } else {
                    throw Kit.codeBug();
                }
                if (!decorators.isEmpty()) {
                    for (DecoratorNode dn : decorators) {
                        if (dn.getDecoratorType() != DecoratorType.INITIALIZE && dn.getDecoratorType() != DecoratorType.USER_DEFINED) continue;
                        if (dn.getDecoratorType() == DecoratorType.INITIALIZE && child instanceof ClassField && ((ClassField)child).isStatic()) {
                            throw ScriptRuntime.typeError0("msg.decorator.initialize.on.static.field");
                        }
                        Name decorator = (Name)dn.getTarget();
                        this.generateExpression(decorator, child);
                        this.cfw.add(192, "org/mozilla/javascript/BaseFunction");
                        if (child instanceof ClassElement) {
                            this.cfw.addALoad(this.thisObjLocal);
                            this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
                            this.cfw.add(178, "org/mozilla/javascript/decorators/Decorator", "NAME_KEY", OBJECT);
                            Object targetName = ((ClassElement)((Object)child)).getNameKey();
                            if (targetName instanceof String) {
                                this.cfw.addPush((String)targetName);
                            } else if (targetName instanceof Integer) {
                                this.cfw.addPush((Integer)targetName);
                            } else if (targetName instanceof Node) {
                                this.generateExpression((Node)targetName, child);
                            } else {
                                throw Kit.codeBug(targetName == null ? "null" : targetName.getClass().getSimpleName());
                            }
                            this.cfw.addPush(true);
                            this.cfw.addInvoke(182, "org/mozilla/javascript/ScriptableObject", "associateValue", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;");
                            this.cfw.add(87);
                        }
                        if (child instanceof ClassField && !((ClassField)child).isStatic()) {
                            this.cfw.addALoad(this.thisObjLocal);
                            this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
                            this.cfw.add(178, "org/mozilla/javascript/decorators/Decorator", "VALUE_KEY", OBJECT);
                            Node targetValue = child.getFirstChild();
                            this.generateExpression(targetValue, child);
                            this.cfw.addPush(true);
                            this.cfw.addInvoke(182, "org/mozilla/javascript/ScriptableObject", "associateValue", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;");
                            this.cfw.add(87);
                        }
                        this.cfw.addALoad(this.contextLocal);
                        this.cfw.addALoad(this.variableObjectLocal);
                        this.cfw.addALoad(this.thisObjLocal);
                        this.cfw.addPush(4);
                        this.cfw.add(189, "java/lang/Object");
                        this.cfw.add(89);
                        this.cfw.addPush(0);
                        this.cfw.addALoad(this.thisObjLocal);
                        this.cfw.add(83);
                        this.cfw.add(89);
                        this.cfw.addPush(1);
                        this.generateDecoratorDescriptor(child);
                        this.generateIntegerWrap();
                        this.cfw.add(83);
                        this.cfw.add(89);
                        this.cfw.addPush(2);
                        this.cfw.add(178, "org/mozilla/javascript/decorators/DecoratorType", DecoratorType.INITIALIZE.name(), "Lorg/mozilla/javascript/decorators/DecoratorType;");
                        this.cfw.add(83);
                        ArrayList<Node> args = new ArrayList<Node>();
                        for (Node ch = dn.getFirstChild(); ch != null; ch = ch.getNext()) {
                            args.add(ch);
                        }
                        this.cfw.add(89);
                        this.cfw.addPush(3);
                        this.cfw.addPush(args.size());
                        this.cfw.add(189, "java/lang/Object");
                        for (int i = 0; i < args.size(); ++i) {
                            this.cfw.add(89);
                            this.cfw.addPush(i);
                            Node ch = (Node)args.get(i);
                            this.generateExpression(ch, child);
                            this.cfw.add(83);
                        }
                        this.cfw.add(83);
                        this.cfw.addInvoke(182, "org/mozilla/javascript/BaseFunction", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
                    }
                }
                if (child instanceof ClassField && !((ClassField)child).isStatic()) {
                    int L1 = this.cfw.acquireLabel();
                    this.cfw.addALoad(this.thisObjLocal);
                    this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
                    this.cfw.add(178, "org/mozilla/javascript/decorators/Decorator", "HAS_INITIALIZE", OBJECT);
                    this.cfw.addInvoke(182, "org/mozilla/javascript/ScriptableObject", "getAssociatedValue", "(Ljava/lang/Object;)Ljava/lang/Object;");
                    this.cfw.add(192, "java/lang/Boolean");
                    this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                    this.cfw.add(165, L1);
                    ClassField cp = (ClassField)child;
                    Node defaultValue = cp.getFirstChild();
                    Object name = cp.getNameKey();
                    this.cfw.addALoad(this.thisObjLocal);
                    if (name instanceof String) {
                        this.cfw.addPush((String)name);
                    } else if (name instanceof Node) {
                        Node nameNode = (Node)name;
                        this.generateExpression(nameNode, cls);
                    } else {
                        this.cfw.addPush((Integer)name);
                        this.addScriptRuntimeInvoke("wrapInt", "Ljava/lang/Integer;", INTEGER);
                    }
                    this.generateExpression(defaultValue, cls);
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addPush(cp.isPrivate());
                    this.addScriptRuntimeInvoke("addClassProperty", OBJECT, OBJECT, OBJECT, OBJECT, CONTEXT, BOOLEAN);
                    this.cfw.addAStore(this.thisObjLocal);
                    this.cfw.markLabel(L1);
                    child = child.getNext();
                    continue;
                }
                if (child instanceof ClassNode) break;
                if ((child = child.getNext()) != null) continue;
                child = cls;
            }
        }
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        if (this.isGenerator) {
            short s2 = this.firstFreeLocal;
            this.firstFreeLocal = (short)(s2 + 1);
            this.operationLocal = s2;
            this.localsMax = this.firstFreeLocal;
            this.cfw.addALoad(this.thisObjLocal);
            short s3 = this.firstFreeLocal;
            this.firstFreeLocal = (short)(s3 + 1);
            this.generatorStateLocal = s3;
            this.localsMax = this.firstFreeLocal;
            this.cfw.add(192, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState");
            this.cfw.add(89);
            this.cfw.addAStore(this.generatorStateLocal);
            this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "thisObj", SCRIPTABLE);
            this.cfw.addAStore(this.thisObjLocal);
            if (this.epilogueLabel == -1) {
                this.epilogueLabel = this.cfw.acquireLabel();
            }
            List<Node> targets = ((FunctionNode)this.scriptOrFn).getResumptionPoints();
            this.generateGetGeneratorResumptionPoint();
            this.generatorSwitch = this.cfw.addTableSwitch(0, targets.size() + 0);
            this.generateCheckForThrowOrClose(-1, false, 0);
        }
        if (this.fnCurrent == null && this.scriptOrFn.getRegexpCount() != 0) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addInvoke(184, this.codegen.mainClassName, "_reInit", "(Lorg/mozilla/javascript/Context;)V");
        }
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.saveCurrentCodeOffset();
        }
        if (this.hasVarsInRegs) {
            int paramCount = this.scriptOrFn.getParamCount();
            if (paramCount > 0 && !this.inDirectCallFunction) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add(190);
                this.cfw.addPush(paramCount);
                int label = this.cfw.acquireLabel();
                this.cfw.add(162, label);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(paramCount);
                this.addScriptRuntimeInvoke("padArguments", OBJECT_ARRAY, OBJECT_ARRAY, INTEGER);
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(label);
            }
            paramCount = this.fnCurrent.fnode.getParamCount();
            int varCount = this.fnCurrent.fnode.getParamAndVarCount();
            boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
            List<AstNode> params = this.fnCurrent.fnode.getParams();
            Map<Integer, Node> defaultParams = this.fnCurrent.fnode.getDefaultParams();
            this.generateParameterTDZChecks(params, defaultParams);
            int firstUndefVar = -1;
            for (int i = 0; i != varCount; ++i) {
                int reg = -1;
                if (i < paramCount) {
                    if (!this.inDirectCallFunction) {
                        reg = this.getNewWordLocal();
                        if (params.get(i).getProp(29) != null) {
                            this.cfw.addALoad(this.argsLocal);
                            this.cfw.addPush(i);
                            this.cfw.addALoad(this.contextLocal);
                            this.cfw.addALoad(this.variableObjectLocal);
                            this.addScriptRuntimeInvoke("getRestParams", OBJECT, OBJECT_ARRAY, INTEGER, CONTEXT, SCRIPTABLE);
                        } else {
                            this.cfw.addALoad(this.argsLocal);
                            this.cfw.addPush(i);
                            this.cfw.add(50);
                            if (defaultParams.containsKey(i)) {
                                int label = this.cfw.acquireLabel();
                                Node defaultParam = defaultParams.get(i);
                                if (defaultParam.getType() == 53) {
                                    this.cfw.addALoad(this.argsLocal);
                                    this.cfw.addPush(i);
                                    this.cfw.add(50);
                                    this.cfw.addInvoke(184, "org/mozilla/javascript/Undefined", "isUndefined", "(Ljava/lang/Object;)Z");
                                    this.cfw.add(153, label);
                                } else {
                                    this.cfw.add(89);
                                    this.cfw.addInvoke(184, "org/mozilla/javascript/Undefined", "isUndefined", "(Ljava/lang/Object;)Z");
                                    this.cfw.add(153, label);
                                    this.cfw.add(87);
                                }
                                this.generateExpression(defaultParam, this.fnCurrent.fnode);
                                this.cfw.markLabel(label);
                            }
                        }
                        this.cfw.addAStore(reg);
                    }
                } else if (this.fnCurrent.isNumberVar(i)) {
                    reg = this.getNewWordPairLocal(constDeclarations[i]);
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(reg);
                } else {
                    reg = this.getNewWordLocal(constDeclarations[i]);
                    if (firstUndefVar == -1) {
                        Codegen.pushUndefined(this.cfw);
                        firstUndefVar = reg;
                    } else {
                        this.cfw.addALoad(firstUndefVar);
                    }
                    this.cfw.addAStore(reg);
                }
                if (reg >= 0) {
                    if (constDeclarations[i]) {
                        this.cfw.addPush(0);
                        this.cfw.addIStore(reg + (this.fnCurrent.isNumberVar(i) ? 2 : 1));
                    }
                    this.varRegisters[i] = reg;
                }
                if (!this.compilerEnv.isGenerateDebugInfo()) continue;
                String name = this.fnCurrent.fnode.getParamOrVarName(i);
                String type = this.fnCurrent.isNumberVar(i) ? DOUBLE : OBJECT;
                int startPC = this.cfw.getCurrentCodeOffset();
                if (reg < 0) {
                    reg = this.varRegisters[i];
                }
                this.cfw.addVariableDescriptor(name, type, startPC, reg);
            }
            return;
        }
        if (this.isGenerator) {
            return;
        }
        boolean isArrow = false;
        if (this.scriptOrFn instanceof FunctionNode) {
            boolean bl = isArrow = ((FunctionNode)this.scriptOrFn).getFunctionType() == 4;
        }
        if (this.fnCurrent != null) {
            boolean spread;
            String methodName = isArrow ? "createArrowFunctionActivation" : "createFunctionActivation";
            debugVariableName = "activation";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.argsLocal);
            if (this.fnCurrent.fnode instanceof DecoratorDeclarationNode) {
                this.cfw.addPush(3);
                this.cfw.add(50);
                this.cfw.add(192, OBJECT_ARRAY);
            }
            if (spread = this.fnCurrent.fnode.getParams().stream().anyMatch(param -> param.getProp(29) != null)) {
                this.cfw.addPush(this.fnCurrent.fnode.getParams().size() - 1);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("paramsToRestParams", OBJECT_ARRAY, OBJECT_ARRAY, INTEGER, CONTEXT, SCRIPTABLE);
            }
            int paramCount = this.fnCurrent.fnode.getParamCount();
            Map<Integer, Node> defaultParams = this.fnCurrent.fnode.getDefaultParams();
            if (!defaultParams.isEmpty()) {
                int max = -1;
                for (int key : defaultParams.keySet()) {
                    if (key <= max) continue;
                    max = key;
                }
                this.cfw.add(89);
                this.cfw.addPush(max + 1);
                this.addScriptRuntimeInvoke("lengthenObjArray", OBJECT_ARRAY, OBJECT_ARRAY, INTEGER);
                short array = this.getNewWordLocal();
                this.cfw.addAStore(array);
                for (int i = 0; i < paramCount; ++i) {
                    if (!defaultParams.containsKey(i)) continue;
                    int label = this.cfw.acquireLabel();
                    this.cfw.addALoad(array);
                    this.cfw.addPush(i);
                    this.cfw.add(50);
                    this.cfw.addInvoke(184, "org/mozilla/javascript/Undefined", "isUndefined", "(Ljava/lang/Object;)Z");
                    this.cfw.add(153, label);
                    if (defaultParams.get(i).getType() == 53) {
                        this.generateExpression(defaultParams.get(i), this.fnCurrent.fnode);
                    } else {
                        this.cfw.addALoad(array);
                        this.cfw.addPush(i);
                        this.generateExpression(defaultParams.get(i), this.fnCurrent.fnode);
                        this.cfw.add(83);
                    }
                    this.cfw.markLabel(label);
                }
                this.cfw.addALoad(array);
                this.cfw.addPush(this.scriptOrFn.isInStrictMode());
                this.cfw.addPush(false);
                this.addScriptRuntimeInvoke(methodName, SCRIPTABLE, NATIVE_FUNCTION, SCRIPTABLE, OBJECT_ARRAY, OBJECT_ARRAY, BOOLEAN, BOOLEAN);
            } else {
                boolean hasDefaults = this.fnCurrent.fnode.getParams().stream().anyMatch(ast -> ast.getType() == 69);
                this.cfw.addPush(this.scriptOrFn.isInStrictMode());
                this.cfw.addPush(!hasDefaults && !this.scriptOrFn.hasRest());
                this.addScriptRuntimeInvoke(methodName, SCRIPTABLE, NATIVE_FUNCTION, SCRIPTABLE, OBJECT_ARRAY, BOOLEAN, BOOLEAN);
            }
            this.cfw.addAStore(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("enterActivationFunction", VOID, CONTEXT, SCRIPTABLE);
        } else {
            debugVariableName = "global";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("initScript", VOID, NATIVE_FUNCTION, SCRIPTABLE, CONTEXT, SCRIPTABLE);
        }
        this.enterAreaStartLabel = this.cfw.acquireLabel();
        this.epilogueLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(this.enterAreaStartLabel);
        this.generateNestedFunctionInits();
        if (this.compilerEnv.isGenerateDebugInfo()) {
            this.cfw.addVariableDescriptor(debugVariableName, SCRIPTABLE, this.cfw.getCurrentCodeOffset(), this.variableObjectLocal);
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            int linenum = this.scriptOrFn.getEndLineno();
            if (linenum != -1) {
                this.cfw.addLineNumberEntry((short)linenum);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", OBJECT_ARRAY);
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add(189, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateGetGeneratorResumptionPoint() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", INTEGER);
    }

    private void generateSetGeneratorResumptionPoint(int nextState) {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.addLoadConstant(nextState);
        this.cfw.add(181, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", INTEGER);
    }

    private void generateGenGetStack() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorStackState", OBJECT_ARRAY, OBJECT);
    }

    private void generateEpilogue() {
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.addInstructionCount();
        }
        if (this.isGenerator) {
            Map<Node, int[]> liveLocals = ((FunctionNode)this.scriptOrFn).getLiveLocals();
            if (liveLocals != null) {
                List<Node> nodes = ((FunctionNode)this.scriptOrFn).getResumptionPoints();
                for (int i = 0; i < nodes.size(); ++i) {
                    Node node = (Node)nodes.get(i);
                    int[] live = liveLocals.get(node);
                    if (live == null) continue;
                    this.cfw.markTableSwitchCase(this.generatorSwitch, this.getNextGeneratorState(node));
                    this.generateGetGeneratorLocalsState();
                    for (int j = 0; j < live.length; ++j) {
                        this.cfw.add(89);
                        this.cfw.addLoadConstant(j);
                        this.cfw.add(50);
                        this.cfw.addAStore(live[j]);
                    }
                    this.cfw.add(87);
                    this.cfw.add(167, this.getTargetLabel(node));
                }
            }
            if (this.finallys != null) {
                for (Node n : this.finallys.keySet()) {
                    if (n.getType() != 134) continue;
                    FinallyReturnPoint ret = this.finallys.get(n);
                    this.cfw.markLabel(ret.tableLabel, (short)1);
                    int startSwitch = this.cfw.addTableSwitch(0, ret.jsrPoints.size() - 1);
                    int c = 0;
                    this.cfw.markTableSwitchDefault(startSwitch);
                    for (int i = 0; i < ret.jsrPoints.size(); ++i) {
                        this.cfw.markTableSwitchCase(startSwitch, c);
                        this.cfw.add(167, ret.jsrPoints.get(i));
                        ++c;
                    }
                }
            }
        }
        if (this.epilogueLabel != -1) {
            this.cfw.markLabel(this.epilogueLabel);
        }
        if (this.hasVarsInRegs && !this.isGenerator) {
            if (this.currentCtorClass) {
                this.addScriptRuntimeInvoke("endClassCtor", SCRIPTABLE, SCRIPTABLE);
            }
            this.cfw.add(176);
        } else if (this.isGenerator) {
            int state = ((FunctionNode)this.scriptOrFn).getResumptionPoints().size();
            this.generateGeneratorReturnObject(this.generatorReturnNode, true);
            this.generateSetGeneratorResumptionPoint(state + 1);
            this.cfw.add(176);
            this.generateCheckForThrowOrClose(-1, false, null);
            this.generateGeneratorReturnObject((Node)null, true);
            this.generateSetGeneratorResumptionPoint(-1);
            this.cfw.add(176);
        } else if (this.fnCurrent == null) {
            this.cfw.addALoad(this.popvLocal);
            this.cfw.add(176);
        } else {
            this.generateActivationExit();
            this.cfw.add(176);
            int finallyHandler = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            short exceptionObject = this.getNewWordLocal();
            this.cfw.addAStore(exceptionObject);
            this.generateActivationExit();
            this.cfw.addALoad(exceptionObject);
            this.releaseWordLocal(exceptionObject);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(this.enterAreaStartLabel, this.epilogueLabel, finallyHandler, null);
        }
    }

    private void generateGeneratorReturnObject(Runnable value, boolean isDone) {
        this.cfw.addPush(2);
        this.cfw.add(189, "java/lang/Object");
        this.cfw.add(89);
        this.cfw.addPush(0);
        this.cfw.addPush("value");
        this.cfw.add(83);
        this.cfw.add(89);
        this.cfw.addPush(1);
        this.cfw.addPush("done");
        this.cfw.add(83);
        this.cfw.addPush(2);
        this.cfw.add(189, "java/lang/Object");
        this.cfw.add(89);
        this.cfw.addPush(0);
        value.run();
        this.cfw.add(83);
        this.cfw.add(89);
        this.cfw.addPush(1);
        if (isDone) {
            this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        } else {
            this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        }
        this.cfw.add(83);
        this.cfw.add(1);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("newObjectLiteral", SCRIPTABLE, OBJECT_ARRAY, OBJECT_ARRAY, "[I", CONTEXT, SCRIPTABLE);
    }

    private void generateGeneratorReturnObject(Node node, boolean isDone) {
        this.generateGeneratorReturnObject(() -> {
            Node returnVal;
            Node node2 = returnVal = node == null ? null : node.getFirstChild();
            if (returnVal == null) {
                Codegen.pushUndefined(this.cfw);
            } else {
                this.generateExpression(returnVal, node);
            }
        }, isDone);
    }

    private void generateGetGeneratorLocalsState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorLocalsState", OBJECT_ARRAY, OBJECT);
    }

    private void generateActivationExit() {
        if (this.fnCurrent == null || this.hasVarsInRegs) {
            throw Kit.codeBug();
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("exitActivationFunction", VOID, CONTEXT);
    }

    private void generateStatement(Node node) {
        this.updateLineNumber(node);
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 146: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount(1);
                }
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                break;
            }
            case 151: {
                boolean prevLocal = this.inLocalBlock;
                this.inLocalBlock = true;
                short local = this.getNewWordLocal();
                if (this.isGenerator) {
                    this.cfw.add(1);
                    this.cfw.addAStore(local);
                }
                node.putIntProp(2, local);
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                this.releaseWordLocal(local);
                node.removeProp(2);
                this.inLocalBlock = prevLocal;
                break;
            }
            case 119: {
                ExportNode en = (ExportNode)node;
                if (en.isDefaultExport()) {
                    this.generateExpression(en.getFirstChild(), en);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.addScriptRuntimeInvoke("handleExport", VOID, OBJECT, SCRIPTABLE);
                    break;
                }
                if (en.getExportedValue() != null) {
                    AstNode ast = en.getExportedValue();
                    String identifier = en.getIdentifier();
                    Node value = en.getFirstChild();
                    if (!(ast instanceof VariableDeclaration) && identifier == null) {
                        throw Codegen.badTree();
                    }
                    this.generateStatement(value);
                    if (ast instanceof VariableDeclaration) {
                        List<VariableInitializer> variables = ((VariableDeclaration)ast).getVariables();
                        variables.forEach(var -> {
                            AstNode name = var.getTarget();
                            if (!(name instanceof Name)) {
                                throw Codegen.badTree();
                            }
                            this.cfw.addPush(((Name)name).getIdentifier());
                            this.cfw.add(89);
                            this.cfw.addALoad(this.variableObjectLocal);
                            this.addScriptRuntimeInvoke("handleExport", VOID, STRING, STRING, SCRIPTABLE);
                        });
                        break;
                    }
                    this.cfw.addPush(identifier);
                    this.cfw.add(89);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.addScriptRuntimeInvoke("handleExport", VOID, STRING, STRING, SCRIPTABLE);
                    break;
                }
                String filePath = en.getFilePath();
                if (filePath != null && en.getNamedMembers().size() == 0) {
                    this.generateRequireCall(filePath);
                    this.cfw.add(192, "org/mozilla/javascript/Scriptable");
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.addScriptRuntimeInvoke("handleExport", VOID, SCRIPTABLE, SCRIPTABLE);
                    break;
                }
                for (ImportNode.ModuleMember namedImport : en.getNamedMembers()) {
                    String target = namedImport.getTargetName();
                    String scope = namedImport.getScopeName();
                    if (scope == null) {
                        scope = target;
                    }
                    this.cfw.addPush(target);
                    this.cfw.addPush(scope);
                    if (filePath != null) {
                        this.generateRequireCall(filePath);
                    }
                    this.cfw.addALoad(this.variableObjectLocal);
                    if (filePath == null) {
                        this.addScriptRuntimeInvoke("handleExport", VOID, STRING, STRING, SCRIPTABLE);
                        continue;
                    }
                    this.addScriptRuntimeInvoke("handleExport", VOID, STRING, STRING, SCRIPTABLE, SCRIPTABLE);
                }
                break;
            }
            case 120: {
                ImportNode in = (ImportNode)node;
                this.generateRequireCall(in.getFilePath());
                int namedCount = in.getNamedMembers().size();
                this.cfw.addPush(namedCount);
                this.cfw.add(189, "java/lang/Object");
                List<ImportNode.ModuleMember> namedImports = in.getNamedMembers();
                int namedImportsSize = namedImports.size();
                for (int i = 0; i < namedImportsSize; ++i) {
                    ImportNode.ModuleMember namedImport = namedImports.get(i);
                    this.cfw.add(89);
                    this.cfw.addPush(i);
                    this.cfw.addPush(2);
                    this.cfw.add(189, "java/lang/String");
                    this.cfw.add(89);
                    this.cfw.addPush(0);
                    String target = namedImport.getTargetName();
                    this.cfw.addPush(target);
                    this.cfw.add(83);
                    this.cfw.add(89);
                    this.cfw.addPush(1);
                    String scope = namedImport.getScopeName();
                    if (scope == null) {
                        scope = target;
                    }
                    this.cfw.addPush(scope);
                    this.cfw.add(83);
                    this.cfw.add(83);
                }
                ImportNode.ModuleMember defaultImport = in.getDefaultMember();
                if (defaultImport == null) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addPush(defaultImport.getScopeName());
                }
                ImportNode.ModuleMember moduleImport = in.getModuleImport();
                if (moduleImport == null) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addPush(moduleImport.getScopeName());
                }
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("handleImport", VOID, OBJECT, OBJECT_ARRAY, STRING, STRING, SCRIPTABLE);
                break;
            }
            case 135: {
                if (this.fnCurrent == null) break;
                this.visitDecoratorDeclaration((DecoratorDeclarationNode)node);
                break;
            }
            case 114: {
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t == 3 || node.getProp(33) != null) {
                    this.visitFunction(ofn, t);
                    break;
                }
                if (t == 1) break;
                throw Codegen.badTree();
            }
            case 115: {
                this.visitClass((ClassNode)node);
                break;
            }
            case 78: {
                this.visitTryCatchFinally((Jump)node, child);
                break;
            }
            case 60: {
                this.cfw.setStackTop((short)0);
                int local = this.getLocalBlockRegister(node);
                int scopeIndex = node.getExistingIntProp(14);
                String name = child.getString();
                child = child.getNext();
                this.generateExpression(child, node);
                if (scopeIndex == 0) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addALoad(local);
                }
                this.cfw.addPush(name);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("newCatchScope", SCRIPTABLE, "Ljava/lang/Throwable;", SCRIPTABLE, STRING, CONTEXT, SCRIPTABLE);
                this.cfw.addAStore(local);
                break;
            }
            case 53: {
                this.generateExpression(child, node);
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.generateThrowJavaScriptException();
                break;
            }
            case 54: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                this.cfw.add(191);
                break;
            }
            case 4: 
            case 68: {
                if (!this.isGenerator) {
                    if (child != null) {
                        this.generateExpression(child, node);
                        if (this.currentCtorClass) {
                            this.cfw.addALoad(this.thisObjLocal);
                            this.addScriptRuntimeInvoke("coerceClassCtorReturnValue", SCRIPTABLE, OBJECT, SCRIPTABLE);
                        }
                    } else if (type == 4) {
                        if (!this.currentCtorClass) {
                            Codegen.pushUndefined(this.cfw);
                        } else {
                            this.cfw.addALoad(this.thisObjLocal);
                        }
                    } else {
                        if (this.popvLocal < 0) {
                            throw Codegen.badTree();
                        }
                        this.cfw.addALoad(this.popvLocal);
                    }
                }
                this.generatorReturnNode = node;
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                if (this.epilogueLabel == -1) {
                    if (!this.hasVarsInRegs) {
                        throw Codegen.badTree();
                    }
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add(167, this.epilogueLabel);
                break;
            }
            case 123: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.visitSwitch((Jump)node, child);
                break;
            }
            case 2: {
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enterWith", SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE);
                this.cfw.addAStore(this.variableObjectLocal);
                this.incReferenceWordLocal(this.variableObjectLocal);
                break;
            }
            case 3: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("leaveWith", SCRIPTABLE, SCRIPTABLE);
                this.cfw.addAStore(this.variableObjectLocal);
                this.decReferenceWordLocal(this.variableObjectLocal);
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                int enumType = type == 61 ? 0 : (type == 62 ? 1 : (type == 64 ? 6 : 2));
                this.cfw.addPush(enumType);
                this.addScriptRuntimeInvoke("enumInit", OBJECT, OBJECT, CONTEXT, SCRIPTABLE, INTEGER);
                this.cfw.addAStore(this.getLocalBlockRegister(node));
                break;
            }
            case 143: {
                if (child.getType() == 59) {
                    this.visitSetVar(child, child.getFirstChild(), false);
                    break;
                }
                if (child.getType() == 161) {
                    this.visitSetConstVar(child, child.getFirstChild(), false);
                    break;
                }
                if (child.getType() == 76) {
                    this.generateYieldPoint(child, false);
                    break;
                }
                this.generateExpression(child, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.add(88);
                    break;
                }
                this.cfw.add(87);
                break;
            }
            case 144: {
                this.generateExpression(child, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                break;
            }
            case 141: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                int label = this.getTargetLabel(node);
                this.cfw.markLabel(label);
                if (!this.compilerEnv.isGenerateObserverCount()) break;
                this.saveCurrentCodeOffset();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 145: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.visitGoto((Jump)node, type, child);
                break;
            }
            case 134: {
                if (!this.isGenerator) break;
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.saveCurrentCodeOffset();
                }
                this.cfw.setStackTop((short)1);
                short finallyRegister = this.getNewWordLocal();
                int finallyStart = this.cfw.acquireLabel();
                int finallyEnd = this.cfw.acquireLabel();
                this.cfw.markLabel(finallyStart);
                this.generateIntegerWrap();
                this.cfw.addAStore(finallyRegister);
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                this.cfw.addALoad(finallyRegister);
                this.cfw.add(192, "java/lang/Integer");
                this.generateIntegerUnwrap();
                FinallyReturnPoint ret = this.finallys.get(node);
                ret.tableLabel = this.cfw.acquireLabel();
                this.cfw.add(167, ret.tableLabel);
                this.cfw.setStackTop((short)0);
                this.releaseWordLocal(finallyRegister);
                this.cfw.markLabel(finallyEnd);
                break;
            }
            case 165: {
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
    }

    private void generateIntegerWrap() {
        this.cfw.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
    }

    private void generateIntegerUnwrap() {
        this.cfw.addInvoke(182, "java/lang/Integer", "intValue", "()I");
    }

    private void generateBooleanWrap() {
        this.cfw.addInvoke(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
    }

    private void generateThrowJavaScriptException() {
        this.cfw.add(187, "org/mozilla/javascript/JavaScriptException");
        this.cfw.add(90);
        this.cfw.add(95);
        this.cfw.addPush(this.scriptOrFn.getSourceName());
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addInvoke(183, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
        this.cfw.add(191);
    }

    private void generateParameterTDZChecks(List<AstNode> params, Map<Integer, Node> defaultParams) {
        int paramsSize = params.size();
        for (Map.Entry<Integer, Node> en : defaultParams.entrySet()) {
            int paramIndex = en.getKey();
            Node defaultParam = en.getValue();
            for (int i = paramIndex; i < paramsSize; ++i) {
                AstNode param = params.get(i);
                if (!Name.sameIdentifier(param, defaultParam)) continue;
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush("ReferenceError");
                this.cfw.addPush("can't access lexical declaration '" + ((Name)defaultParam).getIdentifier() + "' before initialization");
                this.addScriptRuntimeInvoke("throwCustomError", "Lorg/mozilla/javascript/JavaScriptException;", CONTEXT, SCRIPTABLE, STRING, STRING);
                this.cfw.add(191);
            }
        }
    }

    private int getNextGeneratorState(Node node) {
        int nodeIndex = ((FunctionNode)this.scriptOrFn).getResumptionPoints().indexOf(node);
        return nodeIndex + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void generateExpression(Node node, Node parent) {
        int type = node.getType();
        block0 : switch (type) {
            case 148: {
                break;
            }
            case 53: {
                Node child;
                this.generateExpression(child, node);
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.generateThrowJavaScriptException();
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 114: {
                if (this.fnCurrent == null && parent.getType() == 146) break;
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t != 2 && t != 4) {
                    throw Codegen.badTree();
                }
                this.visitFunction(ofn, t);
                break;
            }
            case 115: {
                this.visitClass((ClassNode)node);
                break;
            }
            case 40: {
                if (node.getString().equals("new.target") && this.scriptOrFn.getType() == 114) {
                    this.cfw.addLoadThis();
                    this.cfw.addALoad(this.thisObjLocal);
                    this.addScriptRuntimeInvoke("getNewTarget", OBJECT, OBJECT, OBJECT);
                    break;
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("name", OBJECT, CONTEXT, SCRIPTABLE, STRING);
                break;
            }
            case 31: 
            case 39: {
                Node child;
                int specialType = node.getIntProp(10, 0);
                if (specialType == 0) {
                    OptFunctionNode target = (OptFunctionNode)node.getProp(9);
                    if (target != null) {
                        this.visitOptimizedCall(node, target, type, child);
                        break;
                    }
                    if (type == 39) {
                        this.visitStandardCall(node, child);
                        break;
                    }
                    this.visitStandardNew(node, child);
                    break;
                }
                this.visitSpecialCall(node, type, specialType, child);
                break;
            }
            case 74: {
                Node child;
                this.generateFunctionAndThisObj(child, node);
                child = child.getNext();
                this.generateCallArgArray(node, child, false);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callRef", REF, CALLABLE, SCRIPTABLE, OBJECT_ARRAY, CONTEXT);
                break;
            }
            case 41: {
                double num = node.getDouble();
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.addPush(num);
                } else {
                    this.codegen.pushNumberAsObject(this.cfw, num);
                }
                DecoratorNode dn = ((NumberLiteral)node).getDecoratorNode();
                if (dn == null) break;
                ArrayList<DecoratorNode> dnList = new ArrayList<DecoratorNode>();
                dnList.add(dn);
                this.generateApplyDecorator(node, dnList, DecoratorType.NUMERICTEMPLATE);
                break;
            }
            case 43: {
                void var12_53;
                TemplateLiteral lit = (TemplateLiteral)node;
                Node target = lit.getTransformedTarget();
                if (target == null) {
                    this.cfw.addPush(lit.getElements().size());
                    this.cfw.add(189, "java/lang/Object");
                    int index = 0;
                    for (Node element : node) {
                        this.cfw.add(89);
                        this.cfw.addPush(index);
                        this.generateExpression(element, node);
                        this.cfw.add(83);
                        ++index;
                    }
                    this.addScriptRuntimeInvoke("templateConcat", OBJECT, OBJECT_ARRAY);
                    break;
                }
                this.cfw.addPush(lit.getElements().size());
                this.cfw.add(189, "java/lang/Object");
                int arrayIndex = 0;
                ArrayList<Object> exprs = new ArrayList<Object>();
                int i = 0;
                for (Object element : lit) {
                    if (lit.isExpr(i)) {
                        exprs.add(element);
                    } else {
                        this.cfw.add(89);
                        this.cfw.addPush(arrayIndex++);
                        this.generateExpression((Node)element, node);
                        this.cfw.add(83);
                    }
                    ++i;
                }
                int boundary = arrayIndex;
                for (Node node2 : exprs) {
                    this.cfw.add(89);
                    this.cfw.addPush(arrayIndex++);
                    this.generateExpression(node2, node);
                    this.cfw.add(83);
                }
                this.cfw.addPush(boundary);
                String[] rawStrings = lit.getRawElements();
                this.cfw.addPush(rawStrings.length);
                this.cfw.add(189, "java/lang/Object");
                boolean bl = false;
                int rawStringsLength = rawStrings.length;
                while (var12_53 < rawStringsLength) {
                    String rawString = rawStrings[var12_53];
                    this.cfw.add(89);
                    this.cfw.addPush((int)var12_53);
                    this.cfw.addPush(rawString);
                    this.cfw.add(83);
                    ++var12_53;
                }
                this.generateExpression(target, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                ClassFileWriter.MHandle mHandle = new ClassFileWriter.MHandle(6, "org/mozilla/javascript/optimizer/InvokeDynamicSupport", "bootstrapCallWithTemplateLiteral", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class).toMethodDescriptorString());
                this.cfw.addInvokeDynamic("callWithTemplateLiteral", "([Ljava/lang/Object;I[Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;", mHandle, new Object[0]);
                break;
            }
            case 42: {
                this.cfw.addPush(node.getString());
                break;
            }
            case 46: {
                this.cfw.addALoad(this.thisObjLocal);
                break;
            }
            case 67: {
                this.cfw.add(42);
                break;
            }
            case 45: {
                this.cfw.add(1);
                break;
            }
            case 48: {
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 47: {
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 51: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                int i = node.getExistingIntProp(4);
                this.cfw.add(178, this.codegen.mainClassName, this.codegen.getCompiledRegexpName(this.scriptOrFn, i), OBJECT);
                this.cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 86: {
                Node child;
                for (Node next = child.getNext(); next != null; next = next.getNext()) {
                    this.generateExpression(child, node);
                    this.cfw.add(87);
                    child = next;
                }
                this.generateExpression(child, node);
                break;
            }
            case 65: 
            case 66: {
                int local = this.getLocalBlockRegister(node);
                this.cfw.addALoad(local);
                if (type == 65) {
                    this.addScriptRuntimeInvoke("enumNext", "Ljava/lang/Boolean;", OBJECT);
                    break;
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("enumId", OBJECT, OBJECT, CONTEXT);
                break;
            }
            case 69: {
                Node child;
                this.visitArrayLiteral(node, child, false);
                break;
            }
            case 70: {
                Node child;
                this.visitObjectLiteral(node, child, false);
                break;
            }
            case 136: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(87);
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 33: {
                Node child;
                this.generateExpression(child, node);
                this.addScriptRuntimeInvoke("typeof", STRING, OBJECT);
                break;
            }
            case 147: {
                this.visitTypeofname(node);
                break;
            }
            case 107: 
            case 108: {
                this.visitIncDec(node);
                break;
            }
            case 105: 
            case 106: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(89);
                this.addScriptRuntimeInvoke("toBoolean", BOOLEAN, OBJECT);
                int falseTarget = this.cfw.acquireLabel();
                if (type == 106) {
                    this.cfw.add(153, falseTarget);
                } else {
                    this.cfw.add(154, falseTarget);
                }
                this.cfw.add(87);
                this.generateExpression(child.getNext(), node);
                this.cfw.markLabel(falseTarget);
                break;
            }
            case 103: {
                Node child;
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                this.generateExpression(child, node);
                this.addScriptRuntimeInvoke("toBoolean", BOOLEAN, OBJECT);
                int elseTarget = this.cfw.acquireLabel();
                this.cfw.add(153, elseTarget);
                short stack = this.cfw.getStackTop();
                this.generateExpression(ifThen, node);
                int afterHook = this.cfw.acquireLabel();
                this.cfw.add(167, afterHook);
                this.cfw.markLabel(elseTarget, stack);
                this.generateExpression(ifElse, node);
                this.cfw.markLabel(afterHook);
                break;
            }
            case 21: {
                Node child;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                switch (node.getIntProp(8, -1)) {
                    case 0: {
                        this.cfw.add(99);
                        break block0;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", OBJECT, DOUBLE, OBJECT);
                        break block0;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", OBJECT, OBJECT, DOUBLE);
                        break block0;
                    }
                }
                if (child.getType() == 42) {
                    this.addScriptRuntimeInvoke("add", "Ljava/lang/CharSequence;", "Ljava/lang/CharSequence;", OBJECT);
                    break;
                }
                if (child.getNext().getType() == 42) {
                    this.addScriptRuntimeInvoke("add", "Ljava/lang/CharSequence;", OBJECT, "Ljava/lang/CharSequence;");
                    break;
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("add", OBJECT, OBJECT, OBJECT, CONTEXT);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                Node child;
                this.visitOperator(node, child, type);
                break;
            }
            case 155: {
                Node child;
                this.generateExpression(child, node);
                this.addObjectToDouble();
                break;
            }
            case 154: {
                Node child;
                int prop = -1;
                if (child.getType() == 41) {
                    prop = child.getIntProp(8, -1);
                }
                if (prop != -1) {
                    child.removeProp(8);
                    this.generateExpression(child, node);
                    child.putIntProp(8, prop);
                    break;
                }
                this.generateExpression(child, node);
                this.addDoubleWrap();
                break;
            }
            case 55: 
            case 56: {
                Node child;
                int trueGOTO = this.cfw.acquireLabel();
                int falseGOTO = this.cfw.acquireLabel();
                this.visitIfJumpRelOp(node, child, trueGOTO, falseGOTO);
                this.addJumpedBooleanWrap(trueGOTO, falseGOTO);
                break;
            }
            case 12: 
            case 13: 
            case 49: 
            case 50: {
                Node child;
                int trueGOTO = this.cfw.acquireLabel();
                int falseGOTO = this.cfw.acquireLabel();
                this.visitIfJumpEqOp(node, child, trueGOTO, falseGOTO);
                this.addJumpedBooleanWrap(trueGOTO, falseGOTO);
                break;
            }
            case 34: 
            case 35: {
                Node child;
                this.visitGetProp(node, child);
                break;
            }
            case 37: {
                String prefix;
                Node child;
                Object spread = node.getProp(29);
                if (child.getProp(31) != null) {
                    this.generateExpression(child.getNext(), node);
                    this.cfw.addALoad(this.thisObjLocal);
                    this.cfw.addALoad(this.funObjLocal);
                    this.addScriptRuntimeInvoke("accessSuper", OBJECT, OBJECT, SCRIPTABLE, NATIVE_FUNCTION);
                    return;
                }
                if (spread != null) {
                    int startIndex = (Integer)((Object[])spread)[0];
                    Node right = (Node)((Object[])spread)[1];
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.cfw.addPush(startIndex);
                    this.generateExpression(right, node);
                    this.addScriptRuntimeInvoke("handleRestDestructure", OBJECT, CONTEXT, SCRIPTABLE, INTEGER, OBJECT);
                    break;
                }
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                String string = prefix = node.getProp(30) != null ? "optionalGet" : "get";
                if (node.getIntProp(8, -1) != -1) {
                    this.addScriptRuntimeInvoke(prefix + "ObjectIndex", OBJECT, OBJECT, DOUBLE, CONTEXT);
                    break;
                }
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(prefix + "ObjectElem", OBJECT, OBJECT, OBJECT, CONTEXT, SCRIPTABLE);
                break;
            }
            case 110: {
                Node child;
                Object[] alreadyTaken = (Object[])node.getProp(32);
                if (alreadyTaken == null) {
                    throw new RuntimeException("Unexpected Token.SPREAD without spread_ids");
                }
                this.generateExpression(child, node);
                this.addNewObjectArray(alreadyTaken.length);
                for (int i = 0; i < alreadyTaken.length; ++i) {
                    Object taken = alreadyTaken[i];
                    this.cfw.add(89);
                    this.cfw.addPush(i);
                    if (taken instanceof String) {
                        this.cfw.addPush((String)taken);
                    } else if (taken instanceof Integer) {
                        this.cfw.addPush((Integer)taken);
                    } else {
                        throw new RuntimeException("Unknown constant: " + taken);
                    }
                    this.cfw.add(83);
                }
                this.addScriptRuntimeInvoke("handleObjectRest", OBJECT, OBJECT, OBJECT_ARRAY);
                break;
            }
            case 71: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refGet", OBJECT, REF, CONTEXT);
                break;
            }
            case 58: {
                this.visitGetVar(node);
                break;
            }
            case 59: {
                Node child;
                this.visitSetVar(node, child, true);
                break;
            }
            case 8: {
                Node child;
                this.visitSetName(node, child);
                break;
            }
            case 77: {
                Node child;
                this.visitStrictSetName(node, child);
                break;
            }
            case 160: {
                Node child;
                this.visitSetConst(node, child);
                break;
            }
            case 161: {
                Node child;
                this.visitSetConstVar(node, child, true);
                break;
            }
            case 36: 
            case 149: {
                Node child;
                this.visitSetProp(type, node, child);
                break;
            }
            case 38: 
            case 150: {
                Node child;
                this.visitSetElem(type, node, child);
                break;
            }
            case 72: 
            case 152: {
                Node child;
                this.generateExpression(child, node);
                child = child.getNext();
                if (type == 152) {
                    this.cfw.add(89);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("refGet", OBJECT, REF, CONTEXT);
                }
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("refSet", OBJECT, REF, OBJECT, CONTEXT, SCRIPTABLE);
                break;
            }
            case 73: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refDel", OBJECT, REF, CONTEXT);
                break;
            }
            case 32: {
                Node child;
                boolean isName = child.getType() == 52;
                this.generateExpression(child, node);
                child = child.getNext();
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(isName);
                this.addScriptRuntimeInvoke("delete", OBJECT, OBJECT, OBJECT, CONTEXT, BOOLEAN);
                break;
            }
            case 52: {
                Node child;
                for (child = node.getFirstChild(); child != null; child = child.getNext()) {
                    this.generateExpression(child, node);
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("bind", SCRIPTABLE, CONTEXT, SCRIPTABLE, STRING);
                break;
            }
            case 57: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                break;
            }
            case 75: {
                Node child;
                String special = (String)node.getProp(17);
                this.generateExpression(child, node);
                this.cfw.addPush(special);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("specialRef", REF, OBJECT, STRING, CONTEXT, SCRIPTABLE);
                break;
            }
            case 76: {
                this.generateYieldPoint(node, true);
                break;
            }
            case 164: {
                Node child;
                Node with = child.getNext();
                Node leaveWith = with.getNext();
                this.generateStatement(child);
                this.generateExpression(with.getFirstChild(), with);
                this.generateStatement(leaveWith);
                break;
            }
            case 162: {
                Node child;
                Node expr = child.getNext();
                this.generateStatement(child);
                this.generateExpression(expr, node);
                break;
            }
            case 125: {
                Node child;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                this.addScriptRuntimeInvoke("mixDefaultArgument", OBJECT, OBJECT, OBJECT);
                break;
            }
            case 113: {
                Node child;
                int endOfIf = this.cfw.acquireLabel();
                this.generateExpression(child, node);
                this.cfw.add(89);
                this.addScriptRuntimeInvoke("isNullOrUndefined", BOOLEAN, OBJECT);
                this.cfw.add(153, endOfIf);
                this.cfw.add(87);
                this.generateExpression(child.getNext(), node);
                this.cfw.markLabel(endOfIf);
                break;
            }
            case 138: {
                if (parent.getType() != 69 && parent.getProp(29) == null) {
                    throw new RuntimeException("Unexpected node type " + type);
                }
                Codegen.pushUndefined(this.cfw);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + type);
            }
        }
    }

    private void generateYieldPoint(Node node, boolean exprContext) {
        int top = this.cfw.getStackTop();
        this.maxStack = Math.max(this.maxStack, top);
        if (top != 0) {
            this.generateGenGetStack();
            for (int i = 0; i < top; ++i) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addLoadConstant(i);
                this.cfw.add(95);
                this.cfw.add(83);
            }
            this.cfw.add(87);
        }
        int nextState = this.getNextGeneratorState(node);
        this.generateGeneratorReturnObject(node, false);
        this.generateSetGeneratorResumptionPoint(nextState);
        boolean hasLocals = this.generateSaveLocals(node);
        this.cfw.add(176);
        if (nextState != ((FunctionNode)this.scriptOrFn).getResumptionPoints().size() + 1) {
            this.generateCheckForThrowOrClose(this.getTargetLabel(node), hasLocals, nextState);
        }
        if (top != 0) {
            this.generateGenGetStack();
            for (int i = 0; i < top; ++i) {
                this.cfw.add(89);
                this.cfw.addLoadConstant(top - i - 1);
                this.cfw.add(50);
                this.cfw.add(95);
            }
            this.cfw.add(87);
        }
        if (exprContext) {
            this.cfw.addALoad(this.argsLocal);
        }
    }

    private void generateCheckForThrowOrClose(int label, boolean hasLocals, Object nextState) {
        int throwLabel = this.cfw.acquireLabel();
        int closeLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(throwLabel);
        this.cfw.addALoad(this.argsLocal);
        this.generateThrowJavaScriptException();
        this.cfw.markLabel(closeLabel);
        this.generateGeneratorReturnObject(() -> this.cfw.addALoad(this.argsLocal), true);
        this.generateSetGeneratorResumptionPoint(-1);
        this.cfw.add(176);
        if (nextState == null) {
            this.cfw.markTableSwitchDefault(this.generatorSwitch);
        }
        if (label != -1) {
            this.cfw.markLabel(label);
        }
        if (!hasLocals && nextState != null) {
            this.cfw.markTableSwitchCase(this.generatorSwitch, (Integer)nextState);
        }
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(2);
        this.cfw.add(159, closeLabel);
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(1);
        this.cfw.add(159, throwLabel);
    }

    private void generateIfJump(Node node, Node parent, int trueLabel, int falseLabel) {
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 27: {
                this.generateIfJump(child, node, falseLabel, trueLabel);
                break;
            }
            case 105: 
            case 106: {
                int interLabel = this.cfw.acquireLabel();
                if (type == 106) {
                    this.generateIfJump(child, node, interLabel, falseLabel);
                } else {
                    this.generateIfJump(child, node, trueLabel, interLabel);
                }
                this.cfw.markLabel(interLabel);
                child = child.getNext();
                this.generateIfJump(child, node, trueLabel, falseLabel);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 55: 
            case 56: {
                this.visitIfJumpRelOp(node, child, trueLabel, falseLabel);
                break;
            }
            case 12: 
            case 13: 
            case 49: 
            case 50: {
                this.visitIfJumpEqOp(node, child, trueLabel, falseLabel);
                break;
            }
            default: {
                this.generateExpression(node, parent);
                this.addScriptRuntimeInvoke("toBoolean", BOOLEAN, OBJECT);
                this.cfw.add(154, trueLabel);
                this.cfw.add(167, falseLabel);
            }
        }
    }

    private void visitDecoratorDeclaration(DecoratorDeclarationNode node) {
        boolean hasInitialize = false;
        short descriptor = this.getNewWordLocal();
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addPush(1);
        this.cfw.add(50);
        this.cfw.addAStore(descriptor);
        for (DecoratorNode dn : node.getDecoratorNodes()) {
            if (dn.getDecoratorType() == DecoratorType.INITIALIZE) {
                hasInitialize = true;
                int L1 = this.cfw.acquireLabel();
                this.cfw.addALoad(descriptor);
                this.cfw.add(192, "java/lang/Integer");
                this.generateIntegerUnwrap();
                this.cfw.addPush(Decorator.FIELD);
                this.cfw.add(126);
                this.cfw.add(153, L1);
                this.cfw.addALoad(descriptor);
                this.cfw.add(192, "java/lang/Integer");
                this.generateIntegerUnwrap();
                this.cfw.addPush(Decorator.STATIC);
                this.cfw.add(126);
                this.cfw.add(153, L1);
                this.cfw.addPush("msg.decorator.initialize.on.static.field");
                this.addScriptRuntimeInvoke("typeError0", "Lorg/mozilla/javascript/EcmaError;", STRING);
                this.cfw.add(191);
                this.cfw.markLabel(L1);
            }
            this.generateExpression(dn.getTarget(), node);
            this.cfw.add(192, "org/mozilla/javascript/BaseFunction");
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.add(89);
            this.cfw.addPush(3);
            ArrayList<Node> args = new ArrayList<Node>();
            for (Node ch = dn.getFirstChild(); ch != null; ch = ch.getNext()) {
                args.add(ch);
            }
            this.cfw.addPush(args.size());
            this.cfw.add(189, "java/lang/Object");
            int argsSize = args.size();
            for (int i = 0; i < argsSize; ++i) {
                Node arg = (Node)args.get(i);
                this.cfw.add(89);
                this.cfw.addPush(i);
                this.generateExpression(arg, node);
                this.cfw.add(83);
            }
            this.cfw.add(83);
            this.cfw.addInvoke(182, "org/mozilla/javascript/BaseFunction", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
            this.cfw.addALoad(this.argsLocal);
            this.cfw.add(95);
            this.cfw.addPush(0);
            this.cfw.add(95);
            this.cfw.add(83);
        }
        int skipAssociate = this.cfw.acquireLabel();
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addPush(0);
        this.cfw.add(50);
        this.cfw.add(89);
        this.cfw.add(193, "org/mozilla/javascript/ScriptableObject");
        this.cfw.add(153, skipAssociate);
        this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
        this.cfw.add(89);
        this.cfw.add(178, "org/mozilla/javascript/decorators/Decorator", "HAS_INITIALIZE", OBJECT);
        this.cfw.addPush(hasInitialize);
        this.generateBooleanWrap();
        this.cfw.addPush(true);
        this.cfw.addInvoke(182, "org/mozilla/javascript/ScriptableObject", "associateValue", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;");
        this.cfw.add(87);
        this.cfw.markLabel(skipAssociate);
    }

    private void visitClass(ClassNode cls) {
        Node child = cls.getFirstChild();
        this.generateExpression(child, cls);
        child = child.getNext();
        if (cls.getExtended() != null) {
            this.generateExpression(cls.getExtended(), cls);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("setClassExtends", OBJECT, OBJECT, OBJECT, CONTEXT, SCRIPTABLE);
        }
        while (child != null) {
            Node node;
            Object name;
            if (child instanceof ClassMethod) {
                ClassMethod cm = (ClassMethod)child;
                Node method = cm.getFirstChild();
                name = cm.getNameKey();
                if (name instanceof String) {
                    this.cfw.addPush((String)name);
                } else if (name instanceof Node) {
                    node = (Node)name;
                    this.generateExpression(node, cls);
                } else {
                    this.cfw.addPush((Integer)name);
                    this.addScriptRuntimeInvoke("wrapInt", "Ljava/lang/Integer;", INTEGER);
                }
                this.generateExpression(method, cls);
                this.generateApplyDecorator(child, (List)cm.getProp(33), DecoratorType.WRAP);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(!cm.isStatic());
                this.cfw.addPush(cm.isGetterMethod() ? 2 : (cm.isSetterMethod() ? 1 : 0));
                this.cfw.addPush(cm.isPrivate());
                this.addScriptRuntimeInvoke("addClassMethod", OBJECT, OBJECT, OBJECT, OBJECT, CONTEXT, BOOLEAN, INTEGER, BOOLEAN);
                child = child.getNext();
                continue;
            }
            if (!(child instanceof ClassField)) continue;
            ClassField cp = (ClassField)child;
            Node defaultValue = cp.getFirstChild();
            name = cp.getNameKey();
            this.generateApplyDecorator(child, (List)cp.getProp(33), DecoratorType.WRAP);
            if (!cp.isStatic()) {
                child = child.getNext();
                continue;
            }
            if (name instanceof String) {
                this.cfw.addPush((String)name);
            } else if (name instanceof Node) {
                node = (Node)name;
                this.generateExpression(node, cls);
            } else {
                this.cfw.addPush((Integer)name);
                this.addScriptRuntimeInvoke("wrapInt", "Ljava/lang/Integer;", INTEGER);
            }
            this.generateExpression(defaultValue, cls);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addPush(cp.isPrivate());
            this.addScriptRuntimeInvoke("addClassProperty", OBJECT, OBJECT, OBJECT, OBJECT, CONTEXT, BOOLEAN);
            child = child.getNext();
        }
        this.generateApplyDecorator(cls.getFirstChild(), (List)cls.getProp(33), DecoratorType.WRAP);
        int skipInit = this.cfw.acquireLabel();
        this.cfw.add(89);
        this.cfw.add(193, "org/mozilla/javascript/NativeFunction");
        this.cfw.add(153, skipInit);
        this.cfw.add(89);
        this.cfw.add(192, "org/mozilla/javascript/NativeFunction");
        this.cfw.addPush(1);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", VOID, NATIVE_FUNCTION, INTEGER, SCRIPTABLE, CONTEXT);
        int skipManualScope = this.cfw.acquireLabel();
        this.cfw.add(167, skipManualScope);
        this.cfw.markLabel(skipInit);
        Name className = cls.getClassName();
        if (className != null) {
            short tmp = this.getNewWordLocal(true);
            this.cfw.addAStore(tmp);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(className.getIdentifier());
            this.addScriptRuntimeInvoke("bind", SCRIPTABLE, CONTEXT, SCRIPTABLE, STRING);
            this.cfw.addALoad(tmp);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(cls.getClassName().getIdentifier());
            this.addScriptRuntimeInvoke("setName", OBJECT, SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE, STRING);
        }
        this.cfw.markLabel(skipManualScope);
        for (child = cls.getFirstChild(); child != null; child = child.getNext()) {
            if (child instanceof ClassMethod) {
                ClassMethod cm = (ClassMethod)child;
                this.generateApplyDecorator(child, (List)cm.getProp(33), DecoratorType.REGISTER);
                continue;
            }
            if (!(child instanceof ClassField)) continue;
            ClassField cp = (ClassField)child;
            this.generateApplyDecorator(child, (List)cp.getProp(33), DecoratorType.REGISTER);
        }
        this.generateApplyDecorator(cls.getFirstChild(), (List)cls.getProp(33), DecoratorType.REGISTER);
    }

    private void generateDecoratorDescriptor(Node node) {
        int descriptor = 0;
        if (node instanceof ClassElement) {
            ClassElement ce = (ClassElement)((Object)node);
            if (ce.isStatic()) {
                descriptor |= Decorator.STATIC;
            }
            descriptor = ce.isPrivate() ? (descriptor |= Decorator.PRIVATE) : (descriptor |= Decorator.PUBLIC);
            descriptor = node instanceof ClassMethod ? (descriptor |= Decorator.METHOD) : (descriptor |= Decorator.FIELD);
        } else {
            descriptor |= Decorator.CLASS;
        }
        this.cfw.addPush(descriptor);
    }

    private void generateApplyDecorator(Node node, List<DecoratorNode> decoratorNodes, DecoratorType decoratorType) {
        for (DecoratorNode dn : decoratorNodes) {
            DecoratorType type = dn.getDecoratorType();
            if (!decoratorType.shouldTrigger(type)) continue;
            short target = this.getNewWordLocal();
            this.cfw.addAStore(target);
            if (node instanceof ClassElement) {
                this.cfw.addALoad(target);
                this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
                this.cfw.add(178, "org/mozilla/javascript/decorators/Decorator", "NAME_KEY", OBJECT);
                Object targetName = ((ClassElement)((Object)node)).getNameKey();
                if (targetName instanceof String) {
                    this.cfw.addPush((String)targetName);
                } else if (targetName instanceof Integer) {
                    this.cfw.addPush((Integer)targetName);
                } else if (targetName instanceof Node) {
                    this.generateExpression((Node)targetName, node);
                } else {
                    throw Kit.codeBug(targetName == null ? "null" : targetName.getClass().getSimpleName());
                }
                this.cfw.addPush(true);
                this.cfw.addInvoke(182, "org/mozilla/javascript/ScriptableObject", "associateValue", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;");
                this.cfw.add(87);
            }
            Name decorator = (Name)dn.getTarget();
            this.generateExpression(decorator, node);
            this.cfw.add(192, "org/mozilla/javascript/BaseFunction");
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(4);
            this.cfw.add(189, "java/lang/Object");
            this.cfw.add(89);
            this.cfw.addPush(0);
            this.cfw.addALoad(target);
            this.cfw.add(83);
            this.cfw.add(89);
            this.cfw.addPush(1);
            this.generateDecoratorDescriptor(node);
            this.generateIntegerWrap();
            this.cfw.add(83);
            this.cfw.add(89);
            this.cfw.addPush(2);
            this.cfw.add(178, "org/mozilla/javascript/decorators/DecoratorType", decoratorType.name(), "Lorg/mozilla/javascript/decorators/DecoratorType;");
            this.cfw.add(83);
            ArrayList<Node> args = new ArrayList<Node>();
            for (Node ch = dn.getFirstChild(); ch != null; ch = ch.getNext()) {
                args.add(ch);
            }
            this.cfw.add(89);
            this.cfw.addPush(3);
            this.cfw.addPush(args.size());
            this.cfw.add(189, "java/lang/Object");
            for (int i = 0; i < args.size(); ++i) {
                this.cfw.add(89);
                this.cfw.addPush(i);
                Node ch = (Node)args.get(i);
                this.generateExpression(ch, node);
                this.cfw.add(83);
            }
            this.cfw.add(83);
            this.cfw.addInvoke(182, "org/mozilla/javascript/BaseFunction", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
    }

    private void generateDebugCall() {
        this.addScriptRuntimeInvoke("debug", VOID, OBJECT);
    }

    private void generateRequireCall(String filePath) {
        this.cfw.addPush(1);
        this.cfw.add(189, "java/lang/Object");
        this.cfw.add(89);
        this.cfw.addPush(0);
        this.cfw.addPush(filePath);
        this.cfw.add(83);
        this.cfw.addPush("require");
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("callName", OBJECT, OBJECT_ARRAY, STRING, CONTEXT, SCRIPTABLE);
    }

    private void visitFunction(OptFunctionNode ofn, int functionType) {
        int fnIndex = this.codegen.getIndex(ofn.fnode);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(fnIndex);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        if (functionType == 4) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.addOptRuntimeInvoke("bindThis", FUNCTION, NATIVE_FUNCTION, CONTEXT, SCRIPTABLE, SCRIPTABLE);
        }
        if (functionType == 2 || functionType == 4) {
            return;
        }
        this.cfw.addPush(functionType);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", VOID, NATIVE_FUNCTION, INTEGER, SCRIPTABLE, CONTEXT);
    }

    private int getTargetLabel(Node target) {
        int labelId = target.labelId();
        if (labelId == -1) {
            labelId = this.cfw.acquireLabel();
            target.labelId(labelId);
        }
        return labelId;
    }

    private void visitGoto(Jump node, int type, Node child) {
        Node target = node.target;
        if (type == 6 || type == 7) {
            if (child == null) {
                throw Codegen.badTree();
            }
            int targetLabel = this.getTargetLabel(target);
            int fallThruLabel = this.cfw.acquireLabel();
            if (type == 6) {
                this.generateIfJump(child, node, targetLabel, fallThruLabel);
            } else {
                this.generateIfJump(child, node, fallThruLabel, targetLabel);
            }
            this.cfw.markLabel(fallThruLabel);
        } else if (type == 145) {
            if (this.isGenerator) {
                this.addGotoWithReturn(target);
            } else {
                this.inlineFinally(target);
            }
        } else {
            this.addGoto(target, 167);
        }
    }

    private void addGotoWithReturn(Node target) {
        FinallyReturnPoint ret = this.finallys.get(target);
        this.cfw.addLoadConstant(ret.jsrPoints.size());
        this.addGoto(target, 167);
        this.cfw.add(87);
        int retLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(retLabel);
        ret.jsrPoints.add(retLabel);
    }

    private void generateArrayLiteralFactory(Node node, int count) {
        String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + count;
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        this.cfw.startMethod(methodName, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)2);
        this.visitArrayLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateObjectLiteralFactory(Node node, int count) {
        String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + count;
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        this.cfw.startMethod(methodName, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)2);
        this.visitObjectLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void visitArrayLiteral(Node node, Node child, boolean topLevel) {
        int count = 0;
        for (Node cursor = child; cursor != null; cursor = cursor.getNext()) {
            ++count;
        }
        if (!(topLevel || count <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new LinkedList<Node>();
            }
            this.literals.add(node);
            String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + this.literals.size();
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(182, this.codegen.mainClassName, methodName, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        if (this.isGenerator) {
            int i;
            for (i = 0; i != count; ++i) {
                this.generateExpression(child, node);
                child = child.getNext();
            }
            this.addNewObjectArray(count);
            for (i = 0; i != count; ++i) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(count - i - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            ArgGroups groups = this.populateArgGroups(child);
            if (groups.isSpread.size() > 0) {
                this.addNewObjectArray(groups.groupCount());
                this.generateArgArray(node, groups);
            } else {
                this.addNewObjectArray(count);
                for (int i = 0; i != count; ++i) {
                    this.cfw.add(89);
                    this.cfw.addPush(i);
                    this.generateExpression(child, node);
                    this.cfw.add(83);
                    child = child.getNext();
                }
            }
        }
        int[] skipIndexes = (int[])node.getProp(11);
        if (skipIndexes == null) {
            this.cfw.add(1);
            this.cfw.add(3);
        } else {
            this.cfw.addPush(OptRuntime.encodeIntArray(skipIndexes));
            this.cfw.addPush(skipIndexes.length);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", SCRIPTABLE, OBJECT_ARRAY, STRING, INTEGER, CONTEXT, SCRIPTABLE);
    }

    private void addLoadPropertyIds(Object[] properties, int[] spreadIndices, Node parent) {
        int count = properties.length + spreadIndices.length;
        this.addNewObjectArray(count);
        int propIndex = 0;
        block0: for (int i = 0; i != count; ++i) {
            Object id;
            this.cfw.add(89);
            this.cfw.addPush(i);
            for (int j : spreadIndices) {
                if (i != j) continue;
                this.cfw.add(1);
                this.cfw.add(83);
                continue block0;
            }
            if ((id = properties[propIndex++]) instanceof String) {
                this.cfw.addPush((String)id);
            } else if (id instanceof Node) {
                Node node = (Node)id;
                this.generateExpression(node, parent);
            } else {
                this.cfw.addPush((Integer)id);
                this.addScriptRuntimeInvoke("wrapInt", "Ljava/lang/Integer;", INTEGER);
            }
            this.cfw.add(83);
        }
    }

    private void addLoadPropertyValues(Node node, Node child, int count) {
        if (this.isGenerator) {
            int i;
            for (i = 0; i != count; ++i) {
                int childType = child.getType();
                if (childType == 156 || childType == 157 || childType == 168) {
                    this.generateExpression(child.getFirstChild(), node);
                } else {
                    this.generateExpression(child, node);
                }
                child = child.getNext();
            }
            this.addNewObjectArray(count);
            for (i = 0; i != count; ++i) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(count - i - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            this.addNewObjectArray(count);
            Node child2 = child;
            for (int i = 0; i != count; ++i) {
                this.cfw.add(89);
                this.cfw.addPush(i);
                boolean spread = child2.getProp(29) != null;
                int childType = child2.getType();
                if (childType == 156 || childType == 157 || childType == 168) {
                    if (spread) {
                        throw Kit.codeBug("Unexpected spread on an object method");
                    }
                    this.generateExpression(child2.getFirstChild(), node);
                } else {
                    this.generateExpression(child2, node);
                }
                this.cfw.add(83);
                child2 = child2.getNext();
            }
        }
    }

    private void visitObjectLiteral(Node node, Node child, boolean topLevel) {
        int childType;
        int i;
        Object[] properties = (Object[])node.getProp(12);
        int[] spreadIndices = (int[])node.getProp(32, new int[0]);
        int count = properties.length;
        if (!(topLevel || count <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new LinkedList<Node>();
            }
            this.literals.add(node);
            String methodName = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + this.literals.size();
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(182, this.codegen.mainClassName, methodName, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        if (this.isGenerator) {
            this.addLoadPropertyValues(node, child, count + spreadIndices.length);
            this.addLoadPropertyIds(properties, spreadIndices, node);
            this.cfw.add(95);
        } else {
            this.addLoadPropertyIds(properties, spreadIndices, node);
            this.addLoadPropertyValues(node, child, count + spreadIndices.length);
        }
        boolean hasGetterSetters = false;
        Node child2 = child;
        for (i = 0; i != count; ++i) {
            childType = child2.getType();
            if (childType == 156 || childType == 157) {
                hasGetterSetters = true;
                break;
            }
            child2 = child2.getNext();
        }
        if (hasGetterSetters) {
            this.cfw.addPush(count);
            this.cfw.add(188, 10);
            child2 = child;
            for (i = 0; i != count; ++i) {
                this.cfw.add(89);
                this.cfw.addPush(i);
                childType = child2.getType();
                if (childType == 156) {
                    this.cfw.add(2);
                } else if (childType == 157) {
                    this.cfw.add(4);
                } else {
                    this.cfw.add(3);
                }
                this.cfw.add(79);
                child2 = child2.getNext();
            }
        } else {
            this.cfw.add(1);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("newObjectLiteral", SCRIPTABLE, OBJECT_ARRAY, OBJECT_ARRAY, "[I", CONTEXT, SCRIPTABLE);
    }

    private void visitSpecialCall(Node node, int type, int specialType, Node child) {
        String[] callSignature;
        String methodName;
        this.cfw.addALoad(this.contextLocal);
        if (type == 31) {
            this.generateExpression(child, node);
        } else {
            this.generateFunctionAndThisObj(child, node);
        }
        child = child.getNext();
        this.generateCallArgArray(node, child, false);
        if (type == 31) {
            methodName = "newObjectSpecial";
            callSignature = new String[]{CONTEXT, OBJECT, OBJECT_ARRAY, SCRIPTABLE, SCRIPTABLE, INTEGER};
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(specialType);
        } else {
            methodName = "callSpecial";
            callSignature = new String[]{CONTEXT, CALLABLE, SCRIPTABLE, OBJECT_ARRAY, SCRIPTABLE, SCRIPTABLE, INTEGER, STRING, INTEGER};
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(specialType);
            String sourceName = this.scriptOrFn.getSourceName();
            this.cfw.addPush(sourceName == null ? "" : sourceName);
            this.cfw.addPush(this.itsLineNumber);
        }
        this.addOptRuntimeInvoke(methodName, OBJECT, callSignature);
    }

    private void visitStandardCall(Node node, Node child) {
        String[] signature;
        String methodName;
        boolean isPartial;
        if (node.getType() != 39) {
            throw Codegen.badTree();
        }
        boolean isPrivate = child.getProp(34) != null;
        boolean bl = isPartial = node.getProp(37) != null;
        if (isPartial) {
            this.cfw.add(187, "org/mozilla/javascript/PartialFunction");
            this.cfw.add(89);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
        }
        Node firstArgChild = child.getNext();
        int childType = child.getType();
        if (firstArgChild == null) {
            if (childType == 40) {
                if (child.getProp(31) != null) {
                    boolean isReturned;
                    boolean bl2 = isReturned = node.getNext() != null && node.getNext().getType() == 4;
                    if (child.getProp(31) == IRFactory.GENERATED_SUPER) {
                        this.cfw.addALoad(this.argsLocal);
                    } else {
                        this.cfw.add(1);
                    }
                    this.cfw.addPush(isReturned);
                    this.cfw.addALoad(this.funObjLocal);
                    this.cfw.addALoad(this.thisObjLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("callSuper", OBJECT, OBJECT_ARRAY, BOOLEAN, NATIVE_FUNCTION, SCRIPTABLE, SCRIPTABLE, CONTEXT);
                    if (!isReturned) {
                        this.cfw.add(89);
                        this.cfw.addAStore(this.thisObjLocal);
                    }
                    return;
                }
                String name = child.getString();
                this.cfw.addPush(name);
                methodName = "callName0";
                signature = new String[]{STRING, CONTEXT, SCRIPTABLE};
            } else if (childType == 34) {
                Node propTarget = child.getFirstChild();
                Node id = propTarget.getNext();
                if (propTarget.getProp(31) != null) {
                    this.generateExpression(id, node);
                    this.cfw.add(1);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.cfw.addALoad(this.thisObjLocal);
                    this.cfw.addALoad(this.funObjLocal);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("callSuperProp", OBJECT, OBJECT, OBJECT_ARRAY, SCRIPTABLE, SCRIPTABLE, NATIVE_FUNCTION, CONTEXT);
                    return;
                }
                this.generateExpression(propTarget, node);
                String property = id.getString();
                this.cfw.addPush(property);
                methodName = child.getProp(30) != null ? "optionalAccessCallProp0" : (node.getProp(30) != null ? "optionalCallProp0" : (isPrivate ? "privateCallProp0" : "callProp0"));
                signature = new String[]{OBJECT, STRING, CONTEXT, SCRIPTABLE};
            } else {
                if (childType == 35) {
                    throw Kit.codeBug();
                }
                if (node.getProp(30) != null) {
                    this.generateExpression(child, node);
                    methodName = "optionalCall0";
                    signature = new String[]{OBJECT, CONTEXT, SCRIPTABLE};
                } else {
                    this.generateFunctionAndThisObj(child, node, isPrivate);
                    methodName = "call0";
                    signature = new String[]{CALLABLE, SCRIPTABLE, CONTEXT, SCRIPTABLE};
                }
            }
        } else if (childType == 40) {
            if (isPartial) {
                this.generateExpression(child, node);
                this.cfw.addALoad(this.thisObjLocal);
            }
            this.generateCallArgArray(node, firstArgChild, false);
            if (isPartial) {
                this.cfw.addInvoke(183, "org/mozilla/javascript/PartialFunction", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[I[Ljava/lang/Object;)V");
                this.cfw.add(192, "java/lang/Object");
                return;
            }
            String name = child.getString();
            if (child.getProp(31) != null) {
                boolean isReturned = node.getNext() != null && node.getNext().getType() == 4;
                this.cfw.addPush(isReturned);
                this.cfw.addALoad(this.funObjLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callSuper", OBJECT, OBJECT_ARRAY, BOOLEAN, NATIVE_FUNCTION, SCRIPTABLE, SCRIPTABLE, CONTEXT);
                if (!isReturned) {
                    this.cfw.add(89);
                    this.cfw.addAStore(this.thisObjLocal);
                }
                return;
            }
            this.cfw.addPush(name);
            methodName = "callName";
            signature = new String[]{OBJECT_ARRAY, STRING, CONTEXT, SCRIPTABLE};
        } else {
            Node prop;
            if (isPartial) {
                this.generateFunctionAndThisObj(child, node, isPrivate);
                this.generateCallArgArray(node, firstArgChild, false);
                this.cfw.addInvoke(183, "org/mozilla/javascript/PartialFunction", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[I[Ljava/lang/Object;)V");
                this.cfw.add(192, "java/lang/Object");
                return;
            }
            int argCount = 0;
            for (Node arg = firstArgChild; arg != null; arg = arg.getNext()) {
                if (arg.getProp(29) != null) {
                    argCount = -1;
                    break;
                }
                ++argCount;
            }
            if (child.getFirstChild() != null && child.getFirstChild().getProp(31) != null) {
                this.generateExpression(child.getLastChild(), node);
                this.generateCallArgArray(node, firstArgChild, false);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addALoad(this.funObjLocal);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callSuperProp", OBJECT, OBJECT, OBJECT_ARRAY, SCRIPTABLE, SCRIPTABLE, NATIVE_FUNCTION, CONTEXT);
                return;
            }
            if (child.getProp(30) != null) {
                prop = child.getFirstChild();
                this.generateExpression(prop, child);
                String property = prop.getNext().getString();
                this.cfw.addPush(property);
                this.generateCallArgArray(node, firstArgChild, false);
                methodName = "optionalAccessCallN";
                signature = new String[]{OBJECT, STRING, OBJECT_ARRAY, CONTEXT, SCRIPTABLE};
            } else if (node.getProp(30) != null) {
                if (child.getType() == 40) {
                    prop = child.getFirstChild();
                    this.generateExpression(prop, child);
                    String property = prop.getNext().getString();
                    this.cfw.addPush(property);
                    this.generateCallArgArray(node, firstArgChild, false);
                    methodName = "optionalCallPropN";
                    signature = new String[]{OBJECT, STRING, OBJECT_ARRAY, CONTEXT, SCRIPTABLE};
                } else {
                    this.generateExpression(child, node);
                    this.generateCallArgArray(node, firstArgChild, false);
                    methodName = "optionalCallN";
                    signature = new String[]{OBJECT, OBJECT_ARRAY, CONTEXT, SCRIPTABLE};
                }
            } else if (argCount == 1) {
                this.generateFunctionAndThisObj(child, node, isPrivate);
                this.generateExpression(firstArgChild, node);
                methodName = "call1";
                signature = new String[]{CALLABLE, SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE};
            } else if (argCount == 2) {
                this.generateFunctionAndThisObj(child, node, isPrivate);
                this.generateExpression(firstArgChild, node);
                this.generateExpression(firstArgChild.getNext(), node);
                methodName = "call2";
                signature = new String[]{CALLABLE, SCRIPTABLE, OBJECT, OBJECT, CONTEXT, SCRIPTABLE};
            } else {
                this.generateFunctionAndThisObj(child, node, isPrivate);
                this.generateCallArgArray(node, firstArgChild, false);
                methodName = "callN";
                signature = new String[]{CALLABLE, SCRIPTABLE, OBJECT_ARRAY, CONTEXT, SCRIPTABLE};
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke(methodName, OBJECT, signature);
    }

    private void visitStandardNew(Node node, Node child) {
        if (node.getType() != 31) {
            throw Codegen.badTree();
        }
        Node firstArgChild = child.getNext();
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.generateCallArgArray(node, firstArgChild, false);
        this.addScriptRuntimeInvoke("newObject", SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE, OBJECT_ARRAY);
    }

    private void visitOptimizedCall(Node node, OptFunctionNode target, int type, Node child) {
        Node firstArgChild = child.getNext();
        String className = this.codegen.mainClassName;
        short thisObjLocal = 0;
        if (type == 31) {
            this.generateExpression(child, node);
        } else {
            this.generateFunctionAndThisObj(child, node);
            thisObjLocal = this.getNewWordLocal();
            this.cfw.addAStore(thisObjLocal);
        }
        int beyond = this.cfw.acquireLabel();
        int regularCall = this.cfw.acquireLabel();
        this.cfw.add(89);
        this.cfw.add(193, className);
        this.cfw.add(153, regularCall);
        this.cfw.add(192, className);
        this.cfw.add(89);
        this.cfw.add(180, className, "_id", INTEGER);
        this.cfw.addPush(this.codegen.getIndex(target.fnode));
        this.cfw.add(160, regularCall);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (type == 31) {
            this.cfw.add(1);
        } else {
            this.cfw.addALoad(thisObjLocal);
        }
        for (Node argChild = firstArgChild; argChild != null; argChild = argChild.getNext()) {
            int dcp_register = this.nodeIsDirectCallParameter(argChild);
            if (dcp_register >= 0) {
                this.cfw.addALoad(dcp_register);
                this.cfw.addDLoad(dcp_register + 1);
                continue;
            }
            if (argChild.getIntProp(8, -1) == 0) {
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.generateExpression(argChild, node);
                continue;
            }
            this.generateExpression(argChild, node);
            this.cfw.addPush(0.0);
        }
        this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", OBJECT_ARRAY);
        this.cfw.addInvoke(184, this.codegen.mainClassName, type == 31 ? this.codegen.getDirectCtorName(target.fnode) : this.codegen.getBodyMethodName(target.fnode), this.codegen.getBodyMethodSignature(target.fnode));
        this.cfw.add(167, beyond);
        this.cfw.markLabel(regularCall);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (type != 31) {
            this.cfw.addALoad(thisObjLocal);
            this.releaseWordLocal(thisObjLocal);
        }
        this.generateCallArgArray(node, firstArgChild, true);
        if (type == 31) {
            this.addScriptRuntimeInvoke("newObject", SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE, OBJECT_ARRAY);
        } else {
            this.cfw.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.cfw.markLabel(beyond);
    }

    private ArgGroups populateArgGroups(Node argChild) {
        ArgGroups groups = new ArgGroups();
        boolean wasSpread = false;
        for (Node child = argChild; child != null; child = child.getNext()) {
            boolean isSpread;
            boolean bl = isSpread = child.getProp(29) != null;
            if ((isSpread || !isSpread && wasSpread) && child != argChild) {
                groups.crossBoundary();
            }
            wasSpread = isSpread;
            groups.put(child, isSpread);
        }
        return groups;
    }

    private void generateArgArray(Node parent, ArgGroups groups) {
        for (int i = 0; i < groups.groupCount(); ++i) {
            List<Node> group = groups.groups.get(i);
            boolean isSpread = groups.isSpread.contains(i);
            this.cfw.add(89);
            this.cfw.addPush(i);
            if (isSpread) {
                if (group.size() != 1) {
                    throw Kit.codeBug();
                }
                this.generateExpression(group.get(0), parent);
            } else {
                this.addNewObjectArray(group.size());
                for (int i1 = 0; i1 < group.size(); ++i1) {
                    this.cfw.add(89);
                    this.cfw.addPush(i1);
                    Node groupChild = group.get(i1);
                    this.generateExpression(groupChild, parent);
                    this.cfw.add(83);
                }
            }
            this.cfw.add(83);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("combineSpreadArgs", OBJECT_ARRAY, OBJECT_ARRAY, CONTEXT, SCRIPTABLE);
    }

    private void generateCallArgArray(Node node, Node argChild, boolean directCall) {
        int i;
        ArgGroups groups = this.populateArgGroups(argChild);
        if (groups.isPartial.size() > 0) {
            this.cfw.addPush(groups.isPartial.size());
            this.cfw.add(188, 10);
            i = 0;
            for (int partialIndex : groups.isPartial) {
                this.cfw.add(89);
                this.cfw.addPush(i);
                this.cfw.addPush(partialIndex);
                this.cfw.add(79);
                ++i;
            }
        }
        if (groups.totalArgs == 1 && this.itsOneArgArray >= 0) {
            this.cfw.addALoad(this.itsOneArgArray);
        } else if (groups.isSpread.size() > 0) {
            this.addNewObjectArray(groups.groupCount());
        } else {
            this.addNewObjectArray(groups.totalArgs - groups.isPartial.size());
        }
        if (groups.isSpread.size() > 0) {
            this.generateArgArray(node, groups);
            return;
        }
        for (i = 0; i < groups.totalArgs - groups.isPartial.size(); ++i) {
            if (argChild.getType() == 103 && argChild instanceof EmptyExpression) {
                argChild = argChild.getNext();
                --i;
                continue;
            }
            if (!this.isGenerator) {
                this.cfw.add(89);
                this.cfw.addPush(i);
            }
            if (!directCall) {
                this.generateExpression(argChild, node);
            } else {
                int dcp_register = this.nodeIsDirectCallParameter(argChild);
                if (dcp_register >= 0) {
                    this.dcpLoadAsObject(dcp_register);
                } else {
                    this.generateExpression(argChild, node);
                    int childNumberFlag = argChild.getIntProp(8, -1);
                    if (childNumberFlag == 0) {
                        this.addDoubleWrap();
                    }
                }
            }
            if (this.isGenerator) {
                short tempLocal = this.getNewWordLocal();
                this.cfw.addAStore(tempLocal);
                this.cfw.add(192, OBJECT_ARRAY);
                this.cfw.add(89);
                this.cfw.addPush(i);
                this.cfw.addALoad(tempLocal);
                this.releaseWordLocal(tempLocal);
            }
            this.cfw.add(83);
            argChild = argChild.getNext();
        }
    }

    private void generateFunctionAndThisObj(Node node, Node parent) {
        this.generateFunctionAndThisObj(node, parent, false);
    }

    private void generateFunctionAndThisObj(Node node, Node parent, boolean isPrivate) {
        int type = node.getType();
        switch (node.getType()) {
            case 35: {
                throw Kit.codeBug();
            }
            case 34: 
            case 37: {
                Node target = node.getFirstChild();
                this.generateExpression(target, node);
                short objLocal = 0;
                if (isPrivate) {
                    objLocal = this.getNewWordLocal();
                    this.cfw.add(89);
                    this.cfw.addAStore(objLocal);
                }
                Node id = target.getNext();
                if (isPrivate) {
                    this.cfw.addALoad(objLocal);
                    this.addOptRuntimeInvoke("optionalPrivateToggle", VOID, OBJECT);
                }
                if (type == 34) {
                    String property = id.getString();
                    this.cfw.addPush(property);
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.addScriptRuntimeInvoke("getPropFunctionAndThis", CALLABLE, OBJECT, STRING, CONTEXT, SCRIPTABLE);
                } else {
                    this.generateExpression(id, node);
                    if (node.getIntProp(8, -1) != -1) {
                        this.addDoubleWrap();
                    }
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.addScriptRuntimeInvoke("getElemFunctionAndThis", CALLABLE, OBJECT, OBJECT, CONTEXT, SCRIPTABLE);
                }
                if (!isPrivate) break;
                this.cfw.addALoad(objLocal);
                this.addOptRuntimeInvoke("optionalPrivateToggle", VOID, OBJECT);
                break;
            }
            case 40: {
                String name = node.getString();
                this.cfw.addPush(name);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getNameFunctionAndThis", CALLABLE, STRING, CONTEXT, SCRIPTABLE);
                break;
            }
            default: {
                this.generateExpression(node, parent);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getValueFunctionAndThis", CALLABLE, OBJECT, CONTEXT);
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("lastStoredScriptable", SCRIPTABLE, CONTEXT);
    }

    private void updateLineNumber(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Jump node, Node child) {
        short savedVariableObject = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(savedVariableObject);
        int startLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(startLabel, (short)0);
        Node catchTarget = node.target;
        Node finallyTarget = node.getFinally();
        int[] handlerLabels = new int[5];
        this.exceptionManager.pushExceptionInfo(node);
        if (catchTarget != null) {
            handlerLabels[0] = this.cfw.acquireLabel();
            handlerLabels[1] = this.cfw.acquireLabel();
            handlerLabels[2] = this.cfw.acquireLabel();
            Context cx = Context.getCurrentContext();
            if (cx != null && cx.hasFeature(12)) {
                handlerLabels[3] = this.cfw.acquireLabel();
            }
        }
        if (finallyTarget != null) {
            handlerLabels[4] = this.cfw.acquireLabel();
        }
        this.exceptionManager.setHandlers(handlerLabels, startLabel);
        if (this.isGenerator && finallyTarget != null) {
            FinallyReturnPoint ret = new FinallyReturnPoint();
            if (this.finallys == null) {
                this.finallys = new HashMap<Node, FinallyReturnPoint>();
            }
            this.finallys.put(finallyTarget, ret);
            this.finallys.put(finallyTarget.getNext(), ret);
        }
        while (child != null) {
            if (child == catchTarget) {
                int catchLabel = this.getTargetLabel(catchTarget);
                this.exceptionManager.removeHandler(0, catchLabel);
                this.exceptionManager.removeHandler(1, catchLabel);
                this.exceptionManager.removeHandler(2, catchLabel);
                this.exceptionManager.removeHandler(3, catchLabel);
            }
            this.generateStatement(child);
            child = child.getNext();
        }
        int realEnd = this.cfw.acquireLabel();
        this.cfw.add(167, realEnd);
        int exceptionLocal = this.getLocalBlockRegister(node);
        if (catchTarget != null) {
            int catchLabel = catchTarget.labelId();
            this.generateCatchBlock(0, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[0]);
            this.generateCatchBlock(1, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[1]);
            this.generateCatchBlock(2, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[2]);
            Context cx = Context.getCurrentContext();
            if (cx != null && cx.hasFeature(12)) {
                this.generateCatchBlock(3, savedVariableObject, catchLabel, exceptionLocal, handlerLabels[3]);
            }
        }
        if (finallyTarget != null) {
            int finallyHandler = this.cfw.acquireLabel();
            int finallyEnd = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            if (!this.isGenerator) {
                this.cfw.markLabel(handlerLabels[4]);
            }
            this.cfw.addAStore(exceptionLocal);
            this.cfw.addALoad(savedVariableObject);
            this.cfw.addAStore(this.variableObjectLocal);
            int finallyLabel = finallyTarget.labelId();
            if (this.isGenerator) {
                this.addGotoWithReturn(finallyTarget);
            } else {
                this.inlineFinally(finallyTarget, handlerLabels[4], finallyEnd);
            }
            this.cfw.addALoad(exceptionLocal);
            if (this.isGenerator) {
                this.cfw.add(192, "java/lang/Throwable");
            }
            this.cfw.add(191);
            this.cfw.markLabel(finallyEnd);
            if (this.isGenerator) {
                this.cfw.addExceptionHandler(startLabel, finallyLabel, finallyHandler, null);
            }
        }
        this.releaseWordLocal(savedVariableObject);
        this.cfw.markLabel(realEnd);
        if (!this.isGenerator) {
            this.exceptionManager.popExceptionInfo();
        }
    }

    private void generateCatchBlock(int exceptionType, short savedVariableObject, int catchLabel, int exceptionLocal, int handler) {
        if (handler == 0) {
            handler = this.cfw.acquireLabel();
        }
        this.cfw.markHandler(handler);
        this.cfw.addAStore(exceptionLocal);
        this.cfw.addALoad(savedVariableObject);
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(167, catchLabel);
    }

    private String exceptionTypeToName(int exceptionType) {
        if (exceptionType == 0) {
            return "org/mozilla/javascript/JavaScriptException";
        }
        if (exceptionType == 1) {
            return "org/mozilla/javascript/EvaluatorException";
        }
        if (exceptionType == 2) {
            return "org/mozilla/javascript/EcmaError";
        }
        if (exceptionType == 3) {
            return "java/lang/Throwable";
        }
        if (exceptionType == 4) {
            return null;
        }
        throw Kit.codeBug();
    }

    private void inlineFinally(Node finallyTarget, int finallyStart, int finallyEnd) {
        Node fBlock = this.getFinallyAtTarget(finallyTarget);
        fBlock.resetTargets();
        this.exceptionManager.markInlineFinallyStart(fBlock, finallyStart);
        for (Node child = fBlock.getFirstChild(); child != null; child = child.getNext()) {
            this.generateStatement(child);
        }
        this.exceptionManager.markInlineFinallyEnd(fBlock, finallyEnd);
    }

    private void inlineFinally(Node finallyTarget) {
        int finallyStart = this.cfw.acquireLabel();
        int finallyEnd = this.cfw.acquireLabel();
        this.cfw.markLabel(finallyStart);
        this.inlineFinally(finallyTarget, finallyStart, finallyEnd);
        this.cfw.markLabel(finallyEnd);
    }

    private Node getFinallyAtTarget(Node node) {
        Node fBlock;
        if (node == null) {
            return null;
        }
        if (node.getType() == 134) {
            return node;
        }
        if (node.getType() == 141 && (fBlock = node.getNext()) != null && fBlock.getType() == 134) {
            return fBlock;
        }
        throw Kit.codeBug("bad finally target");
    }

    private boolean generateSaveLocals(Node node) {
        int i;
        int count = 0;
        for (int i2 = 0; i2 < this.firstFreeLocal; ++i2) {
            if (this.locals[i2] == 0) continue;
            ++count;
        }
        if (count == 0) {
            ((FunctionNode)this.scriptOrFn).addLiveLocals(node, null);
            return false;
        }
        this.maxLocals = Math.max(this.maxLocals, count);
        int[] ls = new int[count];
        int s = 0;
        for (i = 0; i < this.firstFreeLocal; ++i) {
            if (this.locals[i] == 0) continue;
            ls[s] = i;
            ++s;
        }
        ((FunctionNode)this.scriptOrFn).addLiveLocals(node, ls);
        this.generateGetGeneratorLocalsState();
        for (i = 0; i < count; ++i) {
            this.cfw.add(89);
            this.cfw.addLoadConstant(i);
            this.cfw.addALoad(ls[i]);
            this.cfw.add(83);
        }
        this.cfw.add(87);
        return true;
    }

    private void visitSwitch(Jump switchNode, Node child) {
        this.generateExpression(child, switchNode);
        short selector = this.getNewWordLocal();
        this.cfw.addAStore(selector);
        for (Jump caseNode = (Jump)child.getNext(); caseNode != null; caseNode = (Jump)caseNode.getNext()) {
            if (caseNode.getType() != 124) {
                throw Codegen.badTree();
            }
            Node test2 = caseNode.getFirstChild();
            this.generateExpression(test2, caseNode);
            this.cfw.addALoad(selector);
            this.addScriptRuntimeInvoke("shallowEq", BOOLEAN, OBJECT, OBJECT);
            this.addGoto(caseNode.target, 154);
        }
        this.releaseWordLocal(selector);
    }

    private void visitTypeofname(Node node) {
        int varIndex;
        if (this.hasVarsInRegs && (varIndex = this.fnCurrent.fnode.getIndexForNameNode(node)) >= 0) {
            if (this.fnCurrent.isNumberVar(varIndex)) {
                this.cfw.addPush("number");
            } else if (this.varIsDirectCallParameter(varIndex)) {
                short dcp_register = this.varRegisters[varIndex];
                this.cfw.addALoad(dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int isNumberLabel = this.cfw.acquireLabel();
                this.cfw.add(165, isNumberLabel);
                short stack = this.cfw.getStackTop();
                this.cfw.addALoad(dcp_register);
                this.addScriptRuntimeInvoke("typeof", STRING, OBJECT);
                int beyond = this.cfw.acquireLabel();
                this.cfw.add(167, beyond);
                this.cfw.markLabel(isNumberLabel, stack);
                this.cfw.addPush("number");
                this.cfw.markLabel(beyond);
            } else {
                this.cfw.addALoad(this.varRegisters[varIndex]);
                this.addScriptRuntimeInvoke("typeof", STRING, OBJECT);
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke("typeofName", STRING, SCRIPTABLE, STRING);
    }

    private void saveCurrentCodeOffset() {
        this.savedCodeOffset = this.cfw.getCurrentCodeOffset();
    }

    private void addInstructionCount() {
        int count = this.cfw.getCurrentCodeOffset() - this.savedCodeOffset;
        this.addInstructionCount(Math.max(count, 1));
    }

    private void addInstructionCount(int count) {
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(count);
        this.addScriptRuntimeInvoke("addInstructionCount", VOID, CONTEXT, INTEGER);
    }

    private void visitIncDec(Node node) {
        int incrDecrMask = node.getExistingIntProp(13);
        Node child = node.getFirstChild();
        switch (child.getType()) {
            case 58: {
                if (!this.hasVarsInRegs) {
                    Kit.codeBug();
                }
                boolean post = (incrDecrMask & 2) != 0;
                int varIndex = this.fnCurrent.getVarIndex(child);
                short reg = this.varRegisters[varIndex];
                boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
                if (constDeclarations[varIndex]) {
                    if (node.getIntProp(8, -1) != -1) {
                        short offset = this.varIsDirectCallParameter(varIndex) ? (short)1 : 0;
                        this.cfw.addDLoad(reg + offset);
                        if (post) break;
                        this.cfw.addPush(1.0);
                        if ((incrDecrMask & 1) == 0) {
                            this.cfw.add(99);
                            break;
                        }
                        this.cfw.add(103);
                        break;
                    }
                    if (this.varIsDirectCallParameter(varIndex)) {
                        this.dcpLoadAsObject(reg);
                    } else {
                        this.cfw.addALoad(reg);
                    }
                    if (post) {
                        this.cfw.add(89);
                        this.addObjectToDouble();
                        this.cfw.add(88);
                        break;
                    }
                    this.addObjectToDouble();
                    this.cfw.addPush(1.0);
                    if ((incrDecrMask & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    this.addDoubleWrap();
                    break;
                }
                if (node.getIntProp(8, -1) != -1) {
                    short offset = this.varIsDirectCallParameter(varIndex) ? (short)1 : 0;
                    this.cfw.addDLoad(reg + offset);
                    if (post) {
                        this.cfw.add(92);
                    }
                    this.cfw.addPush(1.0);
                    if ((incrDecrMask & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    if (!post) {
                        this.cfw.add(92);
                    }
                    this.cfw.addDStore(reg + offset);
                    break;
                }
                if (this.varIsDirectCallParameter(varIndex)) {
                    this.dcpLoadAsObject(reg);
                } else {
                    this.cfw.addALoad(reg);
                }
                this.addObjectToDouble();
                if (post) {
                    this.cfw.add(92);
                }
                this.cfw.addPush(1.0);
                if ((incrDecrMask & 1) == 0) {
                    this.cfw.add(99);
                } else {
                    this.cfw.add(103);
                }
                this.addDoubleWrap();
                if (!post) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(reg);
                if (!post) break;
                this.addDoubleWrap();
                break;
            }
            case 40: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(child.getString());
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("nameIncrDecr", OBJECT, SCRIPTABLE, STRING, CONTEXT, INTEGER);
                break;
            }
            case 35: {
                throw Kit.codeBug();
            }
            case 34: {
                Node getPropChild = child.getFirstChild();
                this.generateExpression(getPropChild, node);
                this.generateExpression(getPropChild.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("propIncrDecr", OBJECT, OBJECT, STRING, CONTEXT, SCRIPTABLE, INTEGER);
                break;
            }
            case 37: {
                Node elemChild = child.getFirstChild();
                this.generateExpression(elemChild, node);
                this.generateExpression(elemChild.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(incrDecrMask);
                if (elemChild.getNext().getIntProp(8, -1) != -1) {
                    this.addOptRuntimeInvoke("elemIncrDecr", OBJECT, OBJECT, DOUBLE, CONTEXT, SCRIPTABLE, INTEGER);
                    break;
                }
                this.addScriptRuntimeInvoke("elemIncrDecr", OBJECT, OBJECT, OBJECT, CONTEXT, SCRIPTABLE, INTEGER);
                break;
            }
            case 71: {
                Node refChild = child.getFirstChild();
                this.generateExpression(refChild, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("refIncrDecr", OBJECT, REF, CONTEXT, SCRIPTABLE, INTEGER);
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int type = node.getType();
        return type == 22 || type == 25 || type == 24 || type == 23;
    }

    private void visitOperator(Node node, Node child, int op) {
        boolean unary = false;
        switch (op) {
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                unary = true;
            }
        }
        this.generateExpression(child, node);
        if (!unary) {
            this.generateExpression(child.getNext(), node);
        }
        this.cfw.addPush(op);
        this.cfw.addALoad(this.contextLocal);
        if (unary) {
            this.addScriptRuntimeInvoke("unaryOperator", OBJECT, OBJECT, INTEGER, CONTEXT);
        } else {
            this.addScriptRuntimeInvoke("binaryOperator", OBJECT, OBJECT, OBJECT, INTEGER, CONTEXT);
        }
    }

    private int nodeIsDirectCallParameter(Node node) {
        int varIndex;
        if (node.getType() == 58 && this.inDirectCallFunction && !this.itsForcedObjectParameters && this.fnCurrent.isParameter(varIndex = this.fnCurrent.getVarIndex(node))) {
            return this.varRegisters[varIndex];
        }
        return -1;
    }

    private boolean varIsDirectCallParameter(int varIndex) {
        return this.fnCurrent.isParameter(varIndex) && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int type, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1) {
            throw Codegen.badTree();
        }
        switch (type) {
            case 15: {
                this.cfw.add(152);
                this.cfw.add(158, trueGOTO);
                break;
            }
            case 17: {
                this.cfw.add(151);
                this.cfw.add(156, trueGOTO);
                break;
            }
            case 14: {
                this.cfw.add(152);
                this.cfw.add(155, trueGOTO);
                break;
            }
            case 16: {
                this.cfw.add(151);
                this.cfw.add(157, trueGOTO);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        if (falseGOTO != -1) {
            this.cfw.add(167, falseGOTO);
        }
    }

    private void visitIfJumpRelOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1 || falseGOTO == -1) {
            throw Codegen.badTree();
        }
        int type = node.getType();
        Node rChild = child.getNext();
        if (type == 56 || type == 55) {
            this.generateExpression(child, node);
            this.generateExpression(rChild, node);
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke(type == 56 ? "instanceOf" : "in", BOOLEAN, OBJECT, OBJECT, CONTEXT);
            this.cfw.add(154, trueGOTO);
            this.cfw.add(167, falseGOTO);
            return;
        }
        int childNumberFlag = node.getIntProp(8, -1);
        int left_dcp_register = this.nodeIsDirectCallParameter(child);
        int right_dcp_register = this.nodeIsDirectCallParameter(rChild);
        if (childNumberFlag != -1) {
            if (childNumberFlag != 2) {
                this.generateExpression(child, node);
            } else if (left_dcp_register != -1) {
                this.dcpLoadAsNumber(left_dcp_register);
            } else {
                this.generateExpression(child, node);
                this.addObjectToDouble();
            }
            if (childNumberFlag != 1) {
                this.generateExpression(rChild, node);
            } else if (right_dcp_register != -1) {
                this.dcpLoadAsNumber(right_dcp_register);
            } else {
                this.generateExpression(rChild, node);
                this.addObjectToDouble();
            }
            this.genSimpleCompare(type, trueGOTO, falseGOTO);
        } else {
            if (left_dcp_register != -1 && right_dcp_register != -1) {
                short stack = this.cfw.getStackTop();
                int leftIsNotNumber = this.cfw.acquireLabel();
                this.cfw.addALoad(left_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, leftIsNotNumber);
                this.cfw.addDLoad(left_dcp_register + 1);
                this.dcpLoadAsNumber(right_dcp_register);
                this.genSimpleCompare(type, trueGOTO, falseGOTO);
                if (stack != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(leftIsNotNumber);
                int rightIsNotNumber = this.cfw.acquireLabel();
                this.cfw.addALoad(right_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, rightIsNotNumber);
                this.cfw.addALoad(left_dcp_register);
                this.addObjectToDouble();
                this.cfw.addDLoad(right_dcp_register + 1);
                this.genSimpleCompare(type, trueGOTO, falseGOTO);
                if (stack != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(rightIsNotNumber);
                this.cfw.addALoad(left_dcp_register);
                this.cfw.addALoad(right_dcp_register);
            } else {
                this.generateExpression(child, node);
                this.generateExpression(rChild, node);
            }
            if (type == 17 || type == 16) {
                this.cfw.add(95);
            }
            String routine = type == 14 || type == 16 ? "cmp_LT" : "cmp_LE";
            this.addScriptRuntimeInvoke(routine, BOOLEAN, OBJECT, OBJECT);
            this.cfw.add(154, trueGOTO);
            this.cfw.add(167, falseGOTO);
        }
    }

    private void visitIfJumpEqOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1 || falseGOTO == -1) {
            throw Codegen.badTree();
        }
        short stackInitial = this.cfw.getStackTop();
        int type = node.getType();
        Node rChild = child.getNext();
        if (child.getType() == 45 || rChild.getType() == 45) {
            if (child.getType() == 45) {
                child = rChild;
            }
            this.generateExpression(child, node);
            if (type == 49 || type == 50) {
                int testCode = type == 49 ? 198 : 199;
                this.cfw.add(testCode, trueGOTO);
            } else {
                if (type != 12) {
                    if (type != 13) {
                        throw Codegen.badTree();
                    }
                    int tmp = trueGOTO;
                    trueGOTO = falseGOTO;
                    falseGOTO = tmp;
                }
                this.cfw.add(89);
                int undefCheckLabel = this.cfw.acquireLabel();
                this.cfw.add(199, undefCheckLabel);
                short stack = this.cfw.getStackTop();
                this.cfw.add(87);
                this.cfw.add(167, trueGOTO);
                this.cfw.markLabel(undefCheckLabel, stack);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add(165, trueGOTO);
            }
            this.cfw.add(167, falseGOTO);
        } else {
            int testCode;
            String name;
            Node convertChild;
            int child_dcp_register = this.nodeIsDirectCallParameter(child);
            if (child_dcp_register != -1 && rChild.getType() == 154 && (convertChild = rChild.getFirstChild()).getType() == 41) {
                this.cfw.addALoad(child_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int notNumbersLabel = this.cfw.acquireLabel();
                this.cfw.add(166, notNumbersLabel);
                this.cfw.addDLoad(child_dcp_register + 1);
                this.cfw.addPush(convertChild.getDouble());
                this.cfw.add(151);
                if (type == 12) {
                    this.cfw.add(153, trueGOTO);
                } else {
                    this.cfw.add(154, trueGOTO);
                }
                this.cfw.add(167, falseGOTO);
                this.cfw.markLabel(notNumbersLabel);
            }
            this.generateExpression(child, node);
            this.generateExpression(rChild, node);
            switch (type) {
                case 12: {
                    name = "eq";
                    testCode = 154;
                    break;
                }
                case 13: {
                    name = "eq";
                    testCode = 153;
                    break;
                }
                case 49: {
                    name = "shallowEq";
                    testCode = 154;
                    break;
                }
                case 50: {
                    name = "shallowEq";
                    testCode = 153;
                    break;
                }
                default: {
                    throw Codegen.badTree();
                }
            }
            this.addScriptRuntimeInvoke(name, BOOLEAN, OBJECT, OBJECT);
            this.cfw.add(testCode, trueGOTO);
            this.cfw.add(167, falseGOTO);
        }
        if (stackInitial != this.cfw.getStackTop()) {
            throw Codegen.badTree();
        }
    }

    private void visitSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("setName", OBJECT, SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE, STRING);
    }

    private void visitStrictSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("strictSetName", OBJECT, SCRIPTABLE, OBJECT, CONTEXT, SCRIPTABLE, STRING);
    }

    private void visitSetConst(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("setConst", OBJECT, SCRIPTABLE, OBJECT, CONTEXT, STRING);
    }

    private void visitGetVar(Node node) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        short reg = this.varRegisters[varIndex];
        if (this.varIsDirectCallParameter(varIndex)) {
            if (node.getIntProp(8, -1) != -1) {
                this.dcpLoadAsNumber(reg);
            } else {
                this.dcpLoadAsObject(reg);
            }
        } else if (this.fnCurrent.isNumberVar(varIndex)) {
            this.cfw.addDLoad(reg);
        } else {
            this.cfw.addALoad(reg);
        }
    }

    private void visitSetVar(Node node, Node child, boolean needValue) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        this.generateExpression(child.getNext(), node);
        boolean isNumber = node.getIntProp(8, -1) != -1;
        short reg = this.varRegisters[varIndex];
        boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
        if (constDeclarations[varIndex]) {
            if (!needValue) {
                if (isNumber) {
                    this.cfw.add(88);
                } else {
                    this.cfw.add(87);
                }
            }
        } else if (this.varIsDirectCallParameter(varIndex)) {
            if (isNumber) {
                if (needValue) {
                    this.cfw.add(92);
                }
                this.cfw.addALoad(reg);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int isNumberLabel = this.cfw.acquireLabel();
                int beyond = this.cfw.acquireLabel();
                this.cfw.add(165, isNumberLabel);
                short stack = this.cfw.getStackTop();
                this.addDoubleWrap();
                this.cfw.addAStore(reg);
                this.cfw.add(167, beyond);
                this.cfw.markLabel(isNumberLabel, stack);
                this.cfw.addDStore(reg + 1);
                this.cfw.markLabel(beyond);
            } else {
                if (needValue) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(reg);
            }
        } else {
            boolean isNumberVar = this.fnCurrent.isNumberVar(varIndex);
            if (isNumber) {
                if (isNumberVar) {
                    this.cfw.addDStore(reg);
                    if (needValue) {
                        this.cfw.addDLoad(reg);
                    }
                } else {
                    if (needValue) {
                        this.cfw.add(92);
                    }
                    this.addDoubleWrap();
                    this.cfw.addAStore(reg);
                }
            } else {
                if (isNumberVar) {
                    Kit.codeBug();
                }
                this.cfw.addAStore(reg);
                if (needValue) {
                    this.cfw.addALoad(reg);
                }
            }
        }
    }

    private void visitSetConstVar(Node node, Node child, boolean needValue) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        this.generateExpression(child.getNext(), node);
        boolean isNumber = node.getIntProp(8, -1) != -1;
        short reg = this.varRegisters[varIndex];
        int beyond = this.cfw.acquireLabel();
        int noAssign = this.cfw.acquireLabel();
        if (isNumber) {
            this.cfw.addILoad(reg + 2);
            this.cfw.add(154, noAssign);
            short stack = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(reg + 2);
            this.cfw.addDStore(reg);
            if (needValue) {
                this.cfw.addDLoad(reg);
                this.cfw.markLabel(noAssign, stack);
            } else {
                this.cfw.add(167, beyond);
                this.cfw.markLabel(noAssign, stack);
                this.cfw.add(88);
            }
        } else {
            this.cfw.addILoad(reg + 1);
            this.cfw.add(154, noAssign);
            short stack = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(reg + 1);
            this.cfw.addAStore(reg);
            if (needValue) {
                this.cfw.addALoad(reg);
                this.cfw.markLabel(noAssign, stack);
            } else {
                this.cfw.add(167, beyond);
                this.cfw.markLabel(noAssign, stack);
                this.cfw.add(87);
            }
        }
        this.cfw.markLabel(beyond);
    }

    private void visitGetProp(Node node, Node child) {
        boolean isPrivate;
        boolean bl = isPrivate = node.getProp(34) != null;
        if (child.getProp(31) != null) {
            this.generateExpression(child.getNext(), node);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.addScriptRuntimeInvoke("accessSuper", OBJECT, OBJECT, SCRIPTABLE, NATIVE_FUNCTION);
            return;
        }
        this.generateExpression(child, node);
        short objLocal = 0;
        if (isPrivate) {
            this.cfw.add(89);
            this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
            objLocal = this.getNewWordLocal();
            this.cfw.addAStore(objLocal);
        }
        Node nameChild = child.getNext();
        this.generateExpression(nameChild, node);
        if (node.getType() == 35) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(isPrivate);
            this.addScriptRuntimeInvoke("getObjectPropNoWarn", OBJECT, OBJECT, STRING, CONTEXT, SCRIPTABLE, BOOLEAN);
        } else {
            String methodName = node.getProp(30) != null ? "optionalGetObjectProp" : "getObjectProp";
            int childType = child.getType();
            if (childType == 46 && nameChild.getType() == 42) {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(isPrivate);
                this.addScriptRuntimeInvoke(methodName, OBJECT, SCRIPTABLE, STRING, CONTEXT, BOOLEAN);
            } else {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(isPrivate);
                this.addScriptRuntimeInvoke(methodName, OBJECT, OBJECT, STRING, CONTEXT, SCRIPTABLE, BOOLEAN);
            }
        }
    }

    private void visitSetProp(int type, Node node, Node child) {
        boolean isSuper;
        boolean isPrivate = node.getProp(34) != null;
        Node objectChild = child;
        boolean bl = isSuper = objectChild.getProp(31) != null;
        if (!isSuper) {
            this.generateExpression(child, node);
        }
        short objLocal = 0;
        if (isPrivate) {
            this.cfw.add(89);
            this.cfw.add(192, "org/mozilla/javascript/ScriptableObject");
            objLocal = this.getNewWordLocal();
            this.cfw.addAStore(objLocal);
        }
        child = child.getNext();
        if (type == 149) {
            this.cfw.add(89);
        }
        Node nameChild = child;
        this.generateExpression(child, node);
        child = child.getNext();
        if (type == 149) {
            this.cfw.add(90);
            if (objectChild.getType() == 46 && nameChild.getType() == 42) {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(isPrivate);
                this.addScriptRuntimeInvoke("getObjectProp", OBJECT, SCRIPTABLE, STRING, CONTEXT, BOOLEAN);
            } else {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(isPrivate);
                this.addScriptRuntimeInvoke("getObjectProp", OBJECT, OBJECT, STRING, CONTEXT, SCRIPTABLE, BOOLEAN);
            }
        }
        if (isSuper) {
            this.generateExpression(child, node);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.addScriptRuntimeInvoke("setSuperProp", OBJECT, STRING, OBJECT, SCRIPTABLE, NATIVE_FUNCTION);
            return;
        }
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(isPrivate);
        this.addScriptRuntimeInvoke("setObjectProp", OBJECT, OBJECT, STRING, OBJECT, CONTEXT, SCRIPTABLE, BOOLEAN);
    }

    private void visitSetElem(int type, Node node, Node child) {
        boolean indexIsNumber;
        boolean isSuper;
        boolean bl = isSuper = child.getProp(31) != null;
        if (isSuper) {
            child = child.getNext();
            this.generateExpression(child, node);
            child = child.getNext();
            this.generateExpression(child, node);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.addScriptRuntimeInvoke("setSuperElem", OBJECT, OBJECT, OBJECT, SCRIPTABLE, NATIVE_FUNCTION);
            return;
        }
        this.generateExpression(child, node);
        child = child.getNext();
        if (type == 150) {
            this.cfw.add(89);
        }
        this.generateExpression(child, node);
        child = child.getNext();
        boolean bl2 = indexIsNumber = node.getIntProp(8, -1) != -1;
        if (type == 150) {
            if (indexIsNumber) {
                this.cfw.add(93);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectIndex", OBJECT, OBJECT, DOUBLE, CONTEXT, SCRIPTABLE);
            } else {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectElem", OBJECT, OBJECT, OBJECT, CONTEXT, SCRIPTABLE);
            }
        }
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (indexIsNumber) {
            this.addScriptRuntimeInvoke("setObjectIndex", OBJECT, OBJECT, DOUBLE, OBJECT, CONTEXT, SCRIPTABLE);
        } else {
            this.addScriptRuntimeInvoke("setObjectElem", OBJECT, OBJECT, OBJECT, OBJECT, CONTEXT, SCRIPTABLE);
        }
    }

    private int getLocalBlockRegister(Node node) {
        Node localBlock = (Node)node.getProp(3);
        return localBlock.getExistingIntProp(2);
    }

    private void dcpLoadAsNumber(int dcp_register) {
        this.cfw.addALoad(dcp_register);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int isNumberLabel = this.cfw.acquireLabel();
        this.cfw.add(165, isNumberLabel);
        short stack = this.cfw.getStackTop();
        this.cfw.addALoad(dcp_register);
        this.addObjectToDouble();
        int beyond = this.cfw.acquireLabel();
        this.cfw.add(167, beyond);
        this.cfw.markLabel(isNumberLabel, stack);
        this.cfw.addDLoad(dcp_register + 1);
        this.cfw.markLabel(beyond);
    }

    private void dcpLoadAsObject(int dcp_register) {
        this.cfw.addALoad(dcp_register);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int isNumberLabel = this.cfw.acquireLabel();
        this.cfw.add(165, isNumberLabel);
        short stack = this.cfw.getStackTop();
        this.cfw.addALoad(dcp_register);
        int beyond = this.cfw.acquireLabel();
        this.cfw.add(167, beyond);
        this.cfw.markLabel(isNumberLabel, stack);
        this.cfw.addDLoad(dcp_register + 1);
        this.addDoubleWrap();
        this.cfw.markLabel(beyond);
    }

    private void addGoto(Node target, int jumpcode) {
        int targetLabel = this.getTargetLabel(target);
        this.cfw.add(jumpcode, targetLabel);
    }

    private void addObjectToDouble() {
        this.addScriptRuntimeInvoke("toNumber", DOUBLE, OBJECT);
    }

    private void addNewObjectArray(int size) {
        if (size == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", OBJECT_ARRAY);
            }
        } else {
            this.cfw.addPush(size);
            this.cfw.add(189, "java/lang/Object");
        }
    }

    private void addScriptRuntimeInvoke(String methodName, String returnValue, String ... args) {
        this.cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", methodName, "(" + String.join((CharSequence)"", args) + ")" + returnValue);
    }

    private void addOptRuntimeInvoke(String methodName, String returnValue, String ... args) {
        this.cfw.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", methodName, "(" + String.join((CharSequence)"", args) + ")" + returnValue);
    }

    private void addJumpedBooleanWrap(int trueLabel, int falseLabel) {
        this.cfw.markLabel(falseLabel);
        int skip = this.cfw.acquireLabel();
        this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cfw.add(167, skip);
        this.cfw.markLabel(trueLabel);
        this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        this.cfw.markLabel(skip);
        this.cfw.adjustStackTop(-1);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "Ljava/lang/Double;", DOUBLE);
    }

    private short getNewWordPairLocal(boolean isConst) {
        return this.getNewWordIntern(isConst ? 3 : 2);
    }

    private short getNewWordLocal(boolean isConst) {
        return this.getNewWordIntern(isConst ? 2 : 1);
    }

    private short getNewWordLocal() {
        return this.getNewWordIntern(1);
    }

    private short getNewWordIntern(int count) {
        int i;
        assert (count >= 1 && count <= 3);
        int[] locals = this.locals;
        short result = -1;
        if (count > 1) {
            i = this.firstFreeLocal;
            block0: while (i + count <= 1024) {
                for (int j = 0; j < count; ++j) {
                    if (locals[i + j] == 0) continue;
                    i += j + 1;
                    continue block0;
                }
                result = (short)i;
                break;
            }
        } else {
            result = this.firstFreeLocal;
        }
        if (result != -1) {
            locals[result] = 1;
            if (count > 1) {
                locals[result + 1] = 1;
            }
            if (count > 2) {
                locals[result + 2] = 1;
            }
            if (result == this.firstFreeLocal) {
                for (i = result + count; i < 1024; ++i) {
                    if (locals[i] != 0) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return result;
                }
            } else {
                return result;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void incReferenceWordLocal(short local) {
        short s = local;
        this.locals[s] = this.locals[s] + 1;
    }

    private void decReferenceWordLocal(short local) {
        short s = local;
        this.locals[s] = this.locals[s] - 1;
    }

    private void releaseWordLocal(short local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = 0;
    }

    static class FinallyReturnPoint {
        public List<Integer> jsrPoints = new ArrayList<Integer>();
        public int tableLabel = 0;

        FinallyReturnPoint() {
        }
    }

    private class ExceptionManager {
        private LinkedList<ExceptionInfo> exceptionInfo = new LinkedList();

        ExceptionManager() {
        }

        void pushExceptionInfo(Jump node) {
            Node fBlock = BodyCodegen.this.getFinallyAtTarget(node.getFinally());
            ExceptionInfo ei = new ExceptionInfo(node, fBlock);
            this.exceptionInfo.add(ei);
        }

        void addHandler(int exceptionType, int handlerLabel, int startLabel) {
            ExceptionInfo top = this.getTop();
            top.handlerLabels[exceptionType] = handlerLabel;
            top.exceptionStarts[exceptionType] = startLabel;
        }

        void setHandlers(int[] handlerLabels, int startLabel) {
            for (int i = 0; i < handlerLabels.length; ++i) {
                if (handlerLabels[i] == 0) continue;
                this.addHandler(i, handlerLabels[i], startLabel);
            }
        }

        int removeHandler(int exceptionType, int endLabel) {
            ExceptionInfo top = this.getTop();
            if (top.handlerLabels[exceptionType] != 0) {
                int handlerLabel = top.handlerLabels[exceptionType];
                this.endCatch(top, exceptionType, endLabel);
                top.handlerLabels[exceptionType] = 0;
                return handlerLabel;
            }
            return 0;
        }

        void popExceptionInfo() {
            this.exceptionInfo.removeLast();
        }

        void markInlineFinallyStart(Node finallyBlock, int finallyStart) {
            ListIterator<ExceptionInfo> iter = this.exceptionInfo.listIterator(this.exceptionInfo.size());
            while (iter.hasPrevious()) {
                ExceptionInfo ei = iter.previous();
                for (int i = 0; i < 5; ++i) {
                    if (ei.handlerLabels[i] == 0 || ei.currentFinally != null) continue;
                    this.endCatch(ei, i, finallyStart);
                    ei.exceptionStarts[i] = 0;
                    ei.currentFinally = finallyBlock;
                }
                if (ei.finallyBlock != finallyBlock) continue;
                break;
            }
        }

        void markInlineFinallyEnd(Node finallyBlock, int finallyEnd) {
            ListIterator<ExceptionInfo> iter = this.exceptionInfo.listIterator(this.exceptionInfo.size());
            while (iter.hasPrevious()) {
                ExceptionInfo ei = iter.previous();
                for (int i = 0; i < 5; ++i) {
                    if (ei.handlerLabels[i] == 0 || ei.currentFinally != finallyBlock) continue;
                    ei.exceptionStarts[i] = finallyEnd;
                    ei.currentFinally = null;
                }
                if (ei.finallyBlock != finallyBlock) continue;
                break;
            }
        }

        private void endCatch(ExceptionInfo ei, int exceptionType, int catchEnd) {
            int catchEndPC;
            if (ei.exceptionStarts[exceptionType] == 0) {
                throw new IllegalStateException("bad exception start");
            }
            int currentStart = ei.exceptionStarts[exceptionType];
            int currentStartPC = BodyCodegen.this.cfw.getLabelPC(currentStart);
            if (currentStartPC != (catchEndPC = BodyCodegen.this.cfw.getLabelPC(catchEnd))) {
                BodyCodegen.this.cfw.addExceptionHandler(ei.exceptionStarts[exceptionType], catchEnd, ei.handlerLabels[exceptionType], BodyCodegen.this.exceptionTypeToName(exceptionType));
            }
        }

        private ExceptionInfo getTop() {
            return this.exceptionInfo.getLast();
        }

        private class ExceptionInfo {
            Node finallyBlock;
            int[] handlerLabels;
            int[] exceptionStarts;
            Node currentFinally;

            ExceptionInfo(Jump node, Node finallyBlock) {
                this.finallyBlock = finallyBlock;
                this.handlerLabels = new int[5];
                this.exceptionStarts = new int[5];
                this.currentFinally = null;
            }
        }
    }

    static class ArgGroups {
        public List<List<Node>> groups = new ArrayList<List<Node>>();
        public Set<Integer> isSpread = new HashSet<Integer>();
        public Set<Integer> isPartial = new HashSet<Integer>();
        public int totalArgs;
        private int cursor = 0;

        ArgGroups() {
            this.groups.add(new ArrayList());
        }

        public void put(Node node, boolean isSpread) {
            ++this.totalArgs;
            if (node.getType() == 103 && node instanceof EmptyExpression) {
                this.isPartial.add(this.totalArgs - 1);
                return;
            }
            this.groups.get(this.cursor).add(node);
            if (isSpread) {
                this.isSpread.add(this.cursor);
            }
        }

        public void crossBoundary() {
            ++this.cursor;
            this.groups.add(new ArrayList());
        }

        public int groupCount() {
            return this.groups.size();
        }
    }
}

