/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.generator;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.generator.NativeGenerator;

public class NativeGeneratorIterator
extends ES6Iterator {
    private static final String GEN_ITERATOR_TAG = "GeneratorIterator";
    private NativeGenerator generator;
    private Object prevValue;
    private boolean done;

    public static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeGeneratorIterator(), GEN_ITERATOR_TAG);
    }

    private NativeGeneratorIterator() {
    }

    public NativeGeneratorIterator(Context cx, Scriptable scope, NativeGenerator generator) {
        super(scope, GEN_ITERATOR_TAG);
        this.generator = generator;
        Object value = this.getNext(cx, scope);
        if (this.isDone(value)) {
            this.done = true;
        } else {
            this.prevValue = value;
        }
    }

    @Override
    public boolean isDone(Context cx, Scriptable scope) {
        return this.done;
    }

    @Override
    public Object nextValue(Context cx, Scriptable scope) {
        if (this.done) {
            return Undefined.instance;
        }
        Object toRet = this.prevValue;
        this.prevValue = this.getNext(cx, scope);
        if (this.isDone(this.prevValue)) {
            this.done = true;
        }
        return ScriptableObject.getProperty((Scriptable)toRet, "value");
    }

    private Object getNext(Context cx, Scriptable scope) {
        return this.generator.resume(cx, scope, 0, Undefined.instance);
    }

    private boolean isDone(Object obj) {
        if (!(obj instanceof NativeObject)) {
            throw Kit.codeBug();
        }
        return (Boolean)ScriptableObject.getProperty((Scriptable)obj, "done");
    }

    @Override
    public String getClassName() {
        return "Generator Iterator";
    }

    @Override
    protected String getTag() {
        return GEN_ITERATOR_TAG;
    }
}

