/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.generator;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.generator.NativeGeneratorIterator;

public final class NativeGenerator
extends IdScriptableObject {
    private static final long serialVersionUID = 1645892441041347273L;
    private static final Object GENERATOR_TAG = "Generator";
    public static final int GENERATOR_SEND = 0;
    public static final int GENERATOR_THROW = 1;
    public static final int GENERATOR_CLOSE = 2;
    private static final int Id_next = 1;
    private static final int Id_return = 2;
    private static final int Id_throw = 3;
    private static final int Id___iterator__ = 4;
    private static final int SymbolId_iterator = 5;
    private static final int MAX_PROTOTYPE_ID = 5;
    private NativeFunction function;
    private Object savedState;
    private String lineSource;
    private int lineNumber;
    private boolean firstTime = true;
    private boolean locked;

    public static NativeGenerator init(ScriptableObject scope, boolean sealed) {
        NativeGenerator prototype = new NativeGenerator();
        if (scope != null) {
            prototype.setParentScope(scope);
            prototype.setPrototype(NativeGenerator.getObjectPrototype(scope));
        }
        prototype.activatePrototypeMap(5);
        if (sealed) {
            prototype.sealObject();
        }
        if (scope != null) {
            scope.associateValue(GENERATOR_TAG, prototype);
        }
        return prototype;
    }

    private NativeGenerator() {
    }

    public NativeGenerator(Scriptable scope, NativeFunction function, Object savedState) {
        this.function = function;
        this.savedState = savedState;
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        this.setParentScope(top);
        NativeGenerator prototype = (NativeGenerator)ScriptableObject.getTopScopeValue(top, GENERATOR_TAG);
        this.setPrototype(prototype);
    }

    @Override
    public String getClassName() {
        return "Generator";
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        if (id == 5) {
            this.initPrototypeMethod(GENERATOR_TAG, id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        switch (id) {
            case 1: {
                arity = 1;
                s = "next";
                break;
            }
            case 2: {
                arity = 1;
                s = "return";
                break;
            }
            case 3: {
                arity = 0;
                s = "throw";
                break;
            }
            case 4: {
                arity = 1;
                s = "__iterator__";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(GENERATOR_TAG, id, s, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(GENERATOR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        if (!(thisObj instanceof NativeGenerator)) {
            throw NativeGenerator.incompatibleCallError(f);
        }
        NativeGenerator generator = (NativeGenerator)thisObj;
        switch (id) {
            case 1: {
                generator.firstTime = false;
                Object arg = args.length > 0 ? args[0] : Undefined.instance;
                return generator.resume(cx, scope, 0, arg);
            }
            case 2: {
                Object arg = args.length > 0 ? args[0] : Undefined.instance;
                return generator.resume(cx, scope, 2, arg);
            }
            case 3: {
                return generator.resume(cx, scope, 1, args.length > 0 ? args[0] : Undefined.instance);
            }
            case 4: 
            case 5: {
                return new NativeGeneratorIterator(cx, scope, (NativeGenerator)thisObj);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object resume(Context cx, Scriptable scope, int operation, Object value) {
        if (this.savedState == null) {
            throw new JavaScriptException(value, this.lineSource, this.lineNumber);
        }
        try {
            Object object = this;
            synchronized (object) {
                if (this.locked) {
                    throw ScriptRuntime.typeError0("msg.already.exec.gen");
                }
                this.locked = true;
            }
            object = this.function.resumeGenerator(cx, scope, operation, this.savedState, value);
            return object;
        }
        catch (GeneratorClosedException e) {
            Object object = Undefined.instance;
            return object;
        }
        catch (RhinoException e) {
            this.lineNumber = e.lineNumber();
            this.lineSource = e.lineSource();
            this.savedState = null;
            throw e;
        }
        finally {
            NativeGenerator nativeGenerator = this;
            synchronized (nativeGenerator) {
                this.locked = false;
            }
        }
    }

    @Override
    protected int findPrototypeId(Symbol key) {
        if (SymbolKey.ITERATOR.equals(key)) {
            return 5;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        int id;
        block6: {
            id = 0;
            String X = null;
            switch (s.length()) {
                case 4: {
                    X = "next";
                    id = 1;
                    break;
                }
                case 5: {
                    X = "throw";
                    id = 3;
                    break;
                }
                case 6: {
                    X = "return";
                    id = 2;
                    break;
                }
                case 12: {
                    X = "__iterator__";
                    id = 4;
                    break;
                }
            }
            if (X == null || X == s || X.equals(s)) break block6;
            id = 0;
        }
        return id;
    }

    public static class GeneratorClosedException
    extends RuntimeException {
        private static final long serialVersionUID = 2561315658662379681L;
    }
}

