/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.decorators;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.decorators.Decorator;
import org.mozilla.javascript.decorators.DecoratorType;

public class WrapDecorator
extends Decorator {
    public static void init(Scriptable scope) {
        WrapDecorator wrap = new WrapDecorator();
        ScriptableObject.defineProperty(scope, "@wrap", (Object)wrap, 2);
    }

    @Override
    public Object consume(Object target, int descriptor, DecoratorType decoratorType, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (decoratorType != DecoratorType.WRAP) {
            return target;
        }
        if ((descriptor & FIELD) != 0) {
            throw ScriptRuntime.typeError("@wrap cannot be applied to class fields");
        }
        if (args.length == 0 || !(args[0] instanceof Callable)) {
            return target;
        }
        return ((Callable)args[0]).call(cx, scope, thisObj, new Object[]{target});
    }
}

