/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.decorators;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.decorators.Decorator;
import org.mozilla.javascript.decorators.DecoratorType;

public class InitializeDecorator
extends Decorator {
    public static void init(Scriptable scope) {
        InitializeDecorator initialize = new InitializeDecorator();
        ScriptableObject.defineProperty(scope, "@initialize", (Object)initialize, 2);
    }

    @Override
    public Object consume(Object target, int descriptor, DecoratorType decoratorType, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object result;
        if (decoratorType != DecoratorType.INITIALIZE) {
            return target;
        }
        if ((descriptor & STATIC) != 0) {
            throw ScriptRuntime.typeError("@initialize is not allowed on static class members");
        }
        if (args.length == 0 || !(args[0] instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(args[0]));
        }
        Callable cb = (Callable)args[0];
        ScriptableObject sTarget = ScriptableObject.ensureScriptableObject(target);
        Object key = Undefined.instance;
        Object value = Undefined.instance;
        if ((descriptor & PUBLIC) != 0 && (descriptor & CLASS) == 0) {
            Object object = key = sTarget.hasAssociatedValue(NAME_KEY) ? sTarget.getAssociatedValue(NAME_KEY) : Undefined.instance;
            if ((descriptor & METHOD) == 0) {
                Object object2 = value = sTarget.hasAssociatedValue(VALUE_KEY) ? sTarget.getAssociatedValue(VALUE_KEY) : Undefined.instance;
            }
        }
        if (!Undefined.isUndefined(result = cb.call(cx, scope, thisObj, new Object[]{target, key, value}))) {
            throw ScriptRuntime.typeError("The function provided to @initialize must return undefined");
        }
        return target;
    }
}

