/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.decorators;

import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.decorators.Decorator;
import org.mozilla.javascript.decorators.InitializeDecorator;
import org.mozilla.javascript.decorators.NumericTemplateDecorator;
import org.mozilla.javascript.decorators.RegisterDecorator;
import org.mozilla.javascript.decorators.WrapDecorator;

public enum DecoratorType {
    WRAP(WrapDecorator.class),
    REGISTER(RegisterDecorator.class),
    INITIALIZE(InitializeDecorator.class),
    NUMERICTEMPLATE(NumericTemplateDecorator.class),
    USER_DEFINED(null);

    private Class<? extends Decorator> decoratorClass;

    private DecoratorType(Class<? extends Decorator> decoratorClass) {
        this.decoratorClass = decoratorClass;
    }

    public Class<? extends Decorator> getDecoratorClass() {
        return this.decoratorClass;
    }

    public boolean shouldTrigger(DecoratorType type) {
        return type == USER_DEFINED || this == type;
    }

    public static DecoratorType fromDecorator(String decorator) {
        decorator = decorator.replaceAll("@", "");
        for (DecoratorType type : DecoratorType.values()) {
            if (!type.name().toLowerCase().equals(decorator.toLowerCase())) continue;
            return type;
        }
        return USER_DEFINED;
    }

    public static void init(Scriptable scope) {
        WrapDecorator.init(scope);
        RegisterDecorator.init(scope);
        InitializeDecorator.init(scope);
        NumericTemplateDecorator.init(scope);
    }
}

