/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.StringLiteral;

public class TemplateLiteral
extends AstNode {
    private List<AstNode> elements = new ArrayList<AstNode>();
    private String[] rawElements = null;
    private Set<Integer> isExpr = new HashSet<Integer>();
    private AstNode target = null;
    private Node transformedTarget = null;

    public TemplateLiteral() {
        this.type = 43;
    }

    public void addString(String literal) {
        StringLiteral lit = new StringLiteral();
        lit.setValue(literal);
        this.elements.add(lit);
    }

    public void addExpr(AstNode expr) {
        this.isExpr.add(this.elements.size());
        this.elements.add(expr);
    }

    public void setRawElements(String[] rawElements) {
        this.rawElements = rawElements;
    }

    public String[] getRawElements() {
        return this.rawElements;
    }

    public List<AstNode> getElements() {
        return this.elements;
    }

    public boolean isExpr(int index) {
        return this.isExpr.contains(index);
    }

    @Override
    public String toSource(int depth) {
        return "";
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            for (AstNode e : this.elements) {
                e.visit(v);
            }
        }
    }

    public void setTarget(AstNode target) {
        this.target = target;
    }

    public AstNode getTarget() {
        return this.target;
    }

    public void setTransformedTarget(Node transformedTarget) {
        this.transformedTarget = transformedTarget;
    }

    public Node getTransformedTarget() {
        return this.transformedTarget;
    }
}

