/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;

public class Name
extends AstNode {
    private String identifier;
    private Scope scope;

    public Name() {
        this.type = 40;
    }

    public Name(int pos) {
        super(pos);
        this.type = 40;
    }

    public Name(int pos, int len) {
        super(pos, len);
        this.type = 40;
    }

    public Name(int pos, int len, String name) {
        super(pos, len);
        this.type = 40;
        this.setIdentifier(name);
    }

    public Name(int pos, String name) {
        super(pos);
        this.type = 40;
        this.setIdentifier(name);
        this.setLength(name.length());
    }

    public static boolean sameIdentifier(Node name1, Node name2) {
        return name1 instanceof Name && name2 instanceof Name && ((Name)name1).getIdentifier().equals(((Name)name2).getIdentifier());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.assertNotNull(identifier);
        this.identifier = identifier;
        this.setLength(identifier.length());
    }

    @Override
    public void setScope(Scope s) {
        this.scope = s;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public Scope getDefiningScope() {
        Scope enclosing = this.getEnclosingScope();
        String name = this.getIdentifier();
        return enclosing == null ? null : enclosing.getDefiningScope(name);
    }

    public boolean isLocalName() {
        Scope scope = this.getDefiningScope();
        return scope != null && scope.getParentScope() != null;
    }

    public int length() {
        return this.identifier == null ? 0 : this.identifier.length();
    }

    @Override
    public String toSource(int depth) {
        return this.makeIndent(depth) + (this.identifier == null ? "<null>" : this.identifier);
    }

    @Override
    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

