/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class KeywordLiteral
extends AstNode {
    public KeywordLiteral() {
    }

    public KeywordLiteral(int pos) {
        super(pos);
    }

    public KeywordLiteral(int pos, int len) {
        super(pos, len);
    }

    public KeywordLiteral(int pos, int len, int nodeType) {
        super(pos, len);
        this.setType(nodeType);
    }

    @Override
    public KeywordLiteral setType(int nodeType) {
        if (nodeType != 46 && nodeType != 45 && nodeType != 48 && nodeType != 47 && nodeType != 165) {
            throw new IllegalArgumentException("Invalid node type: " + nodeType);
        }
        this.type = nodeType;
        return this;
    }

    public boolean isBooleanLiteral() {
        return this.type == 48 || this.type == 47;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        switch (this.getType()) {
            case 46: {
                sb.append("this");
                break;
            }
            case 45: {
                sb.append("null");
                break;
            }
            case 48: {
                sb.append("true");
                break;
            }
            case 47: {
                sb.append("false");
                break;
            }
            case 165: {
                sb.append("debugger;\n");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid keyword literal type: " + this.getType());
            }
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

