/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ImportNode
extends AstNode {
    private List<ModuleMember> namedMembers = new ArrayList<ModuleMember>();
    private ModuleMember defaultMember = null;
    private ModuleMember moduleMember = null;
    private String filePath = null;

    public ImportNode() {
        this.type = 120;
    }

    public List<ModuleMember> getNamedMembers() {
        return this.namedMembers;
    }

    public ModuleMember getDefaultMember() {
        return this.defaultMember;
    }

    public ModuleMember getModuleImport() {
        return this.moduleMember;
    }

    public void addNamedMember(String targetName, String scopeName) {
        this.namedMembers.add(new ModuleMember(targetName, scopeName));
    }

    public void setDefaultMember(String scopeName) {
        this.defaultMember = new ModuleMember(null, scopeName);
    }

    public boolean hasDefaultMember() {
        return this.defaultMember != null;
    }

    public void setModuleMember(String scopeName) {
        this.moduleMember = new ModuleMember(null, scopeName);
    }

    public boolean getModuleMember() {
        return this.moduleMember != null;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder("import ");
        if (this.getModuleMember()) {
            sb.append("* ");
            if (this.defaultMember.scopeName != null) {
                sb.append(" as ").append(this.defaultMember.scopeName);
            }
        } else if (this.hasDefaultMember()) {
            sb.append(this.defaultMember.scopeName);
        }
        if (!this.getModuleMember()) {
            if (this.hasDefaultMember()) {
                sb.append(",");
            }
            sb.append(" {");
            int namedMemberSize = this.namedMembers.size();
            for (int i = 0; i < namedMemberSize; ++i) {
                ModuleMember imp = this.namedMembers.get(i);
                sb.append(' ').append(imp.targetName);
                if (imp.scopeName != null) {
                    sb.append(" as ").append(imp.scopeName);
                }
                if (i == namedMemberSize - 1) continue;
                sb.append(',');
            }
            sb.append(" } ");
        }
        sb.append("from '").append(this.filePath).append("';");
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        v.visit(this);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public static class ModuleMember {
        private String targetName;
        private String scopeName;

        public ModuleMember(String targetName, String scopeName) {
            this.targetName = targetName;
            this.scopeName = scopeName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getScopeName() {
            return this.scopeName;
        }
    }
}

