/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.ClassField;
import org.mozilla.javascript.ast.ClassMethod;
import org.mozilla.javascript.ast.DecoratorNode;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.ScriptNode;

public class ClassNode
extends ScriptNode {
    private Name className = null;
    private AstNode extendsName = null;
    private FunctionNode constructor = null;
    private List<ClassMethod> methods = new ArrayList<ClassMethod>();
    private List<ClassField> fields = new ArrayList<ClassField>();
    private List<DecoratorNode> decorators = new ArrayList<DecoratorNode>();
    private Node parentFn = null;
    private Node extended = null;

    public ClassNode() {
        this.type = 115;
    }

    public ClassNode(int pos) {
        super(pos);
        this.type = 115;
    }

    public ClassNode(int pos, Name name) {
        super(pos);
        this.type = 115;
        this.className = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    public boolean hasPrivateSlots() {
        return this.methods.stream().anyMatch(ClassMethod::isPrivate) || this.fields.stream().anyMatch(ClassField::isPrivate);
    }

    public Name getClassName() {
        return this.className;
    }

    public void setClassName(Name name) {
        this.className = name;
    }

    public void setExtendsNode(AstNode name) {
        this.extendsName = name;
    }

    public AstNode getExtendsName() {
        return this.extendsName;
    }

    public FunctionNode getConstructor() {
        return this.constructor;
    }

    public void setConstructor(FunctionNode constructor) {
        this.constructor = constructor;
    }

    public List<ClassMethod> getMethods() {
        return this.methods;
    }

    public void setMethods(List<ClassMethod> methods) {
        this.methods = methods;
    }

    public List<ClassField> getFields() {
        return this.fields;
    }

    public void setFields(List<ClassField> fields) {
        this.fields = fields;
    }

    public Node getParentFn() {
        return this.parentFn;
    }

    public void setParentFn(Node parentFn) {
        this.parentFn = parentFn;
    }

    public Node getExtended() {
        return this.extended;
    }

    public void setExtended(Node extended) {
        this.extended = extended;
    }

    public List<DecoratorNode> getDecorators() {
        return this.decorators;
    }

    public void setDecorators(List<DecoratorNode> decorators) {
        this.decorators = decorators;
    }
}

