/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;

class TokenStream {
    private static final int EOF_CHAR = -1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private boolean dirtyLine;
    String regExpFlags;
    private String string = "";
    private double number;
    private boolean isBinary;
    private boolean isOldOctal;
    private boolean isOctal;
    private boolean isHex;
    private boolean inTemplateLiteral = false;
    private boolean inTemplateExpr = false;
    private boolean endOfTemplate = false;
    private boolean justBeganTemplateExpr = false;
    private final StringBuilder currRawLiteral = new StringBuilder();
    private final List<String> rawLiterals = new ArrayList<String>();
    private int quoteChar;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineEndChar = -1;
    int lineno;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    int sourceCursor;
    int cursor;
    int tokenBeg;
    int tokenEnd;
    Token.CommentType commentType;
    private Parser parser;
    private String commentPrefix = "";
    private int commentCursor = -1;

    TokenStream(Parser parser, Reader sourceReader, String sourceString, int lineno) {
        this.parser = parser;
        this.lineno = lineno;
        if (sourceReader != null) {
            if (sourceString != null) {
                Kit.codeBug();
            }
            this.sourceReader = sourceReader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (sourceString == null) {
                Kit.codeBug();
            }
            this.sourceString = sourceString;
            this.sourceEnd = sourceString.length();
        }
        this.cursor = 0;
        this.sourceCursor = 0;
    }

    String tokenToString(int token) {
        return "";
    }

    static boolean isKeyword(String s, int version, boolean isStrict) {
        return 0 != TokenStream.stringToKeyword(s, version, isStrict);
    }

    private static int stringToKeyword(String name, int version, boolean isStrict) {
        if (version < 200) {
            return TokenStream.stringToKeywordForJS(name);
        }
        return TokenStream.stringToKeywordForES(name, isStrict);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeywordForJS(String name) {
        int Id_break = 129;
        int Id_case = 124;
        int Id_continue = 130;
        int Id_default = 125;
        int Id_delete = 32;
        int Id_do = 127;
        int Id_else = 122;
        int Id_export = 137;
        int Id_false = 47;
        int Id_for = 128;
        int Id_function = 114;
        int Id_class = 115;
        int Id_extends = 116;
        int Id_static = 117;
        int Id_super = 118;
        int Id_if = 121;
        int Id_in = 55;
        int Id_let = 158;
        int Id_new = 31;
        int Id_null = 45;
        int Id_return = 4;
        int Id_switch = 123;
        int Id_this = 46;
        int Id_true = 48;
        int Id_typeof = 33;
        int Id_var = 131;
        int Id_void = 136;
        int Id_while = 126;
        int Id_with = 132;
        int Id_yield = 76;
        int Id_abstract = 137;
        int Id_boolean = 137;
        int Id_byte = 137;
        int Id_catch = 133;
        int Id_char = 137;
        int Id_const = 159;
        int Id_debugger = 165;
        int Id_double = 137;
        int Id_enum = 137;
        int Id_final = 137;
        int Id_finally = 134;
        int Id_float = 137;
        int Id_goto = 137;
        int Id_implements = 137;
        int Id_import = 137;
        int Id_instanceof = 56;
        int Id_int = 137;
        int Id_interface = 137;
        int Id_long = 137;
        int Id_native = 137;
        int Id_package = 137;
        int Id_private = 137;
        int Id_protected = 137;
        int Id_public = 137;
        int Id_short = 137;
        int Id_synchronized = 137;
        int Id_throw = 53;
        int Id_throws = 137;
        int Id_transient = 137;
        int Id_try = 78;
        int Id_volatile = 137;
        String s = name;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                char c = s.charAt(1);
                if (c == 'f') {
                    if (s.charAt(0) != 'i') break;
                    return 121;
                }
                if (c == 'n') {
                    if (s.charAt(0) != 'i') break;
                    return 55;
                }
                if (c != 'o' || s.charAt(0) != 'd') break;
                return 127;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'f': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                        return 128;
                    }
                    case 'i': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'n') break;
                        return 137;
                    }
                    case 'l': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                        return 158;
                    }
                    case 'n': {
                        if (s.charAt(2) != 'w' || s.charAt(1) != 'e') break;
                        return 31;
                    }
                    case 't': {
                        if (s.charAt(2) != 'y' || s.charAt(1) != 'r') break;
                        return 78;
                    }
                    case 'v': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'a') break;
                        return 131;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        X = "byte";
                        id = 137;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                            return 124;
                        }
                        if (c != 'r' || s.charAt(2) != 'a' || s.charAt(1) != 'h') break;
                        return 137;
                    }
                    case 'e': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'l') break;
                            return 122;
                        }
                        if (c != 'm' || s.charAt(2) != 'u' || s.charAt(1) != 'n') break;
                        return 137;
                    }
                    case 'g': {
                        X = "goto";
                        id = 137;
                        break;
                    }
                    case 'l': {
                        X = "long";
                        id = 137;
                        break;
                    }
                    case 'n': {
                        X = "null";
                        id = 45;
                        break;
                    }
                    case 't': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 'u' || s.charAt(1) != 'r') break;
                            return 48;
                        }
                        if (c != 's' || s.charAt(2) != 'i' || s.charAt(1) != 'h') break;
                        return 46;
                    }
                    case 'v': {
                        X = "void";
                        id = 136;
                        break;
                    }
                    case 'w': {
                        X = "with";
                        id = 132;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(2)) {
                    case 'a': {
                        X = "class";
                        id = 115;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'b') {
                            X = "break";
                            id = 129;
                            break;
                        }
                        if (c != 'y') break;
                        X = "yield";
                        id = 76;
                        break;
                    }
                    case 'i': {
                        X = "while";
                        id = 126;
                        break;
                    }
                    case 'l': {
                        X = "false";
                        id = 47;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            X = "const";
                            id = 159;
                            break;
                        }
                        if (c != 'f') break;
                        X = "final";
                        id = 137;
                        break;
                    }
                    case 'o': {
                        char c = s.charAt(0);
                        if (c == 'f') {
                            X = "float";
                            id = 137;
                            break;
                        }
                        if (c != 's') break;
                        X = "short";
                        id = 137;
                        break;
                    }
                    case 'p': {
                        X = "super";
                        id = 118;
                        break;
                    }
                    case 'r': {
                        X = "throw";
                        id = 53;
                        break;
                    }
                    case 't': {
                        X = "catch";
                        id = 133;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "native";
                        id = 137;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "delete";
                            id = 32;
                            break;
                        }
                        if (c != 'r') break;
                        X = "return";
                        id = 4;
                        break;
                    }
                    case 'h': {
                        X = "throws";
                        id = 137;
                        break;
                    }
                    case 'm': {
                        X = "import";
                        id = 137;
                        break;
                    }
                    case 'o': {
                        X = "double";
                        id = 137;
                        break;
                    }
                    case 't': {
                        X = "static";
                        id = 117;
                        break;
                    }
                    case 'u': {
                        X = "public";
                        id = 137;
                        break;
                    }
                    case 'w': {
                        X = "switch";
                        id = 123;
                        break;
                    }
                    case 'x': {
                        X = "export";
                        id = 137;
                        break;
                    }
                    case 'y': {
                        X = "typeof";
                        id = 33;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "package";
                        id = 137;
                        break block0;
                    }
                    case 'e': {
                        X = "default";
                        id = 125;
                        break block0;
                    }
                    case 'i': {
                        X = "finally";
                        id = 134;
                        break block0;
                    }
                    case 'o': {
                        X = "boolean";
                        id = 137;
                        break block0;
                    }
                    case 'r': {
                        X = "private";
                        id = 137;
                        break block0;
                    }
                    case 'x': {
                        X = "extends";
                        id = 116;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "abstract";
                        id = 137;
                        break block0;
                    }
                    case 'c': {
                        X = "continue";
                        id = 130;
                        break block0;
                    }
                    case 'd': {
                        X = "debugger";
                        id = 165;
                        break block0;
                    }
                    case 'f': {
                        X = "function";
                        id = 114;
                        break block0;
                    }
                    case 'v': {
                        X = "volatile";
                        id = 137;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'i') {
                    X = "interface";
                    id = 137;
                    break;
                }
                if (c == 'p') {
                    X = "protected";
                    id = 137;
                    break;
                }
                if (c != 't') break;
                X = "transient";
                id = 137;
                break;
            }
            case 10: {
                char c = s.charAt(1);
                if (c == 'm') {
                    X = "implements";
                    id = 137;
                    break;
                }
                if (c != 'n') break;
                X = "instanceof";
                id = 56;
                break;
            }
            case 12: {
                X = "synchronized";
                id = 137;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            return 0;
        }
        if (id != 0) return id & 0xFF;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeywordForES(String name, boolean isStrict) {
        int Id_break = 129;
        int Id_case = 124;
        int Id_catch = 133;
        int Id_class = 115;
        int Id_const = 159;
        int Id_continue = 130;
        int Id_debugger = 165;
        int Id_decorator = 135;
        int Id_default = 125;
        int Id_delete = 32;
        int Id_do = 127;
        int Id_else = 122;
        int Id_export = 119;
        int Id_extends = 116;
        int Id_finally = 134;
        int Id_for = 128;
        int Id_function = 114;
        int Id_if = 121;
        int Id_import = 120;
        int Id_in = 55;
        int Id_instanceof = 56;
        int Id_new = 31;
        int Id_return = 4;
        int Id_static = 117;
        int Id_super = 118;
        int Id_switch = 123;
        int Id_this = 46;
        int Id_throw = 53;
        int Id_try = 78;
        int Id_typeof = 33;
        int Id_var = 131;
        int Id_void = 136;
        int Id_while = 126;
        int Id_with = 132;
        int Id_yield = 76;
        int Id_await = 137;
        int Id_enum = 137;
        int Id_implements = 137;
        int Id_interface = 137;
        int Id_package = 137;
        int Id_private = 137;
        int Id_protected = 137;
        int Id_public = 137;
        int Id_false = 47;
        int Id_null = 45;
        int Id_true = 48;
        int Id_let = 158;
        String s = name;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                char c = s.charAt(1);
                if (c == 'f') {
                    if (s.charAt(0) != 'i') break;
                    return 121;
                }
                if (c == 'n') {
                    if (s.charAt(0) != 'i') break;
                    return 55;
                }
                if (c != 'o' || s.charAt(0) != 'd') break;
                return 127;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'f': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                        return 128;
                    }
                    case 'l': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                        return 158;
                    }
                    case 'n': {
                        if (s.charAt(2) != 'w' || s.charAt(1) != 'e') break;
                        return 31;
                    }
                    case 't': {
                        if (s.charAt(2) != 'y' || s.charAt(1) != 'r') break;
                        return 78;
                    }
                    case 'v': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'a') break;
                        return 131;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "case";
                        id = 124;
                        break block0;
                    }
                    case 'h': {
                        X = "this";
                        id = 46;
                        break block0;
                    }
                    case 'i': {
                        X = "with";
                        id = 132;
                        break block0;
                    }
                    case 'l': {
                        X = "else";
                        id = 122;
                        break block0;
                    }
                    case 'n': {
                        X = "enum";
                        id = 137;
                        break block0;
                    }
                    case 'o': {
                        X = "void";
                        id = 136;
                        break block0;
                    }
                    case 'r': {
                        X = "true";
                        id = 48;
                        break block0;
                    }
                    case 'u': {
                        X = "null";
                        id = 45;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "await";
                        id = 137;
                        break;
                    }
                    case 'b': {
                        X = "break";
                        id = 129;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(4);
                        if (c == 'h') {
                            X = "catch";
                            id = 133;
                            break;
                        }
                        if (c == 's') {
                            X = "class";
                            id = 115;
                            break;
                        }
                        if (c != 't') break;
                        X = "const";
                        id = 159;
                        break;
                    }
                    case 'f': {
                        X = "false";
                        id = 47;
                        break;
                    }
                    case 's': {
                        X = "super";
                        id = 118;
                        break;
                    }
                    case 't': {
                        X = "throw";
                        id = 53;
                        break;
                    }
                    case 'w': {
                        X = "while";
                        id = 126;
                        break;
                    }
                    case 'y': {
                        X = "yield";
                        id = 76;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(0)) {
                    case 'd': {
                        X = "delete";
                        id = 32;
                        break;
                    }
                    case 'e': {
                        X = "export";
                        id = 119;
                        break;
                    }
                    case 'i': {
                        X = "import";
                        id = 120;
                        break;
                    }
                    case 'p': {
                        X = "public";
                        id = 137;
                        break;
                    }
                    case 'r': {
                        X = "return";
                        id = 4;
                        break;
                    }
                    case 's': {
                        char c = s.charAt(5);
                        if (c == 'c') {
                            X = "static";
                            id = 117;
                            break;
                        }
                        if (c != 'h') break;
                        X = "switch";
                        id = 123;
                        break;
                    }
                    case 't': {
                        X = "typeof";
                        id = 33;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "package";
                        id = 137;
                        break block0;
                    }
                    case 'e': {
                        X = "default";
                        id = 125;
                        break block0;
                    }
                    case 'i': {
                        X = "finally";
                        id = 134;
                        break block0;
                    }
                    case 'r': {
                        X = "private";
                        id = 137;
                        break block0;
                    }
                    case 'x': {
                        X = "extends";
                        id = 116;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "continue";
                    id = 130;
                    break;
                }
                if (c == 'd') {
                    X = "debugger";
                    id = 165;
                    break;
                }
                if (c != 'f') break;
                X = "function";
                id = 114;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'd') {
                    X = "decorator";
                    id = 135;
                    break;
                }
                if (c == 'i') {
                    X = "interface";
                    id = 137;
                    break;
                }
                if (c != 'p') break;
                X = "protected";
                id = 137;
                break;
            }
            case 10: {
                char c = s.charAt(1);
                if (c == 'm') {
                    X = "implements";
                    id = 137;
                    break;
                }
                if (c != 'n') break;
                X = "instanceof";
                id = 56;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            return 0;
        }
        if (id != 0) return id & 0xFF;
        return 0;
    }

    final String getSourceString() {
        return this.sourceString;
    }

    final int getLineno() {
        return this.lineno;
    }

    final String getString() {
        return this.string;
    }

    final char getQuoteChar() {
        return (char)this.quoteChar;
    }

    final double getNumber() {
        return this.number;
    }

    final boolean isNumberBinary() {
        return this.isBinary;
    }

    final boolean isNumberOldOctal() {
        return this.isOldOctal;
    }

    final boolean isNumberOctal() {
        return this.isOctal;
    }

    final boolean isNumberHex() {
        return this.isHex;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int getToken() throws IOException {
        boolean lookForSlash;
        int c;
        block198: {
            block206: {
                double dval;
                String numString;
                boolean isEmpty;
                int base;
                block205: {
                    block204: {
                        boolean isUnicodeEscapeStart;
                        block202: {
                            block203: {
                                boolean es6;
                                boolean identifierStart;
                                block200: {
                                    block199: {
                                        if (this.inTemplateLiteral && !this.inTemplateExpr && !this.endOfTemplate) break block199;
                                        if (this.justBeganTemplateExpr) {
                                            this.justBeganTemplateExpr = false;
                                            this.getChar();
                                            this.getChar();
                                            return 44;
                                        }
                                        break block200;
                                    }
                                    int character = this.getChar(false);
                                    boolean wasJustEscape = false;
                                    this.stringBufferTop = 0;
                                    block52: while (character != 96) {
                                        block201: {
                                            this.currRawLiteral.append((char)character);
                                            if (character == -1) {
                                                throw new EvaluatorException("Unfinished template literal");
                                            }
                                            if (character == 92) {
                                                int c2;
                                                int i;
                                                int escapeVal;
                                                character = this.getChar();
                                                this.currRawLiteral.append((char)character);
                                                switch (character) {
                                                    case 98: {
                                                        character = 8;
                                                        break block201;
                                                    }
                                                    case 102: {
                                                        character = 12;
                                                        break block201;
                                                    }
                                                    case 110: {
                                                        character = 10;
                                                        break block201;
                                                    }
                                                    case 114: {
                                                        character = 13;
                                                        break block201;
                                                    }
                                                    case 116: {
                                                        character = 9;
                                                        break block201;
                                                    }
                                                    case 118: {
                                                        character = 11;
                                                        break block201;
                                                    }
                                                    case 117: {
                                                        int escapeStart = this.stringBufferTop;
                                                        escapeVal = 0;
                                                        if (this.matchChar(123)) {
                                                            break;
                                                        }
                                                        this.addToString(117);
                                                        for (i = 0; i != 4; ++i) {
                                                            c2 = this.getChar();
                                                            escapeVal = Kit.xDigitToInt(c2, escapeVal);
                                                            if (escapeVal < 0) {
                                                                this.parser.addError("msg.invalid.escape");
                                                                return -1;
                                                            }
                                                            this.addToString(c2);
                                                        }
                                                        c2 = escapeVal;
                                                        this.stringBufferTop = escapeStart;
                                                        break block201;
                                                    }
                                                    case 120: {
                                                        character = this.getChar();
                                                        escapeVal = Kit.xDigitToInt(character, 0);
                                                        if (escapeVal < 0) {
                                                            this.addToString(120);
                                                            continue block52;
                                                        }
                                                        int c1 = character;
                                                        character = this.getChar();
                                                        escapeVal = Kit.xDigitToInt(character, escapeVal);
                                                        if (escapeVal < 0) {
                                                            this.addToString(120);
                                                            this.addToString(c1);
                                                            continue block52;
                                                        }
                                                        character = escapeVal;
                                                        break block201;
                                                    }
                                                    case 10: {
                                                        character = this.getChar();
                                                        continue block52;
                                                    }
                                                    default: {
                                                        if (48 <= character && character < 56) {
                                                            int val = character - 48;
                                                            character = this.getChar();
                                                            if (48 <= character && character < 56) {
                                                                val = 8 * val + character - 48;
                                                                character = this.getChar();
                                                                if (48 <= character && character < 56 && val <= 31) {
                                                                    val = 8 * val + character - 48;
                                                                    character = this.getChar();
                                                                }
                                                            }
                                                            this.ungetChar(character);
                                                            character = val;
                                                        }
                                                        break block201;
                                                    }
                                                }
                                                for (i = 0; i < 6; ++i) {
                                                    c2 = this.getChar();
                                                    if (c2 == 125) {
                                                        this.ungetChar(c2);
                                                        break;
                                                    }
                                                    if ((escapeVal = Kit.xDigitToInt(c2, escapeVal)) < 0) break;
                                                }
                                                if ((c2 = this.getChar()) != 125) {
                                                    this.parser.addError("msg.invalid.escape");
                                                    return -1;
                                                }
                                                int high = (escapeVal - 65536) / 1024 + 55296;
                                                this.addToString(high);
                                                c2 = (char)(escapeVal - 65536) % 1024 + 56320;
                                            }
                                        }
                                        if (character == 36 && !wasJustEscape) {
                                            int aChar = this.getChar(false);
                                            if (aChar == 123) {
                                                this.justBeganTemplateExpr = true;
                                                this.inTemplateExpr = true;
                                                this.currRawLiteral.deleteCharAt(this.currRawLiteral.length() - 1);
                                                this.rawLiterals.add(this.currRawLiteral.toString());
                                                this.currRawLiteral.setLength(0);
                                                this.ungetChar(aChar);
                                                this.ungetChar(character);
                                                break;
                                            }
                                            this.ungetChar(aChar);
                                        }
                                        wasJustEscape = character == 92;
                                        this.addToString(character);
                                        character = this.getChar(false);
                                    }
                                    if (character == 96) {
                                        this.ungetChar(96);
                                        this.endOfTemplate = true;
                                    }
                                    String str = this.getStringFromBuffer();
                                    this.string = (String)this.allStrings.intern(str);
                                    return 42;
                                }
                                do {
                                    if ((c = this.getChar()) == -1) {
                                        this.tokenBeg = this.cursor - 1;
                                        this.tokenEnd = this.cursor;
                                        return 0;
                                    }
                                    if (c != 10) continue;
                                    this.dirtyLine = false;
                                    this.tokenBeg = this.cursor - 1;
                                    this.tokenEnd = this.cursor;
                                    return 1;
                                } while (TokenStream.isJSSpace(c));
                                if (c != 45) {
                                    this.dirtyLine = true;
                                }
                                this.tokenBeg = this.cursor - 1;
                                this.tokenEnd = this.cursor;
                                if (c == 64) {
                                    return 153;
                                }
                                isUnicodeEscapeStart = false;
                                if (c == 92) {
                                    c = this.getChar();
                                    if (c == 117) {
                                        identifierStart = true;
                                        isUnicodeEscapeStart = true;
                                        this.stringBufferTop = 0;
                                    } else {
                                        identifierStart = false;
                                        this.ungetChar(c);
                                        c = 92;
                                    }
                                } else {
                                    identifierStart = Character.isJavaIdentifierStart((char)c);
                                    if (identifierStart) {
                                        this.stringBufferTop = 0;
                                        this.addToString(c);
                                    }
                                }
                                if (identifierStart) break block202;
                                if (!TokenStream.isDigit(c) && (c != 46 || !TokenStream.isDigit(this.peekChar()))) break block203;
                                this.stringBufferTop = 0;
                                base = 10;
                                this.isBinary = false;
                                this.isOctal = false;
                                this.isOldOctal = false;
                                this.isHex = false;
                                boolean bl = es6 = this.parser.compilerEnv.getLanguageVersion() >= 200;
                                if (c == 48) {
                                    c = this.getChar();
                                    if (c == 120 || c == 88) {
                                        base = 16;
                                        this.isHex = true;
                                        c = this.getChar();
                                    } else if (es6 && (c == 111 || c == 79)) {
                                        base = 8;
                                        this.isOctal = true;
                                        c = this.getChar();
                                    } else if (es6 && (c == 98 || c == 66)) {
                                        base = 2;
                                        this.isBinary = true;
                                        c = this.getChar();
                                    } else if (TokenStream.isDigit(c)) {
                                        base = 8;
                                        this.isOldOctal = true;
                                    } else {
                                        this.addToString(48);
                                    }
                                }
                                isEmpty = true;
                                if (base != 16) break block204;
                                while (0 <= Kit.xDigitToInt(c, 0)) {
                                    this.addToString(c);
                                    c = this.getChar();
                                    isEmpty = false;
                                }
                                break block205;
                            }
                            if (c == 96) {
                                boolean bl = this.inTemplateLiteral = !this.inTemplateLiteral;
                                if (this.inTemplateLiteral) {
                                    this.currRawLiteral.setLength(0);
                                    this.rawLiterals.clear();
                                } else {
                                    this.rawLiterals.add(this.currRawLiteral.toString());
                                }
                                this.endOfTemplate = false;
                                return 43;
                            }
                            if (c == 34 || c == 39) break block206;
                            switch (c) {
                                case 59: {
                                    return 79;
                                }
                                case 91: {
                                    return 80;
                                }
                                case 93: {
                                    return 81;
                                }
                                case 123: {
                                    return 82;
                                }
                                case 125: {
                                    return 83;
                                }
                                case 40: {
                                    return 84;
                                }
                                case 41: {
                                    return 85;
                                }
                                case 44: {
                                    return 86;
                                }
                                case 63: {
                                    if (this.matchChar(63)) {
                                        if (this.matchChar(61)) {
                                            return 102;
                                        }
                                        return 113;
                                    }
                                    if (this.matchChar(46)) {
                                        return 111;
                                    }
                                    return 103;
                                }
                                case 35: {
                                    return 170;
                                }
                                case 58: {
                                    return 104;
                                }
                                case 46: {
                                    if (this.matchChar(46)) {
                                        if (this.matchChar(46)) {
                                            return 110;
                                        }
                                        this.ungetChar(46);
                                    }
                                    return 109;
                                }
                                case 124: {
                                    if (this.matchChar(124)) {
                                        if (this.matchChar(61)) {
                                            return 100;
                                        }
                                        return 105;
                                    }
                                    if (this.matchChar(61)) {
                                        return 88;
                                    }
                                    if (this.matchChar(62)) {
                                        return 112;
                                    }
                                    return 9;
                                }
                                case 94: {
                                    if (this.matchChar(61)) {
                                        return 89;
                                    }
                                    return 10;
                                }
                                case 38: {
                                    if (this.matchChar(38)) {
                                        if (this.matchChar(61)) {
                                            return 101;
                                        }
                                        return 106;
                                    }
                                    if (this.matchChar(61)) {
                                        return 90;
                                    }
                                    return 11;
                                }
                                case 61: {
                                    if (this.matchChar(61)) {
                                        if (this.matchChar(61)) {
                                            return 49;
                                        }
                                        return 12;
                                    }
                                    if (this.matchChar(62)) {
                                        return 169;
                                    }
                                    return 87;
                                }
                                case 33: {
                                    if (!this.matchChar(61)) {
                                        return 27;
                                    }
                                    if (this.matchChar(61)) {
                                        return 50;
                                    }
                                    return 13;
                                }
                                case 60: {
                                    if (this.matchChar(33)) {
                                        if (this.matchChar(45)) {
                                            if (this.matchChar(45)) {
                                                this.tokenBeg = this.cursor - 4;
                                                this.skipLine();
                                                this.commentType = Token.CommentType.HTML;
                                                return 166;
                                            }
                                            this.ungetCharIgnoreLineEnd(45);
                                        }
                                        this.ungetCharIgnoreLineEnd(33);
                                    }
                                    if (this.matchChar(60)) {
                                        if (this.matchChar(61)) {
                                            return 91;
                                        }
                                        return 18;
                                    }
                                    if (this.matchChar(61)) {
                                        return 15;
                                    }
                                    return 14;
                                }
                                case 62: {
                                    if (this.matchChar(62)) {
                                        if (this.matchChar(62)) {
                                            if (this.matchChar(61)) {
                                                return 93;
                                            }
                                            return 20;
                                        }
                                        if (this.matchChar(61)) {
                                            return 92;
                                        }
                                        return 19;
                                    }
                                    if (this.matchChar(61)) {
                                        return 17;
                                    }
                                    return 16;
                                }
                                case 42: {
                                    if (this.matchChar(61)) {
                                        return 96;
                                    }
                                    if (!this.matchChar(42)) {
                                        return 23;
                                    }
                                    if (this.matchChar(61)) {
                                        return 99;
                                    }
                                    return 26;
                                }
                                case 8233: {
                                    return 1;
                                }
                                case 47: {
                                    this.markCommentStart();
                                    if (this.matchChar(47)) {
                                        this.tokenBeg = this.cursor - 2;
                                        this.skipLine();
                                        this.commentType = Token.CommentType.LINE;
                                        return 166;
                                    }
                                    if (this.matchChar(42)) {
                                        lookForSlash = false;
                                        this.tokenBeg = this.cursor - 2;
                                        if (this.matchChar(42)) {
                                            lookForSlash = true;
                                            this.commentType = Token.CommentType.JSDOC;
                                            break block198;
                                        } else {
                                            this.commentType = Token.CommentType.BLOCK_COMMENT;
                                        }
                                        break block198;
                                    } else {
                                        if (this.matchChar(61)) {
                                            return 97;
                                        }
                                        return 24;
                                    }
                                }
                                case 37: {
                                    if (this.matchChar(61)) {
                                        return 98;
                                    }
                                    return 25;
                                }
                                case 126: {
                                    return 28;
                                }
                                case 43: {
                                    if (this.matchChar(61)) {
                                        return 94;
                                    }
                                    if (this.matchChar(43)) {
                                        return 107;
                                    }
                                    return 21;
                                }
                                case 45: {
                                    if (this.matchChar(45)) {
                                        if (this.matchChar(62)) {
                                            this.tokenBeg = this.cursor - 3;
                                            this.skipLine();
                                            this.commentType = Token.CommentType.HTML;
                                            return 166;
                                        }
                                        this.ungetCharIgnoreLineEnd(45);
                                    }
                                    if (this.matchChar(61)) {
                                        c = 95;
                                    } else if (this.matchChar(45)) {
                                        if (!this.dirtyLine && this.matchChar(62)) {
                                            this.markCommentStart("--");
                                            this.skipLine();
                                            this.commentType = Token.CommentType.HTML;
                                            return 166;
                                        }
                                        c = 108;
                                    } else {
                                        c = 22;
                                    }
                                    this.dirtyLine = true;
                                    return c;
                                }
                                default: {
                                    this.parser.addError("msg.illegal.character", c);
                                    return -1;
                                }
                            }
                        }
                        boolean containsEscape = isUnicodeEscapeStart;
                        while (true) {
                            int i;
                            int escapeVal;
                            block208: {
                                block210: {
                                    block209: {
                                        block207: {
                                            if (!isUnicodeEscapeStart) break block207;
                                            escapeVal = 0;
                                            if (!this.matchChar(123)) break block208;
                                            break block209;
                                        }
                                        c = this.getChar();
                                        if (c == 92) {
                                            c = this.getChar();
                                            if (c != 117) {
                                                this.parser.addError("msg.illegal.character", c);
                                                return -1;
                                            }
                                            isUnicodeEscapeStart = true;
                                            containsEscape = true;
                                            continue;
                                        }
                                        if (c != -1 && c != 65279 && Character.isJavaIdentifierPart((char)c)) {
                                            this.addToString(c);
                                            continue;
                                        }
                                        break block210;
                                    }
                                    for (i = 0; i < 6; ++i) {
                                        c = this.getChar();
                                        if (c == 125) {
                                            this.ungetChar(c);
                                            break;
                                        }
                                        if ((escapeVal = Kit.xDigitToInt(c, escapeVal)) < 0) break;
                                    }
                                    if ((c = this.getChar()) != 125) {
                                        this.parser.addError("msg.invalid.escape");
                                        return -1;
                                    }
                                    this.addToString((escapeVal - 65536) / 1024 + 55296);
                                    this.addToString((escapeVal - 65536) % 1024 + 56320);
                                    isUnicodeEscapeStart = false;
                                }
                                if (!containsEscape) {
                                    this.ungetChar(c);
                                }
                                String str = this.getStringFromBuffer();
                                if (!containsEscape) {
                                    int result = TokenStream.stringToKeyword(str, this.parser.compilerEnv.getLanguageVersion(), this.parser.inUseStrictDirective());
                                    if (result != 0) {
                                        if ((result == 158 || result == 76) && this.parser.compilerEnv.getLanguageVersion() < 170) {
                                            this.string = result == 158 ? "let" : "yield";
                                            result = 40;
                                        }
                                        this.string = (String)this.allStrings.intern(str);
                                        if (result != 137) {
                                            return result;
                                        }
                                        if (this.parser.compilerEnv.getLanguageVersion() >= 200) {
                                            return result;
                                        }
                                        if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                                            return result;
                                        }
                                    }
                                } else if (TokenStream.isKeyword(str, this.parser.compilerEnv.getLanguageVersion(), this.parser.inUseStrictDirective())) {
                                    str = this.convertLastCharToHex(str);
                                }
                                this.string = (String)this.allStrings.intern(str);
                                return 40;
                            }
                            for (i = 0; i != 4 && (escapeVal = Kit.xDigitToInt(c = this.getChar(), escapeVal)) >= 0; ++i) {
                            }
                            if (escapeVal < 0) {
                                this.parser.addError("msg.invalid.escape");
                                return -1;
                            }
                            this.addToString(escapeVal);
                            isUnicodeEscapeStart = false;
                        }
                    }
                    while (48 <= c && c <= 57 || c == 95) {
                        if (c == 95) {
                            c = this.getChar();
                            if (c != 101 && c != 69 && c != 46 && TokenStream.isDigit(c)) continue;
                            this.parser.addError("msg.caught.nfe");
                            return -1;
                        }
                        if (base == 8 && c >= 56) {
                            if (!this.isOldOctal) {
                                this.parser.addError("msg.caught.nfe");
                                return -1;
                            }
                            this.parser.addWarning("msg.bad.octal.literal", c == 56 ? "8" : "9");
                            base = 10;
                        } else if (base == 2 && c >= 50) {
                            this.parser.addError("msg.caught.nfe");
                            return -1;
                        }
                        this.addToString(c);
                        c = this.getChar();
                        isEmpty = false;
                    }
                }
                if (isEmpty && (this.isBinary || this.isOctal || this.isHex)) {
                    this.parser.addError("msg.caught.nfe");
                    return -1;
                }
                boolean isInteger = true;
                if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                    isInteger = false;
                    if (c == 46) {
                        if (this.peekChar() == 95) {
                            this.parser.addError("msg.caught.nfe");
                            return -1;
                        }
                        do {
                            if (c == 95) {
                                c = this.getChar();
                                if (TokenStream.isDigit(c) || c == 95) continue;
                                this.parser.addError("msg.caught.nfe");
                                return -1;
                            }
                            this.addToString(c);
                            c = this.getChar();
                        } while (TokenStream.isDigit(c) || c == 95);
                    }
                    if (c == 101 || c == 69) {
                        if (this.peekChar() == 95) {
                            this.parser.addError("msg.caught.nfe");
                            return -1;
                        }
                        this.addToString(c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            this.addToString(c);
                            c = this.getChar();
                        }
                        if (!TokenStream.isDigit(c)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            if (c == 95) {
                                c = this.getChar();
                                if (TokenStream.isDigit(c) || c == 95) continue;
                                this.parser.addError("msg.caught.nfe");
                                return -1;
                            }
                            this.addToString(c);
                            c = this.getChar();
                        } while (TokenStream.isDigit(c) || c == 95);
                    }
                }
                this.ungetChar(c);
                this.string = numString = this.getStringFromBuffer();
                if (base == 10 && !isInteger) {
                    try {
                        dval = Double.parseDouble(numString);
                    }
                    catch (NumberFormatException ex) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    dval = ScriptRuntime.stringPrefixToNumber(numString, 0, base);
                }
                this.number = dval;
                return 41;
            }
            this.quoteChar = c;
            this.stringBufferTop = 0;
            c = this.getChar(false);
            block63: while (true) {
                block211: {
                    if (c == this.quoteChar) {
                        String str = this.getStringFromBuffer();
                        this.string = (String)this.allStrings.intern(str);
                        return 42;
                    }
                    if (c == 10 || c == -1) {
                        this.ungetChar(c);
                        this.tokenEnd = this.cursor;
                        this.parser.addError("msg.unterminated.string.lit");
                        return -1;
                    }
                    if (c == 92) {
                        int i;
                        int escapeVal;
                        c = this.getChar();
                        switch (c) {
                            case 98: {
                                c = 8;
                                break block211;
                            }
                            case 102: {
                                c = 12;
                                break block211;
                            }
                            case 110: {
                                c = 10;
                                break block211;
                            }
                            case 114: {
                                c = 13;
                                break block211;
                            }
                            case 116: {
                                c = 9;
                                break block211;
                            }
                            case 118: {
                                c = 11;
                                break block211;
                            }
                            case 117: {
                                int escapeStart = this.stringBufferTop;
                                escapeVal = 0;
                                if (this.matchChar(123)) {
                                    break;
                                }
                                this.addToString(117);
                                for (i = 0; i != 4; ++i) {
                                    c = this.getChar();
                                    escapeVal = Kit.xDigitToInt(c, escapeVal);
                                    if (escapeVal < 0) {
                                        this.parser.addError("msg.invalid.escape");
                                        return -1;
                                    }
                                    this.addToString(c);
                                }
                                c = escapeVal;
                                this.stringBufferTop = escapeStart;
                                break block211;
                            }
                            case 120: {
                                c = this.getChar();
                                escapeVal = Kit.xDigitToInt(c, 0);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    continue block63;
                                }
                                int c1 = c;
                                c = this.getChar();
                                escapeVal = Kit.xDigitToInt(c, escapeVal);
                                if (escapeVal < 0) {
                                    this.addToString(120);
                                    this.addToString(c1);
                                    continue block63;
                                }
                                c = escapeVal;
                                break block211;
                            }
                            case 10: {
                                c = this.getChar();
                                continue block63;
                            }
                            default: {
                                if (48 <= c && c < 56) {
                                    int val = c - 48;
                                    c = this.getChar();
                                    if (48 <= c && c < 56) {
                                        val = 8 * val + c - 48;
                                        c = this.getChar();
                                        if (48 <= c && c < 56 && val <= 31) {
                                            val = 8 * val + c - 48;
                                            c = this.getChar();
                                        }
                                    }
                                    this.ungetChar(c);
                                    c = val;
                                }
                                break block211;
                            }
                        }
                        for (i = 0; i < 6; ++i) {
                            c = this.getChar();
                            if (c == 125) {
                                this.ungetChar(c);
                                break;
                            }
                            if ((escapeVal = Kit.xDigitToInt(c, escapeVal)) < 0) break;
                        }
                        if ((c = this.getChar()) != 125) {
                            this.parser.addError("msg.invalid.escape");
                            return -1;
                        }
                        int high = (escapeVal - 65536) / 1024 + 55296;
                        this.addToString(high);
                        c = (char)(escapeVal - 65536) % 1024 + 56320;
                    }
                }
                this.addToString(c);
                c = this.getChar(false);
            }
        }
        while (true) {
            if ((c = this.getChar()) == -1) {
                this.tokenEnd = this.cursor - 1;
                this.parser.addError("msg.unterminated.comment");
                return 166;
            }
            if (c == 42) {
                lookForSlash = true;
                continue;
            }
            if (c == 47) {
                if (!lookForSlash) continue;
                this.tokenEnd = this.cursor;
                return 166;
            }
            lookForSlash = false;
            this.tokenEnd = this.cursor;
        }
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || c == 65279 || Character.getType((char)c) == 12;
    }

    private static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType((char)c) == 16;
    }

    void readRegExp(int startToken) throws IOException {
        int c;
        int start = this.tokenBeg;
        this.stringBufferTop = 0;
        if (startToken == 97) {
            this.addToString(61);
        } else if (startToken != 24) {
            Kit.codeBug();
        }
        boolean inCharSet = false;
        while ((c = this.getChar()) != 47 || inCharSet) {
            if (c == 10 || c == -1) {
                this.ungetChar(c);
                this.tokenEnd = this.cursor - 1;
                this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                this.parser.reportError("msg.unterminated.re.lit");
                return;
            }
            if (c == 92) {
                this.addToString(c);
                c = this.getChar();
            } else if (c == 91) {
                inCharSet = true;
            } else if (c == 93) {
                inCharSet = false;
            }
            this.addToString(c);
        }
        int reEnd = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (this.matchChar(109)) {
                this.addToString(109);
                continue;
            }
            if (this.matchChar(121)) {
                this.addToString(121);
                continue;
            }
            if (!this.matchChar(115)) break;
            this.addToString(115);
        }
        this.tokenEnd = start + this.stringBufferTop + 2;
        if (TokenStream.isAlpha(this.peekChar())) {
            this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, reEnd);
        this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
    }

    String readAndClearRegExpFlags() {
        String flags = this.regExpFlags;
        this.regExpFlags = null;
        return flags;
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int N = this.stringBufferTop;
        if (N == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, N);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[N] = (char)c;
        this.stringBufferTop = N + 1;
    }

    private boolean canUngetChar() {
        return this.ungetCursor == 0 || this.ungetBuffer[this.ungetCursor - 1] != 10;
    }

    private void ungetChar(int c) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private boolean matchChar(int test2) throws IOException {
        int c = this.getCharIgnoreLineEnd();
        if (c == test2) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(c);
        return false;
    }

    private int peekChar() throws IOException {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    private int getChar() throws IOException {
        return this.getChar(true);
    }

    private int getChar(boolean skipFormattingChars) throws IOException {
        int c;
        block12: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    c = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    c = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block12;
                }
                if (c == 65279) {
                    return c;
                }
                if (!skipFormattingChars || !TokenStream.isJSFormatChar(c)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private int getCharIgnoreLineEnd() throws IOException {
        int c;
        block9: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            do {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    c = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    c = this.sourceBuffer[this.sourceCursor++];
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block9;
                }
                if (c != 65279) continue;
                return c;
            } while (TokenStream.isJSFormatChar(c));
            if (ScriptRuntime.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private void ungetCharIgnoreLineEnd(int c) {
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
        }
        this.ungetChar(c);
        this.tokenEnd = this.cursor;
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    private final int charAt(int index) {
        if (index < 0) {
            return -1;
        }
        if (this.sourceString != null) {
            if (index >= this.sourceEnd) {
                return -1;
            }
            return this.sourceString.charAt(index);
        }
        if (index >= this.sourceEnd) {
            int oldSourceCursor = this.sourceCursor;
            try {
                if (!this.fillSourceBuffer()) {
                    return -1;
                }
            }
            catch (IOException ioe) {
                return -1;
            }
            index -= oldSourceCursor - this.sourceCursor;
        }
        return this.sourceBuffer[index];
    }

    private final String substring(int beginIndex, int endIndex) {
        if (this.sourceString != null) {
            return this.sourceString.substring(beginIndex, endIndex);
        }
        int count = endIndex - beginIndex;
        return new String(this.sourceBuffer, beginIndex, count);
    }

    final String getLine() {
        int lineEnd = this.sourceCursor;
        if (this.lineEndChar >= 0) {
            if (this.lineEndChar == 10 && this.charAt(--lineEnd - 1) == 13) {
                --lineEnd;
            }
        } else {
            int c;
            int lineLength = lineEnd - this.lineStart;
            while ((c = this.charAt(this.lineStart + lineLength)) != -1 && !ScriptRuntime.isJSLineTerminator(c)) {
                ++lineLength;
            }
            lineEnd = this.lineStart + lineLength;
        }
        return this.substring(this.lineStart, lineEnd);
    }

    final String getLine(int position, int[] linep) {
        assert (position >= 0 && position <= this.cursor);
        assert (linep.length == 2);
        int delta = this.cursor + this.ungetCursor - position;
        int cur = this.sourceCursor;
        if (delta > cur) {
            return null;
        }
        int end = 0;
        int lines = 0;
        while (delta > 0) {
            assert (cur > 0);
            int c = this.charAt(cur - 1);
            if (ScriptRuntime.isJSLineTerminator(c)) {
                if (c == 10 && this.charAt(cur - 2) == 13) {
                    --delta;
                    --cur;
                }
                ++lines;
                end = cur - 1;
            }
            --delta;
            --cur;
        }
        int start = 0;
        int offset = 0;
        while (cur > 0) {
            int c = this.charAt(cur - 1);
            if (ScriptRuntime.isJSLineTerminator(c)) {
                start = cur;
                break;
            }
            --cur;
            ++offset;
        }
        linep[0] = this.lineno - lines + (this.lineEndChar >= 0 ? 1 : 0);
        linep[1] = offset;
        if (lines == 0) {
            return this.getLine();
        }
        return this.substring(start, end);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0 && !this.isMarkingComment()) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] tmp = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceEnd);
                this.sourceBuffer = tmp;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }

    public void setTemplateExprFinished() {
        this.inTemplateExpr = false;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getTokenBeg() {
        return this.tokenBeg;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getTokenLength() {
        return this.tokenEnd - this.tokenBeg;
    }

    public Token.CommentType getCommentType() {
        return this.commentType;
    }

    private void markCommentStart() {
        this.markCommentStart("");
    }

    private void markCommentStart(String prefix) {
        if (this.parser.compilerEnv.isRecordingComments() && this.sourceReader != null) {
            this.commentPrefix = prefix;
            this.commentCursor = this.sourceCursor - 1;
        }
    }

    private boolean isMarkingComment() {
        return this.commentCursor != -1;
    }

    final String getAndResetCurrentComment() {
        if (this.sourceString != null) {
            if (this.isMarkingComment()) {
                Kit.codeBug();
            }
            return this.sourceString.substring(this.tokenBeg, this.tokenEnd);
        }
        if (!this.isMarkingComment()) {
            Kit.codeBug();
        }
        StringBuilder comment = new StringBuilder(this.commentPrefix);
        comment.append(this.sourceBuffer, this.commentCursor, this.getTokenLength() - this.commentPrefix.length());
        this.commentCursor = -1;
        return comment.toString();
    }

    private String convertLastCharToHex(String str) {
        int lastIndex = str.length() - 1;
        StringBuilder buf = new StringBuilder(str.substring(0, lastIndex));
        buf.append("\\u");
        String hexCode = Integer.toHexString(str.charAt(lastIndex));
        for (int i = 0; i < 4 - hexCode.length(); ++i) {
            buf.append('0');
        }
        buf.append(hexCode);
        return buf.toString();
    }

    public String[] getRawLiterals() {
        return this.rawLiterals.toArray(new String[0]);
    }

    public TokenPosition getPosition() {
        return new TokenPosition(this.getTokenBeg(), this.getOffset(), this.getLine(), this.getLineno(), this.getTokenLength());
    }

    static class TokenPosition {
        int start;
        int lineno;
        String line;
        int colno;
        int length;

        public TokenPosition(int start, int colno, String line, int lineno, int length) {
            this.start = start;
            this.colno = colno;
            this.line = line;
            this.lineno = lineno;
            this.length = length;
        }
    }
}

