/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mozilla.javascript.ArrowFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class PartialFunction
extends ArrowFunction {
    List<Integer> partialIndices;
    Object[] appliedObjects;

    public PartialFunction(Context cx, Scriptable scope, Callable targetFunction, Scriptable boundThis, int[] partialIndices, Object[] appliedObjects) {
        super(cx, scope, targetFunction, boundThis);
        this.partialIndices = Arrays.stream(partialIndices).boxed().collect(Collectors.toList());
        this.appliedObjects = appliedObjects;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] oldArgs) {
        Scriptable callThis = this.boundThis != null ? this.boundThis : ScriptRuntime.getTopCallScope(cx);
        Object[] newArgs = new Object[this.partialIndices.size() + this.appliedObjects.length];
        int appliedIndex = 0;
        int oldArgsIndex = 0;
        for (int i = 0; i < newArgs.length; ++i) {
            int indexOf = this.partialIndices.indexOf(i);
            newArgs[i] = indexOf == -1 ? this.appliedObjects[appliedIndex++] : oldArgs[oldArgsIndex++];
        }
        return this.targetFunction.call(cx, scope, callThis, newArgs);
    }
}

