/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.ClassField;
import org.mozilla.javascript.ast.ClassMethod;
import org.mozilla.javascript.ast.ClassNode;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DecoratorDeclarationNode;
import org.mozilla.javascript.ast.DecoratorNode;
import org.mozilla.javascript.ast.DestructuringForm;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ErrorNode;
import org.mozilla.javascript.ast.ExportNode;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.GeneratorExpression;
import org.mozilla.javascript.ast.GeneratorExpressionLoop;
import org.mozilla.javascript.ast.IdeErrorReporter;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.ImportNode;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.Symbol;
import org.mozilla.javascript.ast.TemplateLiteral;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;
import org.mozilla.javascript.ast.Yield;
import org.mozilla.javascript.decorators.DecoratorType;
import org.mozilla.javascript.tools.shell.Main;

public class Parser {
    public static final int ARGC_LIMIT = 65536;
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    private static final int PROP_ENTRY = 1;
    private static final int GET_ENTRY = 2;
    private static final int SET_ENTRY = 4;
    private static final int METHOD_ENTRY = 8;
    private static final int GENERATOR_ENTRY = 16;
    private static final int FIELD_ENTRY = 32;
    protected int nestingOfFunction;
    protected boolean inUseStrictDirective;
    protected boolean insideClass;
    private Set<String> privateClassIdentifiers = new HashSet<String>();
    private Map<String, TokenStream.TokenPosition> accessedPrivateClassIdentifiers = new HashMap<String, TokenStream.TokenPosition>();
    CompilerEnvirons compilerEnv;
    boolean calledByCompileFunction;
    ScriptNode currentScriptOrFn;
    Scope currentScope;
    private int scopeNesting = 0;
    private ErrorReporter errorReporter;
    private IdeErrorReporter errorCollector;
    private String sourceURI;
    private char[] sourceChars;
    private boolean parseFinished;
    private TokenStream ts;
    private int currentFlaggedToken = 0;
    private int currentToken;
    private int syntaxErrorCount;
    private List<Comment> scannedComments;
    private Comment currentJsDocComment;
    private LabeledStatement currentLabel;
    private boolean inDestructuringAssignment;
    private boolean assumeDestructuring;
    private int endFlags;
    private boolean inForInit;
    private Map<String, LabeledStatement> labelSet;
    private List<Loop> loopSet;
    private List<Jump> loopAndSwitchSet;
    private int prevNameTokenStart;
    private String prevNameTokenString = "";
    private int prevNameTokenLineno;
    private boolean defaultUseStrictDirective;

    public Parser() {
        this(new CompilerEnvirons());
    }

    public Parser(CompilerEnvirons compilerEnv) {
        this(compilerEnv, compilerEnv.getErrorReporter());
    }

    public Parser(CompilerEnvirons compilerEnv, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnv;
        this.errorReporter = errorReporter;
        if (errorReporter instanceof IdeErrorReporter) {
            this.errorCollector = (IdeErrorReporter)errorReporter;
        }
    }

    private static boolean nowAllSet(int before, int after, int mask) {
        return (before & mask) != mask && (after & mask) == mask;
    }

    void addStrictWarning(String messageId, String messageArg) {
        int beg = -1;
        int end = -1;
        if (this.ts != null) {
            beg = this.ts.tokenBeg;
            end = this.ts.tokenEnd - this.ts.tokenBeg;
        }
        this.addStrictWarning(messageId, messageArg, beg, end);
    }

    void addStrictWarning(String messageId, String messageArg, int position, int length) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(messageId, messageArg, position, length);
        }
    }

    void addWarning(String messageId, String messageArg) {
        int beg = -1;
        int end = -1;
        if (this.ts != null) {
            beg = this.ts.tokenBeg;
            end = this.ts.tokenEnd - this.ts.tokenBeg;
        }
        this.addWarning(messageId, messageArg, beg, end);
    }

    void addWarning(String messageId, int position, int length) {
        this.addWarning(messageId, null, position, length);
    }

    void addWarning(String messageId, String messageArg, int position, int length) {
        String message = this.lookupMessage(messageId, messageArg);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(messageId, messageArg, position, length);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.warning(message, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        }
    }

    void addError(String messageId) {
        this.addError(messageId, null, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String messageId, int c) {
        String messageArg = Character.toString((char)c);
        this.addError(messageId, messageArg, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String messageId, String messageArg, int position, int length) {
        ++this.syntaxErrorCount;
        String message = this.lookupMessage(messageId, messageArg);
        if (this.errorCollector != null) {
            this.errorCollector.error(message, this.sourceURI, position, length);
        } else {
            int lineno = 1;
            int offset = 1;
            String line = "";
            if (this.ts != null) {
                lineno = this.ts.getLineno();
                line = this.ts.getLine();
                offset = this.ts.getOffset();
            }
            this.errorReporter.error(message, this.sourceURI, lineno, line, offset);
        }
    }

    private void addStrictWarning(String messageId, String messageArg, int position, int length, int line, String lineSource, int lineOffset) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(messageId, messageArg, position, length, line, lineSource, lineOffset);
        }
    }

    private void addWarning(String messageId, String messageArg, int position, int length, int line, String lineSource, int lineOffset) {
        String message = this.lookupMessage(messageId, messageArg);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(messageId, messageArg, position, length, line, lineSource, lineOffset);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.warning(message, this.sourceURI, line, lineSource, lineOffset);
        }
    }

    private void addError(String messageId, String messageArg, int position, int length, int line, String lineSource, int lineOffset) {
        ++this.syntaxErrorCount;
        String message = this.lookupMessage(messageId, messageArg);
        if (this.errorCollector != null) {
            this.errorCollector.error(message, this.sourceURI, position, length);
        } else {
            this.errorReporter.error(message, this.sourceURI, line, lineSource, lineOffset);
        }
    }

    String lookupMessage(String messageId) {
        return this.lookupMessage(messageId, null);
    }

    String lookupMessage(String messageId, String messageArg) {
        return messageArg == null ? ScriptRuntime.getMessage0(messageId) : ScriptRuntime.getMessage1(messageId, messageArg);
    }

    void reportError(String messageId) {
        this.reportError(messageId, null);
    }

    void reportError(String messageId, String messageArg) {
        if (this.ts == null) {
            this.addError(messageId, messageArg, 1, 1);
        } else {
            this.addError(messageId, messageArg, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        }
    }

    void reportError(String messageId, int position, int length) {
        this.addError(messageId, null, position, length);
    }

    private int getNodeEnd(AstNode n) {
        return n.getPosition() + n.getLength();
    }

    private void recordComment(int lineno, String comment) {
        if (this.scannedComments == null) {
            this.scannedComments = new ArrayList<Comment>();
        }
        Comment commentNode = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, comment);
        if (this.ts.commentType == Token.CommentType.JSDOC && this.compilerEnv.isRecordingLocalJsDocComments()) {
            this.currentJsDocComment = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, comment);
            this.currentJsDocComment.setLineno(lineno);
        }
        commentNode.setLineno(lineno);
        this.scannedComments.add(commentNode);
    }

    private Comment getAndResetJsDoc() {
        Comment saved = this.currentJsDocComment;
        this.currentJsDocComment = null;
        return saved;
    }

    private int getNumberOfEols(String comment) {
        int lines = 0;
        for (int i = comment.length() - 1; i >= 0; --i) {
            if (comment.charAt(i) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private int peekToken() throws IOException {
        if (this.currentFlaggedToken != 0) {
            return this.currentToken;
        }
        int lineno = this.ts.getLineno();
        int tt = this.ts.getToken();
        boolean sawEOL = false;
        while (tt == 1 || tt == 166) {
            if (tt == 1) {
                ++lineno;
                sawEOL = true;
                tt = this.ts.getToken();
                continue;
            }
            if (this.compilerEnv.isRecordingComments()) {
                String comment = this.ts.getAndResetCurrentComment();
                this.recordComment(lineno, comment);
                lineno += this.getNumberOfEols(comment);
                break;
            }
            tt = this.ts.getToken();
        }
        this.currentToken = tt;
        this.currentFlaggedToken = tt | (sawEOL ? 65536 : 0);
        return this.currentToken;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int tt = this.peekToken();
        this.consumeToken();
        return tt;
    }

    private boolean matchToken(int toMatch) throws IOException {
        int tt = this.peekToken();
        while (tt == 166) {
            this.consumeToken();
            tt = this.peekToken();
        }
        if (tt != toMatch) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int tt = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            tt = 1;
        }
        return tt;
    }

    private boolean mustMatchToken(int toMatch, String messageId) throws IOException {
        return this.mustMatchToken(toMatch, messageId, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    private boolean mustMatchToken(int toMatch, String msgId, int pos, int len) throws IOException {
        if (this.matchToken(toMatch)) {
            return true;
        }
        this.reportError(msgId, pos, len);
        return false;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    void pushScope(Scope scope) {
        ++this.scopeNesting;
        Scope parent = scope.getParentScope();
        if (parent != null) {
            if (parent != this.currentScope) {
                this.codeBug();
            }
        } else {
            this.currentScope.addChildScope(scope);
        }
        this.currentScope = scope;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
        --this.scopeNesting;
    }

    private void enterLoop(Loop loop) {
        if (this.loopSet == null) {
            this.loopSet = new ArrayList<Loop>();
        }
        this.loopSet.add(loop);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(loop);
        this.pushScope(loop);
        if (this.currentLabel != null) {
            this.currentLabel.setStatement(loop);
            this.currentLabel.getFirstLabel().setLoop(loop);
            loop.setRelative(-this.currentLabel.getPosition());
        }
    }

    private void exitLoop() {
        Loop loop = this.loopSet.remove(this.loopSet.size() - 1);
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
        if (loop.getParent() != null) {
            loop.setRelative(loop.getParent().getPosition());
        }
        this.popScope();
    }

    private void enterSwitch(SwitchStatement node) {
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(node);
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
    }

    public AstRoot parse(String sourceString, String sourceURI, int lineno) {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        this.sourceURI = sourceURI;
        if (this.compilerEnv.isIdeMode()) {
            this.sourceChars = sourceString.toCharArray();
        }
        this.ts = new TokenStream(this, null, sourceString, lineno);
        try {
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        catch (IOException iox) {
            throw new IllegalStateException();
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public AstRoot parse(Reader sourceReader, String sourceURI, int lineno) throws IOException {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        if (this.compilerEnv.isIdeMode()) {
            return this.parse(Kit.readReader(sourceReader), sourceURI, lineno);
        }
        try {
            this.sourceURI = sourceURI;
            this.ts = new TokenStream(this, sourceReader, null, lineno);
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstRoot parse() throws IOException {
        int pos = 0;
        AstRoot root = new AstRoot(pos);
        this.currentScriptOrFn = root;
        this.currentScope = this.currentScriptOrFn;
        int baseLineno = this.ts.lineno;
        int end = pos;
        boolean inDirectivePrologue = true;
        boolean savedStrictMode = this.inUseStrictDirective;
        this.inUseStrictDirective = this.defaultUseStrictDirective;
        if (this.inUseStrictDirective) {
            root.setInStrictMode(true);
        }
        try {
            while (true) {
                AstNode n;
                block23: {
                    int tt;
                    if ((tt = this.peekToken()) <= 0) {
                        break;
                    }
                    if (tt == 114) {
                        this.consumeToken();
                        try {
                            n = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block23;
                        }
                        catch (ParserException e) {
                            break;
                        }
                    }
                    if (tt == 166) {
                        n = this.scannedComments.get(this.scannedComments.size() - 1);
                        this.consumeToken();
                    } else {
                        n = this.statement();
                        if (inDirectivePrologue) {
                            String directive = this.getDirective(n);
                            if (directive == null) {
                                inDirectivePrologue = false;
                            } else if (directive.equals("use strict")) {
                                this.inUseStrictDirective = true;
                                root.setInStrictMode(true);
                            }
                        }
                    }
                }
                end = this.getNodeEnd(n);
                root.addChildToBack(n);
                n.setParent(root);
            }
        }
        catch (StackOverflowError ex) {
            String msg = this.lookupMessage("msg.too.deep.parser.recursion");
            if (!this.compilerEnv.isIdeMode()) {
                throw Context.reportRuntimeError(msg, this.sourceURI, this.ts.lineno, null, 0);
            }
        }
        finally {
            this.inUseStrictDirective = savedStrictMode;
        }
        if (this.syntaxErrorCount != 0) {
            String msg = String.valueOf(this.syntaxErrorCount);
            msg = this.lookupMessage("msg.got.syntax.errors", msg);
            if (!this.compilerEnv.isIdeMode()) {
                throw this.errorReporter.runtimeError(msg, this.sourceURI, baseLineno, null, 0);
            }
        }
        if (this.scannedComments != null) {
            int last = this.scannedComments.size() - 1;
            end = Math.max(end, this.getNodeEnd(this.scannedComments.get(last)));
            for (Comment c : this.scannedComments) {
                root.addComment(c);
            }
        }
        root.setLength(end - pos);
        root.setSourceName(this.sourceURI);
        root.setBaseLineno(baseLineno);
        root.setEndLineno(this.ts.lineno);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parseFunctionBody(int type, FunctionNode fnNode) throws IOException {
        Block pn;
        int pos;
        boolean isExpressionClosure;
        block19: {
            isExpressionClosure = false;
            if (!this.matchToken(82)) {
                if (this.compilerEnv.getLanguageVersion() < 180 && type != 4) {
                    this.reportError("msg.no.brace.body");
                } else {
                    isExpressionClosure = true;
                }
            }
            boolean isArrow = type == 4;
            ++this.nestingOfFunction;
            pos = this.ts.tokenBeg;
            pn = new Block(pos);
            boolean inDirectivePrologue = true;
            boolean savedStrictMode = this.inUseStrictDirective;
            pn.setLineno(this.ts.lineno);
            try {
                if (isExpressionClosure) {
                    AstNode returnValue = this.assignExpr();
                    ReturnStatement n = new ReturnStatement(returnValue.getPosition(), returnValue.getLength(), returnValue);
                    n.putProp(25, Boolean.TRUE);
                    pn.putProp(25, Boolean.TRUE);
                    if (isArrow) {
                        n.putProp(27, Boolean.TRUE);
                    }
                    pn.addStatement(n);
                    break block19;
                }
                while (true) {
                    AstNode n;
                    int tt = this.peekToken();
                    switch (tt) {
                        case -1: 
                        case 0: 
                        case 83: {
                            break block19;
                        }
                        case 166: {
                            this.consumeToken();
                            n = this.scannedComments.get(this.scannedComments.size() - 1);
                            break;
                        }
                        case 114: {
                            this.consumeToken();
                            n = this.function(1);
                            break;
                        }
                        default: {
                            n = this.statement();
                            if (!inDirectivePrologue) break;
                            String directive = this.getDirective(n);
                            if (directive == null) {
                                inDirectivePrologue = false;
                                break;
                            }
                            if (!directive.equals("use strict")) break;
                            if (fnNode.hasComplexParameters()) {
                                this.reportError("msg.complex.params.in.strict");
                            }
                            this.inUseStrictDirective = true;
                            fnNode.setInStrictMode(true);
                            if (savedStrictMode) break;
                            this.setRequiresActivation();
                        }
                    }
                    pn.addStatement(n);
                }
            }
            catch (ParserException n) {
            }
            finally {
                --this.nestingOfFunction;
                this.inUseStrictDirective = savedStrictMode;
            }
        }
        int end = this.ts.tokenEnd;
        this.getAndResetJsDoc();
        if (!isExpressionClosure && this.mustMatchToken(83, "msg.no.brace.after.body")) {
            end = this.ts.tokenEnd;
        }
        pn.setLength(end - pos);
        return pn;
    }

    private String getDirective(AstNode n) {
        AstNode e;
        if (n instanceof ExpressionStatement && (e = ((ExpressionStatement)n).getExpression()) instanceof StringLiteral) {
            return ((StringLiteral)e).getValue();
        }
        return null;
    }

    private ClassNode classExpr(List<DecoratorNode> classDecorators) throws IOException {
        Set<String> prevPrivateClassIdentifiers = this.privateClassIdentifiers;
        Map<String, TokenStream.TokenPosition> prevAccessedPrivateClassIdentifiers = this.accessedPrivateClassIdentifiers;
        this.privateClassIdentifiers = new HashSet<String>();
        this.accessedPrivateClassIdentifiers = new HashMap<String, TokenStream.TokenPosition>();
        this.insideClass = true;
        ClassNode cls = new ClassNode(this.ts.tokenBeg);
        cls.setDecorators(classDecorators);
        if (this.matchToken(40)) {
            Name name = this.createNameNode();
            this.defineSymbol(115, name.getIdentifier());
            cls.setClassName(name);
        }
        if (this.matchToken(116)) {
            AstNode extendsName = this.memberExpr(true);
            cls.setExtendsNode(extendsName);
        }
        this.mustMatchToken(82, "msg.class.missing.lc");
        HashSet<String> getterNames = new HashSet<String>();
        HashSet<String> setterNames = new HashSet<String>();
        ArrayList<ClassMethod> classMethods = new ArrayList<ClassMethod>();
        ArrayList<ClassField> classProperties = new ArrayList<ClassField>();
        while (true) {
            if (this.matchToken(79) || this.matchToken(1)) {
                continue;
            }
            String propertyName = null;
            int entryKind = 1;
            int tt = this.peekToken();
            Comment jsdocNode = this.getAndResetJsDoc();
            if (tt == 166) {
                this.consumeToken();
                tt = this.peekUntilNonComment(tt);
            }
            if (tt == 83) {
                this.consumeToken();
                break;
            }
            ArrayList<DecoratorNode> decorators = new ArrayList<DecoratorNode>();
            while (this.matchToken(153)) {
                decorators.add(this.decorator(false, false));
            }
            boolean isStatic = this.matchToken(117);
            boolean isPrivate = this.matchToken(170);
            AstNode pname = this.objliteralProperty();
            int pos = this.ts.tokenBeg;
            if (pname == null && this.peekToken() != 23) {
                this.reportError("msg.bad.prop");
                break;
            }
            propertyName = this.ts.getString();
            int peeked = this.peekToken();
            if (peeked == 84) {
                entryKind = 8;
            } else if (peeked == 23) {
                entryKind = 16;
                this.consumeToken();
            } else if (peeked == 79 || peeked == 87) {
                entryKind = 32;
            } else if (pname.getType() == 40) {
                if ("get".equals(propertyName)) {
                    entryKind = 2;
                } else if ("set".equals(propertyName)) {
                    entryKind = 4;
                }
                if (entryKind != 1) {
                    isPrivate = this.matchToken(170);
                }
            }
            if (entryKind == 2 || entryKind == 4 || entryKind == 16) {
                pname = this.objliteralProperty();
                if (pname == null) {
                    this.reportError("msg.bad.prop");
                }
                this.consumeToken();
            }
            if (pname == null) {
                throw Kit.codeBug();
            }
            propertyName = this.ts.getString();
            if (entryKind == 32) {
                if ("constructor".equals(propertyName)) {
                    this.reportError("msg.class.ctor.as.field");
                }
                if (decorators.stream().anyMatch(it -> DecoratorType.WRAP == it.getDecoratorType())) {
                    this.reportError("msg.decorator.wrap.on.field");
                }
                AstNode defaultValue = null;
                int token = this.peekTokenOrEOL();
                if (token == 87) {
                    this.consumeToken();
                    defaultValue = this.expr();
                } else if (token != 79 && token != 1) {
                    throw Kit.codeBug();
                }
                if (defaultValue == null) {
                    defaultValue = new Name(this.ts.tokenBeg, "undefined");
                }
                ClassField cp = new ClassField(pname, defaultValue);
                if (isStatic) {
                    cp.setIsStatic();
                }
                if (isPrivate) {
                    cp.setIsPrivate();
                    this.privateClassIdentifiers.add(((Name)cp.getName()).getIdentifier());
                }
                cp.setLength(this.getNodeEnd(defaultValue) - pos);
                cp.setDecorators(decorators);
                classProperties.add(cp);
            } else {
                FunctionNode fn = this.function(2, entryKind);
                Name name = fn.getFunctionName();
                if (name != null && name.length() != 0) {
                    this.reportError("msg.bad.prop");
                }
                if (pname instanceof Name) {
                    fn.setFunctionName((Name)pname);
                }
                pname.setJsDocNode(jsdocNode);
                if (isStatic) {
                    fn.setStatic(true);
                }
                if (isPrivate) {
                    fn.setPrivate(true);
                    this.privateClassIdentifiers.add(fn.getName());
                }
                ClassMethod cm = new ClassMethod(pname, fn);
                cm.setDecorators(decorators);
                switch (entryKind) {
                    case 2: {
                        fn.setFunctionIsGetterMethod();
                        cm.setIsGetterMethod();
                        break;
                    }
                    case 4: {
                        fn.setFunctionIsSetterMethod();
                        cm.setIsSetterMethod();
                        break;
                    }
                    case 8: {
                        fn.setFunctionIsNormalMethod();
                    }
                }
                if (isStatic) {
                    cm.setIsStatic();
                }
                if (isPrivate) {
                    cm.setIsPrivate();
                }
                int end = this.getNodeEnd(fn);
                cm.setLength(end - pos);
                if ("constructor".equals(propertyName)) {
                    cls.setConstructor(fn);
                } else {
                    classMethods.add(cm);
                }
            }
            if (this.inUseStrictDirective && propertyName != null) {
                switch (entryKind) {
                    case 1: 
                    case 8: {
                        getterNames.add(propertyName);
                        setterNames.add(propertyName);
                        break;
                    }
                    case 2: {
                        getterNames.add(propertyName);
                        break;
                    }
                    case 4: {
                        setterNames.add(propertyName);
                    }
                }
            }
            this.getAndResetJsDoc();
        }
        for (Map.Entry<String, TokenStream.TokenPosition> en : this.accessedPrivateClassIdentifiers.entrySet()) {
            if (this.privateClassIdentifiers.contains(en.getKey())) continue;
            TokenStream.TokenPosition pos = en.getValue();
            this.addError("msg.unknown.private.ident", en.getKey(), pos.start, pos.length, pos.lineno, pos.line, pos.colno);
            break;
        }
        cls.setFields(classProperties);
        cls.setMethods(classMethods);
        this.insideClass = false;
        this.privateClassIdentifiers = prevPrivateClassIdentifiers;
        this.accessedPrivateClassIdentifiers = prevAccessedPrivateClassIdentifiers;
        return cls;
    }

    private void parseFunctionParams(FunctionNode fnNode, boolean isObjectSetterFunction) throws IOException {
        if (this.matchToken(85)) {
            fnNode.setRp(this.ts.tokenBeg - fnNode.getPosition());
            return;
        }
        VariableDeclaration vd = this.variables(84, this.ts.tokenEnd, false, true, isObjectSetterFunction);
        List<VariableInitializer> variables = vd.getVariables();
        Node destructuringNode = new Node(86);
        HashMap<String, VariableInitializer> destructVars = new HashMap<String, VariableInitializer>();
        int variablesSize = variables.size();
        for (int i1 = 0; i1 < variablesSize; ++i1) {
            VariableInitializer variable = variables.get(i1);
            AstNode target = variable.getTarget();
            AstNode initializer = variable.getInitializer();
            fnNode.addParam(target);
            if (initializer != null) {
                fnNode.addDefaultParam(i1, initializer);
                fnNode.setHasComplexParameters();
            }
            if (variable.isDestructuring()) {
                String tempName = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(84, tempName, false);
                destructVars.put(tempName, variable);
                fnNode.setHasComplexParameters();
            }
            if (target.getProp(29) == null) continue;
            fnNode.setHasComplexParameters();
        }
        for (Map.Entry destructure : destructVars.entrySet()) {
            Node assign = this.createDestructuringAssignment(158, ((VariableInitializer)destructure.getValue()).getTarget(), this.createName((String)destructure.getKey()));
            destructuringNode.addChildToBack(assign);
        }
        if (destructuringNode.hasChildren()) {
            fnNode.putProp(23, destructuringNode);
        }
        if (this.mustMatchToken(85, "msg.no.paren.after.parms")) {
            fnNode.setRp(this.ts.tokenBeg - fnNode.getPosition());
        }
    }

    private FunctionNode function(int type) throws IOException {
        return this.function(type, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode function(int type, int objEntryKind) throws IOException {
        int lpPos;
        boolean generator;
        int syntheticType = type;
        int baseLineno = this.ts.lineno;
        int functionSourceStart = this.ts.tokenBeg;
        Name name = null;
        boolean bl = generator = objEntryKind == 16;
        if (this.matchToken(23)) {
            generator = true;
        }
        if (this.matchToken(40)) {
            String id;
            name = this.createNameNode(true, 40);
            if (this.inUseStrictDirective && ("eval".equals(id = name.getIdentifier()) || "arguments".equals(id))) {
                this.reportError("msg.bad.id.strict", id);
            }
            if (!this.matchToken(84)) {
                this.mustMatchToken(84, "msg.no.paren.parms");
            }
        } else if (!this.matchToken(84)) {
            this.mustMatchToken(84, "msg.no.paren.parms");
        }
        int n = lpPos = this.currentToken == 84 ? this.ts.tokenBeg : -1;
        if (syntheticType != 2 && name != null && name.length() > 0) {
            this.defineSymbol(114, name.getIdentifier());
        }
        FunctionNode fnNode = new FunctionNode(functionSourceStart, name);
        fnNode.setFunctionType(type);
        if (generator) {
            fnNode.setIsGenerator();
        }
        if (lpPos != -1) {
            fnNode.setLp(lpPos - functionSourceStart);
        }
        fnNode.setJsDocNode(this.getAndResetJsDoc());
        PerFunctionVariables savedVars = new PerFunctionVariables(fnNode);
        try {
            this.parseFunctionParams(fnNode, objEntryKind == 4);
            fnNode.setBody(this.parseFunctionBody(type, fnNode));
            fnNode.setEncodedSourceBounds(functionSourceStart, this.ts.tokenEnd);
            fnNode.setLength(this.ts.tokenEnd - functionSourceStart);
            if (this.compilerEnv.isStrictMode() && !fnNode.getBody().hasConsistentReturnUsage()) {
                String msg = name != null && name.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(msg, name == null ? "" : name.getIdentifier());
            }
        }
        finally {
            savedVars.restore();
        }
        fnNode.setSourceName(this.sourceURI);
        fnNode.setBaseLineno(baseLineno);
        fnNode.setEndLineno(this.ts.lineno);
        if (this.compilerEnv.isIdeMode()) {
            fnNode.setParentScope(this.currentScope);
        }
        return fnNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode arrowFunction(AstNode params) throws IOException {
        int baseLineno = this.ts.lineno;
        int functionSourceStart = params != null ? params.getPosition() : -1;
        FunctionNode fnNode = new FunctionNode(functionSourceStart);
        fnNode.setFunctionType(4);
        fnNode.setJsDocNode(this.getAndResetJsDoc());
        HashMap<String, Node> destructuring = new HashMap<String, Node>();
        HashSet<String> paramNames = new HashSet<String>();
        PerFunctionVariables savedVars = new PerFunctionVariables(fnNode);
        try {
            if (params instanceof ParenthesizedExpression) {
                fnNode.setParens(0, params.getLength());
                AstNode p = ((ParenthesizedExpression)params).getExpression();
                if (!(p instanceof EmptyExpression)) {
                    this.arrowFunctionParams(fnNode, p, destructuring, paramNames);
                }
            } else {
                this.arrowFunctionParams(fnNode, params, destructuring, paramNames);
            }
            if (!destructuring.isEmpty()) {
                Node destructuringNode = new Node(86);
                for (Map.Entry param : destructuring.entrySet()) {
                    Node assign = this.createDestructuringAssignment(131, (Node)param.getValue(), this.createName((String)param.getKey()));
                    destructuringNode.addChildToBack(assign);
                }
                fnNode.putProp(23, destructuringNode);
            }
            fnNode.setBody(this.parseFunctionBody(4, fnNode));
            fnNode.setEncodedSourceBounds(functionSourceStart, this.ts.tokenEnd);
            fnNode.setLength(this.ts.tokenEnd - functionSourceStart);
        }
        finally {
            savedVars.restore();
        }
        if (fnNode.isGenerator()) {
            this.reportError("msg.arrowfunction.generator");
            return this.makeErrorNode();
        }
        fnNode.setSourceName(this.sourceURI);
        fnNode.setBaseLineno(baseLineno);
        fnNode.setEndLineno(this.ts.lineno);
        return fnNode;
    }

    private void arrowFunctionParams(FunctionNode fnNode, AstNode params, Map<String, Node> destructuring, Set<String> paramNames) {
        if (params instanceof ArrayLiteral || params instanceof ObjectLiteral) {
            this.markDestructuring(params);
            fnNode.addParam(params);
            String pname = this.currentScriptOrFn.getNextTempName();
            this.defineSymbol(84, pname, false);
            destructuring.put(pname, params);
        } else if (params instanceof InfixExpression && params.getType() == 86) {
            this.arrowFunctionParams(fnNode, ((InfixExpression)params).getLeft(), destructuring, paramNames);
            this.arrowFunctionParams(fnNode, ((InfixExpression)params).getRight(), destructuring, paramNames);
        } else if (params instanceof Name) {
            fnNode.addParam(params);
            String paramName = ((Name)params).getIdentifier();
            this.defineSymbol(84, paramName);
            if (this.inUseStrictDirective) {
                if ("eval".equals(paramName) || "arguments".equals(paramName)) {
                    this.reportError("msg.bad.id.strict", paramName);
                }
                if (paramNames.contains(paramName)) {
                    this.reportError("msg.dup.param.strict", paramName);
                }
                paramNames.add(paramName);
            }
        } else if (params instanceof Assignment) {
            int index = fnNode.getParams().size();
            AstNode target = ((Assignment)params).getLeft();
            fnNode.addParam(target);
            if (target instanceof Name) {
                fnNode.addDefaultParam(index, ((Assignment)params).getRight());
                this.defineSymbol(84, ((Name)target).getIdentifier());
                fnNode.setHasComplexParameters();
            } else if (target instanceof ArrayLiteral || target instanceof ObjectLiteral) {
                this.reportError("msg.arrowfn.destructuring.unsupported");
            }
        } else {
            this.reportError("msg.no.parm", params.getPosition(), params.getLength());
            fnNode.addParam(this.makeErrorNode());
        }
    }

    private AstNode statements(AstNode parent) throws IOException {
        int tt;
        if (this.currentToken != 82 && !this.compilerEnv.isIdeMode()) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        AstNode block = parent != null ? parent : new Block(pos);
        block.setLineno(this.ts.lineno);
        while ((tt = this.peekToken()) > 0 && tt != 83) {
            block.addChild(this.statement());
        }
        block.setLength(this.ts.tokenBeg - pos);
        return block;
    }

    private AstNode statements() throws IOException {
        return this.statements(null);
    }

    private ConditionData condition() throws IOException {
        ConditionData data = new ConditionData();
        if (this.mustMatchToken(84, "msg.no.paren.cond")) {
            data.lp = this.ts.tokenBeg;
        }
        data.condition = this.expr();
        if (this.mustMatchToken(85, "msg.no.paren.after.cond")) {
            data.rp = this.ts.tokenBeg;
        }
        if (data.condition instanceof Assignment) {
            this.addStrictWarning("msg.equal.as.assign", "", data.condition.getPosition(), data.condition.getLength());
        }
        return data;
    }

    private AstNode statement() throws IOException {
        int pos = this.ts.tokenBeg;
        try {
            AstNode pn = this.statementHelper();
            if (pn != null) {
                int ntt;
                if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                    int beg = pn.getPosition();
                    beg = Math.max(beg, this.lineBeginningFor(beg));
                    this.addStrictWarning(pn instanceof EmptyStatement ? "msg.extra.trailing.semi" : "msg.no.side.effects", "", beg, this.nodeEnd(pn) - beg);
                }
                if ((ntt = this.peekToken()) == 166 && pn.getLineno() == this.scannedComments.get(this.scannedComments.size() - 1).getLineno()) {
                    pn.setInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                    this.consumeToken();
                }
                return pn;
            }
        }
        catch (ParserException pn) {
            // empty catch block
        }
        block5: while (true) {
            int tt = this.peekTokenOrEOL();
            this.consumeToken();
            switch (tt) {
                case -1: 
                case 0: 
                case 1: 
                case 79: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return new EmptyStatement(pos, this.ts.tokenBeg - pos);
    }

    private AstNode statementHelper() throws IOException {
        AstNode pn;
        if (this.currentLabel != null && this.currentLabel.getStatement() != null) {
            this.currentLabel = null;
        }
        int tt = this.peekToken();
        switch (tt) {
            case 121: {
                return this.ifStatement();
            }
            case 123: {
                return this.switchStatement();
            }
            case 126: {
                return this.whileLoop();
            }
            case 127: {
                return this.doLoop();
            }
            case 128: {
                return this.forLoop();
            }
            case 78: {
                return this.tryStatement();
            }
            case 53: {
                pn = this.throwStatement();
                break;
            }
            case 135: {
                this.consumeToken();
                pn = this.decoratorDeclaration();
                break;
            }
            case 129: {
                pn = this.breakStatement();
                break;
            }
            case 130: {
                pn = this.continueStatement();
                break;
            }
            case 132: {
                if (this.inUseStrictDirective) {
                    this.reportError("msg.no.with.strict");
                }
                return this.withStatement();
            }
            case 131: 
            case 159: {
                this.consumeToken();
                int lineno = this.ts.lineno;
                pn = this.variables(this.currentToken, this.ts.tokenBeg, true);
                pn.setLineno(lineno);
                break;
            }
            case 158: {
                pn = this.letStatement();
                if (pn instanceof VariableDeclaration && this.peekToken() == 79) break;
                return pn;
            }
            case 4: 
            case 76: {
                pn = this.returnOrYield(tt, false);
                break;
            }
            case 165: {
                this.consumeToken();
                pn = new KeywordLiteral(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, tt);
                pn.setLineno(this.ts.lineno);
                break;
            }
            case 82: {
                return this.block();
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 79: {
                this.consumeToken();
                int pos = this.ts.tokenBeg;
                EmptyStatement pn2 = new EmptyStatement(pos, this.ts.tokenEnd - pos);
                pn2.setLineno(this.ts.lineno);
                return pn2;
            }
            case 114: {
                this.consumeToken();
                return this.function(3);
            }
            case 120: {
                if (!Main.useRequire) {
                    this.reportError("msg.modules.not.supported");
                }
                this.consumeToken();
                pn = this.importStatement();
                break;
            }
            case 119: {
                if (!Main.useRequire) {
                    this.reportError("msg.modules.not.supported");
                }
                this.consumeToken();
                pn = this.exportStatement();
                break;
            }
            case 40: {
                pn = this.nameOrLabel();
                if (pn instanceof ExpressionStatement) break;
                return pn;
            }
            case 166: {
                AstNode pn3 = this.scannedComments.get(this.scannedComments.size() - 1);
                return pn3;
            }
            default: {
                int lineno = this.ts.lineno;
                pn = new ExpressionStatement(this.expr(), !this.insideFunction());
                pn.setLineno(lineno);
            }
        }
        this.autoInsertSemicolon(pn);
        return pn;
    }

    private AstNode importStatement() throws IOException {
        boolean hasTargets;
        if (this.scopeNesting != 0) {
            this.reportError("msg.import.top.level");
        }
        ImportNode in = new ImportNode();
        if (this.matchToken(23)) {
            hasTargets = true;
            this.peekToken();
            if (!"as".equals(this.ts.getString())) {
                this.reportError("msg.import.expected.as");
            }
            this.consumeToken();
            this.mustMatchToken(40, "msg.import.missing.alias");
            String target = this.createNameNode().getIdentifier();
            in.setModuleMember(target);
            this.consumeToken();
        } else {
            boolean hasDefault = false;
            boolean defaultComma = false;
            if (this.matchToken(125)) {
                this.reportError("msg.import.invalid.default");
            }
            boolean decorator = this.matchToken(153);
            if (this.matchToken(40)) {
                String defaultImport = this.createNameNode().getIdentifier();
                if (decorator) {
                    defaultImport = "@" + defaultImport;
                }
                this.consumeToken();
                in.setDefaultMember(defaultImport);
                hasDefault = true;
                defaultComma = this.matchToken(86);
            }
            boolean hasNamedImports = this.matchToken(82);
            if (hasDefault && defaultComma != hasNamedImports) {
                this.reportError(defaultComma ? "msg.import.unexpected.comma" : "msg.import.missing.comma");
            }
            if (hasNamedImports) {
                while (!this.matchToken(83)) {
                    String targetName;
                    decorator = this.matchToken(153);
                    if (this.matchToken(40)) {
                        targetName = this.createNameNode().getIdentifier();
                        if (decorator) {
                            targetName = "@" + targetName;
                        }
                    } else if (this.matchToken(125)) {
                        targetName = "default";
                    } else {
                        this.reportError("msg.import.malformed.name");
                        return this.makeErrorNode();
                    }
                    String scopeName = null;
                    if (this.matchToken(40)) {
                        if (!"as".equals(this.ts.getString())) {
                            this.reportError("msg.import.expected.as");
                        }
                        if (this.matchToken(125)) {
                            this.reportError("msg.import.invalid.default");
                        }
                        decorator = this.matchToken(153);
                        this.mustMatchToken(40, "msg.import.missing.alias");
                        scopeName = this.createNameNode().getIdentifier();
                        if (decorator) {
                            scopeName = "@" + scopeName;
                        }
                    }
                    this.matchToken(86);
                    in.addNamedMember(targetName, scopeName);
                }
            }
            hasTargets = hasNamedImports || hasDefault;
        }
        this.peekToken();
        if (hasTargets) {
            if (!"from".equals(this.ts.getString())) {
                this.reportError("msg.import.missing.file.path");
            }
            this.consumeToken();
        }
        this.mustMatchToken(42, "msg.import.missing.file.path");
        in.setFilePath(this.ts.getString());
        return in;
    }

    private void validateDefaultExport(AstNode node) {
        if (!(node instanceof FunctionNode || node instanceof ClassNode || node instanceof ConditionalExpression || node instanceof Assignment)) {
            this.reportError("msg.export.invalid.default.export");
        }
    }

    private void validateExport(AstNode node) {
        if (!(node instanceof VariableDeclaration || node instanceof FunctionNode || node instanceof ClassNode)) {
            this.reportError("msg.export.invalid.export");
        }
        if (node instanceof FunctionNode && ((FunctionNode)node).getFunctionName() == null || node instanceof ClassNode && ((ClassNode)node).getClassName() == null) {
            this.reportError("msg.export.no.identifier");
        }
    }

    private AstNode exportStatement() throws IOException {
        if (this.scopeNesting != 0) {
            this.reportError("msg.export.top.level");
        }
        ExportNode en = new ExportNode();
        en.setType(119);
        if (this.matchToken(125)) {
            AstNode exportTarget;
            if (this.matchToken(114)) {
                exportTarget = this.function(2);
            } else if (this.matchToken(115)) {
                exportTarget = this.classExpr(Collections.emptyList());
            } else {
                exportTarget = this.assignExpr();
                if (exportTarget instanceof Name && "from".equals(((Name)exportTarget).getIdentifier())) {
                    if (this.matchToken(42)) {
                        en.addNamedMember("default", "default");
                        en.setFilePath(this.ts.getString());
                        exportTarget = null;
                    }
                } else if (exportTarget == null) {
                    this.reportError("msg.export.invalid.default.export");
                }
            }
            if (exportTarget != null) {
                en.setExportedValue(exportTarget);
            }
        } else if (this.matchToken(23)) {
            this.mustMatchToken(40, "msg.export.unexpected.char.after.wildcard");
            if (!"from".equals(this.ts.getString())) {
                this.reportError("msg.export.unexpected.char.after.wildcard");
            }
            this.mustMatchToken(42, "msg.export.star.missing.file.path");
            en.setFilePath(this.ts.getString());
        } else if (this.matchToken(82)) {
            do {
                String target;
                boolean decorator = this.matchToken(153);
                if (this.matchToken(125)) {
                    target = "default";
                } else {
                    this.mustMatchToken(40, "msg.export.missing.identifier");
                    target = this.createNameNode().getIdentifier();
                }
                if (decorator) {
                    target = "@" + target;
                }
                String scope = null;
                this.consumeToken();
                this.peekToken();
                if ("as".equals(this.ts.getString())) {
                    this.consumeToken();
                    decorator = this.matchToken(153);
                    if (this.matchToken(40)) {
                        scope = this.createNameNode().getIdentifier();
                        if (decorator) {
                            scope = "@" + scope;
                        }
                    } else if (this.matchToken(125)) {
                        if (decorator) {
                            this.reportError("msg.export.invalid.default");
                        }
                        scope = "default";
                    } else {
                        this.reportError("msg.export.unexpected.token");
                        this.consumeToken();
                    }
                }
                en.addNamedMember(target, scope);
            } while (this.matchToken(86));
            this.mustMatchToken(83, "msg.export.missing.rc");
            if (this.matchToken(40)) {
                if (!"from".equals(this.ts.getString())) {
                    this.reportError("msg.export.missing.from");
                }
                this.mustMatchToken(42, "");
                en.setFilePath(this.ts.getString());
            }
        } else if (this.matchToken(114)) {
            FunctionNode fn = this.function(3);
            if (fn.getName() == null) {
                this.reportError("msg.export.inline.requires.name");
                return this.makeErrorNode();
            }
            en.setExportedValue(fn, fn.getFunctionName().getIdentifier());
        } else if (this.matchToken(115)) {
            ClassNode cn = this.classExpr(Collections.emptyList());
            if (cn.getClassName() == null) {
                this.reportError("msg.export.inline.requires.name");
                return this.makeErrorNode();
            }
            en.setExportedValue(cn, cn.getClassName().getIdentifier());
        } else if (this.matchToken(135)) {
            DecoratorDeclarationNode ddn = this.decoratorDeclaration();
            en.setExportedValue(ddn, ddn.getName());
        } else {
            int token = -1;
            if (this.matchToken(131)) {
                token = 131;
            } else if (this.matchToken(158)) {
                token = 158;
            } else if (this.matchToken(159)) {
                token = 159;
            }
            if (token == -1) {
                this.reportError("msg.export.inline.requires.name");
                return this.makeErrorNode();
            }
            VariableDeclaration decl = this.variables(token, this.ts.tokenBeg, false);
            en.setExportedValue(decl, null);
        }
        return en;
    }

    private void autoInsertSemicolon(AstNode pn) throws IOException {
        int ttFlagged = this.peekFlaggedToken();
        int pos = pn.getPosition();
        switch (ttFlagged & 0xFFFF) {
            case 79: {
                this.consumeToken();
                pn.setLength(this.ts.tokenEnd - pos);
                break;
            }
            case -1: 
            case 0: 
            case 83: {
                this.warnMissingSemi(pos, Math.max(pos + 1, this.nodeEnd(pn)));
                break;
            }
            default: {
                if ((ttFlagged & 0x10000) == 0) {
                    this.reportError("msg.no.semi.stmt");
                    break;
                }
                this.warnMissingSemi(pos, this.nodeEnd(pn));
            }
        }
    }

    private IfStatement ifStatement() throws IOException {
        if (this.currentToken != 121) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        int lineno = this.ts.lineno;
        int elsePos = -1;
        IfStatement pn = new IfStatement(pos);
        ConditionData data = this.condition();
        AstNode ifTrue = this.getNextStatementAfterInlineComments(pn, true);
        AstNode ifFalse = null;
        if (this.matchToken(122)) {
            int tt = this.peekToken();
            if (tt == 166) {
                pn.setElseKeyWordInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                this.consumeToken();
            }
            elsePos = this.ts.tokenBeg - pos;
            ifFalse = this.statement();
            this.validateSingleStatementContext(ifFalse);
        }
        int end = this.getNodeEnd(ifFalse != null ? ifFalse : ifTrue);
        pn.setLength(end - pos);
        pn.setCondition(data.condition);
        pn.setParens(data.lp - pos, data.rp - pos);
        pn.setThenPart(ifTrue);
        pn.setElsePart(ifFalse);
        pn.setElsePosition(elsePos);
        pn.setLineno(lineno);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwitchStatement switchStatement() throws IOException {
        SwitchStatement pn;
        block18: {
            if (this.currentToken != 123) {
                this.codeBug();
            }
            this.consumeToken();
            int pos = this.ts.tokenBeg;
            pn = new SwitchStatement(pos);
            if (this.mustMatchToken(84, "msg.no.paren.switch")) {
                pn.setLp(this.ts.tokenBeg - pos);
            }
            pn.setLineno(this.ts.lineno);
            AstNode discriminant = this.expr();
            pn.setExpression(discriminant);
            this.enterSwitch(pn);
            try {
                if (this.mustMatchToken(85, "msg.no.paren.after.switch")) {
                    pn.setRp(this.ts.tokenBeg - pos);
                }
                this.mustMatchToken(82, "msg.no.brace.switch");
                boolean hasDefault = false;
                block9: while (true) {
                    int tt = this.nextToken();
                    int casePos = this.ts.tokenBeg;
                    int caseLineno = this.ts.lineno;
                    AstNode caseExpression = null;
                    switch (tt) {
                        case 83: {
                            pn.setLength(this.ts.tokenEnd - pos);
                            break block18;
                        }
                        case 124: {
                            caseExpression = this.expr();
                            this.mustMatchToken(104, "msg.no.colon.case");
                            break;
                        }
                        case 125: {
                            if (hasDefault) {
                                this.reportError("msg.double.switch.default");
                            }
                            hasDefault = true;
                            this.mustMatchToken(104, "msg.no.colon.case");
                            break;
                        }
                        case 166: {
                            AstNode n = this.scannedComments.get(this.scannedComments.size() - 1);
                            pn.addChild(n);
                            continue block9;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                            break block18;
                        }
                    }
                    SwitchCase caseNode = new SwitchCase(casePos);
                    caseNode.setExpression(caseExpression);
                    caseNode.setLength(this.ts.tokenEnd - pos);
                    caseNode.setLineno(caseLineno);
                    while ((tt = this.peekToken()) != 83 && tt != 124 && tt != 125 && tt != 0) {
                        if (tt == 166) {
                            Comment inlineComment = this.scannedComments.get(this.scannedComments.size() - 1);
                            if (caseNode.getInlineComment() == null && inlineComment.getLineno() == caseNode.getLineno()) {
                                caseNode.setInlineComment(inlineComment);
                            } else {
                                caseNode.addStatement(inlineComment);
                            }
                            this.consumeToken();
                            continue;
                        }
                        AstNode nextStmt = this.statement();
                        caseNode.addStatement(nextStmt);
                    }
                    pn.addCase(caseNode);
                }
            }
            finally {
                this.exitSwitch();
            }
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhileLoop whileLoop() throws IOException {
        if (this.currentToken != 126) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        WhileLoop pn = new WhileLoop(pos);
        pn.setLineno(this.ts.lineno);
        this.enterLoop(pn);
        try {
            ConditionData data = this.condition();
            pn.setCondition(data.condition);
            pn.setParens(data.lp - pos, data.rp - pos);
            AstNode body = this.getNextStatementAfterInlineComments(pn, true);
            pn.setLength(this.getNodeEnd(body) - pos);
            pn.setBody(body);
        }
        finally {
            this.exitLoop();
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoLoop doLoop() throws IOException {
        int end;
        if (this.currentToken != 127) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        DoLoop pn = new DoLoop(pos);
        pn.setLineno(this.ts.lineno);
        this.enterLoop(pn);
        try {
            AstNode body = this.getNextStatementAfterInlineComments(pn, true);
            this.mustMatchToken(126, "msg.no.while.do");
            pn.setWhilePosition(this.ts.tokenBeg - pos);
            ConditionData data = this.condition();
            pn.setCondition(data.condition);
            pn.setParens(data.lp - pos, data.rp - pos);
            end = this.getNodeEnd(body);
            pn.setBody(body);
        }
        finally {
            this.exitLoop();
        }
        if (this.matchToken(79)) {
            end = this.ts.tokenEnd;
        }
        pn.setLength(end - pos);
        return pn;
    }

    private int peekUntilNonComment(int tt) throws IOException {
        while (tt == 166) {
            this.consumeToken();
            tt = this.peekToken();
        }
        return tt;
    }

    private AstNode getNextStatementAfterInlineComments(AstNode pn, boolean checkSingleStatementContext) throws IOException {
        AstNode body = this.statement();
        if (166 == body.getType()) {
            AstNode commentNode = body;
            body = this.statement();
            if (pn != null) {
                pn.setInlineComment(commentNode);
            } else {
                body.setInlineComment(commentNode);
            }
        }
        if (checkSingleStatementContext) {
            this.validateSingleStatementContext(body);
        }
        return body;
    }

    private void validateSingleStatementContext(AstNode node) {
        int type;
        if (node instanceof Scope) {
            return;
        }
        if (node instanceof ExpressionStatement && node.getType() == 144) {
            AstNode expr = ((ExpressionStatement)node).getExpression();
            if (expr instanceof ClassNode) {
                this.reportError("msg.single.statement.context", "classes");
            }
        } else if (node instanceof VariableDeclaration && ((type = node.getType()) == 158 || type == 159)) {
            this.reportError("msg.single.statement.context", "lexical declaration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loop forLoop() throws IOException {
        Loop pn;
        if (this.currentToken != 128) {
            this.codeBug();
        }
        this.consumeToken();
        int forPos = this.ts.tokenBeg;
        int lineno = this.ts.lineno;
        boolean isForIn = false;
        boolean isForOf = false;
        int eachPos = -1;
        int inPos = -1;
        int lp = -1;
        int rp = -1;
        AstNode incr = null;
        Scope tempScope = new Scope();
        this.pushScope(tempScope);
        try {
            AstNode cond;
            if (this.mustMatchToken(84, "msg.no.paren.for")) {
                lp = this.ts.tokenBeg - forPos;
            }
            int tt = this.peekToken();
            AstNode init2 = this.forLoopInit(tt);
            if (this.matchToken(55)) {
                isForIn = true;
                inPos = this.ts.tokenBeg - forPos;
                cond = this.expr();
            } else if (this.compilerEnv.getLanguageVersion() >= 200 && this.matchToken(40) && "of".equals(this.ts.getString())) {
                isForOf = true;
                inPos = this.ts.tokenBeg - forPos;
                cond = this.expr();
            } else {
                this.mustMatchToken(79, "msg.no.semi.for");
                if (this.peekToken() == 79) {
                    cond = new EmptyExpression(this.ts.tokenBeg, 1);
                    cond.setLineno(this.ts.lineno);
                } else {
                    cond = this.expr();
                }
                this.mustMatchToken(79, "msg.no.semi.for.cond");
                int tmpPos = this.ts.tokenEnd;
                if (this.peekToken() == 85) {
                    incr = new EmptyExpression(tmpPos, 1);
                    incr.setLineno(this.ts.lineno);
                } else {
                    incr = this.expr();
                }
            }
            if (this.mustMatchToken(85, "msg.no.paren.for.ctrl")) {
                rp = this.ts.tokenBeg - forPos;
            }
            if (isForIn || isForOf) {
                ForInLoop fis = new ForInLoop(forPos);
                if (init2 instanceof VariableDeclaration) {
                    VariableDeclaration decl = (VariableDeclaration)init2;
                    if (decl.getVariables().size() > 1) {
                        this.reportError("msg.mult.index");
                    }
                    if (this.inUseStrictDirective && decl.getVariables().get(0).hasExplicitInitializer()) {
                        this.reportError("msg.for.in.assignment.in.strict.mode");
                    }
                }
                fis.setIterator(init2);
                fis.setIteratedObject(cond);
                fis.setInPosition(inPos);
                fis.setEachPosition(eachPos);
                fis.setIsForOf(isForOf);
                pn = fis;
            } else {
                ForLoop fl = new ForLoop(forPos);
                fl.setInitializer(init2);
                fl.setCondition(cond);
                fl.setIncrement(incr);
                pn = fl;
            }
            this.currentScope.replaceWith(pn);
            this.popScope();
            this.enterLoop(pn);
            try {
                AstNode body = this.getNextStatementAfterInlineComments(pn, true);
                pn.setLength(this.getNodeEnd(body) - forPos);
                pn.setBody(body);
            }
            finally {
                this.exitLoop();
            }
        }
        finally {
            if (this.currentScope == tempScope) {
                this.popScope();
            }
        }
        pn.setParens(lp, rp);
        pn.setLineno(lineno);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode forLoopInit(int tt) throws IOException {
        try {
            AstNode init2;
            this.inForInit = true;
            if (tt == 79) {
                init2 = new EmptyExpression(this.ts.tokenBeg, 1);
                init2.setLineno(this.ts.lineno);
            } else if (tt == 131 || tt == 158 || tt == 159) {
                this.consumeToken();
                init2 = this.variables(tt, this.ts.tokenBeg, false);
            } else {
                init2 = this.expr();
                this.markDestructuring(init2);
            }
            AstNode astNode = init2;
            return astNode;
        }
        finally {
            this.inForInit = false;
        }
    }

    private TryStatement tryStatement() throws IOException {
        if (this.currentToken != 78) {
            this.codeBug();
        }
        this.consumeToken();
        Comment jsdocNode = this.getAndResetJsDoc();
        int tryPos = this.ts.tokenBeg;
        int lineno = this.ts.lineno;
        int finallyPos = -1;
        TryStatement pn = new TryStatement(tryPos);
        int lctt = this.peekToken();
        if (lctt == 166) {
            Comment commentNode = this.scannedComments.get(this.scannedComments.size() - 1);
            pn.setInlineComment(commentNode);
            this.consumeToken();
            lctt = this.peekToken();
        }
        if (lctt != 82) {
            this.reportError("msg.no.brace.try");
        }
        AstNode tryBlock = this.getNextStatementAfterInlineComments(pn, false);
        int tryEnd = this.getNodeEnd(tryBlock);
        ArrayList<CatchClause> clauses = null;
        boolean sawDefaultCatch = false;
        int peek = this.peekToken();
        if (peek == 133) {
            while (this.matchToken(133)) {
                int catchLineNum = this.ts.lineno;
                if (sawDefaultCatch) {
                    this.reportError("msg.catch.unreachable");
                }
                int catchPos = this.ts.tokenBeg;
                int lp = -1;
                int rp = -1;
                int guardPos = -1;
                if (this.mustMatchToken(84, "msg.no.paren.catch")) {
                    lp = this.ts.tokenBeg;
                }
                this.mustMatchToken(40, "msg.bad.catchcond");
                Name varName = this.createNameNode();
                Comment jsdocNodeForName = this.getAndResetJsDoc();
                if (jsdocNodeForName != null) {
                    varName.setJsDocNode(jsdocNodeForName);
                }
                String varNameString = varName.getIdentifier();
                if (this.inUseStrictDirective && ("eval".equals(varNameString) || "arguments".equals(varNameString))) {
                    this.reportError("msg.bad.id.strict", varNameString);
                }
                if (this.mustMatchToken(85, "msg.bad.catchcond")) {
                    rp = this.ts.tokenBeg;
                }
                this.mustMatchToken(82, "msg.no.brace.catchblock");
                Block catchBlock = (Block)this.statements();
                tryEnd = this.getNodeEnd(catchBlock);
                CatchClause catchNode = new CatchClause(catchPos);
                catchNode.setVarName(varName);
                catchNode.setBody(catchBlock);
                catchNode.setParens(lp, rp);
                catchNode.setLineno(catchLineNum);
                if (this.mustMatchToken(83, "msg.no.brace.after.body")) {
                    tryEnd = this.ts.tokenEnd;
                }
                catchNode.setLength(tryEnd - catchPos);
                if (clauses == null) {
                    clauses = new ArrayList<CatchClause>();
                }
                clauses.add(catchNode);
            }
        } else if (peek != 134) {
            this.mustMatchToken(134, "msg.try.no.catchfinally");
        }
        AstNode finallyBlock = null;
        if (this.matchToken(134)) {
            finallyPos = this.ts.tokenBeg;
            finallyBlock = this.statement();
            tryEnd = this.getNodeEnd(finallyBlock);
        }
        pn.setLength(tryEnd - tryPos);
        pn.setTryBlock(tryBlock);
        pn.setCatchClauses(clauses);
        pn.setFinallyBlock(finallyBlock);
        if (finallyPos != -1) {
            pn.setFinallyPosition(finallyPos - tryPos);
        }
        pn.setLineno(lineno);
        if (jsdocNode != null) {
            pn.setJsDocNode(jsdocNode);
        }
        return pn;
    }

    private ThrowStatement throwStatement() throws IOException {
        if (this.currentToken != 53) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        int lineno = this.ts.lineno;
        if (this.peekTokenOrEOL() == 1) {
            this.reportError("msg.bad.throw.eol");
        }
        AstNode expr = this.expr();
        ThrowStatement pn = new ThrowStatement(pos, expr);
        pn.setLineno(lineno);
        return pn;
    }

    private LabeledStatement matchJumpLabelName() throws IOException {
        LabeledStatement label = null;
        if (this.peekTokenOrEOL() == 40) {
            this.consumeToken();
            if (this.labelSet != null) {
                label = this.labelSet.get(this.ts.getString());
            }
            if (label == null) {
                this.reportError("msg.undef.label");
            }
        }
        return label;
    }

    private BreakStatement breakStatement() throws IOException {
        LabeledStatement labels;
        Jump breakTarget;
        if (this.currentToken != 129) {
            this.codeBug();
        }
        this.consumeToken();
        int lineno = this.ts.lineno;
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        Name breakLabel = null;
        if (this.peekTokenOrEOL() == 40) {
            breakLabel = this.createNameNode();
            end = this.getNodeEnd(breakLabel);
        }
        Label label = breakTarget = (labels = this.matchJumpLabelName()) == null ? null : labels.getFirstLabel();
        if (breakTarget == null && breakLabel == null) {
            if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                this.reportError("msg.bad.break", pos, end - pos);
            } else {
                breakTarget = this.loopAndSwitchSet.get(this.loopAndSwitchSet.size() - 1);
            }
        }
        BreakStatement pn = new BreakStatement(pos, end - pos);
        pn.setBreakLabel(breakLabel);
        if (breakTarget != null) {
            pn.setBreakTarget(breakTarget);
        }
        pn.setLineno(lineno);
        return pn;
    }

    private ContinueStatement continueStatement() throws IOException {
        if (this.currentToken != 130) {
            this.codeBug();
        }
        this.consumeToken();
        int lineno = this.ts.lineno;
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        Name label = null;
        if (this.peekTokenOrEOL() == 40) {
            label = this.createNameNode();
            end = this.getNodeEnd(label);
        }
        LabeledStatement labels = this.matchJumpLabelName();
        Loop target = null;
        if (labels == null && label == null) {
            if (this.loopSet == null || this.loopSet.size() == 0) {
                this.reportError("msg.continue.outside");
            } else {
                target = this.loopSet.get(this.loopSet.size() - 1);
            }
        } else {
            if (labels == null || !(labels.getStatement() instanceof Loop)) {
                this.reportError("msg.continue.nonloop", pos, end - pos);
            }
            target = labels == null ? null : (Loop)labels.getStatement();
        }
        ContinueStatement pn = new ContinueStatement(pos, end - pos);
        if (target != null) {
            pn.setTarget(target);
        }
        pn.setLabel(label);
        pn.setLineno(lineno);
        return pn;
    }

    private WithStatement withStatement() throws IOException {
        if (this.currentToken != 132) {
            this.codeBug();
        }
        this.consumeToken();
        Comment withComment = this.getAndResetJsDoc();
        int lineno = this.ts.lineno;
        int pos = this.ts.tokenBeg;
        int lp = -1;
        int rp = -1;
        if (this.mustMatchToken(84, "msg.no.paren.with")) {
            lp = this.ts.tokenBeg;
        }
        AstNode obj = this.expr();
        if (this.mustMatchToken(85, "msg.no.paren.after.with")) {
            rp = this.ts.tokenBeg;
        }
        WithStatement pn = new WithStatement(pos);
        AstNode body = this.getNextStatementAfterInlineComments(pn, true);
        pn.setLength(this.getNodeEnd(body) - pos);
        pn.setJsDocNode(withComment);
        pn.setExpression(obj);
        pn.setStatement(body);
        pn.setParens(lp, rp);
        pn.setLineno(lineno);
        return pn;
    }

    private AstNode letStatement() throws IOException {
        if (this.currentToken != 158) {
            this.codeBug();
        }
        this.consumeToken();
        int lineno = this.ts.lineno;
        int pos = this.ts.tokenBeg;
        AstNode pn = this.peekToken() == 84 ? this.let(true, pos) : this.variables(158, pos, true);
        pn.setLineno(lineno);
        return pn;
    }

    private AstNode returnOrYield(int tt, boolean exprContext) throws IOException {
        AstNode ret;
        if (!this.insideFunction()) {
            this.reportError(tt == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        int lineno = this.ts.lineno;
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        AstNode e = null;
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 76: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                break;
            }
            default: {
                e = this.expr();
                end = this.getNodeEnd(e);
            }
        }
        int before = this.endFlags;
        if (tt == 4) {
            this.endFlags |= e == null ? 2 : 4;
            ret = new ReturnStatement(pos, end - pos, e);
            if (Parser.nowAllSet(before, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "", pos, end - pos);
            }
        } else {
            if (!this.insideFunction()) {
                this.reportError("msg.bad.yield");
            }
            if (!(this.currentScriptOrFn instanceof FunctionNode) || !((FunctionNode)this.currentScriptOrFn).isGenerator()) {
                this.reportError("msg.bad.yield.fn.type");
                return this.makeErrorNode();
            }
            this.endFlags |= 8;
            ret = new Yield(pos, end - pos, e);
            this.setRequiresActivation();
            if (!exprContext) {
                ret = new ExpressionStatement(ret);
            }
        }
        ret.setLineno(lineno);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode block() throws IOException {
        if (this.currentToken != 82) {
            this.codeBug();
        }
        this.consumeToken();
        int pos = this.ts.tokenBeg;
        Scope block = new Scope(pos);
        block.setLineno(this.ts.lineno);
        this.pushScope(block);
        try {
            this.statements(block);
            this.mustMatchToken(83, "msg.no.brace.block");
            block.setLength(this.ts.tokenEnd - pos);
            Scope scope = block;
            return scope;
        }
        finally {
            this.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecoratorDeclarationNode decoratorDeclaration() throws IOException {
        this.mustMatchToken(153, "msg.decorator.declaration.missing.at");
        this.mustMatchToken(40, "msg.decorator.declaration.missing.name");
        Name name = this.createNameNode();
        name.setIdentifier("@" + name.getIdentifier());
        this.consumeToken();
        DecoratorDeclarationNode dn = new DecoratorDeclarationNode();
        dn.setFunctionName(name);
        PerFunctionVariables savedVars = new PerFunctionVariables(dn);
        try {
            if (this.peekToken() == 84) {
                this.consumeToken();
                this.parseFunctionParams(dn, false);
                dn.setSourceName(this.sourceURI);
            }
            this.mustMatchToken(82, "msg.decorator.declaration.missing.lc");
            while (this.peekToken() == 153) {
                dn.addDecoratorNode(this.decorator(true, false));
            }
        }
        finally {
            savedVars.restore();
        }
        this.mustMatchToken(83, "msg.decorator.declaration.missing.rc");
        return dn;
    }

    private AstNode decoratedExpr() throws IOException {
        ArrayList<DecoratorNode> decorators = new ArrayList<DecoratorNode>();
        int tt = this.peekToken();
        while (tt == 153) {
            decorators.add(this.decorator(false, false));
            tt = this.peekToken();
        }
        AstNode expr = this.statement();
        if (expr instanceof ExpressionStatement) {
            expr = ((ExpressionStatement)expr).getExpression();
        }
        if (!(expr instanceof ClassNode)) {
            this.reportError("msg.decorator.invalid.usage");
            return this.makeErrorNode();
        }
        ((ClassNode)expr).setDecorators(decorators);
        return expr;
    }

    private DecoratorNode decorator(boolean declaration, boolean numericLiteral) throws IOException {
        this.consumeToken();
        this.peekToken();
        Name name = this.createNameNode();
        name.setIdentifier("@" + name.getIdentifier());
        this.consumeToken();
        DecoratorNode dn = new DecoratorNode(this.ts.tokenBeg, name);
        dn.setDecoratorType(DecoratorType.fromDecorator(name.getIdentifier()));
        if (this.peekToken() == 84) {
            AstNode node = this.memberExprTail(true, dn);
            if (!(node instanceof FunctionCall)) {
                throw this.codeBug();
            }
            dn.setArguments(((FunctionCall)node).getArguments());
        }
        if (!numericLiteral) {
            int peeked = this.peekToken();
            if (peeked == 79) {
                this.reportError("msg.decorator.semi");
                this.peekToken();
            }
            if (!declaration && !this.insideClass && peeked != 115 && peeked != 153 && peeked != 119) {
                this.reportError("msg.decorator.invalid.usage");
            }
        }
        return dn;
    }

    private void recordLabel(Label label, LabeledStatement bundle) throws IOException {
        if (this.peekToken() != 104) {
            this.codeBug();
        }
        this.consumeToken();
        String name = label.getName();
        if (this.labelSet == null) {
            this.labelSet = new HashMap<String, LabeledStatement>();
        } else {
            LabeledStatement ls = this.labelSet.get(name);
            if (ls != null) {
                if (this.compilerEnv.isIdeMode()) {
                    Label dup = ls.getLabelByName(name);
                    this.reportError("msg.dup.label", dup.getAbsolutePosition(), dup.getLength());
                }
                this.reportError("msg.dup.label", label.getPosition(), label.getLength());
            }
        }
        bundle.addLabel(label);
        this.labelSet.put(name, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode nameOrLabel() throws IOException {
        if (this.currentToken != 40) {
            throw this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        this.currentFlaggedToken |= 0x20000;
        AstNode expr = this.expr();
        if (expr.getType() != 140) {
            ExpressionStatement n = new ExpressionStatement(expr, !this.insideFunction());
            n.lineno = expr.lineno;
            return n;
        }
        LabeledStatement bundle = new LabeledStatement(pos);
        this.recordLabel((Label)expr, bundle);
        bundle.setLineno(this.ts.lineno);
        AstNode stmt = null;
        while (this.peekToken() == 40) {
            this.currentFlaggedToken |= 0x20000;
            expr = this.expr();
            if (expr.getType() != 140) {
                stmt = new ExpressionStatement(expr, !this.insideFunction());
                this.autoInsertSemicolon(stmt);
                break;
            }
            this.recordLabel((Label)expr, bundle);
        }
        try {
            this.currentLabel = bundle;
            if (stmt == null) {
                stmt = this.statementHelper();
                int ntt = this.peekToken();
                if (ntt == 166 && stmt.getLineno() == this.scannedComments.get(this.scannedComments.size() - 1).getLineno()) {
                    stmt.setInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                    this.consumeToken();
                }
            }
        }
        finally {
            this.currentLabel = null;
            for (Label lb : bundle.getLabels()) {
                this.labelSet.remove(lb.getName());
            }
        }
        bundle.setLength(stmt.getParent() == null ? this.getNodeEnd(stmt) - pos : this.getNodeEnd(stmt));
        bundle.setStatement(stmt);
        return bundle;
    }

    private VariableDeclaration variables(int declType, int pos, boolean isStatement) throws IOException {
        return this.variables(declType, pos, isStatement, false, false);
    }

    private VariableDeclaration variables(int declType, int pos, boolean isStatement, boolean isFunctionParams, boolean isObjectSetterFunction) throws IOException {
        int end;
        VariableDeclaration pn = new VariableDeclaration(pos);
        pn.setType(declType);
        pn.setLineno(this.ts.lineno);
        Comment varjsdocNode = this.getAndResetJsDoc();
        if (varjsdocNode != null) {
            pn.setJsDocNode(varjsdocNode);
        }
        do {
            AstNode destructuring = null;
            Name name = null;
            int tt = this.peekToken();
            int kidPos = this.ts.tokenBeg;
            end = this.ts.tokenEnd;
            boolean rest = false;
            if (tt == 80 || tt == 82) {
                destructuring = this.destructuringPrimaryExpr();
                end = this.getNodeEnd(destructuring);
                if (!(destructuring instanceof DestructuringForm)) {
                    this.reportError("msg.bad.assign.left", kidPos, end - kidPos);
                }
                this.markDestructuring(destructuring);
            } else {
                String id;
                if (this.matchToken(110)) {
                    if (isObjectSetterFunction) {
                        this.reportError("msg.setter.rest");
                    }
                    rest = true;
                }
                tt = this.peekToken();
                if (this.inUseStrictDirective) {
                    this.mustMatchToken(40, "msg.bad.var");
                    name = this.createNameNode();
                } else {
                    if (this.compilerEnv.isReservedKeywordAsIdentifier()) {
                        boolean isSafeKeyword;
                        boolean isKeyword = TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), false);
                        boolean bl = isSafeKeyword = Token.keywordToName(tt) == null;
                        if (isKeyword && isSafeKeyword) {
                            name = this.createNameNode();
                            this.consumeToken();
                        }
                    }
                    if (name == null) {
                        this.mustMatchToken(40, "msg.bad.var");
                        name = this.createNameNode();
                    }
                }
                name.setLineno(this.ts.getLineno());
                if (rest) {
                    name.putProp(29, true);
                    this.currentScope.setHasRest();
                }
                if (this.inUseStrictDirective && ("eval".equals(id = this.ts.getString()) || "arguments".equals(this.ts.getString()))) {
                    this.reportError("msg.bad.id.strict", id);
                }
                this.defineSymbol(declType, this.ts.getString(), this.inForInit);
            }
            int lineno = this.ts.lineno;
            Comment jsdocNode = this.getAndResetJsDoc();
            AstNode init2 = null;
            if (this.matchToken(87)) {
                if (rest) {
                    this.reportError("msg.rest.no.defaults");
                }
                init2 = this.assignExpr();
                end = this.getNodeEnd(init2);
            }
            VariableInitializer vi = new VariableInitializer(kidPos, end - kidPos);
            if (destructuring != null) {
                if (init2 == null && !this.inForInit && !isFunctionParams) {
                    this.reportError("msg.destruct.assign.no.init");
                }
                vi.setTarget(destructuring);
            } else {
                vi.setTarget(name);
            }
            if (declType == 158 && init2 == null) {
                vi.setInitializer(new Name(this.ts.tokenBeg, "undefined"));
            } else {
                vi.setInitializer(init2);
            }
            if (init2 != null) {
                vi.setHasExplicitInitializer();
            }
            vi.setType(declType);
            vi.setJsDocNode(jsdocNode);
            vi.setLineno(lineno);
            pn.addVariable(vi);
            if (!this.matchToken(86)) break;
            if (!rest) continue;
            this.reportError("msg.rest.not.last");
        } while (this.peekToken() != 85 || !isFunctionParams);
        pn.setLength(end - pos);
        pn.setIsStatement(isStatement);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode let(boolean isStatement, int pos) throws IOException {
        LetNode pn = new LetNode(pos);
        pn.setLineno(this.ts.lineno);
        if (this.mustMatchToken(84, "msg.no.paren.after.let")) {
            pn.setLp(this.ts.tokenBeg - pos);
        }
        this.pushScope(pn);
        try {
            VariableDeclaration vars = this.variables(158, this.ts.tokenBeg, isStatement);
            pn.setVariables(vars);
            if (this.mustMatchToken(85, "msg.no.paren.let")) {
                pn.setRp(this.ts.tokenBeg - pos);
            }
            if (isStatement && this.peekToken() == 82) {
                this.consumeToken();
                int beg = this.ts.tokenBeg;
                AstNode stmt = this.statements();
                this.mustMatchToken(83, "msg.no.curly.let");
                stmt.setLength(this.ts.tokenEnd - beg);
                pn.setLength(this.ts.tokenEnd - pos);
                pn.setBody(stmt);
                pn.setType(158);
            } else {
                AstNode expr = this.expr();
                pn.setLength(this.getNodeEnd(expr) - pos);
                pn.setBody(expr);
                if (isStatement) {
                    ExpressionStatement es = new ExpressionStatement(pn, !this.insideFunction());
                    es.setLineno(pn.getLineno());
                    ExpressionStatement expressionStatement = es;
                    return expressionStatement;
                }
            }
        }
        finally {
            this.popScope();
        }
        return pn;
    }

    private void defineSymbol(int declType, String name) {
        this.defineSymbol(declType, name, false);
    }

    void defineSymbol(int declType, String name, boolean ignoreNotInBlock) {
        int symDeclType;
        Scope definingScope;
        if (name == null) {
            if (this.compilerEnv.isIdeMode()) {
                return;
            }
            this.codeBug();
        }
        Symbol symbol = (definingScope = this.currentScope.getDefiningScope(name)) != null ? definingScope.getSymbol(name) : null;
        int n = symDeclType = symbol != null ? symbol.getDeclType() : -1;
        if (symbol != null) {
            if (definingScope == this.currentScope) {
                if (symDeclType == 159) {
                    this.reportError("msg.const.redecl", name);
                    return;
                }
                if (symDeclType == 158) {
                    this.reportError("msg.let.redecl", name);
                    return;
                }
                if (symDeclType == 115) {
                    this.reportError("msg.class.redecl", name);
                    return;
                }
            } else if (symDeclType == 114 && (declType == 115 || declType == 159 || declType == 158)) {
                this.reportError("msg.func.redecl", name);
                return;
            }
        }
        switch (declType) {
            case 158: {
                if (!ignoreNotInBlock && (this.currentScope.getType() == 121 || this.currentScope instanceof Loop)) {
                    this.reportError("msg.let.decl.not.in.block");
                    return;
                }
                this.currentScope.putSymbol(new Symbol(declType, name));
                return;
            }
            case 115: 
            case 159: {
                this.currentScope.putSymbol(new Symbol(declType, name));
                return;
            }
            case 114: 
            case 131: {
                if (symbol != null) {
                    if (symDeclType == 131) {
                        this.addStrictWarning("msg.var.redecl", name);
                    } else if (symDeclType == 84) {
                        this.addStrictWarning("msg.var.hides.arg", name);
                    }
                } else {
                    this.currentScriptOrFn.putSymbol(new Symbol(declType, name));
                }
                return;
            }
            case 84: {
                if (symbol != null) {
                    this.addWarning("msg.dup.parms", name);
                }
                this.currentScriptOrFn.putSymbol(new Symbol(declType, name));
                return;
            }
        }
        throw this.codeBug();
    }

    private AstNode expr() throws IOException {
        AstNode pn = this.assignExpr();
        int pos = pn.getPosition();
        while (this.matchToken(86)) {
            int opPos = this.ts.tokenBeg;
            if (this.compilerEnv.isStrictMode() && !pn.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", pos, this.nodeEnd(pn) - pos);
            }
            if (this.peekToken() == 76) {
                this.reportError("msg.yield.parenthesized");
            }
            pn = new InfixExpression(86, pn, this.assignExpr(), opPos);
        }
        return pn;
    }

    private AstNode assignExpr() throws IOException {
        int tt = this.peekToken();
        if (tt == 76) {
            this.consumeToken();
            return new Yield(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, this.assignExpr());
        }
        AstNode pn = this.condExpr();
        boolean hasEOL = false;
        tt = this.peekTokenOrEOL();
        if (tt == 1) {
            hasEOL = true;
            tt = this.peekToken();
        }
        if (87 <= tt && tt <= 102) {
            if (this.inDestructuringAssignment && tt != 87) {
                this.reportError("msg.destruct.assign.wrong.operator");
            }
            this.consumeToken();
            Comment jsdocNode = this.getAndResetJsDoc();
            this.markDestructuring(pn);
            int opPos = this.ts.tokenBeg;
            if (pn instanceof Name) {
                Symbol definedSymbol;
                Scope definingScope;
                Name lhs = (Name)pn;
                String name = lhs.getString();
                if (name.equals("new.target")) {
                    this.reportError("msg.bad.assign.left");
                }
                if ((definingScope = this.currentScope.getDefiningScope(name)) != null && (definedSymbol = definingScope.getSymbol(name)) != null && definedSymbol.getDeclType() == 159) {
                    this.reportError("msg.const.inval.assign", name);
                }
            }
            pn = new Assignment(tt, pn, this.assignExpr(), opPos);
            if (jsdocNode != null) {
                pn.setJsDocNode(jsdocNode);
            }
        } else if (tt == 79) {
            if (this.currentJsDocComment != null) {
                pn.setJsDocNode(this.getAndResetJsDoc());
            }
        } else if (!hasEOL && tt == 169) {
            this.consumeToken();
            pn = this.arrowFunction(pn);
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode condExpr() throws IOException {
        AstNode pn = this.pipelineExpr(null);
        if (this.matchToken(103)) {
            AstNode ifTrue;
            int line = this.ts.lineno;
            int qmarkPos = this.ts.tokenBeg;
            int colonPos = -1;
            boolean wasInForInit = this.inForInit;
            this.inForInit = false;
            try {
                ifTrue = this.assignExpr();
            }
            finally {
                this.inForInit = wasInForInit;
            }
            if (this.mustMatchToken(104, "msg.no.colon.cond")) {
                colonPos = this.ts.tokenBeg;
            }
            AstNode ifFalse = this.assignExpr();
            int beg = pn.getPosition();
            int len = this.getNodeEnd(ifFalse) - beg;
            ConditionalExpression ce = new ConditionalExpression(beg, len);
            ce.setLineno(line);
            ce.setTestExpression(pn);
            ce.setTrueExpression(ifTrue);
            ce.setFalseExpression(ifFalse);
            ce.setQuestionMarkPosition(qmarkPos - beg);
            ce.setColonPosition(colonPos - beg);
            pn = ce;
        }
        return pn;
    }

    private AstNode pipelineExpr(AstNode previousPipeline) throws IOException {
        AstNode pn;
        AstNode astNode = pn = previousPipeline == null ? this.shortCircuitExpr(null) : previousPipeline;
        if (this.matchToken(112)) {
            int opPos = this.ts.tokenBeg;
            FunctionCall fc = new FunctionCall(opPos);
            AstNode target = this.orExpr();
            if (this.peekToken() == 169) {
                this.consumeToken();
                target = this.arrowFunction(target);
            }
            fc.setTarget(target);
            fc.setArguments(Collections.singletonList(pn));
            pn = this.pipelineExpr(fc);
        }
        return pn;
    }

    private AstNode shortCircuitExpr(AstNode previousShortCircuit) throws IOException {
        AstNode pn;
        AstNode astNode = pn = previousShortCircuit == null ? this.orExpr() : previousShortCircuit;
        if (this.matchToken(113)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(113, pn, this.orExpr(), opPos);
            pn = this.shortCircuitExpr(pn);
        }
        return pn;
    }

    private AstNode orExpr() throws IOException {
        AstNode pn = this.andExpr();
        if (this.matchToken(105)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(105, pn, this.orExpr(), opPos);
        }
        return pn;
    }

    private AstNode andExpr() throws IOException {
        AstNode pn = this.bitOrExpr();
        if (this.matchToken(106)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(106, pn, this.andExpr(), opPos);
        }
        return pn;
    }

    private AstNode bitOrExpr() throws IOException {
        AstNode pn = this.bitXorExpr();
        while (this.matchToken(9)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(9, pn, this.bitXorExpr(), opPos);
        }
        return pn;
    }

    private AstNode bitXorExpr() throws IOException {
        AstNode pn = this.bitAndExpr();
        while (this.matchToken(10)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(10, pn, this.bitAndExpr(), opPos);
        }
        return pn;
    }

    private AstNode bitAndExpr() throws IOException {
        AstNode pn = this.eqExpr();
        while (this.matchToken(11)) {
            int opPos = this.ts.tokenBeg;
            pn = new InfixExpression(11, pn, this.eqExpr(), opPos);
        }
        return pn;
    }

    private AstNode eqExpr() throws IOException {
        AstNode pn = this.relExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 12: 
                case 13: 
                case 49: 
                case 50: {
                    this.consumeToken();
                    int parseToken = tt;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        if (tt == 12) {
                            parseToken = 49;
                        } else if (tt == 13) {
                            parseToken = 50;
                        }
                    }
                    pn = new InfixExpression(parseToken, pn, this.relExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode relExpr() throws IOException {
        AstNode pn = this.shiftExpr();
        block4: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 55: {
                    if (this.inForInit) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 56: {
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.shiftExpr(), opPos);
                    continue block4;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode shiftExpr() throws IOException {
        AstNode pn = this.addExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.addExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode addExpr() throws IOException {
        AstNode pn = this.mulExpr();
        while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            if (tt != 21 && tt != 22) break;
            this.consumeToken();
            pn = new InfixExpression(tt, pn, this.mulExpr(), opPos);
        }
        return pn;
    }

    private AstNode mulExpr() throws IOException {
        AstNode pn = this.expExpr();
        block3: while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            switch (tt) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    pn = new InfixExpression(tt, pn, this.unaryExpr(), opPos);
                    continue block3;
                }
            }
            break;
        }
        return pn;
    }

    private AstNode expExpr() throws IOException {
        AstNode pn = this.unaryExpr();
        while (true) {
            int tt = this.peekToken();
            int opPos = this.ts.tokenBeg;
            if (tt != 26) break;
            if (pn instanceof UnaryExpression) {
                this.reportError("msg.exp.unparenthesized");
                return this.makeErrorNode();
            }
            this.consumeToken();
            pn = new InfixExpression(tt, pn, this.unaryExpr(), opPos);
        }
        return pn;
    }

    private AstNode unaryExpr() throws IOException {
        int tt = this.peekToken();
        if (tt == 166) {
            this.consumeToken();
            tt = this.peekUntilNonComment(tt);
        }
        int line = this.ts.lineno;
        switch (tt) {
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 53: 
            case 136: {
                this.consumeToken();
                UnaryExpression node = new UnaryExpression(tt, this.ts.tokenBeg, this.unaryExpr());
                node.setLineno(line);
                return node;
            }
            case 21: {
                this.consumeToken();
                UnaryExpression node = new UnaryExpression(29, this.ts.tokenBeg, this.unaryExpr());
                node.setLineno(line);
                return node;
            }
            case 22: {
                this.consumeToken();
                UnaryExpression node = new UnaryExpression(30, this.ts.tokenBeg, this.unaryExpr());
                node.setLineno(line);
                return node;
            }
            case 107: 
            case 108: {
                this.consumeToken();
                UnaryExpression expr = new UnaryExpression(tt, this.ts.tokenBeg, this.memberExpr(true));
                expr.setLineno(line);
                this.checkBadIncDec(expr);
                return expr;
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
        }
        AstNode pn = this.memberExpr(true);
        tt = this.peekTokenOrEOL();
        if (tt != 107 && tt != 108) {
            return pn;
        }
        this.consumeToken();
        UnaryExpression uexpr = new UnaryExpression(tt, this.ts.tokenBeg, pn, true);
        uexpr.setLineno(line);
        this.checkBadIncDec(uexpr);
        return uexpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AstNode> argumentList(boolean allowPartial) throws IOException {
        if (this.matchToken(85)) {
            return null;
        }
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        boolean wasInForInit = this.inForInit;
        this.inForInit = false;
        try {
            do {
                AstNode en;
                int tt;
                if ((tt = this.peekToken()) == 85) {
                    break;
                }
                if (tt == 76) {
                    this.reportError("msg.yield.parenthesized");
                }
                if (tt == 103) {
                    if (!allowPartial) {
                        this.reportError("msg.partial.application.with.new");
                    }
                    this.consumeToken();
                    en = new EmptyExpression();
                    en.setType(103);
                } else {
                    en = this.assignExpr();
                }
                result.add(en);
            } while (this.matchToken(86));
        }
        finally {
            this.inForInit = wasInForInit;
        }
        this.mustMatchToken(85, "msg.no.paren.arg");
        return result;
    }

    private AstNode memberExpr(boolean allowCallSyntax) throws IOException {
        AstNode tail;
        AstNode pn;
        int tt = this.peekToken();
        int lineno = this.ts.lineno;
        boolean spread = false;
        if (tt == 110) {
            spread = true;
            this.consumeToken();
            tt = this.peekToken();
        }
        if (tt != 31) {
            pn = this.primaryExpr();
        } else {
            this.consumeToken();
            if (this.matchToken(109)) {
                this.mustMatchToken(40, "Expected identifier");
                Name name = this.createNameNode();
                if (!name.getString().equals("target")) {
                    this.reportError("msg.new.not.target");
                }
                if (!this.insideFunction()) {
                    this.reportError("msg.new.target.not.within.function");
                }
                return new Name(this.ts.tokenBeg, "new.target");
            }
            int pos = this.ts.tokenBeg;
            NewExpression nx = new NewExpression(pos);
            AstNode target = this.memberExpr(false);
            int end = this.getNodeEnd(target);
            nx.setTarget(target);
            if (this.matchToken(84)) {
                int lp = this.ts.tokenBeg;
                List<AstNode> args = this.argumentList(false);
                if (args != null && args.size() > 65536) {
                    this.reportError("msg.too.many.constructor.args");
                }
                int rp = this.ts.tokenBeg;
                end = this.ts.tokenEnd;
                if (args != null) {
                    nx.setArguments(args);
                }
                nx.setParens(lp - pos, rp - pos);
            }
            if (this.matchToken(82)) {
                ObjectLiteral initializer = this.objectLiteral();
                end = this.getNodeEnd(initializer);
                nx.setInitializer(initializer);
            }
            nx.setLength(end - pos);
            pn = nx;
        }
        pn.setLineno(lineno);
        AstNode astNode = tail = pn instanceof ClassNode ? pn : this.memberExprTail(allowCallSyntax, pn);
        if (spread) {
            if (tail == null) {
                throw Kit.codeBug();
            }
            tail.putProp(29, true);
        }
        return tail;
    }

    private AstNode memberExprTail(boolean allowCallSyntax, AstNode pn) throws IOException {
        if (pn == null) {
            this.codeBug();
        }
        while (true) {
            AstNode returned;
            int nextToken;
            if (this.peekToken() == 111) {
                this.consumeToken();
                nextToken = this.peekToken();
                if (nextToken == 80) {
                    pn = this.matchElementGet(pn);
                } else if (nextToken == 84) {
                    returned = this.matchFunctionCall(pn, allowCallSyntax);
                    if (returned == null) break;
                    pn = returned;
                } else if (nextToken == 40) {
                    pn = this.matchPropertyAccess(pn, true);
                } else if (nextToken == 166) {
                    int currentFlagToken = this.currentFlaggedToken;
                    this.peekUntilNonComment(nextToken);
                    this.currentFlaggedToken = (this.currentFlaggedToken & 0x10000) != 0 ? this.currentFlaggedToken : currentFlagToken;
                } else {
                    if (nextToken != 170) break;
                    this.reportError("msg.optional.chaining.private.ident");
                }
                pn.putProp(30, true);
                continue;
            }
            nextToken = this.peekToken();
            if (nextToken == 43) {
                this.consumeToken();
                pn = this.templateLiteral(pn);
                continue;
            }
            if (nextToken == 80) {
                pn = this.matchElementGet(pn);
                continue;
            }
            if (nextToken == 84) {
                returned = this.matchFunctionCall(pn, allowCallSyntax);
                if (returned == null) break;
                pn = returned;
                continue;
            }
            if (nextToken == 109) {
                pn = this.matchPropertyAccess(pn, false);
                continue;
            }
            if (nextToken != 166) break;
            int currentFlagToken = this.currentFlaggedToken;
            this.peekUntilNonComment(nextToken);
            this.currentFlaggedToken = (this.currentFlaggedToken & 0x10000) != 0 ? this.currentFlaggedToken : currentFlagToken;
        }
        return pn;
    }

    private AstNode matchPropertyAccess(AstNode pn, boolean chaining) throws IOException {
        int lineno = this.ts.lineno;
        pn = this.propertyAccess(chaining ? 111 : 109, pn);
        pn.setLineno(lineno);
        return pn;
    }

    private AstNode matchElementGet(AstNode pn) throws IOException {
        int pos = pn.getPosition();
        this.consumeToken();
        int lb = this.ts.tokenBeg;
        int rb = -1;
        int lineno = this.ts.lineno;
        AstNode expr = this.expr();
        int end = this.getNodeEnd(expr);
        if (this.mustMatchToken(81, "msg.no.bracket.index")) {
            rb = this.ts.tokenBeg;
            end = this.ts.tokenEnd;
        }
        ElementGet g = new ElementGet(pos, end - pos);
        g.setTarget(pn);
        g.setElement(expr);
        g.setParens(lb, rb);
        g.setLineno(lineno);
        return g;
    }

    private AstNode matchFunctionCall(AstNode pn, boolean allowCallSyntax) throws IOException {
        if (!allowCallSyntax) {
            return null;
        }
        int pos = pn.getPosition();
        int lineno = this.ts.lineno;
        this.consumeToken();
        this.checkCallRequiresActivation(pn);
        FunctionCall f = new FunctionCall(pos);
        f.setTarget(pn);
        f.setLineno(lineno);
        f.setLp(this.ts.tokenBeg - pos);
        List<AstNode> args = this.argumentList(true);
        if (args != null && args.size() > 65536) {
            this.reportError("msg.too.many.function.args");
        }
        f.setArguments(args);
        f.setRp(this.ts.tokenBeg - pos);
        f.setLength(this.ts.tokenEnd - pos);
        return f;
    }

    private AstNode propertyAccess(int tt, AstNode pn) throws IOException {
        int maybeName;
        if (pn == null) {
            this.codeBug();
        }
        boolean memberTypeFlags = false;
        int lineno = this.ts.lineno;
        int dotPos = this.ts.tokenBeg;
        if (tt != 111) {
            this.consumeToken();
        } else {
            tt = 109;
        }
        boolean isPrivateAccess = false;
        if (this.matchToken(170)) {
            if (!this.insideClass) {
                this.reportError("msg.class.illegal.private.access");
                return this.makeErrorNode();
            }
            isPrivateAccess = true;
        }
        if (!((maybeName = this.nextToken()) == 40 || this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective))) {
            this.reportError("msg.no.name.after.dot");
        }
        Name name = this.createNameNode(true, 34);
        PropertyGet pg = new PropertyGet(pn, name, dotPos);
        if (isPrivateAccess) {
            if (!this.accessedPrivateClassIdentifiers.containsKey(name.getIdentifier())) {
                this.accessedPrivateClassIdentifiers.put(name.getIdentifier(), this.ts.getPosition());
            }
            pg.putProp(34, true);
        }
        pg.setLineno(lineno);
        return pg;
    }

    private AstNode destructuringPrimaryExpr() throws IOException, ParserException {
        try {
            this.inDestructuringAssignment = true;
            AstNode astNode = this.primaryExpr();
            return astNode;
        }
        finally {
            this.inDestructuringAssignment = false;
        }
    }

    private AstNode primaryExpr() throws IOException {
        int ttFlagged = this.peekFlaggedToken();
        int tt = ttFlagged & 0xFFFF;
        AstNode pn = null;
        ArrayList<DecoratorNode> decorators = new ArrayList<DecoratorNode>();
        switch (tt) {
            case 153: {
                return this.decoratedExpr();
            }
            case 114: {
                this.consumeToken();
                pn = this.function(2);
                break;
            }
            case 115: {
                this.consumeToken();
                pn = this.classExpr(decorators);
                break;
            }
            case 80: {
                this.consumeToken();
                pn = this.arrayLiteral();
                break;
            }
            case 82: {
                this.consumeToken();
                pn = this.objectLiteral();
                break;
            }
            case 158: {
                this.consumeToken();
                pn = this.let(false, this.ts.tokenBeg);
                break;
            }
            case 84: {
                this.consumeToken();
                pn = this.parenExpr();
                break;
            }
            case 118: {
                this.consumeToken();
                pn = this.name(ttFlagged, tt);
                pn.putProp(31, true);
                break;
            }
            case 40: {
                this.consumeToken();
                pn = this.name(ttFlagged, tt);
                break;
            }
            case 41: {
                this.consumeToken();
                String s = this.ts.getString();
                if (this.inUseStrictDirective && this.ts.isNumberOldOctal()) {
                    this.reportError("msg.no.old.octal.strict");
                }
                if (this.ts.isNumberBinary()) {
                    s = "0b" + s;
                }
                if (this.ts.isNumberOldOctal()) {
                    s = "0" + s;
                }
                if (this.ts.isNumberOctal()) {
                    s = "0o" + s;
                }
                if (this.ts.isNumberHex()) {
                    s = "0x" + s;
                }
                pn = new NumberLiteral(this.ts.tokenBeg, s, this.ts.getNumber());
                if (!this.matchToken(153)) break;
                DecoratorNode dn = this.decorator(false, true);
                ((NumberLiteral)pn).setDecoratorNode(dn);
                break;
            }
            case 42: {
                this.consumeToken();
                pn = this.createStringLiteral();
                break;
            }
            case 24: 
            case 97: {
                this.consumeToken();
                this.ts.readRegExp(tt);
                int pos = this.ts.tokenBeg;
                int end = this.ts.tokenEnd;
                RegExpLiteral re = new RegExpLiteral(pos, end - pos);
                re.setValue(this.ts.getString());
                re.setFlags(this.ts.readAndClearRegExpFlags());
                pn = re;
                break;
            }
            case 43: {
                this.consumeToken();
                pn = this.templateLiteral(null);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                this.consumeToken();
                int pos = this.ts.tokenBeg;
                int end = this.ts.tokenEnd;
                pn = new KeywordLiteral(pos, end - pos, tt);
                break;
            }
            case 137: {
                this.consumeToken();
                if (this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective)) {
                    pn = this.name(ttFlagged, tt);
                    break;
                }
                this.reportError("msg.reserved.id", this.ts.getString());
                break;
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 0: {
                this.consumeToken();
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.consumeToken();
                this.reportError("msg.syntax");
            }
        }
        return pn;
    }

    private AstNode templateLiteral(AstNode target) throws IOException {
        int token = this.peekToken();
        TemplateLiteral lit = new TemplateLiteral();
        while (token != 43) {
            if (token == 42) {
                String str = this.ts.getString();
                if (!str.equals("")) {
                    lit.addString(str);
                }
                this.consumeToken();
            } else if (token == 44) {
                this.consumeToken();
                lit.addExpr(this.expr());
            } else if (token == 83) {
                this.ts.setTemplateExprFinished();
                this.consumeToken();
            } else {
                throw Kit.codeBug();
            }
            token = this.peekToken();
        }
        this.consumeToken();
        lit.setRawElements(this.ts.getRawLiterals());
        lit.setTarget(target);
        return lit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parenExpr() throws IOException {
        boolean wasInForInit = this.inForInit;
        this.inForInit = false;
        try {
            AstNode e;
            Comment jsdocNode = this.getAndResetJsDoc();
            int lineno = this.ts.lineno;
            int begin = this.ts.tokenBeg;
            AstNode astNode = e = this.peekToken() == 85 ? new EmptyExpression(begin) : this.expr();
            if (this.peekToken() == 128) {
                AstNode astNode2 = this.generatorExpression(e, begin);
                return astNode2;
            }
            this.mustMatchToken(85, "msg.no.paren");
            if (this.peekToken() == 87) {
                this.reportError("msg.bad.assign.left");
            }
            if (e.getType() == 138 && this.peekToken() != 169) {
                this.reportError("msg.syntax");
                ErrorNode errorNode = this.makeErrorNode();
                return errorNode;
            }
            int length = this.ts.tokenEnd - begin;
            ParenthesizedExpression pn = new ParenthesizedExpression(begin, length, e);
            pn.setLineno(lineno);
            if (jsdocNode == null) {
                jsdocNode = this.getAndResetJsDoc();
            }
            if (jsdocNode != null) {
                pn.setJsDocNode(jsdocNode);
            }
            ParenthesizedExpression parenthesizedExpression = pn;
            return parenthesizedExpression;
        }
        finally {
            this.inForInit = wasInForInit;
        }
    }

    private AstNode name(int ttFlagged, int tt) throws IOException {
        String nameString = this.ts.getString();
        int namePos = this.ts.tokenBeg;
        int nameLineno = this.ts.lineno;
        if (0 != (ttFlagged & 0x20000) && this.peekToken() == 104) {
            Label label = new Label(namePos, this.ts.tokenEnd - namePos);
            label.setName(nameString);
            label.setLineno(this.ts.lineno);
            return label;
        }
        this.saveNameTokenData(namePos, nameString, nameLineno);
        return this.createNameNode(true, 40);
    }

    private AstNode arrayLiteral() throws IOException {
        if (this.currentToken != 80) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        ArrayList<AstNode> elements = new ArrayList<AstNode>();
        ArrayLiteral pn = new ArrayLiteral(pos);
        boolean after_lb_or_comma = true;
        int afterComma = -1;
        int skipCount = 0;
        while (true) {
            int tt;
            if ((tt = this.peekToken()) == 86) {
                this.consumeToken();
                afterComma = this.ts.tokenEnd;
                if (!after_lb_or_comma) {
                    after_lb_or_comma = true;
                    continue;
                }
                elements.add(new EmptyExpression(this.ts.tokenBeg, 1));
                ++skipCount;
                continue;
            }
            if (tt == 166) {
                this.consumeToken();
                continue;
            }
            if (tt == 81) {
                this.consumeToken();
                end = this.ts.tokenEnd;
                pn.setDestructuringLength(elements.size() + (after_lb_or_comma ? 1 : 0));
                pn.setSkipCount(skipCount);
                if (afterComma == -1) break;
                this.warnTrailingComma(pos, elements, afterComma);
                break;
            }
            if (tt == 110) {
                this.consumeToken();
                AstNode expr = this.assignExpr();
                if (this.inDestructuringAssignment && expr instanceof Assignment) {
                    this.reportError("msg.rest.no.defaults");
                }
                expr.putProp(29, true);
                elements.add(expr);
                after_lb_or_comma = false;
                afterComma = -1;
                if (!this.inDestructuringAssignment || this.peekToken() != 86) continue;
                this.reportError("msg.rest.not.last");
                continue;
            }
            if (tt == 0) {
                this.reportError("msg.no.bracket.arg");
                break;
            }
            if (!after_lb_or_comma) {
                this.reportError("msg.no.bracket.arg");
            }
            elements.add(this.assignExpr());
            after_lb_or_comma = false;
            afterComma = -1;
        }
        for (AstNode e : elements) {
            pn.addElement(e);
        }
        pn.setLength(end - pos);
        return pn;
    }

    private AstNode generatorExpression(AstNode result, int pos) throws IOException {
        ArrayList<GeneratorExpressionLoop> loops = new ArrayList<GeneratorExpressionLoop>();
        while (this.peekToken() == 128) {
            loops.add(this.generatorExpressionLoop());
        }
        int ifPos = -1;
        ConditionData data = null;
        if (this.peekToken() == 121) {
            this.consumeToken();
            ifPos = this.ts.tokenBeg - pos;
            data = this.condition();
        }
        this.mustMatchToken(85, "msg.no.paren.let");
        GeneratorExpression pn = new GeneratorExpression(pos, this.ts.tokenEnd - pos);
        pn.setResult(result);
        pn.setLoops(loops);
        if (data != null) {
            pn.setIfPosition(ifPos);
            pn.setFilter(data.condition);
            pn.setFilterLp(data.lp - pos);
            pn.setFilterRp(data.rp - pos);
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneratorExpressionLoop generatorExpressionLoop() throws IOException {
        if (this.nextToken() != 128) {
            this.codeBug();
        }
        int pos = this.ts.tokenBeg;
        int lp = -1;
        int rp = -1;
        int inPos = -1;
        GeneratorExpressionLoop pn = new GeneratorExpressionLoop(pos);
        this.pushScope(pn);
        try {
            if (this.mustMatchToken(84, "msg.no.paren.for")) {
                lp = this.ts.tokenBeg - pos;
            }
            AstNode iter = null;
            switch (this.peekToken()) {
                case 80: 
                case 82: {
                    iter = this.destructuringPrimaryExpr();
                    this.markDestructuring(iter);
                    break;
                }
                case 40: {
                    this.consumeToken();
                    iter = this.createNameNode();
                    break;
                }
                default: {
                    this.reportError("msg.bad.var");
                }
            }
            if (iter.getType() == 40) {
                this.defineSymbol(158, this.ts.getString(), true);
            }
            if (this.mustMatchToken(55, "msg.in.after.for.name")) {
                inPos = this.ts.tokenBeg - pos;
            }
            AstNode obj = this.expr();
            if (this.mustMatchToken(85, "msg.no.paren.for.ctrl")) {
                rp = this.ts.tokenBeg - pos;
            }
            pn.setLength(this.ts.tokenEnd - pos);
            pn.setIterator(iter);
            pn.setIteratedObject(obj);
            pn.setInPosition(inPos);
            pn.setParens(lp, rp);
            GeneratorExpressionLoop generatorExpressionLoop = pn;
            return generatorExpressionLoop;
        }
        finally {
            this.popScope();
        }
    }

    private ObjectLiteral objectLiteral() throws IOException {
        int pos = this.ts.tokenBeg;
        int lineno = this.ts.lineno;
        int afterComma = -1;
        ArrayList<ObjectProperty> elems = new ArrayList<ObjectProperty>();
        HashSet<String> getterNames = null;
        HashSet<String> setterNames = null;
        boolean seenProto = false;
        if (this.inUseStrictDirective) {
            getterNames = new HashSet<String>();
            setterNames = new HashSet<String>();
        }
        Comment objJsdocNode = this.getAndResetJsDoc();
        while (true) {
            String propertyName = null;
            int entryKind = 1;
            int tt = this.peekToken();
            Comment jsdocNode = this.getAndResetJsDoc();
            if (tt == 166) {
                this.consumeToken();
                tt = this.peekUntilNonComment(tt);
            }
            if (tt == 83) {
                if (afterComma == -1) break;
                this.warnTrailingComma(pos, elems, afterComma);
                break;
            }
            AstNode pname = this.objliteralProperty();
            if (pname == null && this.peekToken() != 23) {
                this.reportError("msg.bad.prop");
            } else {
                propertyName = this.ts.getString();
                if ("__proto__".equals(propertyName)) {
                    if (seenProto) {
                        this.reportError("msg.object.multiple.proto");
                    } else {
                        seenProto = true;
                    }
                }
                int ppos = this.ts.tokenBeg;
                int peeked = this.peekToken();
                if (peeked != 86 && peeked != 104 && peeked != 83 && peeked != 87) {
                    if (peeked == 84) {
                        entryKind = 8;
                    } else if (peeked == 23) {
                        entryKind = 16;
                        this.consumeToken();
                    } else if (pname.getType() == 40) {
                        if ("get".equals(propertyName)) {
                            entryKind = 2;
                        } else if ("set".equals(propertyName)) {
                            entryKind = 4;
                        }
                    }
                    if (entryKind == 2 || entryKind == 4 || entryKind == 16) {
                        pname = this.objliteralProperty();
                        if (pname == null) {
                            this.reportError("msg.bad.prop");
                        }
                        this.consumeToken();
                    }
                    if (pname == null) {
                        propertyName = null;
                    } else {
                        propertyName = this.ts.getString();
                        ObjectProperty objectProp = this.methodDefinition(ppos, pname, entryKind);
                        pname.setJsDocNode(jsdocNode);
                        elems.add(objectProp);
                    }
                } else {
                    pname.setJsDocNode(jsdocNode);
                    elems.add(this.plainProperty(pname, tt));
                }
            }
            if (this.inUseStrictDirective && propertyName != null) {
                switch (entryKind) {
                    case 1: 
                    case 8: {
                        getterNames.add(propertyName);
                        setterNames.add(propertyName);
                        break;
                    }
                    case 2: {
                        getterNames.add(propertyName);
                        break;
                    }
                    case 4: {
                        setterNames.add(propertyName);
                    }
                }
            }
            this.getAndResetJsDoc();
            if (!this.matchToken(86)) break;
            afterComma = this.ts.tokenEnd;
        }
        this.mustMatchToken(83, "msg.no.brace.prop");
        if (this.assumeDestructuring) {
            if (this.peekToken() != 87) {
                this.reportError("msg.unexpected.object.init");
            }
            this.assumeDestructuring = false;
            this.inDestructuringAssignment = false;
        }
        ObjectLiteral pn = new ObjectLiteral(pos, this.ts.tokenEnd - pos);
        if (objJsdocNode != null) {
            pn.setJsDocNode(objJsdocNode);
        }
        pn.setElements(elems);
        pn.setLineno(lineno);
        return pn;
    }

    private AstNode objliteralProperty() throws IOException {
        AstNode pname;
        int tt = this.peekToken();
        switch (tt) {
            case 40: {
                pname = this.createNameNode();
                this.consumeToken();
                break;
            }
            case 42: {
                pname = this.createStringLiteral();
                this.consumeToken();
                break;
            }
            case 41: {
                pname = new NumberLiteral(this.ts.tokenBeg, this.ts.getString(), this.ts.getNumber());
                this.consumeToken();
                break;
            }
            case 80: {
                this.consumeToken();
                pname = this.assignExpr();
                pname.putProp(28, true);
                if (!this.matchToken(81)) {
                    this.reportError("msg.bad.object.init");
                }
                this.consumeToken();
                break;
            }
            case 110: {
                this.consumeToken();
                pname = this.memberExpr(true);
                pname.putProp(29, true);
                break;
            }
            default: {
                if (this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective)) {
                    pname = this.createNameNode();
                    this.consumeToken();
                    break;
                }
                return null;
            }
        }
        return pname;
    }

    private ObjectProperty plainProperty(AstNode property, int ptt) throws IOException {
        int tt = this.peekToken();
        if (ptt == 110) {
            if (tt != 86 && tt != 83) {
                this.reportError("msg.obj.spread.extra");
            }
            ObjectProperty pn = new ObjectProperty();
            pn.setSpread(property);
            return pn;
        }
        if ((tt == 86 || tt == 83 || tt == 87) && ptt == 40 && this.compilerEnv.getLanguageVersion() >= 180) {
            if (!this.inDestructuringAssignment) {
                if (tt == 87) {
                    this.assumeDestructuring = true;
                    this.inDestructuringAssignment = true;
                } else if (property.getProp(28) != null) {
                    this.reportError("msg.bad.object.init");
                } else {
                    Name nn = new Name(property.getPosition(), property.getString());
                    ObjectProperty pn = new ObjectProperty();
                    pn.setLeftAndRight(property, nn);
                    return pn;
                }
            }
            Name nn = new Name(property.getPosition(), property.getString());
            ObjectProperty pn = new ObjectProperty();
            pn.putProp(26, Boolean.TRUE);
            if (tt == 87) {
                this.consumeToken();
                AstNode exp = this.condExpr();
                pn.setDefaultValue(exp);
            }
            pn.setLeftAndRight(property, nn);
            return pn;
        }
        this.mustMatchToken(104, "msg.no.colon.prop");
        ObjectProperty pn = new ObjectProperty();
        pn.setOperatorPosition(this.ts.tokenBeg);
        AstNode exp = this.assignExpr();
        if (exp instanceof Assignment) {
            Assignment as = (Assignment)exp;
            pn.setLeftAndRight(property, as.getLeft());
            pn.setDefaultValue(as.getRight());
        } else {
            pn.setLeftAndRight(property, exp);
        }
        return pn;
    }

    private ObjectProperty methodDefinition(int pos, AstNode propName, int entryKind) throws IOException {
        FunctionNode fn = this.function(2, entryKind);
        Name name = fn.getFunctionName();
        if (name != null && name.length() != 0) {
            this.reportError("msg.bad.prop");
        }
        ObjectProperty pn = new ObjectProperty(pos);
        switch (entryKind) {
            case 2: {
                pn.setIsGetterMethod();
                fn.setFunctionIsGetterMethod();
                break;
            }
            case 4: {
                pn.setIsSetterMethod();
                fn.setFunctionIsSetterMethod();
                break;
            }
            case 8: {
                pn.setIsNormalMethod();
                fn.setFunctionIsNormalMethod();
            }
        }
        int end = this.getNodeEnd(fn);
        pn.setLeft(propName);
        pn.setRight(fn);
        pn.setLength(end - pos);
        return pn;
    }

    private Name createNameNode() {
        return this.createNameNode(false, 40);
    }

    private Name createNameNode(boolean checkActivation, int token) {
        int beg = this.ts.tokenBeg;
        String s = this.ts.getString();
        int lineno = this.ts.lineno;
        if (!"".equals(this.prevNameTokenString)) {
            beg = this.prevNameTokenStart;
            s = this.prevNameTokenString;
            lineno = this.prevNameTokenLineno;
            this.prevNameTokenStart = 0;
            this.prevNameTokenString = "";
            this.prevNameTokenLineno = 0;
        }
        if (s == null) {
            if (this.compilerEnv.isIdeMode()) {
                s = "";
            } else {
                this.codeBug();
            }
        }
        Name name = new Name(beg, s);
        name.setLineno(lineno);
        if (checkActivation) {
            this.checkActivationName(s, token);
        }
        return name;
    }

    private StringLiteral createStringLiteral() {
        int pos = this.ts.tokenBeg;
        int end = this.ts.tokenEnd;
        StringLiteral s = new StringLiteral(pos, end - pos);
        s.setLineno(this.ts.lineno);
        s.setValue(this.ts.getString());
        s.setQuoteCharacter(this.ts.getQuoteChar());
        return s;
    }

    protected void checkActivationName(String name, int token) {
        if (!this.insideFunction()) {
            return;
        }
        boolean activation = false;
        if ("arguments".equals(name) && ((FunctionNode)this.currentScriptOrFn).getFunctionType() != 4) {
            activation = true;
        } else if (this.compilerEnv.getActivationNames() != null && this.compilerEnv.getActivationNames().contains(name)) {
            activation = true;
        } else if ("length".equals(name) && token == 34 && this.compilerEnv.getLanguageVersion() == 120) {
            activation = true;
        }
        if (activation) {
            this.setRequiresActivation();
        }
    }

    protected void setRequiresActivation() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresActivation();
        }
    }

    private void checkCallRequiresActivation(AstNode pn) {
        if (pn.getType() == 40 && "eval".equals(((Name)pn).getIdentifier()) || pn.getType() == 34 && "eval".equals(((PropertyGet)pn).getProperty().getIdentifier())) {
            this.setRequiresActivation();
        }
    }

    protected void setIsGenerator() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setIsGenerator();
        }
    }

    private void checkBadIncDec(UnaryExpression expr) {
        AstNode op = this.removeParens(expr.getOperand());
        int tt = op.getType();
        if (tt != 40 && tt != 34 && tt != 37 && tt != 71 && tt != 39) {
            this.reportError(expr.getType() == 107 ? "msg.bad.incr" : "msg.bad.decr");
        }
    }

    private ErrorNode makeErrorNode() {
        ErrorNode pn = new ErrorNode(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        pn.setLineno(this.ts.lineno);
        return pn;
    }

    private int nodeEnd(AstNode node) {
        return node.getPosition() + node.getLength();
    }

    private void saveNameTokenData(int pos, String name, int lineno) {
        this.prevNameTokenStart = pos;
        this.prevNameTokenString = name;
        this.prevNameTokenLineno = lineno;
    }

    private int lineBeginningFor(int pos) {
        if (this.sourceChars == null) {
            return -1;
        }
        if (pos <= 0) {
            return 0;
        }
        char[] buf = this.sourceChars;
        if (pos >= buf.length) {
            pos = buf.length - 1;
        }
        while (--pos >= 0) {
            char c = buf[pos];
            if (!ScriptRuntime.isJSLineTerminator(c)) continue;
            return pos + 1;
        }
        return 0;
    }

    private void warnMissingSemi(int pos, int end) {
        if (this.compilerEnv.isStrictMode()) {
            int beg;
            int[] linep = new int[2];
            String line = this.ts.getLine(end, linep);
            int n = beg = this.compilerEnv.isIdeMode() ? Math.max(pos, end - linep[1]) : pos;
            if (line != null) {
                this.addStrictWarning("msg.missing.semi", "", beg, end - beg, linep[0], line, linep[1]);
            } else {
                this.addStrictWarning("msg.missing.semi", "", beg, end - beg);
            }
        }
    }

    private void warnTrailingComma(int pos, List<?> elems, int commaPos) {
        if (this.compilerEnv.getWarnTrailingComma()) {
            if (!elems.isEmpty()) {
                pos = ((AstNode)elems.get(0)).getPosition();
            }
            pos = Math.max(pos, this.lineBeginningFor(commaPos));
            this.addWarning("msg.extra.trailing.comma", pos, commaPos - pos);
        }
    }

    Node createDestructuringAssignment(int type, Node left, Node right) {
        String tempName = this.currentScriptOrFn.getNextTempName();
        Node result = this.destructuringAssignmentHelper(type, left, right, tempName);
        Node comma = result.getLastChild();
        comma.addChildToBack(this.createName(tempName));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node destructuringAssignmentHelper(int variableType, Node left, Node right, String tempName) {
        Scope result = this.createScopeNode(163, left.getLineno());
        result.addChildToFront(new Node(158, this.createName(40, tempName, right)));
        try {
            this.pushScope(result);
            this.defineSymbol(158, tempName, true);
        }
        finally {
            this.popScope();
        }
        Node comma = new Node(86);
        result.addChildToBack(comma);
        ArrayList<String> destructuringNames = new ArrayList<String>();
        boolean empty = true;
        switch (left.getType()) {
            case 69: {
                empty = this.destructuringArray((ArrayLiteral)left, right, variableType, tempName, comma, destructuringNames);
                break;
            }
            case 70: {
                empty = this.destructuringObject((ObjectLiteral)left, variableType, tempName, comma, destructuringNames);
                break;
            }
            case 34: 
            case 37: {
                switch (variableType) {
                    case 131: 
                    case 158: 
                    case 159: {
                        this.reportError("msg.bad.assign.left");
                    }
                }
                comma.addChildToBack(this.simpleAssignment(left, this.createName(tempName)));
                break;
            }
            default: {
                this.reportError("msg.bad.assign.left");
            }
        }
        if (empty) {
            comma.addChildToBack(this.createNumber(0.0));
        }
        result.putProp(22, destructuringNames);
        return result;
    }

    boolean destructuringArray(ArrayLiteral left, Node right, int variableType, String tempName, Node parent, List<String> destructuringNames) {
        boolean empty = true;
        int setOp = variableType == 159 ? 160 : 8;
        int index = 0;
        for (AstNode n : left.getElements()) {
            if (n.getType() == 138) {
                ++index;
                continue;
            }
            Node rightElem = new Node(37, this.createName(tempName), this.createNumber(index));
            if (n.getProp(29) != null) {
                rightElem.putProp(29, new Object[]{index, right});
            }
            if (n.getType() == 40) {
                String name = n.getString();
                parent.addChildToBack(new Node(setOp, this.createName(52, name, null), rightElem));
                if (variableType != -1) {
                    this.defineSymbol(variableType, name, true);
                    destructuringNames.add(name);
                }
            } else if (n.getType() == 87) {
                Assignment assignment = (Assignment)n;
                String name = assignment.getLeft().getString();
                AstNode defaultExpr = this instanceof IRFactory ? ((IRFactory)this).transform(assignment.getRight()) : assignment.getRight();
                rightElem = new Node(125, rightElem, defaultExpr);
                parent.addChildToBack(new Node(setOp, this.createName(52, name, null), rightElem));
                if (variableType != -1) {
                    this.defineSymbol(variableType, name, true);
                    destructuringNames.add(name);
                }
            } else {
                parent.addChildToBack(this.destructuringAssignmentHelper(variableType, n, rightElem, this.currentScriptOrFn.getNextTempName()));
            }
            ++index;
            empty = false;
        }
        return empty;
    }

    boolean destructuringObject(ObjectLiteral node, int variableType, String tempName, Node parent, List<String> destructuringNames) {
        boolean empty = true;
        int setOp = variableType == 159 ? 160 : 8;
        ArrayList<Object> alreadyTaken = new ArrayList<Object>();
        for (ObjectProperty prop : node.getElements()) {
            Node rightElem;
            AstNode spread;
            int lineno = 0;
            if (this.ts != null) {
                lineno = this.ts.lineno;
            }
            if ((spread = prop.getSpread()) != null) {
                Node s = Node.newString(((Name)spread).getIdentifier());
                rightElem = new Node(110, this.createName(tempName), s);
                rightElem.putProp(32, alreadyTaken.toArray());
            } else {
                Node s;
                AstNode id = prop.getLeft();
                if (id.getProp(28) != null) {
                    if (this instanceof IRFactory) {
                        s = ((IRFactory)this).transform(id);
                        rightElem = new Node(37, this.createName(tempName), s);
                    } else {
                        rightElem = new Node(37, this.createName(tempName), id);
                    }
                } else if (id.getProp(29) != null) {
                    s = Node.newString(((Name)id).getIdentifier());
                    rightElem = new Node(110, this.createName(tempName), s);
                    rightElem.putProp(32, alreadyTaken.toArray());
                } else if (id instanceof Name) {
                    s = Node.newString(((Name)id).getIdentifier());
                    alreadyTaken.add(((Name)id).getIdentifier());
                    rightElem = new Node(34, this.createName(tempName), s);
                } else if (id instanceof StringLiteral) {
                    s = Node.newString(((StringLiteral)id).getValue());
                    alreadyTaken.add(((StringLiteral)id).getValue());
                    rightElem = new Node(34, this.createName(tempName), s);
                } else if (id instanceof NumberLiteral) {
                    s = this.createNumber((int)((NumberLiteral)id).getNumber());
                    alreadyTaken.add((int)((NumberLiteral)id).getNumber());
                    rightElem = new Node(37, this.createName(tempName), s);
                } else {
                    throw this.codeBug();
                }
            }
            rightElem.setLineno(lineno);
            AstNode value = spread != null ? spread : prop.getRight();
            AstNode defaultValue = prop.getDefaultValue();
            if (defaultValue != null) {
                AstNode defaultExpr = this instanceof IRFactory ? ((IRFactory)this).transform(defaultValue) : defaultValue;
                rightElem = new Node(125, rightElem, defaultExpr);
            }
            if (value.getType() == 40) {
                String name = ((Name)value).getIdentifier();
                parent.addChildToBack(new Node(setOp, this.createName(52, name, null), rightElem));
                if (variableType != -1) {
                    this.defineSymbol(variableType, name, true);
                    destructuringNames.add(name);
                }
            } else {
                parent.addChildToBack(this.destructuringAssignmentHelper(variableType, value, rightElem, this.currentScriptOrFn.getNextTempName()));
            }
            empty = false;
        }
        return empty;
    }

    protected Node createName(String name) {
        this.checkActivationName(name, 40);
        return Node.newString(40, name);
    }

    protected Node createName(int type, String name, Node child) {
        Node result = this.createName(name);
        result.setType(type);
        if (child != null) {
            result.addChildToBack(child);
        }
        return result;
    }

    protected Node createNumber(double number) {
        return Node.newNumber(number);
    }

    protected Scope createScopeNode(int token, int lineno) {
        Scope scope = new Scope();
        scope.setType(token);
        scope.setLineno(lineno);
        return scope;
    }

    protected Node simpleAssignment(Node left, Node right) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 40: {
                String name = ((Name)left).getIdentifier();
                if (this.inUseStrictDirective && ("eval".equals(name) || "arguments".equals(name))) {
                    this.reportError("msg.bad.id.strict", name);
                }
                left.setType(52);
                return new Node(8, left, right);
            }
            case 34: 
            case 37: {
                int type;
                Node id;
                Node obj;
                boolean isPrivate;
                boolean bl = isPrivate = left.getProp(34) != null;
                if (left instanceof PropertyGet) {
                    obj = ((PropertyGet)left).getTarget();
                    id = ((PropertyGet)left).getProperty();
                } else if (left instanceof ElementGet) {
                    obj = ((ElementGet)left).getTarget();
                    id = ((ElementGet)left).getElement();
                } else {
                    obj = left.getFirstChild();
                    id = left.getLastChild();
                }
                if (nodeType == 34) {
                    type = 36;
                    id.setType(42);
                } else {
                    type = 38;
                }
                Node node = new Node(type, obj, id, right);
                if (isPrivate) {
                    node.putProp(34, true);
                }
                return node;
            }
            case 71: {
                Node ref = left.getFirstChild();
                this.checkMutableReference(ref);
                return new Node(72, ref, right);
            }
        }
        throw this.codeBug();
    }

    protected void checkMutableReference(Node n) {
        int memberTypeFlags = n.getIntProp(16, 0);
        if ((memberTypeFlags & 4) != 0) {
            this.reportError("msg.bad.assign.left");
        }
    }

    protected AstNode removeParens(AstNode node) {
        while (node instanceof ParenthesizedExpression) {
            node = ((ParenthesizedExpression)node).getExpression();
        }
        return node;
    }

    void markDestructuring(AstNode node) {
        if (node instanceof DestructuringForm) {
            ((DestructuringForm)((Object)node)).setIsDestructuring(true);
        } else if (node instanceof ParenthesizedExpression) {
            this.markDestructuring(((ParenthesizedExpression)node).getExpression());
        }
    }

    private RuntimeException codeBug() throws RuntimeException {
        throw Kit.codeBug("ts.cursor=" + this.ts.cursor + ", ts.tokenBeg=" + this.ts.tokenBeg + ", currentToken=" + this.currentToken);
    }

    public void setDefaultUseStrictDirective(boolean useStrict) {
        this.defaultUseStrictDirective = useStrict;
    }

    public boolean inUseStrictDirective() {
        return this.inUseStrictDirective;
    }

    protected class PerFunctionVariables {
        private ScriptNode savedCurrentScriptOrFn;
        private Scope savedCurrentScope;
        private int savedEndFlags;
        private boolean savedInForInit;
        private Map<String, LabeledStatement> savedLabelSet;
        private List<Loop> savedLoopSet;
        private List<Jump> savedLoopAndSwitchSet;

        PerFunctionVariables(FunctionNode fnNode) {
            this.savedCurrentScriptOrFn = Parser.this.currentScriptOrFn;
            Parser.this.currentScriptOrFn = fnNode;
            this.savedCurrentScope = Parser.this.currentScope;
            Parser.this.currentScope = fnNode;
            this.savedLabelSet = Parser.this.labelSet;
            Parser.this.labelSet = null;
            this.savedLoopSet = Parser.this.loopSet;
            Parser.this.loopSet = null;
            this.savedLoopAndSwitchSet = Parser.this.loopAndSwitchSet;
            Parser.this.loopAndSwitchSet = null;
            this.savedEndFlags = Parser.this.endFlags;
            Parser.this.endFlags = 0;
            this.savedInForInit = Parser.this.inForInit;
            Parser.this.inForInit = false;
        }

        void restore() {
            Parser.this.currentScriptOrFn = this.savedCurrentScriptOrFn;
            Parser.this.currentScope = this.savedCurrentScope;
            Parser.this.labelSet = this.savedLabelSet;
            Parser.this.loopSet = this.savedLoopSet;
            Parser.this.loopAndSwitchSet = this.savedLoopAndSwitchSet;
            Parser.this.endFlags = this.savedEndFlags;
            Parser.this.inForInit = this.savedInForInit;
        }
    }

    private static class ConditionData {
        AstNode condition;
        int lp = -1;
        int rp = -1;

        private ConditionData() {
        }
    }

    private static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

