/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptNode tree, CompilerEnvirons env) {
        this.transform(tree, false, env);
    }

    public final void transform(ScriptNode tree, boolean inStrictMode, CompilerEnvirons env) {
        boolean useStrictMode = inStrictMode;
        if (env.getLanguageVersion() >= 200 && tree.isInStrictMode()) {
            useStrictMode = true;
        }
        this.transformCompilationUnit(tree, useStrictMode);
        for (int i = 0; i != tree.getFunctionCount(); ++i) {
            FunctionNode fn = tree.getFunctionNode(i);
            this.transform(fn, useStrictMode, env);
        }
    }

    private void transformCompilationUnit(ScriptNode tree, boolean inStrictMode) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        boolean createScopeObjects = tree.getType() != 114 || ((FunctionNode)tree).requiresActivation();
        tree.flattenSymbolTable(!createScopeObjects);
        this.transformCompilationUnit_r(tree, tree, tree, createScopeObjects, inStrictMode);
    }

    private void transformCompilationUnit_r(ScriptNode tree, Node parent, Scope scope, boolean createScopeObjects, boolean inStrictMode) {
        Node node = null;
        block18: while (true) {
            Scope newScope;
            Node previous = null;
            if (node == null) {
                node = parent.getFirstChild();
            } else {
                previous = node;
                node = node.getNext();
            }
            if (node == null) break;
            int type = node.getType();
            if (createScopeObjects && (type == 139 || type == 142 || type == 162) && node instanceof Scope && (newScope = (Scope)node).getSymbolTable() != null) {
                Node let = new Node(type == 162 ? 163 : 158);
                Node innerLet = new Node(158);
                let.addChildToBack(innerLet);
                for (String name : newScope.getSymbolTable().keySet()) {
                    innerLet.addChildToBack(Node.newString(40, name));
                }
                newScope.setSymbolTable(null);
                Node oldNode = node;
                node = NodeTransformer.replaceCurrent(parent, previous, node, let);
                type = node.getType();
                let.addChildToBack(oldNode);
            }
            switch (type) {
                case 123: 
                case 140: 
                case 142: {
                    this.loops.push(node);
                    this.loopEnds.push(((Jump)node).target);
                    break;
                }
                case 132: {
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 78: {
                    Jump jump = (Jump)node;
                    Node finallytarget = jump.getFinally();
                    if (finallytarget == null) break;
                    this.hasFinally = true;
                    this.loops.push(node);
                    this.loopEnds.push(finallytarget);
                    break;
                }
                case 3: 
                case 141: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 70: {
                    for (Object prop : (Object[])node.getProp(12)) {
                        Node propNode;
                        if (!(prop instanceof Node) || (propNode = (Node)prop).getProp(28) == null) continue;
                        Node parentNode = new Node(138, propNode);
                        this.transformCompilationUnit_r(tree, parentNode, scope, createScopeObjects, inStrictMode);
                        props[i] = parentNode.first;
                    }
                    break;
                }
                case 76: {
                    ((FunctionNode)tree).addResumptionPoint(node);
                    break;
                }
                case 4: {
                    Node n;
                    boolean isGenerator;
                    boolean bl = isGenerator = tree.getType() == 114 && ((FunctionNode)tree).isGenerator();
                    if (isGenerator) {
                        node.putIntProp(20, 1);
                    }
                    if (!this.hasFinally) break;
                    Node unwindBlock = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node unwind;
                        n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype != 78 && elemtype != 132) continue;
                        if (elemtype == 78) {
                            Node jsrtarget;
                            Jump jsrnode = new Jump(145);
                            jsrnode.target = jsrtarget = ((Jump)n).getFinally();
                            unwind = jsrnode;
                        } else {
                            unwind = new Node(3);
                        }
                        if (unwindBlock == null) {
                            unwindBlock = new Node(139, node.getLineno());
                        }
                        unwindBlock.addChildToBack(unwind);
                    }
                    if (unwindBlock == null) break;
                    Node returnNode = node;
                    Node returnExpr = returnNode.getFirstChild();
                    node = NodeTransformer.replaceCurrent(parent, previous, node, unwindBlock);
                    if (returnExpr == null || isGenerator) {
                        unwindBlock.addChildToBack(returnNode);
                        continue block18;
                    }
                    Node store = new Node(144, returnExpr);
                    unwindBlock.addChildToFront(store);
                    returnNode = new Node(68);
                    unwindBlock.addChildToBack(returnNode);
                    this.transformCompilationUnit_r(tree, store, scope, createScopeObjects, inStrictMode);
                    continue block18;
                }
                case 129: 
                case 130: {
                    Node n;
                    Jump jump = (Jump)node;
                    Jump jumpStatement = jump.getJumpStatement();
                    if (jumpStatement == null) {
                        Kit.codeBug();
                    }
                    int i = this.loops.size();
                    while (true) {
                        if (i == 0) {
                            throw Kit.codeBug();
                        }
                        if ((n = (Node)this.loops.get(--i)) == jumpStatement) break;
                        int elemtype = n.getType();
                        if (elemtype == 132) {
                            Node leave = new Node(3);
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, leave);
                            continue;
                        }
                        if (elemtype != 78) continue;
                        Jump tryNode = (Jump)n;
                        Jump jsrFinally = new Jump(145);
                        jsrFinally.target = tryNode.getFinally();
                        previous = NodeTransformer.addBeforeCurrent(parent, previous, node, jsrFinally);
                    }
                    jump.target = type == 129 ? jumpStatement.target : jumpStatement.getContinue();
                    jump.setType(5);
                    break;
                }
                case 39: {
                    this.visitCall(node, tree);
                    break;
                }
                case 31: {
                    this.visitNew(node, tree);
                    break;
                }
                case 158: 
                case 163: {
                    Node child = node.getFirstChild();
                    if (child.getType() == 158) {
                        boolean createWith = tree.getType() != 114 || ((FunctionNode)tree).requiresActivation();
                        node = this.visitLet(createWith, parent, previous, node);
                        break;
                    }
                }
                case 131: 
                case 159: {
                    Node result = new Node(139);
                    Node cursor = node.getFirstChild();
                    while (cursor != null) {
                        Node n = cursor;
                        cursor = cursor.getNext();
                        if (n.getType() == 40) {
                            if (!n.hasChildren()) continue;
                            Node init2 = n.getFirstChild();
                            n.removeChild(init2);
                            n.setType(52);
                            n = new Node(type == 159 ? 160 : 8, n, init2);
                        } else if (n.getType() != 163) {
                            throw Kit.codeBug();
                        }
                        Node pop = new Node(143, n, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    node = NodeTransformer.replaceCurrent(parent, previous, node, result);
                    break;
                }
                case 147: {
                    Scope defining = scope.getDefiningScope(node.getString());
                    if (defining == null) break;
                    node.setScope(defining);
                    break;
                }
                case 7: 
                case 33: {
                    Node child = node.getFirstChild();
                    if (type == 7) {
                        while (child.getType() == 27) {
                            child = child.getFirstChild();
                        }
                        if (child.getType() == 12 || child.getType() == 13) {
                            Node first = child.getFirstChild();
                            Node last = child.getLastChild();
                            if (first.getType() == 40 && first.getString().equals("undefined")) {
                                child = last;
                            } else if (last.getType() == 40 && last.getString().equals("undefined")) {
                                child = first;
                            }
                        }
                    }
                    if (child.getType() != 34) break;
                    child.setType(35);
                    break;
                }
                case 8: {
                    if (inStrictMode) {
                        node.setType(77);
                    }
                }
                case 32: 
                case 40: 
                case 160: {
                    String name;
                    Scope defining;
                    Node nameSource;
                    Node n;
                    if (createScopeObjects) break;
                    if (type == 40) {
                        nameSource = node;
                    } else {
                        nameSource = node.getFirstChild();
                        if (nameSource.getType() != 52) {
                            if (type == 32) break;
                            throw Kit.codeBug();
                        }
                    }
                    if (nameSource.getScope() != null || (defining = scope.getDefiningScope(name = nameSource.getString())) == null) break;
                    nameSource.setScope(defining);
                    if (type == 40) {
                        node.setType(58);
                        break;
                    }
                    if (type == 8 || type == 77) {
                        node.setType(59);
                        nameSource.setType(42);
                        break;
                    }
                    if (type == 160) {
                        node.setType(161);
                        nameSource.setType(42);
                        break;
                    }
                    if (type == 32) {
                        n = new Node(47);
                        node = NodeTransformer.replaceCurrent(parent, previous, node, n);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(tree, node, node instanceof Scope ? (Scope)node : scope, createScopeObjects, inStrictMode);
        }
    }

    protected void visitNew(Node node, ScriptNode tree) {
    }

    protected void visitCall(Node node, ScriptNode tree) {
    }

    protected Node visitLet(boolean createWith, Node parent, Node previous, Node scopeNode) {
        Node result;
        boolean isExpression;
        Node vars = scopeNode.getFirstChild();
        Node body = vars.getNext();
        scopeNode.removeChild(vars);
        scopeNode.removeChild(body);
        boolean bl = isExpression = scopeNode.getType() == 163;
        if (createWith) {
            result = new Node(isExpression ? 164 : 139);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            ArrayList<Object> list = new ArrayList<Object>();
            Node objectLiteral = new Node(70);
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                Node current = v;
                if (current.getType() == 163) {
                    List destructuringNames = (List)current.getProp(22);
                    Node c = current.getFirstChild();
                    if (c.getType() != 158) {
                        throw Kit.codeBug();
                    }
                    body = isExpression ? new Node(86, c.getNext(), body) : new Node(139, new Node(143, c.getNext()), body);
                    if (destructuringNames != null) {
                        list.addAll(destructuringNames);
                        for (int i = 0; i < destructuringNames.size(); ++i) {
                            objectLiteral.addChildToBack(new Node(136, Node.newNumber(0.0)));
                        }
                    }
                    current = c.getFirstChild();
                }
                if (current.getType() != 40) {
                    throw Kit.codeBug();
                }
                list.add(ScriptRuntime.getIndexObject(current.getString()));
                Node init2 = current.getFirstChild();
                if (init2 == null) {
                    init2 = new Node(136, Node.newNumber(0.0));
                }
                objectLiteral.addChildToBack(init2);
            }
            objectLiteral.putProp(12, list.toArray());
            Node newVars = new Node(2, objectLiteral);
            result.addChildToBack(newVars);
            result.addChildToBack(new Node(132, body));
            result.addChildToBack(new Node(3));
        } else {
            Scope scopeParent;
            result = new Node(isExpression ? 86 : 139);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            Node newVars = new Node(86);
            for (Node v = vars.getFirstChild(); v != null; v = v.getNext()) {
                Node current = v;
                if (current.getType() == 163) {
                    Node c = current.getFirstChild();
                    if (c.getType() != 158) {
                        throw Kit.codeBug();
                    }
                    body = isExpression ? new Node(86, c.getNext(), body) : new Node(139, new Node(143, c.getNext()), body);
                    Scope.joinScopes((Scope)current, (Scope)scopeNode);
                    current = c.getFirstChild();
                }
                if (current.getType() != 40) {
                    throw Kit.codeBug();
                }
                Node stringNode = Node.newString(current.getString());
                stringNode.setScope((Scope)scopeNode);
                Node init3 = current.getFirstChild();
                if (init3 == null) {
                    init3 = new Node(136, Node.newNumber(0.0));
                }
                newVars.addChildToBack(new Node(59, stringNode, init3));
            }
            if (isExpression) {
                result.addChildToBack(newVars);
                scopeNode.setType(86);
                result.addChildToBack(scopeNode);
                scopeNode.addChildToBack(body);
                if (body instanceof Scope) {
                    scopeParent = ((Scope)body).getParentScope();
                    ((Scope)body).setParentScope((Scope)scopeNode);
                    ((Scope)scopeNode).setParentScope(scopeParent);
                }
            } else {
                result.addChildToBack(new Node(143, newVars));
                scopeNode.setType(139);
                result.addChildToBack(scopeNode);
                scopeNode.addChildrenToBack(body);
                if (body instanceof Scope) {
                    scopeParent = ((Scope)body).getParentScope();
                    ((Scope)body).setParentScope((Scope)scopeNode);
                    ((Scope)scopeNode).setParentScope(scopeParent);
                }
            }
        }
        return result;
    }

    private static Node addBeforeCurrent(Node parent, Node previous, Node current, Node toAdd) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.addChildToFront(toAdd);
        } else {
            if (current != previous.getNext()) {
                Kit.codeBug();
            }
            parent.addChildAfter(toAdd, previous);
        }
        return toAdd;
    }

    private static Node replaceCurrent(Node parent, Node previous, Node current, Node replacement) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.replaceChild(current, replacement);
        } else if (previous.next == current) {
            parent.replaceChildAfter(previous, replacement);
        } else {
            parent.replaceChild(current, replacement);
        }
        return replacement;
    }
}

