/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeWeakMap
extends IdScriptableObject {
    private static final long serialVersionUID = 8670434366883930453L;
    private static final Object MAP_TAG = "WeakMap";
    private boolean instanceOfWeakMap = false;
    private transient WeakHashMap<Scriptable, Object> map = new WeakHashMap();
    private static final Object NULL_VALUE = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_delete = 2;
    private static final int Id_get = 3;
    private static final int Id_has = 4;
    private static final int Id_set = 5;
    private static final int Id_deleteAll = 6;
    private static final int Id_upsert = 7;
    private static final int SymbolId_toStringTag = 8;
    private static final int MAX_PROTOTYPE_ID = 8;

    static void init(Scriptable scope, boolean sealed) {
        NativeWeakMap m = new NativeWeakMap();
        m.exportAsJSClass(8, scope, sealed);
    }

    @Override
    public String getClassName() {
        return "WeakMap";
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(MAP_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj == null) {
                    NativeWeakMap nm = new NativeWeakMap();
                    nm.instanceOfWeakMap = true;
                    if (args.length > 0) {
                        NativeMap.loadFromIterable(cx, scope, nm, args[0]);
                    }
                    return nm;
                }
                throw ScriptRuntime.typeError1("msg.no.new", "WeakMap");
            }
            case 2: {
                return this.realThis(thisObj, f).js_delete(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 3: {
                return this.realThis(thisObj, f).js_get(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 4: {
                return this.realThis(thisObj, f).js_has(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 5: {
                return this.realThis(thisObj, f).js_set(args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance);
            }
            case 6: {
                return this.realThis(thisObj, f).js_deleteAll(args);
            }
            case 7: {
                return this.realThis(thisObj, f).js_upsert(cx, scope, args);
            }
        }
        throw new IllegalArgumentException("WeakMap.prototype has no method: " + f.getFunctionName());
    }

    private boolean js_delete(Object key) {
        if (!ScriptRuntime.isObject(key)) {
            return false;
        }
        Object oldVal = this.map.remove(key);
        return oldVal != null;
    }

    private Object js_get(Object key) {
        if (!ScriptRuntime.isObject(key)) {
            return Undefined.instance;
        }
        Object result = this.map.get(key);
        if (result == null) {
            return Undefined.instance;
        }
        if (result == NULL_VALUE) {
            return null;
        }
        return result;
    }

    private Object js_has(Object key) {
        if (!ScriptRuntime.isObject(key)) {
            return false;
        }
        return this.map.containsKey(key);
    }

    private Object js_set(Object key, Object v) {
        if (!ScriptRuntime.isObject(key)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(key));
        }
        Object value = v == null ? NULL_VALUE : v;
        this.map.put((Scriptable)key, value);
        return this;
    }

    private Object js_deleteAll(Object[] args) {
        for (Object arg : args) {
            this.js_delete(arg);
        }
        return this;
    }

    private Object js_upsert(Context cx, Scriptable scope, Object[] args) {
        Object insertFnObj;
        if (args.length == 0) {
            throw ScriptRuntime.typeError("Key must be specified for upsert");
        }
        if (args.length == 1) {
            throw ScriptRuntime.typeError("Update function must be specified for upsert");
        }
        Scriptable key = ScriptableObject.ensureScriptable(args[0]);
        Object updateFnObj = args[1];
        Object object = insertFnObj = args.length > 2 ? args[2] : null;
        if (!(updateFnObj instanceof Callable) && !(insertFnObj instanceof Callable)) {
            throw ScriptRuntime.typeError("The updater and inserter provided to upsert are both not functions");
        }
        Callable updateFn = updateFnObj instanceof Callable ? (Callable)updateFnObj : null;
        Callable insertFn = insertFnObj instanceof Callable ? (Callable)insertFnObj : null;
        for (Map.Entry<Scriptable, Object> en : this.map.entrySet()) {
            if (!ScriptRuntime.sameZero(en.getKey(), key)) continue;
            Object value = en.getValue();
            if (updateFn != null) {
                value = updateFn.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{value, key, this});
                this.map.put(key, value);
            }
            return value;
        }
        if (insertFn != null) {
            Object insertionValue = insertFn.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{key, this});
            this.map.put(key, insertionValue);
            return insertionValue;
        }
        return Undefined.instance;
    }

    private NativeWeakMap realThis(Scriptable thisObj, IdFunctionObject f) {
        if (thisObj == null) {
            throw NativeWeakMap.incompatibleCallError(f);
        }
        try {
            NativeWeakMap nm = (NativeWeakMap)ScriptRuntime.unwrapProxy(thisObj);
            if (!nm.instanceOfWeakMap) {
                throw NativeWeakMap.incompatibleCallError(f);
            }
            return nm;
        }
        catch (ClassCastException cce) {
            throw NativeWeakMap.incompatibleCallError(f);
        }
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        if (id == 8) {
            this.initPrototypeValue(8, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
            return;
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 0;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 1;
                s = "delete";
                break;
            }
            case 3: {
                arity = 1;
                s = "get";
                break;
            }
            case 4: {
                arity = 1;
                s = "has";
                break;
            }
            case 5: {
                arity = 2;
                s = "set";
                break;
            }
            case 6: {
                arity = 0;
                s = "deleteAll";
                break;
            }
            case 7: {
                arity = 3;
                s = "upsert";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(MAP_TAG, id, s, fnName, arity);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 8;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'g') {
                    if (s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                    return 3;
                }
                if (c == 'h') {
                    if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                    return 4;
                }
                if (c != 's' || s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                return 5;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'd') {
                    X = "delete";
                    id = 2;
                    break;
                }
                if (c != 'u') break;
                X = "upsert";
                id = 7;
                break;
            }
            case 9: {
                X = "deleteAll";
                id = 6;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.map = new WeakHashMap();
    }
}

