/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.Hashtable;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.NativeCollectionIterator;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSet
extends IdScriptableObject {
    private static final long serialVersionUID = -8442212766987072986L;
    private static final Object SET_TAG = "Set";
    static final String ITERATOR_TAG = "Set Iterator";
    static final SymbolKey GETSIZE = new SymbolKey("[Symbol.getSize]");
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfSet = false;
    private static final int Id_constructor = 1;
    private static final int Id_add = 2;
    private static final int Id_delete = 3;
    private static final int Id_has = 4;
    private static final int Id_clear = 5;
    private static final int Id_keys = 6;
    private static final int Id_values = 6;
    private static final int Id_entries = 7;
    private static final int Id_forEach = 8;
    private static final int Id_addAll = 9;
    private static final int Id_deleteAll = 10;
    private static final int Id_every = 11;
    private static final int Id_filter = 12;
    private static final int Id_find = 13;
    private static final int Id_join = 14;
    private static final int Id_map = 15;
    private static final int Id_reduce = 16;
    private static final int Id_some = 17;
    private static final int Id_intersection = 18;
    private static final int Id_union = 19;
    private static final int Id_difference = 20;
    private static final int Id_symmetricDifference = 21;
    private static final int Id_isDisjointFrom = 22;
    private static final int Id_isSubsetOf = 23;
    private static final int Id_isSupersetOf = 24;
    private static final int SymbolId_getSize = 25;
    private static final int SymbolId_toStringTag = 26;
    private static final int MAX_PROTOTYPE_ID = 26;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeSet obj = new NativeSet();
        obj.exportAsJSClass(26, scope, false);
        NativeObject desc = cx.newObject(scope);
        desc.put("enumerable", (Scriptable)desc, (Object)false);
        desc.put("configurable", (Scriptable)desc, (Object)true);
        desc.put("get", (Scriptable)desc, obj.get(GETSIZE, (Scriptable)obj));
        obj.defineOwnProperty(cx, "size", desc);
        if (sealed) {
            obj.sealObject();
        }
    }

    @Override
    public String getClassName() {
        return "Set";
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addCtorSpecies(ctor);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(SET_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return this.js_constructor(cx, scope, thisObj, args.length > 0 ? args[0] : Undefined.instance);
            }
            case 2: {
                return this.realThis(thisObj, f).js_add(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 3: {
                return this.realThis(thisObj, f).js_delete(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 4: {
                return this.realThis(thisObj, f).js_has(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 5: {
                return this.realThis(thisObj, f).js_clear();
            }
            case 6: {
                return this.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.VALUES);
            }
            case 7: {
                return this.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.BOTH);
            }
            case 8: {
                return this.realThis(thisObj, f).js_forEach(cx, scope, args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance);
            }
            case 9: {
                return this.realThis(thisObj, f).js_addAll(args);
            }
            case 10: {
                return this.realThis(thisObj, f).js_deleteAll(args);
            }
            case 11: {
                return this.realThis(thisObj, f).js_every(cx, scope, args);
            }
            case 12: {
                return this.realThis(thisObj, f).js_filter(cx, scope, args);
            }
            case 13: {
                return this.realThis(thisObj, f).js_find(cx, scope, args);
            }
            case 14: {
                return this.realThis(thisObj, f).js_join(args);
            }
            case 15: {
                return this.realThis(thisObj, f).js_map(cx, scope, args);
            }
            case 16: {
                return this.realThis(thisObj, f).js_reduce(cx, scope, args);
            }
            case 17: {
                return this.realThis(thisObj, f).js_some(cx, scope, args);
            }
            case 18: {
                return this.realThis(thisObj, f).js_intersection(cx, scope, args);
            }
            case 19: {
                return this.realThis(thisObj, f).js_union(cx, scope, args);
            }
            case 20: {
                return this.realThis(thisObj, f).js_difference(cx, scope, args);
            }
            case 21: {
                return this.realThis(thisObj, f).js_symmetricDifference(cx, scope, args);
            }
            case 22: {
                return this.realThis(thisObj, f).js_isDisjointFrom(cx, scope, args);
            }
            case 23: {
                return this.realThis(thisObj, f).js_isSubsetOf(cx, scope, args);
            }
            case 24: {
                return this.realThis(thisObj, f).js_isSupersetOf(cx, scope, args);
            }
            case 25: {
                return this.realThis(thisObj, f).js_getSize();
            }
        }
        throw new IllegalArgumentException("Set.prototype has no method: " + f.getFunctionName());
    }

    private NativeSet js_constructor(Context cx, Scriptable scope, Scriptable thisObj, Object arg) {
        if (thisObj == null) {
            NativeSet ns = new NativeSet();
            ns.instanceOfSet = true;
            NativeSet.loadFromIterable(cx, scope, ns, arg);
            return ns;
        }
        throw ScriptRuntime.typeError1("msg.no.new", "Set");
    }

    private Object js_add(Object k) {
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = 0.0;
        }
        this.entries.put(key, key);
        return this;
    }

    private boolean js_delete(Object arg) {
        Object ov = this.entries.delete(arg);
        return ov != null;
    }

    private boolean js_has(Object arg) {
        return this.entries.has(arg);
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private NativeCollectionIterator js_iterator(Scriptable scope, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(arg1);
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        Iterator<Hashtable.Entry> i = this.entries.iterator();
        while (i.hasNext()) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = i.next();
            f.call(cx, scope, thisObj, new Object[]{e.value, e.value, this});
        }
        return Undefined.instance;
    }

    private Object js_addAll(Object[] args) {
        for (Object arg : args) {
            this.js_add(arg);
        }
        return this;
    }

    private Object js_deleteAll(Object[] args) {
        boolean allDeleted = true;
        for (Object arg : args) {
            allDeleted &= this.js_delete(arg);
        }
        return allDeleted;
    }

    private Object js_every(Context cx, Scriptable scope, Object[] args) {
        Object arg1;
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg0;
        Scriptable thisObj = arg1 instanceof Scriptable ? (Scriptable)arg1 : Undefined.SCRIPTABLE_UNDEFINED;
        for (Hashtable.Entry en : this.entries) {
            Object result = cb.call(cx, scope, thisObj, new Object[]{en.key, en.key, this});
            if (ScriptRuntime.toBoolean(result)) continue;
            return false;
        }
        return true;
    }

    private Object js_filter(Context cx, Scriptable scope, Object[] args) {
        Object arg1;
        BaseFunction species = NativeSet.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeSet set = (NativeSet)species.construct(cx, scope, new Object[0]);
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg0;
        Scriptable thisObj = arg1 instanceof Scriptable ? (Scriptable)arg1 : Undefined.SCRIPTABLE_UNDEFINED;
        for (Hashtable.Entry en : this.entries) {
            Object result = cb.call(cx, scope, thisObj, new Object[]{en.key, en.key, this});
            if (!ScriptRuntime.toBoolean(result)) continue;
            set.entries.put(en.key, en.key);
        }
        return set;
    }

    private Object js_find(Context cx, Scriptable scope, Object[] args) {
        Object arg1;
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg0;
        Scriptable thisObj = arg1 instanceof Scriptable ? (Scriptable)arg1 : Undefined.SCRIPTABLE_UNDEFINED;
        for (Hashtable.Entry en : this.entries) {
            Object result = cb.call(cx, scope, thisObj, new Object[]{en.key, en.key, this});
            if (!ScriptRuntime.toBoolean(result)) continue;
            return en.key;
        }
        return Undefined.instance;
    }

    private Object js_join(Object[] args) {
        String separator = args.length > 0 ? ScriptRuntime.toString(args[0]) : ",";
        StringBuilder sb = new StringBuilder();
        for (Hashtable.Entry en : this.entries) {
            sb.append(ScriptRuntime.toString(en.key)).append(separator);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private Object js_map(Context cx, Scriptable scope, Object[] args) {
        Object arg1;
        BaseFunction species = NativeSet.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeSet set = (NativeSet)species.construct(cx, scope, new Object[0]);
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg0;
        Scriptable thisObj = arg1 instanceof Scriptable ? (Scriptable)arg1 : Undefined.SCRIPTABLE_UNDEFINED;
        for (Hashtable.Entry en : this.entries) {
            Object result = cb.call(cx, scope, thisObj, new Object[]{en.key, en.key, this});
            set.entries.put(result, result);
        }
        return set;
    }

    private Object js_reduce(Context cx, Scriptable scope, Object[] args) {
        Object arg0;
        Object object = arg0 = args.length == 0 ? Undefined.instance : args[0];
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(arg0));
        }
        Callable cb = (Callable)arg0;
        Object accumulator = args.length > 1 ? args[1] : Undefined.instance;
        boolean first = true;
        for (Hashtable.Entry en : this.entries) {
            accumulator = first && Undefined.isUndefined(accumulator) ? en.value : cb.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{accumulator, en.key, en.key, this});
            first = false;
        }
        if (first && Undefined.isUndefined(accumulator)) {
            throw ScriptRuntime.typeError("Map is empty and no accumulator was provided to the reduce method");
        }
        return accumulator;
    }

    private Object js_some(Context cx, Scriptable scope, Object[] args) {
        Object arg1;
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg0;
        Scriptable thisObj = arg1 instanceof Scriptable ? (Scriptable)arg1 : Undefined.SCRIPTABLE_UNDEFINED;
        for (Hashtable.Entry en : this.entries) {
            Object result = cb.call(cx, scope, thisObj, new Object[]{en.key, en.key, this});
            if (!ScriptRuntime.toBoolean(result)) continue;
            return true;
        }
        return false;
    }

    private Object js_intersection(Context cx, Scriptable scope, Object[] args) {
        BaseFunction species = NativeSet.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeSet set = (NativeSet)species.construct(cx, scope, new Object[0]);
        Object arg0 = args.length == 0 ? null : args[0];
        ES6Iterator it = ScriptRuntime.toIterator(cx, scope, ScriptableObject.ensureScriptable(arg0), false);
        while (!it.isDone(cx, scope)) {
            Object value = it.nextValue(cx, scope);
            if (!this.js_has(value)) continue;
            set.js_add(value);
        }
        return set;
    }

    private Object js_union(Context cx, Scriptable scope, Object[] args) {
        BaseFunction species = NativeSet.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeSet set = (NativeSet)species.construct(cx, scope, new Object[0]);
        ES6Iterator it = ScriptRuntime.toIterator(cx, scope, args.length > 0 ? ScriptableObject.ensureScriptable(args[0]) : null, false);
        for (Hashtable.Entry en : this.entries) {
            set.entries.put(en.key, en.key);
        }
        while (!it.isDone(cx, scope)) {
            Object value = it.nextValue(cx, scope);
            set.entries.put(value, value);
        }
        return set;
    }

    private Object js_difference(Context cx, Scriptable scope, Object[] args) {
        BaseFunction species = NativeSet.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeSet set = (NativeSet)species.construct(cx, scope, new Object[0]);
        for (Hashtable.Entry en : this.entries) {
            set.entries.put(en.key, en.key);
        }
        Object arg0 = args.length == 0 ? null : args[0];
        ES6Iterator it = ScriptRuntime.toIterator(cx, scope, ScriptableObject.ensureScriptable(arg0), false);
        while (!it.isDone(cx, scope)) {
            Object value = it.nextValue(cx, scope);
            set.js_delete(value);
        }
        return set;
    }

    private Object js_symmetricDifference(Context cx, Scriptable scope, Object[] args) {
        BaseFunction species = NativeSet.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeSet set = (NativeSet)species.construct(cx, scope, new Object[0]);
        for (Hashtable.Entry en : this.entries) {
            set.entries.put(en.key, en.key);
        }
        Object arg0 = args.length == 0 ? null : args[0];
        ES6Iterator it = ScriptRuntime.toIterator(cx, scope, ScriptableObject.ensureScriptable(arg0), false);
        while (!it.isDone(cx, scope)) {
            Object value = it.nextValue(cx, scope);
            boolean removed = set.js_delete(value);
            if (removed) continue;
            set.js_add(value);
        }
        return set;
    }

    private Object js_isDisjointFrom(Context cx, Scriptable scope, Object[] args) {
        Object arg0 = args.length == 0 ? null : args[0];
        ES6Iterator it = ScriptRuntime.toIterator(cx, scope, ScriptableObject.ensureScriptable(arg0), false);
        while (!it.isDone(cx, scope)) {
            Object value = it.nextValue(cx, scope);
            if (!this.js_has(value)) continue;
            return false;
        }
        return true;
    }

    private Object js_isSubsetOf(Context cx, Scriptable scope, Object[] args) {
        Object arg0;
        Object object = arg0 = args.length == 0 ? null : args[0];
        if (!(arg0 instanceof NativeSet)) {
            arg0 = this.js_constructor(cx, scope, null, arg0);
        }
        NativeSet other = (NativeSet)arg0;
        for (Hashtable.Entry en : this.entries) {
            if (other.entries.has(en.key)) continue;
            return false;
        }
        return true;
    }

    private Object js_isSupersetOf(Context cx, Scriptable scope, Object[] args) {
        Object arg0;
        Object object = arg0 = args.length == 0 ? null : args[0];
        if (!(arg0 instanceof NativeSet)) {
            arg0 = this.js_constructor(cx, scope, null, arg0);
        }
        NativeSet other = (NativeSet)arg0;
        for (Hashtable.Entry en : other.entries) {
            if (this.entries.has(en.key)) continue;
            return false;
        }
        return true;
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject set, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(arg1, cx, scope);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        ScriptableObject dummy = NativeSet.ensureScriptableObject(cx.newObject(scope, set.getClassName()));
        Callable add = ScriptRuntime.getPropFunctionAndThis(dummy.getPrototype(), "add", cx, scope);
        ScriptRuntime.lastStoredScriptable(cx);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, ito);){
            for (Object val : it) {
                Object finalVal = val == Scriptable.NOT_FOUND ? Undefined.instance : val;
                add.call(cx, scope, set, new Object[]{finalVal});
            }
        }
    }

    private NativeSet realThis(Scriptable thisObj, IdFunctionObject f) {
        if (thisObj == null) {
            throw NativeSet.incompatibleCallError(f);
        }
        try {
            NativeSet ns = (NativeSet)ScriptRuntime.unwrapProxy(thisObj);
            if (!ns.instanceOfSet) {
                throw NativeSet.incompatibleCallError(f);
            }
            return ns;
        }
        catch (ClassCastException cce) {
            throw NativeSet.incompatibleCallError(f);
        }
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 25: {
                this.initPrototypeMethod(SET_TAG, id, GETSIZE, "get size", 0);
                return;
            }
            case 26: {
                this.initPrototypeValue(26, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 0;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 1;
                s = "add";
                break;
            }
            case 3: {
                arity = 1;
                s = "delete";
                break;
            }
            case 4: {
                arity = 1;
                s = "has";
                break;
            }
            case 5: {
                arity = 0;
                s = "clear";
                break;
            }
            case 7: {
                arity = 0;
                s = "entries";
                break;
            }
            case 6: {
                arity = 0;
                s = "values";
                break;
            }
            case 8: {
                arity = 1;
                s = "forEach";
                break;
            }
            case 9: {
                arity = 0;
                s = "addAll";
                break;
            }
            case 10: {
                arity = 1;
                s = "deleteAll";
                break;
            }
            case 11: {
                arity = 1;
                s = "every";
                break;
            }
            case 12: {
                arity = 1;
                s = "filter";
                break;
            }
            case 13: {
                arity = 1;
                s = "find";
                break;
            }
            case 14: {
                arity = 1;
                s = "join";
                break;
            }
            case 15: {
                arity = 1;
                s = "map";
                break;
            }
            case 16: {
                arity = 1;
                s = "reduce";
                break;
            }
            case 17: {
                arity = 1;
                s = "some";
                break;
            }
            case 18: {
                arity = 1;
                s = "intersection";
                break;
            }
            case 19: {
                arity = 1;
                s = "union";
                break;
            }
            case 20: {
                arity = 1;
                s = "difference";
                break;
            }
            case 21: {
                arity = 1;
                s = "symmetricDifference";
                break;
            }
            case 22: {
                arity = 1;
                s = "isDisjointFrom";
                break;
            }
            case 23: {
                arity = 1;
                s = "isSubsetOf";
                break;
            }
            case 24: {
                arity = 1;
                s = "isSupersetOf";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(SET_TAG, id, s, fnName, arity);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (GETSIZE.equals(k)) {
            return 25;
        }
        if (SymbolKey.ITERATOR.equals(k)) {
            return 6;
        }
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 26;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'a') {
                    if (s.charAt(2) != 'd' || s.charAt(1) != 'd') break;
                    return 2;
                }
                if (c == 'h') {
                    if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                    return 4;
                }
                if (c != 'm' || s.charAt(2) != 'p' || s.charAt(1) != 'a') break;
                return 15;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'f': {
                        X = "find";
                        id = 13;
                        break block0;
                    }
                    case 'j': {
                        X = "join";
                        id = 14;
                        break block0;
                    }
                    case 'k': {
                        X = "keys";
                        id = 6;
                        break block0;
                    }
                    case 's': {
                        X = "some";
                        id = 17;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "clear";
                    id = 5;
                    break;
                }
                if (c == 'e') {
                    X = "every";
                    id = 11;
                    break;
                }
                if (c != 'u') break;
                X = "union";
                id = 19;
                break;
            }
            case 6: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "addAll";
                        id = 9;
                        break block0;
                    }
                    case 'd': {
                        X = "delete";
                        id = 3;
                        break block0;
                    }
                    case 'f': {
                        X = "filter";
                        id = 12;
                        break block0;
                    }
                    case 'r': {
                        X = "reduce";
                        id = 16;
                        break block0;
                    }
                    case 'v': {
                        X = "values";
                        id = 6;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'e') {
                    X = "entries";
                    id = 7;
                    break;
                }
                if (c != 'f') break;
                X = "forEach";
                id = 8;
                break;
            }
            case 9: {
                X = "deleteAll";
                id = 10;
                break;
            }
            case 10: {
                char c = s.charAt(0);
                if (c == 'd') {
                    X = "difference";
                    id = 20;
                    break;
                }
                if (c != 'i') break;
                X = "isSubsetOf";
                id = 23;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
            case 12: {
                char c = s.charAt(1);
                if (c == 'n') {
                    X = "intersection";
                    id = 18;
                    break;
                }
                if (c != 's') break;
                X = "isSupersetOf";
                id = 24;
                break;
            }
            case 14: {
                X = "isDisjointFrom";
                id = 22;
                break;
            }
            case 19: {
                X = "symmetricDifference";
                id = 21;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

