/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.Hashtable;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCollectionIterator;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeSet;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeMap
extends IdScriptableObject {
    private static final long serialVersionUID = 1171922614280016891L;
    private static final Object MAP_TAG = "Map";
    static final String ITERATOR_TAG = "Map Iterator";
    private static final Object NULL_VALUE = new Object();
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfMap = false;
    private static final int ConstructorId_groupBy = -1;
    private static final int ConstructorId_keyBy = -2;
    private static final int Id_constructor = 1;
    private static final int Id_set = 2;
    private static final int Id_get = 3;
    private static final int Id_delete = 4;
    private static final int Id_has = 5;
    private static final int Id_clear = 6;
    private static final int Id_keys = 7;
    private static final int Id_values = 8;
    private static final int Id_entries = 9;
    private static final int Id_forEach = 10;
    private static final int Id_mapKeys = 11;
    private static final int Id_mapValues = 12;
    private static final int Id_keyOf = 13;
    private static final int Id_includes = 14;
    private static final int Id_find = 15;
    private static final int Id_findKey = 16;
    private static final int Id_some = 17;
    private static final int Id_every = 18;
    private static final int Id_reduce = 19;
    private static final int Id_deleteAll = 20;
    private static final int Id_update = 21;
    private static final int Id_filter = 22;
    private static final int Id_merge = 23;
    private static final int Id_upsert = 24;
    private static final int SymbolId_getSize = 25;
    private static final int SymbolId_toStringTag = 26;
    private static final int MAX_PROTOTYPE_ID = 26;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeMap obj = new NativeMap();
        obj.exportAsJSClass(26, scope, false);
        NativeObject desc = cx.newObject(scope);
        desc.put("enumerable", (Scriptable)desc, (Object)false);
        desc.put("configurable", (Scriptable)desc, (Object)true);
        desc.put("get", (Scriptable)desc, obj.get(NativeSet.GETSIZE, (Scriptable)obj));
        obj.defineOwnProperty(cx, "size", desc);
        if (sealed) {
            obj.sealObject();
        }
    }

    @Override
    public String getClassName() {
        return "Map";
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, MAP_TAG, -1, "groupBy", 1);
        this.addIdFunctionProperty(ctor, MAP_TAG, -2, "keyBy", 1);
        this.addCtorSpecies(ctor);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(MAP_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case -1: {
                return this.js_groupBy(cx, scope, args);
            }
            case -2: {
                return this.js_keyBy(cx, scope, args);
            }
            case 1: {
                return this.js_construct(cx, scope, thisObj, args);
            }
            case 2: {
                return this.realThis(thisObj, f).js_set(args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance);
            }
            case 4: {
                return this.realThis(thisObj, f).js_delete(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 3: {
                return this.realThis(thisObj, f).js_get(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 5: {
                return this.realThis(thisObj, f).js_has(args.length > 0 ? args[0] : Undefined.instance);
            }
            case 6: {
                return this.realThis(thisObj, f).js_clear();
            }
            case 7: {
                return this.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.KEYS);
            }
            case 8: {
                return this.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.VALUES);
            }
            case 9: {
                return this.realThis(thisObj, f).js_iterator(scope, NativeCollectionIterator.Type.BOTH);
            }
            case 10: {
                return this.realThis(thisObj, f).js_forEach(cx, scope, args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance);
            }
            case 11: 
            case 12: {
                return this.realThis(thisObj, f).js_map(cx, scope, args, id == 11);
            }
            case 13: {
                return this.realThis(thisObj, f).js_keyOf(args);
            }
            case 14: {
                return this.realThis(thisObj, f).js_includes(args);
            }
            case 15: 
            case 16: {
                return this.realThis(thisObj, f).js_find(cx, scope, args, id == 16);
            }
            case 17: {
                return this.realThis(thisObj, f).js_some(cx, scope, args);
            }
            case 18: {
                return this.realThis(thisObj, f).js_every(cx, scope, args);
            }
            case 19: {
                return this.realThis(thisObj, f).js_reduce(cx, scope, args);
            }
            case 20: {
                return this.realThis(thisObj, f).js_deleteAll(args);
            }
            case 21: {
                return this.realThis(thisObj, f).js_update(cx, scope, args);
            }
            case 22: {
                return this.realThis(thisObj, f).js_filter(cx, scope, args);
            }
            case 23: {
                return this.realThis(thisObj, f).js_merge(cx, scope, args);
            }
            case 24: {
                return this.realThis(thisObj, f).js_upsert(cx, scope, args);
            }
            case 25: {
                return this.realThis(thisObj, f).js_getSize();
            }
        }
        throw new IllegalArgumentException("Map.prototype has no method: " + f.getFunctionName());
    }

    private NativeMap js_construct(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (thisObj == null) {
            NativeMap nm = new NativeMap();
            nm.instanceOfMap = true;
            if (args.length > 0) {
                NativeMap.loadFromIterable(cx, scope, nm, args[0]);
            }
            return nm;
        }
        throw ScriptRuntime.typeError1("msg.no.new", "Map");
    }

    private Object js_groupBy(Context cx, Scriptable scope, Object[] args) {
        Object next;
        Object arg1;
        BaseFunction species = NativeMap.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeMap map = (NativeMap)species.construct(cx, scope, new Object[0]);
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg1;
        ES6Iterator iterator = ScriptRuntime.toIterator(cx, scope, ScriptableObject.ensureScriptable(arg0), false);
        while ((next = iterator.next(cx, scope)) instanceof Scriptable && !ScriptRuntime.toBoolean(ScriptableObject.getProperty((Scriptable)next, "done"))) {
            Object item = ScriptableObject.getProperty((Scriptable)next, "value");
            Object key = cb.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{item});
            boolean entryWasFound = false;
            for (Hashtable.Entry en : map.entries) {
                if (!ScriptRuntime.sameZero(en.key, key)) continue;
                Object grouped = en.value;
                if (!(grouped instanceof NativeArray)) {
                    throw Kit.codeBug("Expected grouped to be a NativeArray");
                }
                ScriptableObject.callMethod((NativeArray)grouped, "push", new Object[]{item});
                entryWasFound = true;
            }
            if (entryWasFound) continue;
            NativeArray groupedList = cx.newArray(scope, new Object[]{item});
            map.entries.put(key, groupedList);
        }
        return map;
    }

    private Object js_keyBy(Context cx, Scriptable scope, Object[] args) {
        Object next;
        Object arg1;
        BaseFunction species = NativeMap.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeMap map = (NativeMap)species.construct(cx, scope, new Object[0]);
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg1;
        ES6Iterator iterator = ScriptRuntime.toIterator(cx, scope, ScriptableObject.ensureScriptable(arg0), false);
        while ((next = iterator.next(cx, scope)) instanceof Scriptable && !ScriptRuntime.toBoolean(ScriptableObject.getProperty((Scriptable)next, "done"))) {
            Object item = ScriptableObject.getProperty((Scriptable)next, "value");
            Object key = cb.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{item});
            map.entries.put(key, item);
        }
        return map;
    }

    private Object js_set(Object k, Object v) {
        Object value = v == null ? NULL_VALUE : v;
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = 0.0;
        }
        this.entries.put(key, value);
        return this;
    }

    private Object js_delete(Object arg) {
        Object e = this.entries.delete(arg);
        return e != null;
    }

    private Object js_get(Object arg) {
        Object val = this.entries.get(arg);
        if (val == null) {
            return Undefined.instance;
        }
        if (val == NULL_VALUE) {
            return null;
        }
        return val;
    }

    private boolean js_has(Object arg) {
        return this.entries.has(arg);
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeError2("msg.isnt.function.it.is", arg1, ScriptRuntime.typeof(arg1));
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        Iterator<Hashtable.Entry> i = this.entries.iterator();
        while (i.hasNext()) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = i.next();
            Object val = e.value;
            if (val == NULL_VALUE) {
                val = null;
            }
            f.call(cx, scope, thisObj, new Object[]{val, e.key, this});
        }
        return Undefined.instance;
    }

    private Object js_map(Context cx, Scriptable scope, Object[] args, boolean keys) {
        Object cb;
        Object object = cb = args.length > 0 ? args[0] : null;
        if (!(cb instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable callback = (Callable)cb;
        BaseFunction species = NativeMap.getSpecies(this);
        if (species == null) {
            throw Kit.codeBug();
        }
        NativeMap nm = (NativeMap)species.construct(cx, scope, new Object[0]);
        for (Hashtable.Entry en : this.entries) {
            if (keys) {
                nm.entries.put(callback.call(cx, scope, this, new Object[]{en.value, en.key, this}), en.value);
                continue;
            }
            nm.entries.put(en.key, callback.call(cx, scope, this, new Object[]{en.value, en.key, this}));
        }
        return nm;
    }

    private Object js_keyOf(Object[] args) {
        Object searchElement = args.length > 0 ? args[0] : Undefined.instance;
        for (Hashtable.Entry en : this.entries) {
            if (!ScriptRuntime.shallowEq(searchElement, en.value)) continue;
            return en.key;
        }
        return Undefined.instance;
    }

    private Object js_includes(Object[] args) {
        Object searchElement = args.length > 0 ? args[0] : Undefined.instance;
        for (Hashtable.Entry en : this.entries) {
            if (!ScriptRuntime.sameZero(searchElement, en.value)) continue;
            return true;
        }
        return false;
    }

    private Object js_find(Context cx, Scriptable scope, Object[] args, boolean key) {
        Object thisObj;
        Object arg0;
        Object object = arg0 = args.length == 0 ? null : args[0];
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(arg0));
        }
        Callable cb = (Callable)arg0;
        Object object2 = thisObj = args.length > 1 ? args[1] : null;
        if (!(thisObj instanceof Scriptable)) {
            thisObj = Undefined.SCRIPTABLE_UNDEFINED;
        }
        for (Hashtable.Entry en : this.entries) {
            boolean result = ScriptRuntime.toBoolean(cb.call(cx, scope, (Scriptable)thisObj, new Object[]{en.value, en.key, this}));
            if (!result) continue;
            return key ? en.key : en.value;
        }
        return Undefined.instance;
    }

    private boolean js_some(Context cx, Scriptable scope, Object[] args) {
        Object thisObj;
        Object arg0;
        Object object = arg0 = args.length == 0 ? null : args[0];
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(arg0));
        }
        Callable cb = (Callable)arg0;
        Object object2 = thisObj = args.length > 1 ? args[1] : null;
        if (!(thisObj instanceof Scriptable)) {
            thisObj = Undefined.SCRIPTABLE_UNDEFINED;
        }
        for (Hashtable.Entry en : this.entries) {
            boolean result = ScriptRuntime.toBoolean(cb.call(cx, scope, (Scriptable)thisObj, new Object[]{en.value, en.key, this}));
            if (!result) continue;
            return true;
        }
        return false;
    }

    private Object js_every(Context cx, Scriptable scope, Object[] args) {
        Object thisObj;
        Object arg0;
        Object object = arg0 = args.length == 0 ? null : args[0];
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(arg0));
        }
        Callable cb = (Callable)arg0;
        Object object2 = thisObj = args.length > 1 ? args[1] : null;
        if (!(thisObj instanceof Scriptable)) {
            thisObj = Undefined.SCRIPTABLE_UNDEFINED;
        }
        for (Hashtable.Entry en : this.entries) {
            boolean result = ScriptRuntime.toBoolean(cb.call(cx, scope, (Scriptable)thisObj, new Object[]{en.value, en.key, this}));
            if (result) continue;
            return false;
        }
        return true;
    }

    private Object js_reduce(Context cx, Scriptable scope, Object[] args) {
        Object arg0;
        Object object = arg0 = args.length == 0 ? Undefined.instance : args[0];
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(arg0));
        }
        Callable cb = (Callable)arg0;
        Object accumulator = args.length > 1 ? args[1] : Undefined.instance;
        boolean first = true;
        for (Hashtable.Entry en : this.entries) {
            accumulator = first && Undefined.isUndefined(accumulator) ? en.value : cb.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{accumulator, en.value, en.key, this});
            first = false;
        }
        if (first && Undefined.isUndefined(accumulator)) {
            throw ScriptRuntime.typeError("Map is empty and no accumulator was provided to the reduce method");
        }
        return accumulator;
    }

    private Object js_deleteAll(Object[] args) {
        for (Object arg : args) {
            this.js_delete(arg);
        }
        return this;
    }

    private Object js_update(Context cx, Scriptable scope, Object[] args) {
        Object arg2;
        Object key = args.length == 0 ? Undefined.instance : args[0];
        Object arg1 = args.length > 1 ? args[1] : Undefined.instance;
        Object object = arg2 = args.length > 2 ? args[2] : Undefined.instance;
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeError1("msg.object.not.callable", ScriptRuntime.toString(arg1));
        }
        Callable cb = (Callable)arg1;
        Callable thunk = arg2 instanceof Callable ? (Callable)arg2 : null;
        boolean present = this.js_has(key);
        if (!present && !(arg2 instanceof Callable)) {
            throw ScriptRuntime.typeError("Key is not present in map, and no value supplier was provided");
        }
        Object value = present ? this.js_get(key) : thunk.call(cx, scope, this, new Object[]{key, this});
        Object newValue = cb.call(cx, scope, this, new Object[]{value, key, this});
        this.js_set(key, newValue);
        return this;
    }

    private Object js_filter(Context cx, Scriptable scope, Object[] args) {
        Object arg1;
        BaseFunction species = NativeMap.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeMap map = (NativeMap)species.construct(cx, scope, new Object[0]);
        Object arg0 = args.length == 0 ? null : args[0];
        Object object = arg1 = args.length > 1 ? args[1] : null;
        if (!(arg0 instanceof Callable)) {
            throw ScriptRuntime.typeError("Callback is not callable");
        }
        Callable cb = (Callable)arg0;
        Scriptable thisObj = arg1 instanceof Scriptable ? (Scriptable)arg1 : Undefined.SCRIPTABLE_UNDEFINED;
        for (Hashtable.Entry en : this.entries) {
            Object result = cb.call(cx, scope, thisObj, new Object[]{en.value, en.key, this});
            if (!ScriptRuntime.toBoolean(result)) continue;
            map.entries.put(en.key, en.value);
        }
        return map;
    }

    private Object js_merge(Context cx, Scriptable scope, Object[] args) {
        BaseFunction species = NativeMap.getSpecies(this);
        if (species == null) {
            throw ScriptRuntime.typeError("'this' is not constructable");
        }
        NativeMap map = (NativeMap)species.construct(cx, scope, new Object[0]);
        for (Hashtable.Entry en : this.entries) {
            map.entries.put(en.key, en.value);
        }
        for (Object arg : args) {
            if (!(arg instanceof NativeMap)) {
                throw ScriptRuntime.typeError("Expected Map, got " + ScriptRuntime.typeof(arg));
            }
            NativeMap other = (NativeMap)arg;
            for (Hashtable.Entry en : other.entries) {
                map.entries.put(en.key, en.value);
            }
        }
        return map;
    }

    private Object js_upsert(Context cx, Scriptable scope, Object[] args) {
        Object insertFnObj;
        if (args.length == 0) {
            throw ScriptRuntime.typeError("Key must be specified for upsert");
        }
        if (args.length == 1) {
            throw ScriptRuntime.typeError("Update function must be specified for upsert");
        }
        Object key = args[0];
        Object updateFnObj = args[1];
        Object object = insertFnObj = args.length > 2 ? args[2] : null;
        if (!(updateFnObj instanceof Callable) && !(insertFnObj instanceof Callable)) {
            throw ScriptRuntime.typeError("The updater and inserter provided to upsert are both not functions");
        }
        Callable updateFn = updateFnObj instanceof Callable ? (Callable)updateFnObj : null;
        Callable insertFn = insertFnObj instanceof Callable ? (Callable)insertFnObj : null;
        for (Hashtable.Entry en : this.entries) {
            if (!ScriptRuntime.sameZero(en.key, key)) continue;
            Object value = en.value;
            if (updateFn != null) {
                value = updateFn.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{value, key, this});
                this.entries.put(key, value);
            }
            return value;
        }
        if (insertFn != null) {
            Object insertionValue = insertFn.call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{key, this});
            this.entries.put(key, insertionValue);
            return insertionValue;
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject map, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(arg1, cx, scope);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        ScriptableObject dummy = NativeMap.ensureScriptableObject(cx.newObject(scope, map.getClassName()));
        Callable set = ScriptRuntime.getPropFunctionAndThis(dummy.getPrototype(), "set", cx, scope);
        ScriptRuntime.lastStoredScriptable(cx);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, ito);){
            for (Object val : it) {
                Object finalVal;
                Scriptable sVal = ScriptableObject.ensureScriptable(val);
                if (sVal instanceof Symbol) {
                    throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(sVal));
                }
                Object finalKey = sVal.get(0, sVal);
                if (finalKey == NOT_FOUND) {
                    finalKey = Undefined.instance;
                }
                if ((finalVal = sVal.get(1, sVal)) == NOT_FOUND) {
                    finalVal = Undefined.instance;
                }
                set.call(cx, scope, map, new Object[]{finalKey, finalVal});
            }
        }
    }

    private NativeMap realThis(Scriptable thisObj, IdFunctionObject f) {
        if (thisObj == null) {
            throw NativeMap.incompatibleCallError(f);
        }
        try {
            NativeMap nm = (NativeMap)ScriptRuntime.unwrapProxy(thisObj);
            if (!nm.instanceOfMap) {
                throw NativeMap.incompatibleCallError(f);
            }
            return nm;
        }
        catch (ClassCastException cce) {
            throw NativeMap.incompatibleCallError(f);
        }
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 25: {
                this.initPrototypeMethod(MAP_TAG, id, NativeSet.GETSIZE, "get size", 0);
                return;
            }
            case 26: {
                this.initPrototypeValue(26, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 0;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 2;
                s = "set";
                break;
            }
            case 3: {
                arity = 1;
                s = "get";
                break;
            }
            case 4: {
                arity = 1;
                s = "delete";
                break;
            }
            case 5: {
                arity = 1;
                s = "has";
                break;
            }
            case 6: {
                arity = 0;
                s = "clear";
                break;
            }
            case 7: {
                arity = 0;
                s = "keys";
                break;
            }
            case 8: {
                arity = 0;
                s = "values";
                break;
            }
            case 9: {
                arity = 0;
                s = "entries";
                break;
            }
            case 10: {
                arity = 1;
                s = "forEach";
                break;
            }
            case 11: {
                arity = 1;
                s = "mapKeys";
                break;
            }
            case 12: {
                arity = 1;
                s = "mapValues";
                break;
            }
            case 13: {
                arity = 1;
                s = "keyOf";
                break;
            }
            case 14: {
                arity = 1;
                s = "includes";
                break;
            }
            case 15: {
                arity = 1;
                s = "find";
                break;
            }
            case 16: {
                arity = 1;
                s = "findKey";
                break;
            }
            case 17: {
                arity = 1;
                s = "some";
                break;
            }
            case 18: {
                arity = 1;
                s = "every";
                break;
            }
            case 19: {
                arity = 1;
                s = "reduce";
                break;
            }
            case 20: {
                arity = 1;
                s = "deleteAll";
                break;
            }
            case 21: {
                arity = 1;
                s = "update";
                break;
            }
            case 22: {
                arity = 1;
                s = "filter";
                break;
            }
            case 23: {
                arity = 1;
                s = "merge";
                break;
            }
            case 24: {
                arity = 3;
                s = "upsert";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(MAP_TAG, id, s, fnName, arity);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (NativeSet.GETSIZE.equals(k)) {
            return 25;
        }
        if (SymbolKey.ITERATOR.equals(k)) {
            return 9;
        }
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 26;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'g') {
                    if (s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                    return 3;
                }
                if (c == 'h') {
                    if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                    return 5;
                }
                if (c != 's' || s.charAt(2) != 't' || s.charAt(1) != 'e') break;
                return 2;
            }
            case 4: {
                char c = s.charAt(0);
                if (c == 'f') {
                    X = "find";
                    id = 15;
                    break;
                }
                if (c == 'k') {
                    X = "keys";
                    id = 7;
                    break;
                }
                if (c != 's') break;
                X = "some";
                id = 17;
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'c': {
                        X = "clear";
                        id = 6;
                        break block0;
                    }
                    case 'e': {
                        X = "every";
                        id = 18;
                        break block0;
                    }
                    case 'k': {
                        X = "keyOf";
                        id = 13;
                        break block0;
                    }
                    case 'm': {
                        X = "merge";
                        id = 23;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(0)) {
                    case 'd': {
                        X = "delete";
                        id = 4;
                        break;
                    }
                    case 'f': {
                        X = "filter";
                        id = 22;
                        break;
                    }
                    case 'r': {
                        X = "reduce";
                        id = 19;
                        break;
                    }
                    case 'u': {
                        char c = s.charAt(5);
                        if (c == 'e') {
                            X = "update";
                            id = 21;
                            break;
                        }
                        if (c != 't') break;
                        X = "upsert";
                        id = 24;
                        break;
                    }
                    case 'v': {
                        X = "values";
                        id = 8;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "mapKeys";
                        id = 11;
                        break block0;
                    }
                    case 'i': {
                        X = "findKey";
                        id = 16;
                        break block0;
                    }
                    case 'n': {
                        X = "entries";
                        id = 9;
                        break block0;
                    }
                    case 'o': {
                        X = "forEach";
                        id = 10;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                X = "includes";
                id = 14;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'd') {
                    X = "deleteAll";
                    id = 20;
                    break;
                }
                if (c != 'm') break;
                X = "mapValues";
                id = 12;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

