/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.ClassElement;
import org.mozilla.javascript.ast.ClassField;
import org.mozilla.javascript.ast.ClassMethod;
import org.mozilla.javascript.ast.ClassNode;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DecoratorDeclarationNode;
import org.mozilla.javascript.ast.DecoratorNode;
import org.mozilla.javascript.ast.DestructuringForm;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.ExportNode;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.GeneratorExpression;
import org.mozilla.javascript.ast.GeneratorExpressionLoop;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.Symbol;
import org.mozilla.javascript.ast.TemplateLiteral;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;
import org.mozilla.javascript.ast.Yield;
import org.mozilla.javascript.decorators.DecoratorType;
import org.mozilla.javascript.optimizer.Codegen;

public final class IRFactory
extends Parser {
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;
    private Decompiler decompiler = new Decompiler();
    public static Object GENERATED_SUPER = new Object();

    public IRFactory() {
    }

    public IRFactory(CompilerEnvirons env) {
        this(env, env.getErrorReporter());
    }

    public IRFactory(CompilerEnvirons env, ErrorReporter errorReporter) {
        super(env, errorReporter);
    }

    public ScriptNode transformTree(AstRoot root) {
        this.currentScriptOrFn = root;
        this.inUseStrictDirective = root.isInStrictMode();
        int sourceStartOffset = this.decompiler.getCurrentOffset();
        ScriptNode script = (ScriptNode)this.transform(root);
        int sourceEndOffset = this.decompiler.getCurrentOffset();
        script.setEncodedSourceBounds(sourceStartOffset, sourceEndOffset);
        if (this.compilerEnv.isGeneratingSource()) {
            script.setEncodedSource(this.decompiler.getEncodedSource());
        }
        String baseName = "c";
        if (script.getSourceName().length() > 0 && !Character.isJavaIdentifierStart((baseName = script.getSourceName().replaceAll("\\W", "_")).charAt(0))) {
            baseName = "_" + baseName;
        }
        String mainClassName = "org.mozilla.javascript.gen." + baseName + "_" + (Codegen.globalSerialClassCounter + 1);
        File debugOutputPath = Context.getContext().getDebugOutputPath();
        if (debugOutputPath != null) {
            File irDir = new File(debugOutputPath, "ir");
            irDir.mkdirs();
            File outputIR = new File(irDir, mainClassName + ".txt");
            try (FileOutputStream fos = new FileOutputStream(outputIR);){
                fos.write(script.toStringTree(script).getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.decompiler = null;
        return script;
    }

    public Node transform(AstNode node) {
        switch (node.getType()) {
            case 69: {
                return this.transformArrayLiteral((ArrayLiteral)node);
            }
            case 139: {
                return this.transformBlock(node);
            }
            case 129: {
                return this.transformBreak((BreakStatement)node);
            }
            case 39: {
                return this.transformFunctionCall((FunctionCall)node);
            }
            case 115: {
                return this.transformClass((ClassNode)node);
            }
            case 130: {
                return this.transformContinue((ContinueStatement)node);
            }
            case 125: {
                Assignment assignment = (Assignment)node;
                Node left = this.transform(assignment.getLeft());
                Node right = this.transform(assignment.getRight());
                return new Node(125, left, right);
            }
            case 127: {
                return this.transformDoLoop((DoLoop)node);
            }
            case 120: 
            case 138: {
                return node;
            }
            case 119: {
                return this.transformExport((ExportNode)node);
            }
            case 128: {
                if (node instanceof ForInLoop) {
                    return this.transformForInLoop((ForInLoop)node);
                }
                return this.transformForLoop((ForLoop)node);
            }
            case 114: {
                return this.transformFunction((FunctionNode)node);
            }
            case 167: {
                return this.transformGenExpr((GeneratorExpression)node);
            }
            case 37: {
                return this.transformElementGet((ElementGet)node);
            }
            case 34: {
                return this.transformPropertyGet((PropertyGet)node);
            }
            case 103: {
                return this.transformCondExpr((ConditionalExpression)node);
            }
            case 121: {
                return this.transformIf((IfStatement)node);
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 165: {
                return this.transformLiteral(node);
            }
            case 40: {
                return this.transformName((Name)node);
            }
            case 41: {
                return this.transformNumber((NumberLiteral)node);
            }
            case 31: {
                return this.transformNewExpr((NewExpression)node);
            }
            case 70: {
                return this.transformObjectLiteral((ObjectLiteral)node);
            }
            case 51: {
                return this.transformRegExp((RegExpLiteral)node);
            }
            case 4: {
                return this.transformReturn((ReturnStatement)node);
            }
            case 146: {
                return this.transformScript((ScriptNode)node);
            }
            case 42: {
                return this.transformString((StringLiteral)node);
            }
            case 43: {
                return this.transformTemplate((TemplateLiteral)node);
            }
            case 123: {
                return this.transformSwitch((SwitchStatement)node);
            }
            case 53: {
                if (node instanceof ThrowStatement) {
                    return this.transformThrow((ThrowStatement)node);
                }
                return this.transformThrowExpr((UnaryExpression)node);
            }
            case 78: {
                return this.transformTry((TryStatement)node);
            }
            case 126: {
                return this.transformWhileLoop((WhileLoop)node);
            }
            case 132: {
                return this.transformWith((WithStatement)node);
            }
            case 76: {
                return this.transformYield((Yield)node);
            }
        }
        if (node instanceof ExpressionStatement) {
            return this.transformExprStmt((ExpressionStatement)node);
        }
        if (node instanceof Assignment) {
            return this.transformAssignment((Assignment)node);
        }
        if (node instanceof UnaryExpression) {
            return this.transformUnary((UnaryExpression)node);
        }
        if (node instanceof InfixExpression) {
            return this.transformInfix((InfixExpression)node);
        }
        if (node instanceof VariableDeclaration) {
            return this.transformVariables((VariableDeclaration)node);
        }
        if (node instanceof ParenthesizedExpression) {
            return this.transformParenExpr((ParenthesizedExpression)node);
        }
        if (node instanceof LabeledStatement) {
            return this.transformLabeledStatement((LabeledStatement)node);
        }
        if (node instanceof LetNode) {
            return this.transformLetNode((LetNode)node);
        }
        if (node instanceof DecoratorNode) {
            return this.transformDecoratorNode((DecoratorNode)node);
        }
        if (node instanceof DecoratorDeclarationNode) {
            return this.transformDecoratorDeclaration((DecoratorDeclarationNode)node);
        }
        throw new IllegalArgumentException("Can't transform: " + node);
    }

    private Node transformArrayLiteral(ArrayLiteral node) {
        if (node.isDestructuring()) {
            return node;
        }
        this.decompiler.addToken(80);
        List<AstNode> elems = node.getElements();
        Node array = new Node(69);
        ArrayList<Integer> skipIndexes = null;
        boolean spreading = node.getProp(29) != null;
        for (int i = 0; i < elems.size(); ++i) {
            AstNode elem = elems.get(i);
            if (elem.getType() != 138) {
                Node transformed = this.transform(elem);
                if (elem.getProp(29) != null) {
                    transformed.putProp(29, true);
                }
                array.addChildToBack(transformed);
            } else {
                if (spreading) {
                    array.addChildToBack(elem);
                    continue;
                }
                if (skipIndexes == null) {
                    skipIndexes = new ArrayList<Integer>();
                }
                skipIndexes.add(i);
            }
            if (i >= elems.size() - 1) continue;
            this.decompiler.addToken(86);
        }
        if (node.getProp(29) != null) {
            this.decompiler.addToken(110);
            array.putProp(29, true);
        }
        this.decompiler.addToken(81);
        array.putIntProp(21, node.getDestructuringLength());
        if (skipIndexes != null) {
            int[] skips = new int[skipIndexes.size()];
            for (int i = 0; i < skipIndexes.size(); ++i) {
                skips[i] = (Integer)skipIndexes.get(i);
            }
            array.putProp(11, skips);
        }
        return array;
    }

    private Node transformAssignment(Assignment node) {
        AstNode left = this.removeParens(node.getLeft());
        Node target = null;
        if (this.isDestructuring(left)) {
            this.decompile(left);
            target = left;
        } else {
            target = this.transform(left);
        }
        this.decompiler.addToken(node.getType());
        return this.createAssignment(node.getType(), target, this.transform(node.getRight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformBlock(AstNode node) {
        if (node instanceof Scope) {
            this.pushScope((Scope)node);
        }
        try {
            ArrayList<Node> kids = new ArrayList<Node>();
            for (Node kid : node) {
                kids.add(this.transform((AstNode)kid));
            }
            node.removeChildren();
            for (Node kid : kids) {
                node.addChildToBack(kid);
            }
            AstNode astNode = node;
            return astNode;
        }
        finally {
            if (node instanceof Scope) {
                this.popScope();
            }
        }
    }

    private Node transformBreak(BreakStatement node) {
        this.decompiler.addToken(129);
        if (node.getBreakLabel() != null) {
            this.decompiler.addName(node.getBreakLabel().getIdentifier());
        }
        this.decompiler.addEOL(79);
        return node;
    }

    private Node transformCondExpr(ConditionalExpression node) {
        Node test2 = this.transform(node.getTestExpression());
        this.decompiler.addToken(103);
        Node ifTrue = this.transform(node.getTrueExpression());
        this.decompiler.addToken(104);
        Node ifFalse = this.transform(node.getFalseExpression());
        return this.createCondExpr(test2, ifTrue, ifFalse);
    }

    private Node transformContinue(ContinueStatement node) {
        this.decompiler.addToken(130);
        if (node.getLabel() != null) {
            this.decompiler.addName(node.getLabel().getIdentifier());
        }
        this.decompiler.addEOL(79);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformDoLoop(DoLoop loop) {
        loop.setType(142);
        this.pushScope(loop);
        try {
            this.decompiler.addToken(127);
            this.decompiler.addEOL(82);
            Node body = this.transform(loop.getBody());
            this.decompiler.addToken(83);
            this.decompiler.addToken(126);
            this.decompiler.addToken(84);
            Node cond = this.transform(loop.getCondition());
            this.decompiler.addToken(85);
            this.decompiler.addEOL(79);
            Node node = this.createLoop(loop, 0, body, cond, null, null);
            return node;
        }
        finally {
            this.popScope();
        }
    }

    private Node transformExport(ExportNode node) {
        if (node.getExportedValue() != null) {
            node.addChildToBack(this.transform(node.getExportedValue()));
        }
        return node;
    }

    private Node transformElementGet(ElementGet node) {
        boolean chained;
        Node target = this.transform(node.getTarget());
        boolean bl = chained = node.getProp(30) != null;
        if (chained) {
            this.decompiler.addToken(111);
        }
        this.decompiler.addToken(80);
        Node element = this.transform(node.getElement());
        this.decompiler.addToken(81);
        Node newNode = new Node(37, target, element);
        if (chained) {
            newNode.putProp(30, true);
        }
        return newNode;
    }

    private Node transformExprStmt(ExpressionStatement node) {
        Node expr = this.transform(node.getExpression());
        this.decompiler.addEOL(79);
        return new Node(node.getType(), expr, node.getLineno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForInLoop(ForInLoop loop) {
        this.decompiler.addToken(128);
        this.decompiler.addToken(84);
        loop.setType(142);
        this.pushScope(loop);
        try {
            int declType = -1;
            AstNode iter = loop.getIterator();
            if (iter instanceof VariableDeclaration) {
                declType = iter.getType();
            }
            Node lhs = this.transform(iter);
            if (loop.isForOf()) {
                this.decompiler.addName("of ");
            } else {
                this.decompiler.addToken(55);
            }
            Node obj = this.transform(loop.getIteratedObject());
            this.decompiler.addToken(85);
            this.decompiler.addEOL(82);
            Node body = this.transform(loop.getBody());
            this.decompiler.addEOL(83);
            Node node = this.createForIn(declType, loop, lhs, obj, body, loop.isForOf());
            return node;
        }
        finally {
            this.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForLoop(ForLoop loop) {
        this.decompiler.addToken(128);
        this.decompiler.addToken(84);
        loop.setType(142);
        Scope savedScope = this.currentScope;
        this.currentScope = loop;
        try {
            Node init2 = this.transform(loop.getInitializer());
            this.decompiler.addToken(79);
            Node test2 = this.transform(loop.getCondition());
            this.decompiler.addToken(79);
            Node incr = this.transform(loop.getIncrement());
            this.decompiler.addToken(85);
            this.decompiler.addEOL(82);
            Node body = this.transform(loop.getBody());
            this.decompiler.addEOL(83);
            Node node = this.createFor(loop, init2, test2, incr, body);
            return node;
        }
        finally {
            this.currentScope = savedScope;
        }
    }

    private void transformDestructuringParams(Node root) {
        Node child = root.first;
        while (child != null) {
            Node newChild;
            if (child.type == 125) {
                newChild = this.transform((AstNode)child.last);
                child.replaceChild(child.last, newChild);
            } else if (child.getProp(28) != null) {
                newChild = this.transform((AstNode)child);
                root.replaceChild(child, newChild);
            } else {
                this.transformDestructuringParams(child);
            }
            child = child.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformFunction(FunctionNode fn) {
        int functionType = fn.getFunctionType();
        int start = this.decompiler.markFunctionStart(functionType);
        int index = this.currentScriptOrFn.addFunction(fn);
        Parser.PerFunctionVariables savedVars = new Parser.PerFunctionVariables(this, fn);
        try {
            Node pn;
            List initializers;
            this.decompileFunctionHeader(fn);
            Node destructuring = (Node)fn.getProp(23);
            if (destructuring != null) {
                this.transformDestructuringParams(destructuring);
            }
            fn.removeProp(23);
            int lineno = fn.getBody().getLineno();
            ++this.nestingOfFunction;
            Node body = this.transform(fn.getBody());
            if (!fn.isExpressionClosure()) {
                this.decompiler.addToken(83);
            }
            if (fn instanceof DecoratorDeclarationNode) {
                for (DecoratorNode decoratorNode : ((DecoratorDeclarationNode)fn).getDecoratorNodes()) {
                    this.transformDecoratorNode(decoratorNode);
                }
            }
            if ((initializers = (List)fn.getProp(36)) != null) {
                for (AstNode initializer : initializers) {
                    List dns;
                    if (initializer instanceof ClassNode) {
                        dns = ((ClassNode)initializer).getDecorators().stream().filter(dn -> dn.getDecoratorType() == DecoratorType.INITIALIZE).map(this::transformDecoratorNode).collect(Collectors.toList());
                        initializer.putProp(33, dns);
                        continue;
                    }
                    if (initializer instanceof ClassElement) {
                        dns = ((ClassElement)((Object)initializer)).getDecorators().stream().filter(dn -> dn.getDecoratorType() == DecoratorType.INITIALIZE).map(this::transformDecoratorNode).collect(Collectors.toList());
                        initializer.putProp(33, dns);
                        continue;
                    }
                    throw Kit.codeBug();
                }
            }
            fn.setEncodedSourceBounds(start, this.decompiler.markFunctionEnd(start));
            if (functionType != 2 && !fn.isExpressionClosure()) {
                this.decompiler.addToken(1);
            }
            if (destructuring != null) {
                body.addChildToFront(new Node(143, destructuring, lineno));
            }
            int n = fn.getFunctionType();
            Node node = pn = this.initFunction(fn, index, body, n);
            return node;
        }
        finally {
            --this.nestingOfFunction;
            savedVars.restore();
        }
    }

    private DecoratorDeclarationNode transformDecoratorDeclaration(DecoratorDeclarationNode node) {
        node.setBody(new Block());
        node.setFunctionType(1);
        List<DecoratorNode> dns = node.getDecoratorNodes();
        if (dns.stream().anyMatch(it -> it.getDecoratorType() == DecoratorType.NUMERICTEMPLATE) && dns.size() != 1) {
            throw ScriptRuntime.typeError("User-defined decorator cannot contain @numericTemplate with any other decorator");
        }
        this.transformFunction(node);
        return node;
    }

    private Node transformDecoratorNode(DecoratorNode dn) {
        for (AstNode arg : dn.getArguments()) {
            dn.addChildToBack(this.transform(arg));
        }
        return dn;
    }

    private Node transformClass(ClassNode node) {
        FunctionNode fn;
        if (node.getExtendsName() != null) {
            node.setExtended(this.transform(node.getExtendsName()));
        }
        if ((fn = node.getConstructor()) == null) {
            fn = new FunctionNode();
            Block body = new Block();
            if (node.getExtended() != null) {
                FunctionCall superCall = new FunctionCall();
                Name superName = new Name();
                superName.setString("super");
                superName.putProp(31, GENERATED_SUPER);
                superCall.setTarget(superName);
                ExpressionStatement expr = new ExpressionStatement(superCall);
                body.addStatement(expr);
            }
            fn.setBody(body);
        }
        fn.setFunctionName(node.getClassName());
        fn.setFunctionType(2);
        fn.setParentClass(node);
        ArrayList<Node> decorators = new ArrayList<Node>();
        for (DecoratorNode dn2 : node.getDecorators()) {
            if (dn2.getDecoratorType() == DecoratorType.INITIALIZE) continue;
            decorators.add(this.transformDecoratorNode(dn2));
        }
        List initializers = node.getMethods().stream().filter(cm -> cm.getDecorators().stream().anyMatch(dn -> dn.getDecoratorType() == DecoratorType.INITIALIZE)).collect(Collectors.toList());
        initializers.addAll(node.getFields().stream().filter(cf -> cf.getDecorators().stream().anyMatch(dn -> dn.getDecoratorType() == DecoratorType.INITIALIZE)).collect(Collectors.toList()));
        if (node.getDecorators().stream().anyMatch(dn -> dn.getDecoratorType() == DecoratorType.INITIALIZE)) {
            initializers.add(node);
        }
        node.putProp(33, decorators);
        fn.putProp(36, initializers);
        Node transformedFn = this.transform(fn);
        node.addChildToBack(transformedFn);
        node.setParentFn(transformedFn);
        for (ClassMethod cm2 : node.getMethods()) {
            cm2.setNameKey(this.getPropKey(cm2.getName()));
            cm2.addChildToBack(this.transform(cm2.getFunction()));
            decorators = new ArrayList();
            for (DecoratorNode dn3 : cm2.getDecorators()) {
                if (dn3.getDecoratorType() == DecoratorType.INITIALIZE) continue;
                decorators.add(this.transformDecoratorNode(dn3));
            }
            cm2.putProp(33, decorators);
            node.addChildToBack(cm2);
        }
        ScriptNode currentScriptTemp = null;
        for (ClassField cp : node.getFields()) {
            if (!cp.isStatic()) {
                currentScriptTemp = this.currentScriptOrFn;
                this.currentScriptOrFn = fn;
            }
            cp.setNameKey(this.getPropKey(cp.getName()));
            cp.addChildToBack(this.transform(cp.getDefaultValue()));
            if (!cp.isStatic()) {
                this.currentScriptOrFn = currentScriptTemp;
                currentScriptTemp = null;
            }
            decorators = new ArrayList();
            for (DecoratorNode dn4 : cp.getDecorators()) {
                if (dn4.getDecoratorType() == DecoratorType.INITIALIZE) continue;
                decorators.add(this.transformDecoratorNode(dn4));
            }
            cp.putProp(33, decorators);
            node.addChildToBack(cp);
        }
        return node;
    }

    private Node transformFunctionCall(FunctionCall node) {
        Node call = this.createCallOrNew(39, this.transform(node.getTarget()));
        if (node.getProp(30) != null) {
            call.putProp(30, node.getProp(30));
        } else if (node.getProp(29) != null) {
            call.putProp(29, node.getProp(29));
        }
        if (node.getProp(34) != null) {
            call.putProp(34, true);
        }
        call.setLineno(node.getLineno());
        this.decompiler.addToken(84);
        List<AstNode> args = node.getArguments();
        for (int i = 0; i < args.size(); ++i) {
            AstNode arg = args.get(i);
            if (arg.getType() == 103 && arg instanceof EmptyExpression) {
                call.putProp(37, true);
                call.addChildToBack(arg);
                this.decompiler.addToken(103);
                continue;
            }
            Node child = this.transform(arg);
            if (arg.getProp(29) != null) {
                child.putProp(29, true);
            }
            call.addChildToBack(child);
            if (i >= args.size() - 1) continue;
            this.decompiler.addToken(86);
        }
        this.decompiler.addToken(85);
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformGenExpr(GeneratorExpression node) {
        Node pn;
        FunctionNode fn = new FunctionNode();
        fn.setSourceName(this.currentScriptOrFn.getNextTempName());
        fn.setIsGenerator();
        fn.setFunctionType(2);
        fn.setRequiresActivation();
        int functionType = fn.getFunctionType();
        int start = this.decompiler.markFunctionStart(functionType);
        this.decompileFunctionHeader(fn);
        int index = this.currentScriptOrFn.addFunction(fn);
        Parser.PerFunctionVariables savedVars = new Parser.PerFunctionVariables(this, fn);
        try {
            Node destructuring = (Node)fn.getProp(23);
            fn.removeProp(23);
            int lineno = node.lineno;
            ++this.nestingOfFunction;
            Node body = this.genExprTransformHelper(node);
            if (!fn.isExpressionClosure()) {
                this.decompiler.addToken(83);
            }
            fn.setEncodedSourceBounds(start, this.decompiler.markFunctionEnd(start));
            if (functionType != 2 && !fn.isExpressionClosure()) {
                this.decompiler.addToken(1);
            }
            if (destructuring != null) {
                body.addChildToFront(new Node(143, destructuring, lineno));
            }
            int syntheticType = fn.getFunctionType();
            pn = this.initFunction(fn, index, body, syntheticType);
        }
        finally {
            --this.nestingOfFunction;
            savedVars.restore();
        }
        Node call = this.createCallOrNew(39, pn);
        call.setLineno(node.getLineno());
        this.decompiler.addToken(84);
        this.decompiler.addToken(85);
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node genExprTransformHelper(GeneratorExpression node) {
        int i;
        this.decompiler.addToken(84);
        int lineno = node.getLineno();
        Node expr = this.transform(node.getResult());
        List<GeneratorExpressionLoop> loops = node.getLoops();
        int numLoops = loops.size();
        Node[] iterators = new Node[numLoops];
        Node[] iteratedObjs = new Node[numLoops];
        for (int i2 = 0; i2 < numLoops; ++i2) {
            GeneratorExpressionLoop acl = loops.get(i2);
            this.decompiler.addName(" ");
            this.decompiler.addToken(128);
            this.decompiler.addToken(84);
            AstNode iter = acl.getIterator();
            String name = null;
            if (iter.getType() == 40) {
                name = iter.getString();
                this.decompiler.addName(name);
            } else {
                this.decompile(iter);
                name = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(84, name, false);
                expr = this.createBinary(86, this.createAssignment(87, iter, this.createName(name)), expr);
            }
            Node init2 = this.createName(name);
            this.defineSymbol(158, name, false);
            iterators[i2] = init2;
            if (acl.isForOf()) {
                this.decompiler.addName("of ");
            } else {
                this.decompiler.addToken(55);
            }
            iteratedObjs[i2] = this.transform(acl.getIteratedObject());
            this.decompiler.addToken(85);
        }
        Node yield = new Node(76, expr, node.getLineno());
        Node body = new Node(143, yield, lineno);
        if (node.getFilter() != null) {
            this.decompiler.addName(" ");
            this.decompiler.addToken(121);
            this.decompiler.addToken(84);
            body = this.createIf(this.transform(node.getFilter()), body, null, lineno);
            this.decompiler.addToken(85);
        }
        int pushed = 0;
        try {
            for (i = numLoops - 1; i >= 0; --i) {
                GeneratorExpressionLoop acl = loops.get(i);
                Scope loop = this.createLoopNode(null, acl.getLineno());
                this.pushScope(loop);
                ++pushed;
                body = this.createForIn(158, loop, iterators[i], iteratedObjs[i], body, acl.isForOf());
            }
        }
        finally {
            for (i = 0; i < pushed; ++i) {
                this.popScope();
            }
        }
        this.decompiler.addToken(85);
        return body;
    }

    private Node transformIf(IfStatement n) {
        this.decompiler.addToken(121);
        this.decompiler.addToken(84);
        Node cond = this.transform(n.getCondition());
        this.decompiler.addToken(85);
        this.decompiler.addEOL(82);
        Node ifTrue = this.transform(n.getThenPart());
        Node ifFalse = null;
        if (n.getElsePart() != null) {
            this.decompiler.addToken(83);
            this.decompiler.addToken(122);
            this.decompiler.addEOL(82);
            ifFalse = this.transform(n.getElsePart());
        }
        this.decompiler.addEOL(83);
        return this.createIf(cond, ifTrue, ifFalse, n.getLineno());
    }

    private Node transformInfix(InfixExpression node) {
        Node left = this.transform(node.getLeft());
        this.decompiler.addToken(node.getType());
        Node right = this.transform(node.getRight());
        return this.createBinary(node.getType(), left, right);
    }

    private Node transformLabeledStatement(LabeledStatement ls) {
        Label label = ls.getFirstLabel();
        List<Label> labels = ls.getLabels();
        this.decompiler.addName(label.getName());
        if (labels.size() > 1) {
            for (Label lb : labels.subList(1, labels.size())) {
                this.decompiler.addEOL(104);
                this.decompiler.addName(lb.getName());
            }
        }
        if (ls.getStatement().getType() == 139) {
            this.decompiler.addToken(70);
            this.decompiler.addEOL(82);
        } else {
            this.decompiler.addEOL(104);
        }
        Node statement = this.transform(ls.getStatement());
        if (ls.getStatement().getType() == 139) {
            this.decompiler.addEOL(83);
        }
        Node breakTarget = Node.newTarget();
        Node block = new Node(139, (Node)label, statement, breakTarget);
        label.target = breakTarget;
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformLetNode(LetNode node) {
        this.pushScope(node);
        try {
            boolean letExpr;
            this.decompiler.addToken(158);
            this.decompiler.addToken(84);
            Node vars = this.transformVariableInitializers(node.getVariables());
            this.decompiler.addToken(85);
            node.addChildToBack(vars);
            boolean bl = letExpr = node.getType() == 163;
            if (node.getBody() != null) {
                if (letExpr) {
                    this.decompiler.addName(" ");
                } else {
                    this.decompiler.addEOL(82);
                }
                node.addChildToBack(this.transform(node.getBody()));
                if (!letExpr) {
                    this.decompiler.addEOL(83);
                }
            }
            LetNode letNode = node;
            return letNode;
        }
        finally {
            this.popScope();
        }
    }

    private Node transformLiteral(AstNode node) {
        this.decompiler.addToken(node.getType());
        return node;
    }

    private Node transformName(Name node) {
        if (node.getParent() != null && node.getParent().getProp(33) != null) {
            node.putProp(33, true);
            this.decompiler.addToken(153);
        }
        this.decompiler.addName(node.getIdentifier());
        return node;
    }

    private Node transformNewExpr(NewExpression node) {
        this.decompiler.addToken(31);
        Node nx = this.createCallOrNew(31, this.transform(node.getTarget()));
        nx.setLineno(node.getLineno());
        List<AstNode> args = node.getArguments();
        this.decompiler.addToken(84);
        for (int i = 0; i < args.size(); ++i) {
            AstNode arg = args.get(i);
            nx.addChildToBack(this.transform(arg));
            if (i >= args.size() - 1) continue;
            this.decompiler.addToken(86);
        }
        this.decompiler.addToken(85);
        if (node.getInitializer() != null) {
            nx.addChildToBack(this.transformObjectLiteral(node.getInitializer()));
        }
        return nx;
    }

    private Node transformNumber(NumberLiteral node) {
        this.decompiler.addNumber(node.getNumber());
        DecoratorNode dn = node.getDecoratorNode();
        if (dn != null) {
            this.transformDecoratorNode(dn);
        }
        return node;
    }

    private Node transformObjectLiteral(ObjectLiteral node) {
        int[] spreadIndices;
        Object[] properties;
        if (node.isDestructuring()) {
            return node;
        }
        this.decompiler.addToken(82);
        List<ObjectProperty> elems = node.getElements();
        Node object = new Node(70);
        if (elems.isEmpty()) {
            properties = ScriptRuntime.emptyArgs;
            spreadIndices = new int[]{};
        } else {
            int size = elems.size();
            int nonSpreadIndex = 0;
            int spreadIndex = 0;
            properties = new Object[(int)elems.stream().filter(it -> it.getSpread() == null).count()];
            spreadIndices = new int[elems.size() - properties.length];
            for (ObjectProperty prop : elems) {
                if (prop.isGetterMethod()) {
                    this.decompiler.addToken(156);
                } else if (prop.isSetterMethod()) {
                    this.decompiler.addToken(157);
                } else if (prop.isNormalMethod()) {
                    this.decompiler.addToken(168);
                }
                AstNode spread = prop.getSpread();
                if (spread == null) {
                    properties[nonSpreadIndex++] = this.getPropKey(prop.getLeft());
                    if (!prop.isMethod()) {
                        this.decompiler.addToken(70);
                    }
                    Node right = this.transform(prop.getRight());
                    if (prop.isGetterMethod()) {
                        right = this.createUnary(156, right);
                    } else if (prop.isSetterMethod()) {
                        right = this.createUnary(157, right);
                    } else if (prop.isNormalMethod()) {
                        right = this.createUnary(168, right);
                    }
                    object.addChildToBack(right);
                    if (nonSpreadIndex >= size) continue;
                    this.decompiler.addToken(86);
                    continue;
                }
                spreadIndices[spreadIndex] = nonSpreadIndex + spreadIndex;
                ++spreadIndex;
                Node transformed = this.transform(spread);
                object.addChildToBack(transformed);
            }
        }
        this.decompiler.addToken(83);
        object.putProp(12, properties);
        object.putProp(32, spreadIndices);
        return object;
    }

    private Object getPropKey(Node id) {
        Object key;
        if (id.getProp(28) != null) {
            key = this.transform((AstNode)id);
            this.decompiler.addToken(80);
            this.decompile((AstNode)id);
            this.decompiler.addToken(81);
        } else if (id instanceof Name) {
            if (id.getProp(29) != null) {
                this.decompiler.addToken(110);
                key = id;
            } else {
                String s = ((Name)id).getIdentifier();
                this.decompiler.addName(s);
                key = ScriptRuntime.getIndexObject(s);
            }
        } else if (id instanceof StringLiteral) {
            String s = ((StringLiteral)id).getValue();
            this.decompiler.addString(s);
            key = ScriptRuntime.getIndexObject(s);
        } else if (id instanceof NumberLiteral) {
            double n = ((NumberLiteral)id).getNumber();
            this.decompiler.addNumber(n);
            key = ScriptRuntime.getIndexObject(n);
        } else {
            throw Kit.codeBug();
        }
        return key;
    }

    private Node transformParenExpr(ParenthesizedExpression node) {
        AstNode expr = node.getExpression();
        this.decompiler.addToken(84);
        int count = 1;
        while (expr instanceof ParenthesizedExpression) {
            this.decompiler.addToken(84);
            ++count;
            expr = ((ParenthesizedExpression)expr).getExpression();
        }
        Node result = this.transform(expr);
        for (int i = 0; i < count; ++i) {
            this.decompiler.addToken(85);
        }
        result.putProp(19, Boolean.TRUE);
        return result;
    }

    private Node transformPropertyGet(PropertyGet node) {
        Node target = this.transform(node.getTarget());
        String name = node.getProperty().getIdentifier();
        if (node.getProp(30) != null) {
            this.decompiler.addToken(111);
        } else {
            this.decompiler.addToken(109);
        }
        if (node.getProp(34) != null) {
            this.decompiler.addToken(170);
        }
        this.decompiler.addName(name);
        return this.createPropertyGet(target, name, node);
    }

    private Node transformRegExp(RegExpLiteral node) {
        this.decompiler.addRegexp(node.getValue(), node.getFlags());
        this.currentScriptOrFn.addRegExp(node);
        return node;
    }

    private Node transformReturn(ReturnStatement node) {
        AstNode rv;
        Node value;
        boolean expClosure = Boolean.TRUE.equals(node.getProp(25));
        boolean isArrow = Boolean.TRUE.equals(node.getProp(27));
        if (expClosure) {
            if (!isArrow) {
                this.decompiler.addName(" ");
            }
        } else {
            this.decompiler.addToken(4);
        }
        Node node2 = value = (rv = node.getReturnValue()) == null ? null : this.transform(rv);
        if (!expClosure) {
            this.decompiler.addEOL(79);
        }
        return rv == null ? new Node(4, node.getLineno()) : new Node(4, value, node.getLineno());
    }

    private Node transformScript(ScriptNode node) {
        this.decompiler.addToken(146);
        if (this.currentScope != null) {
            Kit.codeBug();
        }
        this.currentScope = node;
        Node body = new Node(139);
        for (Node kid : node) {
            body.addChildToBack(this.transform((AstNode)kid));
        }
        node.removeChildren();
        Node children = body.getFirstChild();
        if (children != null) {
            node.addChildrenToBack(children);
        }
        return node;
    }

    private Node transformString(StringLiteral node) {
        boolean spread;
        boolean bl = spread = node.getProp(29) != null;
        if (spread) {
            this.decompiler.addToken(110);
        }
        this.decompiler.addString(node.getValue());
        if (spread) {
            Node array = new Node(69);
            array.putProp(29, true);
            String str = node.getValue();
            int index = 0;
            while (index < str.length()) {
                int newIndex = str.offsetByCodePoints(index, 1);
                String value = str.substring(index, newIndex);
                index = newIndex;
                StringLiteral sl = new StringLiteral();
                sl.setValue(value);
                array.addChildToBack(this.transformString(sl));
            }
            return array;
        }
        return Node.newString(node.getValue());
    }

    private Node transformTemplate(TemplateLiteral lit) {
        AstNode target = lit.getTarget();
        if (target != null) {
            lit.setTransformedTarget(this.transform(target));
        }
        for (AstNode part : lit.getElements()) {
            lit.addChildToBack(this.transform(part));
        }
        return lit;
    }

    private Node transformSwitch(SwitchStatement node) {
        this.decompiler.addToken(123);
        this.decompiler.addToken(84);
        Node switchExpr = this.transform(node.getExpression());
        this.decompiler.addToken(85);
        node.addChildToBack(switchExpr);
        Node block = new Node(139, (Node)node, node.getLineno());
        this.decompiler.addEOL(82);
        for (SwitchCase sc : node.getCases()) {
            AstNode expr = sc.getExpression();
            Node caseExpr = null;
            if (expr != null) {
                this.decompiler.addToken(124);
                caseExpr = this.transform(expr);
            } else {
                this.decompiler.addToken(125);
            }
            this.decompiler.addEOL(104);
            List<AstNode> stmts = sc.getStatements();
            Block body = new Block();
            if (stmts != null) {
                for (AstNode kid : stmts) {
                    body.addChildToBack(this.transform(kid));
                }
            }
            this.addSwitchCase(block, caseExpr, body);
        }
        this.decompiler.addEOL(83);
        this.closeSwitch(block);
        return block;
    }

    private Node transformThrowExpr(UnaryExpression node) {
        this.decompiler.addToken(53);
        Node value = this.transform(node.getOperand());
        return new Node(53, value, node.getLineno());
    }

    private Node transformThrow(ThrowStatement node) {
        this.decompiler.addToken(53);
        Node value = this.transform(node.getExpression());
        this.decompiler.addEOL(79);
        return new Node(53, value, node.getLineno());
    }

    private Node transformTry(TryStatement node) {
        this.decompiler.addToken(78);
        this.decompiler.addEOL(82);
        Node tryBlock = this.transform(node.getTryBlock());
        this.decompiler.addEOL(83);
        Block catchBlocks = new Block();
        for (CatchClause cc : node.getCatchClauses()) {
            this.decompiler.addToken(133);
            this.decompiler.addToken(84);
            String varName = cc.getVarName().getIdentifier();
            this.decompiler.addName(varName);
            this.decompiler.addToken(85);
            this.decompiler.addEOL(82);
            Node body = this.transform(cc.getBody());
            this.decompiler.addEOL(83);
            catchBlocks.addChildToBack(this.createCatch(varName, body, cc.getLineno()));
        }
        Node finallyBlock = null;
        if (node.getFinallyBlock() != null) {
            this.decompiler.addToken(134);
            this.decompiler.addEOL(82);
            finallyBlock = this.transform(node.getFinallyBlock());
            this.decompiler.addEOL(83);
        }
        return this.createTryCatchFinally(tryBlock, catchBlocks, finallyBlock, node.getLineno());
    }

    private Node transformUnary(UnaryExpression node) {
        int type = node.getType();
        if (node.isPrefix()) {
            this.decompiler.addToken(type);
        }
        Node child = this.transform(node.getOperand());
        if (node.isPostfix()) {
            this.decompiler.addToken(type);
        }
        if (type == 107 || type == 108) {
            return this.createIncDec(type, node.isPostfix(), child);
        }
        return this.createUnary(type, child);
    }

    private Node transformVariables(VariableDeclaration node) {
        this.decompiler.addToken(node.getType());
        this.transformVariableInitializers(node);
        AstNode parent = node.getParent();
        if (!(parent instanceof Loop) && !(parent instanceof LetNode)) {
            this.decompiler.addEOL(79);
        }
        return node;
    }

    private Node transformVariableInitializers(VariableDeclaration node) {
        List<VariableInitializer> vars = node.getVariables();
        int size = vars.size();
        int i = 0;
        for (VariableInitializer var : vars) {
            AstNode target = var.getTarget();
            AstNode init2 = var.getInitializer();
            Node left = null;
            if (var.isDestructuring()) {
                this.decompile(target);
                left = target;
            } else {
                left = this.transform(target);
            }
            Node right = null;
            if (init2 != null) {
                this.decompiler.addToken(87);
                right = this.transform(init2);
            }
            if (var.isDestructuring()) {
                if (right == null) {
                    node.addChildToBack(left);
                } else {
                    Node d = this.createDestructuringAssignment(node.getType(), left, right);
                    node.addChildToBack(d);
                }
            } else {
                if (right != null) {
                    left.addChildToBack(right);
                }
                node.addChildToBack(left);
            }
            if (i++ >= size - 1) continue;
            this.decompiler.addToken(86);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformWhileLoop(WhileLoop loop) {
        this.decompiler.addToken(126);
        loop.setType(142);
        this.pushScope(loop);
        try {
            this.decompiler.addToken(84);
            Node cond = this.transform(loop.getCondition());
            this.decompiler.addToken(85);
            this.decompiler.addEOL(82);
            Node body = this.transform(loop.getBody());
            this.decompiler.addEOL(83);
            Node node = this.createLoop(loop, 1, body, cond, null, null);
            return node;
        }
        finally {
            this.popScope();
        }
    }

    private Node transformWith(WithStatement node) {
        this.decompiler.addToken(132);
        this.decompiler.addToken(84);
        Node expr = this.transform(node.getExpression());
        this.decompiler.addToken(85);
        this.decompiler.addEOL(82);
        Node stmt = this.transform(node.getStatement());
        this.decompiler.addEOL(83);
        return this.createWith(expr, stmt, node.getLineno());
    }

    private Node transformYield(Yield node) {
        Node kid;
        this.decompiler.addToken(76);
        Node node2 = kid = node.getValue() == null ? null : this.transform(node.getValue());
        if (kid != null) {
            return new Node(76, kid, node.getLineno());
        }
        return new Node(76, node.getLineno());
    }

    private void addSwitchCase(Node switchBlock, Node caseExpression, Node statements) {
        if (switchBlock.getType() != 139) {
            throw Kit.codeBug();
        }
        Jump switchNode = (Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 123) {
            throw Kit.codeBug();
        }
        Node gotoTarget = Node.newTarget();
        if (caseExpression != null) {
            Jump caseNode = new Jump(124, caseExpression);
            caseNode.target = gotoTarget;
            switchNode.addChildToBack(caseNode);
        } else {
            switchNode.setDefault(gotoTarget);
        }
        switchBlock.addChildToBack(gotoTarget);
        switchBlock.addChildToBack(statements);
    }

    private void closeSwitch(Node switchBlock) {
        Node switchBreakTarget;
        if (switchBlock.getType() != 139) {
            throw Kit.codeBug();
        }
        Jump switchNode = (Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 123) {
            throw Kit.codeBug();
        }
        switchNode.target = switchBreakTarget = Node.newTarget();
        Node defaultTarget = switchNode.getDefault();
        if (defaultTarget == null) {
            defaultTarget = switchBreakTarget;
        }
        switchBlock.addChildAfter(this.makeJump(5, defaultTarget), switchNode);
        switchBlock.addChildToBack(switchBreakTarget);
    }

    private Node createExprStatementNoReturn(Node expr, int lineno) {
        return new Node(143, expr, lineno);
    }

    private Node createString(String string) {
        return Node.newString(string);
    }

    private Node createCatch(String varName, Node stmts, int lineno) {
        return new Node(133, this.createName(varName), stmts, lineno);
    }

    private Node initFunction(FunctionNode fnNode, int functionIndex, Node statements, int functionType) {
        Node lastStmt;
        Name name;
        fnNode.setFunctionType(functionType);
        fnNode.addChildToBack(statements);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.setRequiresActivation();
        }
        if (functionType == 2 && (name = fnNode.getFunctionName()) != null && name.length() != 0 && fnNode.getSymbol(name.getIdentifier()) == null) {
            fnNode.putSymbol(new Symbol(114, name.getIdentifier()));
            Node setFn = new Node(143, new Node(8, Node.newString(52, name.getIdentifier()), new Node(67)));
            statements.addChildrenToFront(setFn);
        }
        if ((lastStmt = statements.getLastChild()) == null || lastStmt.getType() != 4) {
            statements.addChildToBack(new Node(4));
        }
        Node result = Node.newString(114, fnNode.getName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    private Scope createLoopNode(Node loopLabel, int lineno) {
        Scope result = this.createScopeNode(142, lineno);
        if (loopLabel != null) {
            ((Jump)loopLabel).setLoop(result);
        }
        return result;
    }

    private Node createFor(Scope loop, Node init2, Node test2, Node incr, Node body) {
        if (init2.getType() == 158) {
            Scope let = Scope.splitScope(loop);
            let.setType(158);
            let.addChildrenToBack(init2);
            let.addChildToBack(this.createLoop(loop, 2, body, test2, new Node(138), incr));
            return let;
        }
        return this.createLoop(loop, 2, body, test2, init2, incr);
    }

    private Node createLoop(Jump loop, int loopType, Node body, Node cond, Node init2, Node incr) {
        Node bodyTarget = Node.newTarget();
        Node condTarget = Node.newTarget();
        if (loopType == 2 && cond.getType() == 138) {
            cond = new Node(48);
        }
        Jump IFEQ = new Jump(6, cond);
        IFEQ.target = bodyTarget;
        Node breakTarget = Node.newTarget();
        loop.addChildToBack(bodyTarget);
        loop.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            loop.addChildrenToBack(new Node(138, loop.getLineno()));
        }
        loop.addChildToBack(condTarget);
        loop.addChildToBack(IFEQ);
        loop.addChildToBack(breakTarget);
        loop.target = breakTarget;
        Node continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            loop.addChildToFront(this.makeJump(5, condTarget));
            if (loopType == 2) {
                int initType = init2.getType();
                if (initType != 138) {
                    if (initType != 131 && initType != 158 && initType != 159) {
                        init2 = new Node(143, init2);
                    }
                    loop.addChildToFront(init2);
                }
                Node incrTarget = Node.newTarget();
                loop.addChildAfter(incrTarget, body);
                if (incr.getType() != 138) {
                    incr = new Node(143, incr);
                    loop.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        loop.setContinue(continueTarget);
        return loop;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Node createForIn(int declType, Node loop, Node lhs, Node obj, Node body, boolean isForOf) {
        Node assign;
        Node lvalue;
        int type;
        int destructuringLen;
        int destructuring;
        block13: {
            block12: {
                destructuring = -1;
                destructuringLen = 0;
                type = lhs.getType();
                if (type != 131 && type != 158 && type != 159) break block12;
                Node kid = lhs.getLastChild();
                int kidType = kid.getType();
                if (kidType == 69 || kidType == 70) {
                    type = destructuring = kidType;
                    lvalue = kid;
                    destructuringLen = 0;
                    if (kid instanceof ArrayLiteral) {
                        destructuringLen = ((ArrayLiteral)kid).getDestructuringLength();
                    }
                    break block13;
                } else {
                    if (kidType != 40) {
                        this.reportError("msg.bad.for.in.lhs");
                        return null;
                    }
                    lvalue = Node.newString(40, kid.getString());
                }
                break block13;
            }
            if (type == 69 || type == 70) {
                destructuring = type;
                lvalue = lhs;
                destructuringLen = 0;
                if (lhs instanceof ArrayLiteral) {
                    destructuringLen = ((ArrayLiteral)lhs).getDestructuringLength();
                }
            } else {
                lvalue = this.makeReference(lhs);
                if (lvalue == null) {
                    this.reportError("msg.bad.for.in.lhs");
                    return null;
                }
            }
        }
        Node localBlock = new Node(151);
        int initType = isForOf ? 64 : (destructuring != -1 ? 63 : 61);
        Node init2 = new Node(initType, obj);
        init2.putProp(3, localBlock);
        Node cond = new Node(65);
        cond.putProp(3, localBlock);
        Node id = new Node(66);
        id.putProp(3, localBlock);
        Node newBody = new Node(139);
        if (destructuring != -1) {
            assign = this.createDestructuringAssignment(declType, lvalue, id);
            if (!(isForOf || destructuring != 70 && destructuringLen == 2)) {
                this.reportError("msg.bad.for.in.destruct");
            }
        } else {
            assign = this.simpleAssignment(lvalue, id);
        }
        newBody.addChildToBack(new Node(143, assign));
        newBody.addChildToBack(body);
        loop = this.createLoop((Jump)loop, 1, newBody, cond, null, null);
        loop.addChildToFront(init2);
        if (type == 131 || type == 158 || type == 159) {
            loop.addChildToFront(lhs);
        }
        localBlock.addChildToBack(loop);
        return localBlock;
    }

    private Node createTryCatchFinally(Node tryBlock, Node catchBlocks, Node finallyBlock, int lineno) {
        boolean hasFinally;
        boolean bl = hasFinally = finallyBlock != null && (finallyBlock.getType() != 139 || finallyBlock.hasChildren());
        if (tryBlock.getType() == 139 && !tryBlock.hasChildren() && !hasFinally) {
            return tryBlock;
        }
        boolean hasCatch = catchBlocks.hasChildren();
        if (!hasFinally && !hasCatch) {
            return tryBlock;
        }
        Node handlerBlock = new Node(151);
        Jump pn = new Jump(78, tryBlock, lineno);
        pn.putProp(3, handlerBlock);
        if (hasCatch) {
            Node catchTarget;
            Node endCatch = Node.newTarget();
            pn.addChildToBack(this.makeJump(5, endCatch));
            pn.target = catchTarget = Node.newTarget();
            pn.addChildToBack(catchTarget);
            Node catchScopeBlock = new Node(151);
            Node cb = catchBlocks.getFirstChild();
            boolean hasDefault = false;
            int scopeIndex = 0;
            while (cb != null) {
                int catchLineNo = cb.getLineno();
                Node name = cb.getFirstChild();
                Node catchStatement = name.getNext();
                cb.removeChild(name);
                cb.removeChild(catchStatement);
                catchStatement.addChildToBack(new Node(3));
                catchStatement.addChildToBack(this.makeJump(5, endCatch));
                hasDefault = true;
                Node catchScope = new Node(60, name, this.createUseLocal(handlerBlock));
                catchScope.putProp(3, catchScopeBlock);
                catchScope.putIntProp(14, scopeIndex);
                catchScopeBlock.addChildToBack(catchScope);
                catchScopeBlock.addChildToBack(this.createWith(this.createUseLocal(catchScopeBlock), catchStatement, catchLineNo));
                cb = cb.getNext();
                ++scopeIndex;
            }
            pn.addChildToBack(catchScopeBlock);
            if (!hasDefault) {
                Node rethrow = new Node(54);
                rethrow.putProp(3, handlerBlock);
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
        }
        if (hasFinally) {
            Node finallyTarget = Node.newTarget();
            pn.setFinally(finallyTarget);
            pn.addChildToBack(this.makeJump(145, finallyTarget));
            Node finallyEnd = Node.newTarget();
            pn.addChildToBack(this.makeJump(5, finallyEnd));
            pn.addChildToBack(finallyTarget);
            Node fBlock = new Node(134, finallyBlock);
            fBlock.putProp(3, handlerBlock);
            pn.addChildToBack(fBlock);
            pn.addChildToBack(finallyEnd);
        }
        handlerBlock.addChildToBack(pn);
        return handlerBlock;
    }

    private Node createWith(Node obj, Node body, int lineno) {
        this.setRequiresActivation();
        Node result = new Node(139, lineno);
        result.addChildToBack(new Node(2, obj));
        Node bodyNode = new Node(132, body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(3));
        return result;
    }

    private Node createIf(Node cond, Node ifTrue, Node ifFalse, int lineno) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new Node(139, lineno);
        }
        Node result = new Node(139, lineno);
        Node ifNotTarget = Node.newTarget();
        Jump IFNE = new Jump(7, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack(ifTrue);
        if (ifFalse != null) {
            Node endTarget = Node.newTarget();
            result.addChildToBack(this.makeJump(5, endTarget));
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack(ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    private Node createCondExpr(Node cond, Node ifTrue, Node ifFalse) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new Node(103, cond, ifTrue, ifFalse);
    }

    private Node createUnary(int nodeType, Node child) {
        int childType = child.getType();
        switch (nodeType) {
            case 32: {
                Node n;
                if (childType == 40) {
                    child.setType(52);
                    Node left = child;
                    Node right = Node.newString(child.getString());
                    n = new Node(nodeType, left, right);
                } else if (childType == 34 || childType == 37) {
                    Node left = child.getFirstChild();
                    Node right = child.getLastChild();
                    child.removeChild(left);
                    child.removeChild(right);
                    n = new Node(nodeType, left, right);
                } else if (childType == 71) {
                    Node ref = child.getFirstChild();
                    child.removeChild(ref);
                    n = new Node(73, ref);
                } else {
                    n = new Node(nodeType, new Node(48), child);
                }
                return n;
            }
            case 33: {
                if (childType != 40) break;
                child.setType(147);
                return child;
            }
            case 28: {
                if (childType != 41) break;
                int value = ScriptRuntime.toInt32(child.getDouble());
                child.setDouble(~value);
                return child;
            }
            case 30: {
                if (childType != 41) break;
                child.setDouble(-child.getDouble());
                return child;
            }
            case 27: {
                int status = IRFactory.isAlwaysDefinedBoolean(child);
                if (status == 0) break;
                int type = status == 1 ? 47 : 48;
                if (childType == 48 || childType == 47) {
                    child.setType(type);
                    return child;
                }
                return new Node(type);
            }
        }
        return new Node(nodeType, child);
    }

    private Node createCallOrNew(int nodeType, Node child) {
        String name;
        int type = 0;
        if (child.getType() == 40) {
            name = child.getString();
            if (name.equals("eval")) {
                type = 1;
            } else if (name.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 34 && (name = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        Node node = new Node(nodeType, child);
        if (type != 0) {
            this.setRequiresActivation();
            node.putIntProp(10, type);
        }
        return node;
    }

    private Node createIncDec(int nodeType, boolean post, Node child) {
        child = this.makeReference(child);
        int childType = child.getType();
        switch (childType) {
            case 34: 
            case 37: 
            case 40: 
            case 71: {
                Node n = new Node(nodeType, child);
                int incrDecrMask = 0;
                if (nodeType == 108) {
                    incrDecrMask |= 1;
                }
                if (post) {
                    incrDecrMask |= 2;
                }
                n.putIntProp(13, incrDecrMask);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    private Node createPropertyGet(Node target, String name, Node parent) {
        if (target == null) {
            return this.createName(name);
        }
        this.checkActivationName(name, 34);
        if (ScriptRuntime.isSpecialProperty(name)) {
            Node ref = new Node(75, target);
            ref.putProp(17, name);
            return new Node(71, ref);
        }
        Node node = new Node(34, target, Node.newString(name));
        if (parent != null && parent.getProp(30) != null) {
            node.putProp(30, true);
        }
        if (parent != null && parent.getProp(34) != null) {
            node.putProp(34, true);
        }
        return node;
    }

    private Node createBinary(int nodeType, Node left, Node right) {
        switch (nodeType) {
            case 21: {
                if (left.type == 42) {
                    String s2;
                    if (right.type == 42) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 41) break;
                        s2 = ScriptRuntime.numberToString(right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 41) break;
                if (right.type == 41) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 42) break;
                String s1 = ScriptRuntime.numberToString(left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 22: {
                if (left.type == 41) {
                    double ld = left.getDouble();
                    if (right.type == 41) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new Node(30, right);
                }
                if (right.type != 41 || right.getDouble() != 0.0) break;
                return new Node(29, left);
            }
            case 23: {
                if (left.type == 41) {
                    double ld = left.getDouble();
                    if (right.type == 41) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new Node(29, right);
                }
                if (right.type != 41 || right.getDouble() != 1.0) break;
                return new Node(29, left);
            }
            case 24: {
                if (right.type != 41) break;
                double rd = right.getDouble();
                if (left.type == 41) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new Node(29, left);
            }
            case 106: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return left;
                }
                if (leftStatus != 1) break;
                return right;
            }
            case 105: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return left;
                }
                if (leftStatus != -1) break;
                return right;
            }
        }
        return new Node(nodeType, left, right);
    }

    private Node createAssignment(int assignType, Node left, Node right) {
        int assignOp;
        Node ref = this.makeReference(left);
        if (ref == null) {
            if (left.getType() == 69 || left.getType() == 70) {
                if (assignType != 87) {
                    this.reportError("msg.bad.destruct.op");
                    return right;
                }
                return this.createDestructuringAssignment(-1, left, right);
            }
            this.reportError("msg.bad.assign.left");
            return right;
        }
        left = ref;
        switch (assignType) {
            case 87: {
                return this.simpleAssignment(left, right);
            }
            case 88: {
                assignOp = 9;
                break;
            }
            case 89: {
                assignOp = 10;
                break;
            }
            case 90: {
                assignOp = 11;
                break;
            }
            case 91: {
                assignOp = 18;
                break;
            }
            case 92: {
                assignOp = 19;
                break;
            }
            case 93: {
                assignOp = 20;
                break;
            }
            case 94: {
                assignOp = 21;
                break;
            }
            case 95: {
                assignOp = 22;
                break;
            }
            case 96: {
                assignOp = 23;
                break;
            }
            case 99: {
                assignOp = 26;
                break;
            }
            case 97: {
                assignOp = 24;
                break;
            }
            case 98: {
                assignOp = 25;
                break;
            }
            case 101: {
                assignOp = 106;
                break;
            }
            case 100: {
                assignOp = 105;
                break;
            }
            case 102: {
                assignOp = 113;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int nodeType = left.getType();
        switch (nodeType) {
            case 40: {
                Node op = new Node(assignOp, left, right);
                Node lvalueLeft = Node.newString(52, left.getString());
                return new Node(8, lvalueLeft, op);
            }
            case 34: 
            case 37: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 34 ? 149 : 150;
                Node opLeft = new Node(148);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(type, obj, id, op);
            }
            case 71: {
                ref = left.getFirstChild();
                this.checkMutableReference(ref);
                Node opLeft = new Node(148);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(152, ref, op);
            }
        }
        throw Kit.codeBug();
    }

    private Node createUseLocal(Node localBlock) {
        if (151 != localBlock.getType()) {
            throw Kit.codeBug();
        }
        Node result = new Node(57);
        result.putProp(3, localBlock);
        return result;
    }

    private Jump makeJump(int type, Node target) {
        Jump n = new Jump(type);
        n.target = target;
        return n;
    }

    private Node makeReference(Node node) {
        int type = node.getType();
        switch (type) {
            case 34: 
            case 37: 
            case 40: 
            case 71: {
                return node;
            }
            case 39: {
                node.setType(74);
                return new Node(71, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 45: 
            case 47: {
                return -1;
            }
            case 48: {
                return 1;
            }
            case 41: {
                double num = node.getDouble();
                if (!Double.isNaN(num) && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    boolean isDestructuring(Node n) {
        return n instanceof DestructuringForm && ((DestructuringForm)((Object)n)).isDestructuring();
    }

    void decompileFunctionHeader(FunctionNode fn) {
        boolean noParen;
        if (fn.getFunctionName() != null) {
            this.decompiler.addName(fn.getName());
        }
        boolean isArrow = fn.getFunctionType() == 4;
        boolean bl = noParen = isArrow && fn.getLp() == -1;
        if (!noParen) {
            this.decompiler.addToken(84);
        }
        List<AstNode> params = fn.getParams();
        Map<Integer, Node> defaultParams = fn.getDefaultParams();
        for (int i = 0; i < params.size(); ++i) {
            this.decompile(params.get(i));
            if (defaultParams.containsKey(i)) {
                this.decompiler.addToken(87);
                AstNode node = (AstNode)defaultParams.get(i);
                Node transformed = this.transform(node);
                fn.setDefaultParam(i, transformed);
                fn.addChildrenToBack(transformed);
            }
            if (i >= params.size() - 1) continue;
            this.decompiler.addToken(86);
        }
        if (!noParen) {
            this.decompiler.addToken(85);
        }
        if (isArrow) {
            this.decompiler.addToken(169);
        }
        if (!fn.isExpressionClosure()) {
            this.decompiler.addEOL(82);
        }
    }

    void decompile(AstNode node) {
        switch (node.getType()) {
            case 69: {
                this.decompileArrayLiteral((ArrayLiteral)node);
                break;
            }
            case 70: {
                this.decompileObjectLiteral((ObjectLiteral)node);
                break;
            }
            case 42: {
                this.decompiler.addString(((StringLiteral)node).getValue());
                break;
            }
            case 40: {
                this.decompiler.addName(((Name)node).getIdentifier());
                break;
            }
            case 41: {
                this.decompiler.addNumber(((NumberLiteral)node).getNumber());
                break;
            }
            case 34: {
                this.decompilePropertyGet((PropertyGet)node);
                break;
            }
            case 138: {
                break;
            }
            case 37: {
                this.decompileElementGet((ElementGet)node);
                break;
            }
            case 46: {
                this.decompiler.addToken(node.getType());
                break;
            }
        }
    }

    void decompileArrayLiteral(ArrayLiteral node) {
        this.decompiler.addToken(80);
        List<AstNode> elems = node.getElements();
        int size = elems.size();
        for (int i = 0; i < size; ++i) {
            AstNode elem = elems.get(i);
            if (elem.getType() == 87) {
                Assignment assignment = (Assignment)elem;
                this.decompile(assignment.getLeft());
                this.decompiler.addToken(87);
                this.decompile(assignment.getRight());
            } else {
                this.decompile(elem);
            }
            if (i >= size - 1) continue;
            this.decompiler.addToken(86);
        }
        this.decompiler.addToken(81);
    }

    void decompileObjectLiteral(ObjectLiteral node) {
        this.decompiler.addToken(82);
        List<ObjectProperty> props = node.getElements();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            ObjectProperty prop = props.get(i);
            boolean destructuringShorthand = Boolean.TRUE.equals(prop.getProp(26));
            AstNode spread = prop.getSpread();
            if (spread != null) {
                this.decompiler.addToken(110);
                this.decompile(spread);
            } else {
                this.decompile(prop.getLeft());
                if (!destructuringShorthand) {
                    this.decompiler.addToken(104);
                    this.decompile(prop.getRight());
                }
            }
            if (i >= size - 1) continue;
            this.decompiler.addToken(86);
        }
        this.decompiler.addToken(83);
    }

    void decompilePropertyGet(PropertyGet node) {
        this.decompile(node.getTarget());
        this.decompiler.addToken(109);
        this.decompile(node.getProperty());
    }

    void decompileElementGet(ElementGet node) {
        this.decompile(node.getTarget());
        this.decompiler.addToken(80);
        this.decompile(node.getElement());
        this.decompiler.addToken(81);
    }
}

