/*
 * Decompiled with CFR 0.152.
 */
package dev.falsehonesty.asmhelper.dsl.writers;

import dev.falsehonesty.asmhelper.AsmHelper;
import dev.falsehonesty.asmhelper.dsl.AsmWriter;
import dev.falsehonesty.asmhelper.dsl.code.CodeBlock;
import dev.falsehonesty.asmhelper.dsl.instructions.InsnListBuilder;
import dev.falsehonesty.asmhelper.remapping.Remapper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017Bj\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0019\u0010\u0006\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/falsehonesty/asmhelper/dsl/writers/OverwriteWriter;", "Ldev/falsehonesty/asmhelper/dsl/AsmWriter;", "className", "", "methodName", "methodDesc", "insnListBuilder", "Lkotlin/Function1;", "Ldev/falsehonesty/asmhelper/dsl/instructions/InsnListBuilder;", "", "Lkotlin/ExtensionFunctionType;", "codeBlockClassName", "fieldMaps", "", "methodMaps", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "overwriteMethod", "method", "Lorg/objectweb/asm/tree/MethodNode;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "toString", "transform", "Builder", "AsmHelper1.8.9"})
public final class OverwriteWriter
extends AsmWriter {
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDesc;
    @Nullable
    private final Function1<InsnListBuilder, Unit> insnListBuilder;
    @Nullable
    private final String codeBlockClassName;
    @NotNull
    private final Map<String, String> fieldMaps;
    @NotNull
    private final Map<String, String> methodMaps;

    public OverwriteWriter(@NotNull String className, @NotNull String methodName, @NotNull String methodDesc, @Nullable Function1<? super InsnListBuilder, Unit> insnListBuilder, @Nullable String codeBlockClassName, @NotNull Map<String, String> fieldMaps, @NotNull Map<String, String> methodMaps) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkNotNullParameter(fieldMaps, (String)"fieldMaps");
        Intrinsics.checkNotNullParameter(methodMaps, (String)"methodMaps");
        super(className);
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.insnListBuilder = insnListBuilder;
        this.codeBlockClassName = codeBlockClassName;
        this.fieldMaps = fieldMaps;
        this.methodMaps = methodMaps;
    }

    @Override
    public void transform(@NotNull ClassNode classNode) {
        Object v4;
        boolean bl;
        Iterable iterable;
        block2: {
            Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
            AsmHelper.INSTANCE.setFieldMaps$AsmHelper1_8_9(this.fieldMaps);
            AsmHelper.INSTANCE.setMethodMaps$AsmHelper1_8_9(this.methodMaps);
            iterable = classNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"classNode.methods");
            iterable = iterable;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                MethodNode it = (MethodNode)e;
                boolean bl3 = false;
                Remapper remapper = AsmHelper.INSTANCE.getRemapper();
                String string = classNode.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classNode.name");
                String string2 = string;
                string = it.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                String string3 = string;
                string = it.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.desc");
                String remapped = remapper.remapMethodName(string2, string3, string);
                Remapper remapper2 = AsmHelper.INSTANCE.getRemapper();
                String string4 = it.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.desc");
                String remappedDesc = remapper2.remapDesc(string4);
                if (!(Intrinsics.areEqual((Object)remappedDesc, (Object)this.methodDesc) && (Intrinsics.areEqual((Object)remapped, (Object)this.methodName) || Intrinsics.areEqual((Object)this.methodMaps.get(remapped), (Object)this.methodName)))) continue;
                v4 = e;
                break block2;
            }
            v4 = null;
        }
        MethodNode methodNode = v4;
        if (methodNode != null) {
            iterable = methodNode;
            bl = false;
            boolean bl4 = false;
            Iterable it = iterable;
            boolean bl5 = false;
            this.overwriteMethod((MethodNode)it, classNode);
        }
    }

    private final void overwriteMethod(MethodNode method, ClassNode classNode) {
        method.instructions.clear();
        method.exceptions.clear();
        method.tryCatchBlocks.clear();
        InsnList insnList = this.transformToInstructions(this.insnListBuilder, this.codeBlockClassName, method, classNode);
        if (insnList == null) {
            return;
        }
        InsnList instructions = insnList;
        method.maxLocals = Type.getArgumentTypes((String)method.desc).length + ((method.access & 8) == 0 ? 1 : 0);
        method.instructions.add(instructions);
    }

    @NotNull
    public String toString() {
        return "OverwriteWriter{className=" + this.getClassName() + ", methodName=" + this.methodName + '}';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001f\u0010 \u001a\u00020\u00132\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J\u001f\u0010#\u001a\u00020\u00132\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR&\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\b\u00a8\u0006%"}, d2={"Ldev/falsehonesty/asmhelper/dsl/writers/OverwriteWriter$Builder;", "Ldev/falsehonesty/asmhelper/dsl/AsmWriter$AsmWriterBuilder;", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "codeBlockClassName", "fieldMaps", "", "getFieldMaps", "()Ljava/util/Map;", "setFieldMaps", "(Ljava/util/Map;)V", "insnListBuilder", "Lkotlin/Function1;", "Ldev/falsehonesty/asmhelper/dsl/instructions/InsnListBuilder;", "", "Lkotlin/ExtensionFunctionType;", "methodDesc", "getMethodDesc", "setMethodDesc", "methodMaps", "getMethodMaps", "setMethodMaps", "methodName", "getMethodName", "setMethodName", "build", "Ldev/falsehonesty/asmhelper/dsl/AsmWriter;", "codeBlock", "code", "Ldev/falsehonesty/asmhelper/dsl/code/CodeBlock;", "insnList", "config", "AsmHelper1.8.9"})
    public static final class Builder
    extends AsmWriter.AsmWriterBuilder {
        public String className;
        public String methodName;
        public String methodDesc;
        @Nullable
        private Function1<? super InsnListBuilder, Unit> insnListBuilder;
        @Nullable
        private String codeBlockClassName;
        @NotNull
        private Map<String, String> fieldMaps;
        @NotNull
        private Map<String, String> methodMaps;

        public Builder() {
            boolean bl = false;
            this.fieldMaps = MapsKt.emptyMap();
            bl = false;
            this.methodMaps = MapsKt.emptyMap();
        }

        @NotNull
        public final String getClassName() {
            String string = this.className;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
            throw null;
        }

        public final void setClassName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.className = string;
        }

        @NotNull
        public final String getMethodName() {
            String string = this.methodName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"methodName");
            throw null;
        }

        public final void setMethodName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.methodName = string;
        }

        @NotNull
        public final String getMethodDesc() {
            String string = this.methodDesc;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"methodDesc");
            throw null;
        }

        public final void setMethodDesc(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.methodDesc = string;
        }

        @NotNull
        public final Map<String, String> getFieldMaps() {
            return this.fieldMaps;
        }

        public final void setFieldMaps(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.fieldMaps = map;
        }

        @NotNull
        public final Map<String, String> getMethodMaps() {
            return this.methodMaps;
        }

        public final void setMethodMaps(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.methodMaps = map;
        }

        @NotNull
        public final AsmWriter build() throws IllegalStateException {
            return new OverwriteWriter(this.getClassName(), this.getMethodName(), this.getMethodDesc(), this.insnListBuilder, this.codeBlockClassName, this.fieldMaps, this.methodMaps);
        }

        public final void insnList(@NotNull Function1<? super InsnListBuilder, Unit> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            this.insnListBuilder = config;
        }

        public final void codeBlock(@NotNull Function1<? super CodeBlock, Unit> code) {
            Intrinsics.checkNotNullParameter(code, (String)"code");
            this.codeBlockClassName = Intrinsics.stringPlus((String)code.getClass().getName(), (Object)"$1");
        }
    }
}

