/*
 * Decompiled with CFR 0.152.
 */
package dev.falsehonesty.asmhelper.dsl.code.modifiers;

import dev.falsehonesty.asmhelper.dsl.code.modifiers.Analyzer;
import dev.falsehonesty.asmhelper.dsl.code.modifiers.Modifier;
import dev.falsehonesty.asmhelper.printing.PrintingKt;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Ldev/falsehonesty/asmhelper/dsl/code/modifiers/MutableRefModifier;", "Ldev/falsehonesty/asmhelper/dsl/code/modifiers/Modifier;", "codeBlockMethodNode", "Lorg/objectweb/asm/tree/MethodNode;", "codeBlockClass", "", "(Lorg/objectweb/asm/tree/MethodNode;Ljava/lang/String;)V", "getCodeBlockClass", "()Ljava/lang/String;", "getCodeBlockMethodNode", "()Lorg/objectweb/asm/tree/MethodNode;", "copyReadWrite", "", "to", "Lorg/objectweb/asm/tree/FieldInsnNode;", "from", "getDescriptorForRefType", "refType", "locateRefWrite", "node", "instructions", "Lorg/objectweb/asm/tree/InsnList;", "modify", "modifyRead", "readNode", "writeNode", "AsmHelper1.8.9"})
public final class MutableRefModifier
extends Modifier {
    @NotNull
    private final MethodNode codeBlockMethodNode;
    @NotNull
    private final String codeBlockClass;

    public MutableRefModifier(@NotNull MethodNode codeBlockMethodNode, @NotNull String codeBlockClass) {
        Intrinsics.checkNotNullParameter((Object)codeBlockMethodNode, (String)"codeBlockMethodNode");
        Intrinsics.checkNotNullParameter((Object)codeBlockClass, (String)"codeBlockClass");
        this.codeBlockMethodNode = codeBlockMethodNode;
        this.codeBlockClass = codeBlockClass;
    }

    @NotNull
    public final MethodNode getCodeBlockMethodNode() {
        return this.codeBlockMethodNode;
    }

    @NotNull
    public final String getCodeBlockClass() {
        return this.codeBlockClass;
    }

    @Override
    public void modify(@NotNull InsnList instructions) {
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        AbstractInsnNode node = instructions.getFirst();
        while (node.getNext() != null) {
            String refType;
            if (!((node = node.getNext()) instanceof FieldInsnNode) || !Intrinsics.areEqual((Object)((FieldInsnNode)node).owner, (Object)this.codeBlockClass)) continue;
            String string = ((FieldInsnNode)node).desc;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.desc");
            if (!StringsKt.startsWith$default((String)string, (String)"Lkotlin/jvm/internal/Ref$", (boolean)false, (int)2, null)) continue;
            AbstractInsnNode next = ((FieldInsnNode)node).getNext();
            int allowedActions = 1;
            while (next.getOpcode() == 89) {
                instructions.remove(next);
                instructions.insertBefore(node, next);
                next = ((FieldInsnNode)node).getNext();
                int n = allowedActions;
                allowedActions = n + 1;
            }
            String string2 = ((FieldInsnNode)node).desc;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.desc");
            int n = 1;
            int n2 = ((FieldInsnNode)node).desc.length() - 1;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Object object = node;
            FieldInsnNode writeNode = this.locateRefWrite((FieldInsnNode)object, instructions, refType);
            object = ((FieldInsnNode)node).desc;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.desc");
            if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)refType, (boolean)false, (int)2, null)) {
                String descriptor;
                Intrinsics.checkNotNull((Object)this.getDescriptorForRefType(refType));
                ((FieldInsnNode)node).desc = descriptor;
            }
            boolean hasRead = false;
            if (next.getOpcode() == 180) {
                AbstractInsnNode abstractInsnNode = next;
                if (abstractInsnNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
                }
                if (Intrinsics.areEqual((Object)((FieldInsnNode)abstractInsnNode).owner, (Object)refType)) {
                    hasRead = true;
                    abstractInsnNode = next;
                    Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"next");
                    this.modifyRead((FieldInsnNode)abstractInsnNode, instructions, writeNode);
                    int n3 = allowedActions;
                    allowedActions = n3 + -1;
                }
            }
            if (allowedActions <= 0) continue;
            if (writeNode == null) {
                PrintingKt.getLogger().error(Intrinsics.stringPlus((String)"Couldn't locate write node for ", (Object)node));
                return;
            }
            AbstractInsnNode abstractInsnNode = node;
            this.copyReadWrite(writeNode, (FieldInsnNode)abstractInsnNode);
            AbstractInsnNode abstractInsnNode2 = writeNode.getNext();
            if (abstractInsnNode2 == null) continue;
            AbstractInsnNode possibleRead = abstractInsnNode2;
            if (possibleRead.getOpcode() == 180 && Intrinsics.areEqual((Object)((FieldInsnNode)possibleRead).owner, (Object)refType) && allowedActions > 0) {
                abstractInsnNode2 = node;
                this.copyReadWrite((FieldInsnNode)possibleRead, (FieldInsnNode)abstractInsnNode2);
                hasRead = true;
            }
            if (hasRead) continue;
            AbstractInsnNode prev = ((FieldInsnNode)node).getPrevious();
            if (prev.getOpcode() == 25 && prev instanceof VarInsnNode) {
                CharSequence charSequence = ((FieldInsnNode)node).name;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"node.name");
                int n4 = 1;
                boolean bl2 = false;
                String string3 = charSequence.substring(n4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                charSequence = string3;
                String string4 = "local\\d+";
                bl2 = false;
                string4 = new Regex(string4);
                bl2 = false;
                if (string4.matches(charSequence)) {
                    instructions.remove(prev);
                }
            }
            instructions.remove(node);
        }
    }

    private final void modifyRead(FieldInsnNode readNode, InsnList instructions, FieldInsnNode writeNode) {
        AbstractInsnNode cast;
        if (Intrinsics.areEqual((Object)readNode.owner, (Object)"kotlin/jvm/internal/Ref$ObjectRef") && (cast = readNode.getNext()) instanceof TypeInsnNode && ((TypeInsnNode)cast).getOpcode() == 192) {
            AbstractInsnNode abstractInsnNode = readNode.getPrevious();
            if (abstractInsnNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
            }
            ((FieldInsnNode)abstractInsnNode).desc = ((TypeInsnNode)cast).desc;
            instructions.remove(cast);
        }
        instructions.remove((AbstractInsnNode)readNode);
    }

    private final String getDescriptorForRefType(String refType) {
        String string;
        switch (refType) {
            case "ObjectRef": {
                string = "Ljava/lang/Object;";
                break;
            }
            case "IntRef": {
                string = "I";
                break;
            }
            case "ByteRef": {
                string = "B";
                break;
            }
            case "ShortRef": {
                string = "S";
                break;
            }
            case "FloatRef": {
                string = "F";
                break;
            }
            case "DoubleRef": {
                string = "D";
                break;
            }
            case "LongRef": {
                string = "L";
                break;
            }
            case "BooleanRef": {
                string = "Z";
                break;
            }
            case "CharRef": {
                string = "C";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private final FieldInsnNode locateRefWrite(FieldInsnNode node, InsnList instructions, String refType) {
        Analyzer analyzer = new Analyzer(instructions, this.codeBlockMethodNode);
        AbstractInsnNode currentNode = (AbstractInsnNode)node;
        while (currentNode.getNext() != null) {
            String string;
            AbstractInsnNode abstractInsnNode = currentNode.getNext();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"currentNode.next");
            currentNode = abstractInsnNode;
            if (!(currentNode instanceof FieldInsnNode) || ((FieldInsnNode)currentNode).getOpcode() != 181 || !Intrinsics.areEqual((Object)((FieldInsnNode)currentNode).owner, (Object)refType)) continue;
            Deque<Type> analyzed = analyzer.analyze((AbstractInsnNode)node, currentNode);
            if (analyzed.size() == 1) {
                String string2 = analyzed.getFirst().getDescriptor();
                string = refType;
                int n = 24;
                boolean bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                if (Intrinsics.areEqual((Object)string2, (Object)this.getDescriptorForRefType(string4))) {
                    return (FieldInsnNode)currentNode;
                }
            }
            if (analyzed.size() != 2) continue;
            string = analyzed.getLast().getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"analyzed.last.descriptor");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)refType, (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)refType, (Object)"kotlin/jvm/internal/Ref$ObjectRef")) {
                node.desc = analyzed.getFirst().getDescriptor();
            }
            return (FieldInsnNode)currentNode;
        }
        return null;
    }

    private final void copyReadWrite(FieldInsnNode to, FieldInsnNode from) {
        to.owner = from.owner;
        to.name = from.name;
        to.desc = from.desc;
    }
}

