/*
 * Decompiled with CFR 0.152.
 */
package dev.falsehonesty.asmhelper.dsl.code.modifiers;

import dev.falsehonesty.asmhelper.printing.PrettyprintingKt;
import dev.falsehonesty.asmhelper.printing.PrintingKt;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Ldev/falsehonesty/asmhelper/dsl/code/modifiers/Analyzer;", "", "instructions", "Lorg/objectweb/asm/tree/InsnList;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "(Lorg/objectweb/asm/tree/InsnList;Lorg/objectweb/asm/tree/MethodNode;)V", "getInstructions", "()Lorg/objectweb/asm/tree/InsnList;", "getMethodNode", "()Lorg/objectweb/asm/tree/MethodNode;", "analyze", "Ljava/util/Deque;", "Lorg/objectweb/asm/Type;", "startInsn", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "endInsn", "AsmHelper1.8.9"})
public final class Analyzer {
    @NotNull
    private final InsnList instructions;
    @NotNull
    private final MethodNode methodNode;

    public Analyzer(@NotNull InsnList instructions, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        this.instructions = instructions;
        this.methodNode = methodNode;
    }

    @NotNull
    public final InsnList getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    @NotNull
    public final Deque<Type> analyze(@NotNull AbstractInsnNode startInsn, @NotNull AbstractInsnNode endInsn) {
        Intrinsics.checkNotNullParameter((Object)startInsn, (String)"startInsn");
        Intrinsics.checkNotNullParameter((Object)endInsn, (String)"endInsn");
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        AbstractInsnNode node = startInsn;
        while (!Intrinsics.areEqual((Object)node, (Object)endInsn)) {
            PrintingKt.verbose(Intrinsics.stringPlus((String)"Analyzing ", (Object)PrettyprintingKt.prettyString(node)));
            AbstractInsnNode abstractInsnNode = node;
            if (abstractInsnNode instanceof MethodInsnNode) {
                Type returnType;
                int n = Type.getArgumentTypes((String)((MethodInsnNode)node).desc).length;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    PrintingKt.verbose("Popping " + stack.poll() + " off the stack because it is an argument");
                }
                if (((MethodInsnNode)node).getOpcode() != 184) {
                    PrintingKt.verbose(Intrinsics.stringPlus((String)"Popping receiver ", stack.poll()));
                }
                if (!Intrinsics.areEqual((Object)(returnType = Type.getReturnType((String)((MethodInsnNode)node).desc)), (Object)Type.VOID_TYPE)) {
                    stack.push(returnType);
                }
                PrintingKt.verbose(Intrinsics.stringPlus((String)"Pushed return type ", (Object)returnType));
            } else if (abstractInsnNode instanceof VarInsnNode) {
                if (((VarInsnNode)node).getOpcode() <= 53) {
                    stack.push(Type.getObjectType((String)((LocalVariableNode)this.methodNode.localVariables.get((int)((VarInsnNode)node).var)).desc));
                } else {
                    stack.pop();
                }
            } else if (abstractInsnNode instanceof FieldInsnNode) {
                int n = ((FieldInsnNode)node).getOpcode();
                switch (n) {
                    case 178: {
                        stack.push(Type.getType((String)((FieldInsnNode)node).desc));
                        break;
                    }
                    case 179: {
                        stack.pop();
                        break;
                    }
                    case 180: {
                        stack.poll();
                        stack.push(Type.getType((String)((FieldInsnNode)node).desc));
                        break;
                    }
                    case 181: {
                        stack.poll();
                        stack.pop();
                    }
                }
            } else if (abstractInsnNode instanceof IntInsnNode) {
                stack.push(Type.INT_TYPE);
            } else if (abstractInsnNode instanceof LdcInsnNode) {
                Object object = ((LdcInsnNode)node).cst;
                if (object instanceof String) {
                    String string = String.class.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                    stack.push(Type.getObjectType((String)StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null)));
                } else if (object instanceof Integer) {
                    stack.push(Type.INT_TYPE);
                } else if (object instanceof Long) {
                    stack.push(Type.LONG_TYPE);
                } else if (object instanceof Double) {
                    stack.push(Type.DOUBLE_TYPE);
                } else if (object instanceof Float) {
                    stack.push(Type.FLOAT_TYPE);
                } else if (object instanceof Type) {
                    Object object2 = ((LdcInsnNode)node).cst;
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.Type");
                    }
                    stack.push((Type)object2);
                }
            } else if (abstractInsnNode instanceof InsnNode) {
                int n = ((InsnNode)node).getOpcode();
                boolean bl = 2 <= n ? n <= 8 : false;
                if (bl) {
                    stack.push(Type.INT_TYPE);
                } else {
                    boolean bl3 = 9 <= n ? n <= 10 : false;
                    if (bl3) {
                        stack.push(Type.LONG_TYPE);
                    } else {
                        boolean bl4 = 11 <= n ? n <= 13 : false;
                        if (bl4) {
                            stack.push(Type.FLOAT_TYPE);
                        } else {
                            boolean bl5 = 14 <= n ? n <= 15 : false;
                            if (bl5) {
                                stack.push(Type.DOUBLE_TYPE);
                            } else {
                                boolean bl6 = 96 <= n ? n <= 115 : false;
                                if (bl6) {
                                    stack.pop();
                                } else if (n == 89) {
                                    stack.push(stack.peek());
                                }
                            }
                        }
                    }
                }
            } else if (abstractInsnNode instanceof TypeInsnNode) {
                int n = ((TypeInsnNode)node).getOpcode();
                switch (n) {
                    case 187: {
                        stack.push(Type.getObjectType((String)((TypeInsnNode)node).desc));
                        break;
                    }
                    case 192: {
                        stack.pop();
                        stack.push(Type.getObjectType((String)((TypeInsnNode)node).desc));
                    }
                }
            }
            PrintingKt.verbose(Intrinsics.stringPlus((String)"Stack after analyzation frame looks like ", stack));
            abstractInsnNode = node.getNext();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"node.next");
            node = abstractInsnNode;
        }
        return stack;
    }
}

