/*
 * Decompiled with CFR 0.152.
 */
package dev.falsehonesty.asmhelper.dsl.code;

import dev.falsehonesty.asmhelper.dsl.code.modifiers.Modifier;
import dev.falsehonesty.asmhelper.printing.PrettyprintingKt;
import dev.falsehonesty.asmhelper.printing.PrintingKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0004J\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Ldev/falsehonesty/asmhelper/dsl/code/CodeBuilder;", "", "codeClassNode", "Lorg/objectweb/asm/tree/ClassNode;", "(Lorg/objectweb/asm/tree/ClassNode;)V", "getCodeClassNode", "()Lorg/objectweb/asm/tree/ClassNode;", "modifiers", "", "Ldev/falsehonesty/asmhelper/dsl/code/modifiers/Modifier;", "getModifiers", "()Ljava/util/List;", "getMethodNode", "Lorg/objectweb/asm/tree/MethodNode;", "transformToInstructions", "Lorg/objectweb/asm/tree/InsnList;", "AsmHelper1.8.9"})
public abstract class CodeBuilder {
    @NotNull
    private final ClassNode codeClassNode;

    public CodeBuilder(@NotNull ClassNode codeClassNode) {
        Intrinsics.checkNotNullParameter((Object)codeClassNode, (String)"codeClassNode");
        this.codeClassNode = codeClassNode;
    }

    @NotNull
    public final ClassNode getCodeClassNode() {
        return this.codeClassNode;
    }

    @NotNull
    public abstract List<Modifier> getModifiers();

    @NotNull
    protected final MethodNode getMethodNode() {
        Object v0;
        block1: {
            Iterable iterable = this.codeClassNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"codeClassNode.methods");
            iterable = iterable;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                MethodNode it = (MethodNode)e;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.name, (Object)"invoke") && Intrinsics.areEqual((Object)it.desc, (Object)"()V"))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @NotNull
    public final InsnList transformToInstructions() {
        InsnList instructions = this.getMethodNode().instructions;
        PrintingKt.verbose(Intrinsics.stringPlus((String)"Transforming code class ", (Object)this.codeClassNode.name));
        PrintingKt.verbose("Initial instruction list:");
        Intrinsics.checkNotNullExpressionValue((Object)instructions, (String)"instructions");
        PrintingKt.verbose(Intrinsics.stringPlus((String)"\n", (Object)PrettyprintingKt.prettyString(instructions)));
        PrintingKt.verbose("-----------------");
        Iterable $this$forEach$iv = this.getModifiers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Modifier it = (Modifier)element$iv;
            boolean bl = false;
            PrintingKt.verbose(Intrinsics.stringPlus((String)"Running cycle ", (Object)it));
            PrintingKt.verbose("-----------------");
            it.modify(instructions);
            PrintingKt.verbose("-----------------");
            PrintingKt.verbose(Intrinsics.stringPlus((String)"After cycle ", (Object)it));
            PrintingKt.verbose(Intrinsics.stringPlus((String)"\n", (Object)PrettyprintingKt.prettyString(instructions)));
        }
        return instructions;
    }
}

