/*
 * Decompiled with CFR 0.152.
 */
package dev.falsehonesty.asmhelper.dsl;

import dev.falsehonesty.asmhelper.dsl.code.InjectCodeBuilder;
import dev.falsehonesty.asmhelper.dsl.instructions.InsnListBuilder;
import dev.falsehonesty.asmhelper.printing.PrintingKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J?\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0019\u0010\r\u001a\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Ldev/falsehonesty/asmhelper/dsl/AsmWriter;", "", "className", "", "(Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "transform", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "transformToInstructions", "Lorg/objectweb/asm/tree/InsnList;", "insnListBuilder", "Lkotlin/Function1;", "Ldev/falsehonesty/asmhelper/dsl/instructions/InsnListBuilder;", "Lkotlin/ExtensionFunctionType;", "codeBlockClassName", "method", "Lorg/objectweb/asm/tree/MethodNode;", "AsmWriterBuilder", "AsmHelper1.8.9"})
public abstract class AsmWriter {
    @NotNull
    private final String className;

    public AsmWriter(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className = className;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public abstract void transform(@NotNull ClassNode var1);

    @Nullable
    protected final InsnList transformToInstructions(@Nullable Function1<? super InsnListBuilder, Unit> insnListBuilder, @Nullable String codeBlockClassName, @NotNull MethodNode method, @NotNull ClassNode classNode) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        if (insnListBuilder != null && codeBlockClassName != null) {
            PrintingKt.getLogger().error(this + " specifies both an insnList and a codeBlock, please pick one or the other.");
            insnList = null;
        } else if (insnListBuilder != null) {
            InsnListBuilder builder = new InsnListBuilder(method);
            Function1<? super InsnListBuilder, Unit> function1 = insnListBuilder;
            boolean bl = false;
            boolean bl2 = false;
            Function1<? super InsnListBuilder, Unit> it = function1;
            boolean bl3 = false;
            it.invoke((Object)builder);
            insnList = builder.build();
        } else if (codeBlockClassName != null) {
            String clazzPath = Intrinsics.stringPlus((String)StringsKt.replace$default((String)codeBlockClassName, (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)".class");
            InputStream clazzInputStream = this.getClass().getClassLoader().getResourceAsStream(clazzPath);
            ClassReader clazzReader = new ClassReader(clazzInputStream);
            ClassNode codeClassNode = new ClassNode();
            clazzReader.accept((ClassVisitor)codeClassNode, 4);
            InjectCodeBuilder codeBuilder = new InjectCodeBuilder(codeClassNode, classNode, method);
            insnList = codeBuilder.transformToInstructions();
        } else {
            PrintingKt.getLogger().error(this + " does not have instructions to inject. You must specify an insnList or codeBlock.");
            insnList = null;
        }
        return insnList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ldev/falsehonesty/asmhelper/dsl/AsmWriter$AsmWriterBuilder;", "", "()V", "fullMcVersion", "", "getFullMcVersion", "()I", "mcVersion", "getMcVersion", "AsmHelper1.8.9"})
    public static abstract class AsmWriterBuilder {
        private final int fullMcVersion;
        private final int mcVersion;

        public AsmWriterBuilder() {
            this.fullMcVersion = 10809;
            this.mcVersion = 8;
        }

        public final int getFullMcVersion() {
            return this.fullMcVersion;
        }

        public final int getMcVersion() {
            return this.mcVersion;
        }
    }
}

