/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.utils.console;

import com.chattriggers.ctjs.utils.Config;
import com.chattriggers.ctjs.utils.console.LogType;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J0\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/chattriggers/ctjs/utils/console/TextAreaWriter;", "Ljava/io/Writer;", "textArea", "Ljavax/swing/JTextPane;", "(Ljavax/swing/JTextPane;)V", "currentLogType", "Lcom/chattriggers/ctjs/utils/console/LogType;", "customColor", "Ljava/awt/Color;", "printWriter", "Ljava/io/PrintWriter;", "getPrintWriter", "()Ljava/io/PrintWriter;", "clear", "", "close", "flush", "println", "s", "", "logType", "end", "", "write", "cbuf", "", "off", "", "len", "ctjs"})
public final class TextAreaWriter
extends Writer {
    @NotNull
    private final JTextPane textArea;
    @NotNull
    private final PrintWriter printWriter;
    @NotNull
    private LogType currentLogType;
    @Nullable
    private Color customColor;

    public TextAreaWriter(@NotNull JTextPane textArea) {
        Intrinsics.checkNotNullParameter((Object)textArea, (String)"textArea");
        this.textArea = textArea;
        this.printWriter = new PrintWriter(this);
        this.currentLogType = LogType.INFO;
    }

    @NotNull
    public final PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) {
        Color color;
        StyleContext sc;
        String s;
        block6: {
            Color color2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                s = new String(cbuf, off, len);
                StyleContext styleContext = StyleContext.getDefaultStyleContext();
                Intrinsics.checkNotNullExpressionValue((Object)styleContext, (String)"getDefaultStyleContext()");
                sc = styleContext;
                color2 = this.customColor;
                if (color2 != null) break block5;
                switch (WhenMappings.$EnumSwitchMapping$0[this.currentLogType.ordinal()]) {
                    case 1: {
                        color = Config.INSTANCE.getConsoleForegroundColor();
                        break block6;
                    }
                    case 2: {
                        color = Config.INSTANCE.getConsoleWarningColor();
                        break block6;
                    }
                    case 3: {
                        color = Config.INSTANCE.getConsoleErrorColor();
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            color = color2;
        }
        Color color3 = color;
        AttributeSet attributeSet = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color3);
        Intrinsics.checkNotNullExpressionValue((Object)attributeSet, (String)"sc.addAttribute(\n       \u2026         color,\n        )");
        AttributeSet attributes = attributeSet;
        this.textArea.getDocument().insertString(this.textArea.getDocument().getLength(), s, attributes);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.currentLogType = LogType.INFO;
        this.customColor = null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @JvmOverloads
    public final void println(@NotNull Object s, @NotNull LogType logType, @NotNull String end, @Nullable Color customColor) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        if (Config.INSTANCE.getConsoleErrorAndWarningColors()) {
            this.currentLogType = logType;
            this.customColor = customColor;
        }
        this.printWriter.print(s);
        this.printWriter.print(end);
    }

    public static /* synthetic */ void println$default(TextAreaWriter textAreaWriter, Object object, LogType logType, String string, Color color, int n, Object object2) {
        if ((n & 2) != 0) {
            logType = LogType.INFO;
        }
        if ((n & 4) != 0) {
            string = "\n";
        }
        if ((n & 8) != 0) {
            color = null;
        }
        textAreaWriter.println(object, logType, string, color);
    }

    public final void clear() {
        this.textArea.setText("");
    }

    @JvmOverloads
    public final void println(@NotNull Object s, @NotNull LogType logType, @NotNull String end) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        TextAreaWriter.println$default(this, s, logType, end, null, 8, null);
    }

    @JvmOverloads
    public final void println(@NotNull Object s, @NotNull LogType logType) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        TextAreaWriter.println$default(this, s, logType, null, null, 12, null);
    }

    @JvmOverloads
    public final void println(@NotNull Object s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        TextAreaWriter.println$default(this, s, null, null, null, 14, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogType.values().length];
            nArray[LogType.INFO.ordinal()] = 1;
            nArray[LogType.WARN.ordinal()] = 2;
            nArray[LogType.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

