/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.utils.console;

import com.chattriggers.ctjs.Reference;
import com.chattriggers.ctjs.engine.ILoader;
import com.chattriggers.ctjs.engine.langs.Lang;
import com.chattriggers.ctjs.utils.Config;
import com.chattriggers.ctjs.utils.console.LogType;
import com.chattriggers.ctjs.utils.console.TextAreaWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ0\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00012\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\f2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J\u0006\u0010&\u001a\u00020\u001aR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/chattriggers/ctjs/utils/console/Console;", "", "loader", "Lcom/chattriggers/ctjs/engine/ILoader;", "(Lcom/chattriggers/ctjs/engine/ILoader;)V", "components", "", "Ljava/awt/Component;", "frame", "Ljavax/swing/JFrame;", "history", "", "", "historyOffset", "", "inputField", "Lorg/fife/ui/rsyntaxtextarea/RSyntaxTextArea;", "getLoader", "()Lcom/chattriggers/ctjs/engine/ILoader;", "textArea", "Ljavax/swing/JTextPane;", "writer", "Lcom/chattriggers/ctjs/utils/console/TextAreaWriter;", "getWriter", "()Lcom/chattriggers/ctjs/utils/console/TextAreaWriter;", "clearConsole", "", "printErrorWithColor", "error", "", "printStackTrace", "println", "obj", "logType", "Lcom/chattriggers/ctjs/utils/console/LogType;", "end", "customColor", "Ljava/awt/Color;", "showConsole", "Companion", "ctjs"})
public final class Console {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final ILoader loader;
    @NotNull
    private final JFrame frame;
    @NotNull
    private final JTextPane textArea;
    @NotNull
    private final RSyntaxTextArea inputField;
    @NotNull
    private final Set<Component> components;
    @NotNull
    private final List<String> history;
    private int historyOffset;
    @NotNull
    private final TextAreaWriter writer;
    @NotNull
    private static final Font FIRA_FONT;

    /*
     * WARNING - void declaration
     */
    public Console(@Nullable ILoader loader) {
        void $this$inputField_u24lambda_u2d0;
        String string;
        Object[] objectArray;
        String string2;
        this.loader = loader;
        StringBuilder stringBuilder = new StringBuilder().append("ChatTriggers 2.2.0 ");
        ILoader iLoader = this.loader;
        if (iLoader == null) {
            string2 = "Default";
        } else {
            Lang lang = iLoader.getLanguage();
            if (lang == null) {
                string2 = "Default";
            } else {
                string2 = lang.getLangName();
                if (string2 == null) {
                    string2 = "Default";
                }
            }
        }
        this.frame = new JFrame(stringBuilder.append(string2).append(" Console").toString());
        this.textArea = new JTextPane();
        Object[] objectArray2 = objectArray = new RSyntaxTextArea(5, 1);
        Console console2 = this;
        boolean bl = false;
        ILoader iLoader2 = this.getLoader();
        if (iLoader2 == null) {
            string = "text/plain";
        } else {
            Lang lang = iLoader2.getLanguage();
            if (lang == null) {
                string = "text/plain";
            } else {
                string = lang.getSyntaxStyle();
                if (string == null) {
                    string = "text/plain";
                }
            }
        }
        $this$inputField_u24lambda_u2d0.setSyntaxEditingStyle(string);
        Theme.load($this$inputField_u24lambda_u2d0.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/dark.xml")).apply((RSyntaxTextArea)$this$inputField_u24lambda_u2d0);
        $this$inputField_u24lambda_u2d0.setMargin(new Insets(5, 5, 5, 5));
        $this$inputField_u24lambda_u2d0.setCodeFoldingEnabled(true);
        console2.inputField = objectArray;
        objectArray = new Component[]{this.textArea};
        this.components = SetsKt.mutableSetOf((Object[])objectArray);
        this.history = new ArrayList();
        this.writer = new TextAreaWriter(this.textArea);
        this.frame.setDefaultCloseOperation(1);
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(5, 5, 5, 5));
        this.textArea.setAutoscrolls(true);
        Caret caret = this.textArea.getCaret();
        if (caret == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.text.DefaultCaret");
        }
        DefaultCaret caret2 = (DefaultCaret)caret;
        caret2.setUpdatePolicy(2);
        this.inputField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isControlDown()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        String command = inputField.getText();
                        inputField.setText("");
                        List list = history;
                        Intrinsics.checkNotNullExpressionValue((Object)command, (String)"command");
                        list.add(command);
                        historyOffset = 0;
                        if (Intrinsics.areEqual((Object)command, (Object)"help")) {
                            TextAreaWriter.println$default(this.getWriter(), "-------------- ChatTriggers Console Help --------------\n Shortcuts:\n  Control + Enter: Run code in the textbox\n  Control + UP / DOWN: Cycle between ran code history\n  Control + L: Clear console\n  Control + R: Reload ChatTriggers\n-------------------------------------------------------", null, null, null, 14, null);
                            break;
                        }
                        TextAreaWriter textAreaWriter = this.getWriter();
                        String string = StringsKt.prependIndent((String)command, (String)"    > ").substring(6);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        TextAreaWriter.println$default(textAreaWriter, Intrinsics.stringPlus((String)"eval> ", (Object)string), null, null, null, 14, null);
                        try {
                            ILoader iLoader = this.getLoader();
                            String string2 = iLoader == null ? null : iLoader.eval(command);
                            if (string2 == null) {
                                return;
                            }
                            TextAreaWriter.println$default(this.getWriter(), string2, null, null, null, 14, null);
                        }
                        catch (Throwable e2) {
                            this.printStackTrace(e2);
                        }
                        break;
                    }
                    case 38: {
                        Console command = this;
                        int n = command.historyOffset;
                        command.historyOffset = n + 1;
                        try {
                            String message = (String)history.get(history.size() - historyOffset);
                            inputField.setText(message);
                        }
                        catch (Exception exception) {
                            Console console2 = this;
                            int n2 = console2.historyOffset;
                            console2.historyOffset = n2 + -1;
                        }
                        break;
                    }
                    case 40: {
                        Console exception = this;
                        int n = exception.historyOffset;
                        exception.historyOffset = n + -1;
                        if (historyOffset < 0) {
                            historyOffset = 0;
                        }
                        try {
                            String message = (String)history.get(history.size() - historyOffset);
                            inputField.setText(message);
                        }
                        catch (Exception exception2) {
                            historyOffset = 0;
                            inputField.setText("");
                        }
                        break;
                    }
                    case 76: {
                        this.clearConsole();
                        break;
                    }
                    case 82: {
                        Reference.loadCT();
                    }
                }
            }
        });
        this.frame.add(new JScrollPane(this.textArea));
        this.frame.add((Component)this.inputField, "South");
        this.frame.pack();
        this.frame.setVisible(false);
        this.frame.setSize(800, 600);
    }

    @Nullable
    public final ILoader getLoader() {
        return this.loader;
    }

    @NotNull
    public final TextAreaWriter getWriter() {
        return this.writer;
    }

    public final void clearConsole() {
        SwingUtilities.invokeLater(() -> Console.clearConsole$lambda-1(this));
    }

    @JvmOverloads
    public final void println(@NotNull Object obj, @NotNull LogType logType, @NotNull String end, @Nullable Color customColor) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        SwingUtilities.invokeLater(() -> Console.println$lambda-2(this, obj, logType, end, customColor));
    }

    public static /* synthetic */ void println$default(Console console2, Object object, LogType logType, String string, Color color, int n, Object object2) {
        if ((n & 2) != 0) {
            logType = LogType.INFO;
        }
        if ((n & 4) != 0) {
            string = "\n";
        }
        if ((n & 8) != 0) {
            color = null;
        }
        console2.println(object, logType, string, color);
    }

    public final void printStackTrace(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        SwingUtilities.invokeLater(() -> Console.printStackTrace$lambda-5(this, error));
    }

    private final void printErrorWithColor(Throwable error) {
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        String stacktrace = string;
        TextAreaWriter.println$default(this.writer, stacktrace, LogType.ERROR, null, null, 12, null);
    }

    public final void showConsole() {
        Color fg;
        Color bg;
        block48: {
            block47: {
                this.frame.setVisible(true);
                bg = null;
                fg = null;
                if (!Config.INSTANCE.getCustomTheme()) break block47;
                bg = Config.INSTANCE.getConsoleBackgroundColor();
                fg = Config.INSTANCE.getConsoleForegroundColor();
                break block48;
            }
            switch (Config.INSTANCE.getConsoleTheme()) {
                case "ashes.dark": {
                    bg = new Color(28, 32, 35);
                    fg = new Color(199, 204, 209);
                    break;
                }
                case "atelierforest.dark": {
                    bg = new Color(28, 32, 35);
                    fg = new Color(199, 204, 209);
                    break;
                }
                case "isotope.dark": {
                    bg = new Color(0, 0, 0);
                    fg = new Color(208, 208, 208);
                    break;
                }
                case "codeschool.dark": {
                    bg = new Color(22, 27, 29);
                    fg = new Color(126, 162, 180);
                    break;
                }
                case "gotham": {
                    bg = new Color(10, 15, 20);
                    fg = new Color(152, 209, 206);
                    break;
                }
                case "hybrid": {
                    bg = new Color(29, 31, 33);
                    fg = new Color(197, 200, 198);
                    break;
                }
                case "3024.light": {
                    bg = new Color(247, 247, 247);
                    fg = new Color(74, 69, 67);
                    break;
                }
                case "chalk.light": {
                    bg = new Color(245, 245, 245);
                    fg = new Color(48, 48, 48);
                    break;
                }
                case "blue": {
                    bg = new Color(15, 18, 32);
                    fg = new Color(221, 223, 235);
                    break;
                }
                case "slate": {
                    bg = new Color(33, 36, 41);
                    fg = new Color(193, 199, 208);
                    break;
                }
                case "red": {
                    bg = new Color(26, 9, 11);
                    fg = new Color(231, 210, 212);
                    break;
                }
                case "green": {
                    bg = new Color(6, 10, 10);
                    fg = new Color(47, 227, 149);
                    break;
                }
                case "aids": {
                    bg = new Color(251, 251, 28);
                    fg = new Color(192, 20, 214);
                    break;
                }
                case "default.dark": {
                    bg = new Color(41, 49, 52);
                    fg = new Color(208, 208, 208);
                    break;
                }
                default: {
                    bg = new Color(21, 21, 21);
                    fg = new Color(208, 208, 208);
                }
            }
        }
        for (Component comp : this.components) {
            comp.setBackground(bg);
            comp.setForeground(fg);
        }
        this.frame.toFront();
        this.frame.repaint();
        Font chosenFont = Config.INSTANCE.getConsoleFiraCodeFont() ? FIRA_FONT.deriveFont((float)Config.INSTANCE.getConsoleFontSize()) : new Font("DejaVu Sans Mono", 0, 15).deriveFont((float)Config.INSTANCE.getConsoleFontSize());
        this.textArea.setFont(chosenFont);
        this.inputField.setFont(chosenFont);
        this.frame.toFront();
        this.frame.repaint();
    }

    @JvmOverloads
    public final void println(@NotNull Object obj, @NotNull LogType logType, @NotNull String end) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Console.println$default(this, obj, logType, end, null, 8, null);
    }

    @JvmOverloads
    public final void println(@NotNull Object obj, @NotNull LogType logType) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Console.println$default(this, obj, logType, null, null, 12, null);
    }

    @JvmOverloads
    public final void println(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Console.println$default(this, obj, null, null, null, 14, null);
    }

    private static final void clearConsole$lambda-1(Console this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writer.clear();
    }

    private static final void println$lambda-2(Console this$0, Object $obj, LogType $logType, String $end, Color $customColor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$obj, (String)"$obj");
        Intrinsics.checkNotNullParameter((Object)((Object)$logType), (String)"$logType");
        Intrinsics.checkNotNullParameter((Object)$end, (String)"$end");
        try {
            this$0.writer.println($obj.toString(), $logType, $end, $customColor);
        }
        catch (Exception exception) {
            this$0.println($obj.toString(), $logType, $end, $customColor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void printStackTrace$lambda-5(Console this$0, Throwable $error) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n;
            Object object;
            Object $this$indexOfFirst$iv;
            block13: {
                if (Config.INSTANCE.getOpenConsoleOnError()) {
                    this$0.showConsole();
                }
                StackTraceElement[] stackTraceElementArray = $error.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"error.stackTrace");
                $this$indexOfFirst$iv = stackTraceElementArray;
                boolean $i$f$indexOfFirst = false;
                int n2 = ((Object[])$this$indexOfFirst$iv).length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    boolean bl;
                    StackTraceElement it = (StackTraceElement)$this$indexOfFirst$iv[index$iv];
                    boolean bl2 = false;
                    StackTraceElement stackTraceElement = it;
                    if (stackTraceElement == null) {
                        bl = false;
                    } else {
                        object = stackTraceElement.getFileName();
                        if (object == null) {
                            bl = false;
                        } else {
                            boolean bl3;
                            String string = ((String)object).toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                            bl = string == null ? false : (bl3 = StringsKt.contains$default((CharSequence)string, (CharSequence)"jsloader", (boolean)false, (int)2, null));
                        }
                    }
                    if (!bl) continue;
                    n = index$iv;
                    break block13;
                }
                n = -1;
            }
            int index = n;
            $this$indexOfFirst$iv = $error.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)$this$indexOfFirst$iv, (String)"error.stackTrace");
            $this$indexOfFirst$iv = ArraysKt.dropLast((Object[])$this$indexOfFirst$iv, (int)($error.getStackTrace().length - index - 1));
            Throwable throwable = $error;
            boolean $i$f$map = false;
            void index$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StackTraceElement stackTraceElement;
                void it;
                object = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getFileName();
                Integer n3 = string == null ? null : Integer.valueOf(StringsKt.indexOf$default((CharSequence)string, (String)"ChatTriggers/modules/", (int)0, (boolean)false, (int)6, null));
                if (n3 == null) {
                    stackTraceElement = it;
                } else {
                    int fileNameIndex = n3;
                    String string2 = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.className");
                    int classNameIndex = StringsKt.indexOf$default((CharSequence)string2, (String)"ChatTriggers_modules_", (int)0, (boolean)false, (int)6, null);
                    if (fileNameIndex != -1) {
                        string2 = it.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.className");
                        String string3 = string2.substring(classNameIndex + 21);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                        String string4 = it.getMethodName();
                        String string5 = it.getFileName();
                        Intrinsics.checkNotNull((Object)string5);
                        String string6 = string5.substring(fileNameIndex + 21);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                        stackTraceElement = new StackTraceElement(string3, string4, string6, it.getLineNumber());
                    } else {
                        stackTraceElement = it;
                    }
                }
                collection.add(stackTraceElement);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
            Intrinsics.checkNotNull((Object)stackTraceElementArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            throwable.setStackTrace(stackTraceElementArray);
            this$0.printErrorWithColor($error);
        }
        catch (Throwable ignored) {
            $error.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        FileInputStream fileInputStream;
        Companion = new Companion(null);
        int n = 0;
        String string = System.getProperty("ct.firaFile", null);
        if (string == null) {
            fileInputStream = null;
        } else {
            void it;
            String string2 = string;
            int n2 = n;
            boolean bl = false;
            FileInputStream fileInputStream2 = new FileInputStream(new File((String)it));
            n = n2;
            fileInputStream = fileInputStream2;
        }
        FileInputStream fileInputStream3 = fileInputStream;
        Font font = Font.createFont(n, fileInputStream3 == null ? Companion.getClass().getResourceAsStream("/FiraCode-Regular.otf") : (InputStream)fileInputStream3).deriveFont(9.0f);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"createFont(\n            \u2026\n        ).deriveFont(9f)");
        FIRA_FONT = font;
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(FIRA_FONT);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/chattriggers/ctjs/utils/console/Console$Companion;", "", "()V", "FIRA_FONT", "Ljava/awt/Font;", "getFIRA_FONT", "()Ljava/awt/Font;", "ctjs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font getFIRA_FONT() {
            return FIRA_FONT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

