/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.wrappers.inventory.nbt;

import com.chattriggers.ctjs.minecraft.wrappers.inventory.nbt.NBTBase;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.nbt.NBTTagCompound;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.nbt.NBTTagList;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u001c\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0015H\u0007J\u001a\u0010\u0016\u001a\u00060\u000bj\u0002`\f*\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/nbt/NBT;", "", "()V", "numberNBTFormat", "Lkotlin/text/Regex;", "parse", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/nbt/NBTBase;", "nbt", "options", "Lorg/mozilla/javascript/NativeObject;", "parseString", "Lnet/minecraft/nbt/NBTBase;", "Lcom/chattriggers/ctjs/utils/kotlin/MCNBTBase;", "nbtData", "", "coerceNumericStrings", "", "toArray", "Lorg/mozilla/javascript/NativeArray;", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/nbt/NBTTagList;", "toObject", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/nbt/NBTTagCompound;", "toNBT", "ctjs"})
public final class NBT {
    @NotNull
    public static final NBT INSTANCE = new NBT();
    @NotNull
    private static final Regex numberNBTFormat = new Regex("^([+-]?\\d+\\.?\\d*)([bslfd])?$", RegexOption.IGNORE_CASE);

    private NBT() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTBase parse(@NotNull Object nbt, @Nullable NativeObject options) throws NBTException {
        NBTBase nBTBase;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Object object = nbt;
        if (object instanceof NativeObject) {
            nBTBase = new NBTTagCompound((net.minecraft.nbt.NBTTagCompound)INSTANCE.toNBT(nbt, options));
        } else if (object instanceof NativeArray) {
            net.minecraft.nbt.NBTBase it = INSTANCE.toNBT(nbt, options);
            boolean bl = false;
            nBTBase = it instanceof net.minecraft.nbt.NBTTagList ? (NBTBase)new NBTTagList((net.minecraft.nbt.NBTTagList)it) : new NBTBase(it);
        } else {
            nBTBase = new NBTBase(INSTANCE.toNBT(nbt, options));
        }
        return nBTBase;
    }

    public static /* synthetic */ NBTBase parse$default(Object object, NativeObject nativeObject, int n, Object object2) throws NBTException {
        if ((n & 2) != 0) {
            nativeObject = null;
        }
        return NBT.parse(object, nativeObject);
    }

    @JvmStatic
    @NotNull
    public static final NativeObject toObject(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return nbt.toObject();
    }

    @JvmStatic
    @NotNull
    public static final NativeArray toArray(@NotNull NBTTagList nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return nbt.toArray();
    }

    private final net.minecraft.nbt.NBTBase toNBT(Object $this$toNBT, NativeObject options) throws NBTException {
        net.minecraft.nbt.NBTBase nBTBase;
        boolean preferArraysOverLists = Boolean.parseBoolean(ExtensionsKt.getOption(options, "preferArraysOverLists", false));
        boolean coerceNumericStrings = Boolean.parseBoolean(ExtensionsKt.getOption(options, "coerceNumericStrings", false));
        Object object = $this$toNBT;
        if (object instanceof NativeObject) {
            net.minecraft.nbt.NBTTagCompound nBTTagCompound;
            net.minecraft.nbt.NBTTagCompound $this$toNBT_u24lambda_u2d2 = nBTTagCompound = new net.minecraft.nbt.NBTTagCompound();
            boolean bl = false;
            Set<Map.Entry<Object, Object>> set = ((NativeObject)$this$toNBT).entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Map map = $this$toNBT_u24lambda_u2d2.field_74784_a;
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"tagMap");
                String string = entry.getKey().toString();
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
                map.put(string, INSTANCE.toNBT(v, options));
            }
            nBTBase = (net.minecraft.nbt.NBTBase)nBTTagCompound;
        } else {
            if (object instanceof NativeArray) {
                net.minecraft.nbt.NBTBase nBTBase2;
                boolean bl;
                boolean $i$f$all;
                Iterable $this$all$iv;
                List normalized;
                net.minecraft.nbt.NBTBase it;
                Object item$iv$iv;
                Iterable $this$mapTo$iv$iv;
                Collection destination$iv$iv;
                boolean $i$f$map;
                Iterable $this$map$iv;
                block36: {
                    $this$map$iv = (Iterable)$this$toNBT;
                    $i$f$map = false;
                    Iterable $this$forEach$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator element$iv = $this$mapTo$iv$iv.iterator();
                    while (element$iv.hasNext()) {
                        Object bl2 = item$iv$iv = element$iv.next();
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        void v2 = it;
                        collection.add(v2 == null ? null : INSTANCE.toNBT(v2, options));
                    }
                    normalized = (List)destination$iv$iv;
                    if (!preferArraysOverLists || normalized.isEmpty()) {
                        Iterable $this$toNBT_u24lambda_u2d4 = $this$map$iv = new net.minecraft.nbt.NBTTagList();
                        boolean bl4 = false;
                        ((net.minecraft.nbt.NBTTagList)$this$toNBT_u24lambda_u2d4).field_74747_a = normalized;
                        return (net.minecraft.nbt.NBTBase)$this$map$iv;
                    }
                    $this$all$iv = normalized;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            net.minecraft.nbt.NBTBase it2 = (net.minecraft.nbt.NBTBase)element$iv2;
                            boolean bl5 = false;
                            if (it2 instanceof NBTTagByte) continue;
                            bl = false;
                            break block36;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    $this$map$iv = normalized;
                    $i$f$map = false;
                    Iterable bl4 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator bl5 = $this$mapTo$iv$iv.iterator();
                    while (bl5.hasNext()) {
                        item$iv$iv = bl5.next();
                        it = (net.minecraft.nbt.NBTBase)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl6 = false;
                        net.minecraft.nbt.NBTBase nBTBase3 = it;
                        if (nBTBase3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagByte");
                        }
                        collection.add(((NBTTagByte)nBTBase3).func_150290_f());
                    }
                    byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                    nBTBase2 = (net.minecraft.nbt.NBTBase)new NBTTagByteArray(byArray);
                } else {
                    boolean bl7;
                    block37: {
                        $this$all$iv = normalized;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                net.minecraft.nbt.NBTBase it3 = (net.minecraft.nbt.NBTBase)element$iv2;
                                boolean bl8 = false;
                                if (it3 instanceof NBTTagInt) continue;
                                bl7 = false;
                                break block37;
                            }
                            bl7 = true;
                        }
                    }
                    if (bl7) {
                        $this$map$iv = normalized;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            item$iv$iv = iterator.next();
                            it = (net.minecraft.nbt.NBTBase)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl9 = false;
                            net.minecraft.nbt.NBTBase nBTBase4 = it;
                            if (nBTBase4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagInt");
                            }
                            collection.add(((NBTTagInt)nBTBase4).func_150287_d());
                        }
                        int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                        nBTBase2 = (net.minecraft.nbt.NBTBase)new NBTTagIntArray(nArray);
                    } else {
                        net.minecraft.nbt.NBTTagList nBTTagList;
                        net.minecraft.nbt.NBTTagList $this$toNBT_u24lambda_u2d9 = nBTTagList = new net.minecraft.nbt.NBTTagList();
                        boolean bl10 = false;
                        $this$toNBT_u24lambda_u2d9.field_74747_a = normalized;
                        nBTBase2 = (net.minecraft.nbt.NBTBase)nBTTagList;
                    }
                }
                return nBTBase2;
            }
            if (object instanceof Boolean) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagByte((Boolean)$this$toNBT != false ? (byte)1 : 0);
            } else if (object instanceof String) {
                nBTBase = this.parseString((String)$this$toNBT, coerceNumericStrings);
            } else if (object instanceof Byte) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagByte(((Number)$this$toNBT).byteValue());
            } else if (object instanceof Short) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagShort(((Number)$this$toNBT).shortValue());
            } else if (object instanceof Integer) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagInt(((Number)$this$toNBT).intValue());
            } else if (object instanceof Long) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagLong(((Number)$this$toNBT).longValue());
            } else if (object instanceof Float) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagFloat(((Number)$this$toNBT).floatValue());
            } else if (object instanceof Double) {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagDouble(((Number)$this$toNBT).doubleValue());
            } else {
                throw new NBTException(Intrinsics.stringPlus((String)"Invalid NBT. Value provided: ", (Object)$this$toNBT));
            }
        }
        return nBTBase;
    }

    private final net.minecraft.nbt.NBTBase parseString(String nbtData, boolean coerceNumericStrings) {
        net.minecraft.nbt.NBTBase nBTBase;
        if (!coerceNumericStrings) {
            return (net.minecraft.nbt.NBTBase)new NBTTagString(nbtData);
        }
        MatchResult matchResult = numberNBTFormat.matchEntire((CharSequence)nbtData);
        List list = matchResult == null ? null : matchResult.getGroupValues();
        if (list == null) {
            return (net.minecraft.nbt.NBTBase)new NBTTagString(nbtData);
        }
        List res = list;
        String number = (String)res.get(1);
        String suffix = (String)res.get(2);
        String string = suffix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        switch (string) {
            case "": {
                nBTBase = (net.minecraft.nbt.NBTBase)(StringsKt.contains$default((CharSequence)number, (CharSequence)".", (boolean)false, (int)2, null) ? (NBTBase.NBTPrimitive)new NBTTagDouble(Double.parseDouble(number)) : (NBTBase.NBTPrimitive)new NBTTagInt(Integer.parseInt(number)));
                break;
            }
            case "b": {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagByte(Byte.parseByte(number));
                break;
            }
            case "s": {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagShort(Short.parseShort(number));
                break;
            }
            case "l": {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagLong(Long.parseLong(number));
                break;
            }
            case "f": {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagFloat(Float.parseFloat(number));
                break;
            }
            case "d": {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagDouble(Double.parseDouble(number));
                break;
            }
            default: {
                nBTBase = (net.minecraft.nbt.NBTBase)new NBTTagString(nbtData);
            }
        }
        return nBTBase;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTBase parse(@NotNull Object nbt) throws NBTException {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return NBT.parse$default(nbt, null, 2, null);
    }
}

