/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.wrappers.inventory;

import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.libs.renderer.Renderer;
import com.chattriggers.ctjs.minecraft.objects.message.TextComponent;
import com.chattriggers.ctjs.minecraft.wrappers.Client;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.minecraft.wrappers.entity.Entity;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.nbt.NBTTagCompound;
import com.chattriggers.ctjs.minecraft.wrappers.world.block.BlockType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fJ0\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020#2\b\b\u0002\u0010%\u001a\u00020#2\b\b\u0002\u0010&\u001a\u00020#H\u0007J\u0013\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010)\u001a\u00020\tJ\u0006\u0010*\u001a\u00020\tJ\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0,J\u0006\u0010-\u001a\u00020\tJ\b\u0010.\u001a\u00020/H\u0007J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000601J\u0006\u00102\u001a\u00020\tJ\u0006\u00103\u001a\u00020\tJ\u0006\u00104\u001a\u00020/J\u0006\u00105\u001a\u00020\u0006J\u0006\u00106\u001a\u00020\u0006J\u0006\u00107\u001a\u00020\u0006J\u0006\u00108\u001a\u00020\tJ\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020\u0006J\b\u0010<\u001a\u00020\tH\u0016J\u0006\u0010=\u001a\u00020\u001dJ\u0006\u0010>\u001a\u00020\u001dJ\u0006\u0010?\u001a\u00020\u001dJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\tJ\u001f\u0010B\u001a\u00020\u00002\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060D\"\u00020\u0006\u00a2\u0006\u0002\u0010EJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0006J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\tJ\b\u0010J\u001a\u00020\u0006H\u0016R\u0015\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004\u00a8\u0006K"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/Item;", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "itemName", "", "(Ljava/lang/String;)V", "itemID", "", "(I)V", "block", "Lcom/chattriggers/ctjs/minecraft/wrappers/world/block/BlockType;", "(Lcom/chattriggers/ctjs/minecraft/wrappers/world/block/BlockType;)V", "entityItem", "Lnet/minecraft/entity/item/EntityItem;", "(Lnet/minecraft/entity/item/EntityItem;)V", "entity", "Lcom/chattriggers/ctjs/minecraft/wrappers/entity/Entity;", "(Lcom/chattriggers/ctjs/minecraft/wrappers/entity/Entity;)V", "item", "Lnet/minecraft/item/Item;", "Lcom/chattriggers/ctjs/utils/kotlin/MCItem;", "getItem", "()Lnet/minecraft/item/Item;", "getItemStack", "()Lnet/minecraft/item/ItemStack;", "setItemStack", "canDestroy", "", "canHarvest", "canPlaceOn", "draw", "", "x", "", "y", "scale", "z", "equals", "other", "getDamage", "getDurability", "getEnchantments", "", "getID", "getItemNBT", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/nbt/NBTTagCompound;", "getLore", "", "getMaxDamage", "getMetadata", "getNBT", "getName", "getRawNBT", "getRegistryName", "getStackSize", "getTextComponent", "Lcom/chattriggers/ctjs/minecraft/objects/message/TextComponent;", "getUnlocalizedName", "hashCode", "isDamagable", "isEnchantable", "isEnchanted", "setDamage", "damage", "setLore", "loreLines", "", "([Ljava/lang/String;)Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/Item;", "setName", "name", "setStackSize", "stackSize", "toString", "ctjs"})
public final class Item {
    @NotNull
    private final net.minecraft.item.Item item;
    @NotNull
    private ItemStack itemStack;

    @NotNull
    public final net.minecraft.item.Item getItem() {
        return this.item;
    }

    @NotNull
    public final ItemStack getItemStack() {
        return this.itemStack;
    }

    public final void setItemStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.itemStack = itemStack;
    }

    public Item(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        net.minecraft.item.Item item = itemStack.func_77973_b();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"itemStack.item");
        this.item = item;
        this.itemStack = itemStack;
    }

    public Item(@NotNull String itemName) {
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        net.minecraft.item.Item item = net.minecraft.item.Item.func_111206_d((String)itemName);
        if (item == null) {
            throw new IllegalArgumentException("Item with name or id " + itemName + " does not exist");
        }
        this.item = item;
        this.itemStack = new ItemStack(this.item);
    }

    public Item(int itemID) {
        net.minecraft.item.Item item = net.minecraft.item.Item.func_150899_d((int)itemID);
        if (item == null) {
            throw new IllegalArgumentException("Item with id " + itemID + " does not exist");
        }
        this.item = item;
        this.itemStack = new ItemStack(this.item);
    }

    public Item(@NotNull BlockType block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        net.minecraft.item.Item item = net.minecraft.item.Item.func_150898_a((Block)block.getMcBlock());
        if (item == null) {
            throw new IllegalArgumentException("BlockType " + block + " does not exist");
        }
        this.item = item;
        this.itemStack = new ItemStack(this.item);
    }

    public Item(@NotNull EntityItem entityItem) {
        Intrinsics.checkNotNullParameter((Object)entityItem, (String)"entityItem");
        net.minecraft.item.Item item = entityItem.func_92059_d().func_77973_b();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"entityItem.entityItem.item");
        this.item = item;
        item = entityItem.func_92059_d();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"entityItem.entityItem");
        this.itemStack = item;
    }

    public Item(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity.getEntity() instanceof EntityItem)) {
            boolean bl = false;
            String string = "Entity is not of type EntityItem";
            throw new IllegalArgumentException(string.toString());
        }
        net.minecraft.item.Item item = ((EntityItem)entity.getEntity()).func_92059_d().func_77973_b();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"entity.entity.entityItem.item");
        this.item = item;
        item = ((EntityItem)entity.getEntity()).func_92059_d();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"entity.entity.entityItem");
        this.itemStack = item;
    }

    @NotNull
    public final TextComponent getTextComponent() {
        IChatComponent iChatComponent = this.itemStack.func_151000_E();
        Intrinsics.checkNotNullExpressionValue((Object)iChatComponent, (String)"itemStack.chatComponent");
        return new TextComponent(iChatComponent);
    }

    @NotNull
    public final String getRawNBT() {
        String string = this.itemStack.serializeNBT().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemStack.serializeNBT().toString()");
        return string;
    }

    @NotNull
    public final NBTTagCompound getNBT() {
        net.minecraft.nbt.NBTTagCompound nBTTagCompound = this.itemStack.serializeNBT();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"itemStack.serializeNBT()");
        return new NBTTagCompound(nBTTagCompound);
    }

    @Deprecated(message="Use the better-named method", replaceWith=@ReplaceWith(expression="getNBT", imports={}))
    @NotNull
    public final NBTTagCompound getItemNBT() {
        return this.getNBT();
    }

    public final int getID() {
        return net.minecraft.item.Item.func_150891_b((net.minecraft.item.Item)this.item);
    }

    @NotNull
    public final Item setStackSize(int stackSize) {
        Item item;
        Item $this$setStackSize_u24lambda_u2d1 = item = this;
        boolean bl = false;
        $this$setStackSize_u24lambda_u2d1.getItemStack().field_77994_a = stackSize;
        return item;
    }

    public final int getStackSize() {
        return this.itemStack.field_77994_a;
    }

    @NotNull
    public final String getUnlocalizedName() {
        String string = this.item.func_77658_a();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.unlocalizedName");
        return string;
    }

    @NotNull
    public final String getRegistryName() {
        return this.item.getRegistryName().toString();
    }

    @NotNull
    public final String getName() {
        String string = this.itemStack.func_82833_r();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemStack.displayName");
        return string;
    }

    @NotNull
    public final Item setName(@NotNull String name) {
        Item item;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Item $this$setName_u24lambda_u2d2 = item = this;
        boolean bl = false;
        $this$setName_u24lambda_u2d2.getItemStack().func_151001_c(ChatLib.addColor(name));
        return item;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getEnchantments() {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)this.itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantments(itemStack)");
        boolean $i$f$mapKeys = false;
        void var3_3 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string = Enchantment.func_180306_c((int)((Number)k).intValue()).func_77320_a();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEnchantmentById(\n    \u2026dif\n                .name");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = StringsKt.replace$default((String)string, (String)"enchantment.", (String)"", (boolean)false, (int)4, null);
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string2, entry);
        }
        return destination$iv$iv;
    }

    public final boolean isEnchantable() {
        return this.itemStack.func_77956_u();
    }

    public final boolean isEnchanted() {
        return this.itemStack.func_77948_v();
    }

    public final int getMetadata() {
        return this.itemStack.func_77960_j();
    }

    public final boolean canPlaceOn(@NotNull BlockType block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.itemStack.func_179547_d(block.getMcBlock());
    }

    public final boolean canHarvest(@NotNull BlockType block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.itemStack.func_150998_b(block.getMcBlock());
    }

    public final boolean canDestroy(@NotNull BlockType block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.itemStack.func_179544_c(block.getMcBlock());
    }

    public final int getDurability() {
        return this.getMaxDamage() - this.getDamage();
    }

    public final int getDamage() {
        return this.itemStack.func_77952_i();
    }

    @NotNull
    public final Item setDamage(int damage) {
        Item item;
        Item $this$setDamage_u24lambda_u2d4 = item = this;
        boolean bl = false;
        $this$setDamage_u24lambda_u2d4.getItemStack().func_77964_b(damage);
        return item;
    }

    public final int getMaxDamage() {
        return this.itemStack.func_77958_k();
    }

    public final boolean isDamagable() {
        return this.itemStack.func_77984_f();
    }

    @NotNull
    public final List<String> getLore() {
        List list = this.itemStack.func_82840_a((EntityPlayer)Player.getPlayer(), Client.Companion.getMinecraft().field_71474_y.field_82882_x);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"itemStack.getTooltip(Pla\u2026ngs.advancedItemTooltips)");
        return list;
    }

    @NotNull
    public final Item setLore(String ... loreLines) {
        Item item;
        Intrinsics.checkNotNullParameter((Object)loreLines, (String)"loreLines");
        Item $this$setLore_u24lambda_u2d8 = item = this;
        boolean bl = false;
        if ($this$setLore_u24lambda_u2d8.getItemStack().func_77978_p() == null) {
            $this$setLore_u24lambda_u2d8.getItemStack().func_77982_d(new net.minecraft.nbt.NBTTagCompound());
        }
        NBTTagCompound it = $this$setLore_u24lambda_u2d8.getNBT().getCompoundTag("tag");
        boolean bl2 = false;
        if (!it.getRawNBT().func_74764_b("display")) {
            it.set("display", new net.minecraft.nbt.NBTTagCompound());
        }
        it = it.getCompoundTag("display");
        boolean bl3 = false;
        if (!it.getRawNBT().func_74764_b("display")) {
            it.set("Lore", new NBTTagList());
        }
        NBTTagList lore = it.getTagList("Lore", 8);
        lore.field_74747_a.clear();
        String[] $this$forEach$iv = loreLines;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it2 = element$iv = $this$forEach$iv[i];
            boolean bl4 = false;
            lore.func_74742_a((NBTBase)new NBTTagString(ChatLib.addColor(it2)));
        }
        return item;
    }

    @JvmOverloads
    public final void draw(float x, float y, float scale, float z) {
        RenderItem itemRenderer = Client.Companion.getMinecraft().func_175599_af();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)(x / scale), (float)(y / scale), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        itemRenderer.field_77023_b = z;
        itemRenderer.func_175042_a(this.itemStack, 0, 0);
        Renderer.finishDraw();
    }

    public static /* synthetic */ void draw$default(Item item, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 1.0f;
        }
        if ((n & 8) != 0) {
            f4 = 200.0f;
        }
        item.draw(f, f2, f3, f4);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Item && this.getID() == ((Item)other).getID() && this.getStackSize() == ((Item)other).getStackSize() && this.getDamage() == ((Item)other).getDamage();
    }

    public int hashCode() {
        int result = this.item.hashCode();
        result = 31 * result + this.itemStack.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.itemStack.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemStack.toString()");
        return string;
    }

    @JvmOverloads
    public final void draw(float x, float y, float scale) {
        Item.draw$default(this, x, y, scale, 0.0f, 8, null);
    }

    @JvmOverloads
    public final void draw(float x, float y) {
        Item.draw$default(this, x, y, 0.0f, 0.0f, 12, null);
    }

    @JvmOverloads
    public final void draw(float x) {
        Item.draw$default(this, x, 0.0f, 0.0f, 0.0f, 14, null);
    }

    @JvmOverloads
    public final void draw() {
        Item.draw$default(this, 0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }
}

