/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.wrappers.inventory;

import com.chattriggers.ctjs.engine.langs.js.JSONImpl;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.Item;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.action.Action;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.action.ClickAction;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.action.DragAction;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.action.DropAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00122\n\u0010\u001d\u001a\u00020\u001e\"\u00020\u000eJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\u0012J\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150#J\u0006\u0010$\u001a\u00020\u0012J\u0006\u0010%\u001a\u00020\u000eJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010)\u001a\u00020\u0010J\u0016\u0010*\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010+\u001a\u00020\u0012H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/Inventory;", "Lcom/chattriggers/ctjs/engine/langs/js/JSONImpl;", "inventory", "Lnet/minecraft/inventory/IInventory;", "(Lnet/minecraft/inventory/IInventory;)V", "container", "Lnet/minecraft/inventory/Container;", "(Lnet/minecraft/inventory/Container;)V", "getContainer", "()Lnet/minecraft/inventory/Container;", "getInventory", "()Lnet/minecraft/inventory/IInventory;", "click", "slot", "", "shift", "", "button", "", "contains", "item", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/Item;", "id", "doAction", "", "action", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/action/Action;", "drag", "type", "slots", "", "drop", "ctrl", "getClassName", "getItems", "", "getName", "getSize", "getStackInSlot", "getWindowId", "indexOf", "isContainer", "isItemValidForSlot", "toString", "ctjs"})
public final class Inventory
implements JSONImpl {
    @Nullable
    private final IInventory inventory;
    @Nullable
    private final Container container;

    @Nullable
    public final IInventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public final Container getContainer() {
        return this.container;
    }

    public Inventory(@NotNull IInventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        this.inventory = inventory;
        this.container = null;
    }

    public Inventory(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.container = container;
        this.inventory = null;
    }

    public final int getSize() {
        int n;
        IInventory iInventory = this.inventory;
        Integer n2 = iInventory == null ? null : Integer.valueOf(iInventory.func_70302_i_());
        if (n2 == null) {
            Container container = this.container;
            Intrinsics.checkNotNull((Object)container);
            n = container.field_75151_b.size();
        } else {
            n = n2;
        }
        return n;
    }

    @Nullable
    public final Item getStackInSlot(int slot) {
        Item item;
        if (this.inventory == null) {
            Container container = this.container;
            Intrinsics.checkNotNull((Object)container);
            ItemStack itemStack = container.func_75139_a(slot).func_75211_c();
            if (itemStack == null) {
                item = null;
            } else {
                ItemStack p0 = itemStack;
                boolean bl = false;
                item = new Item(p0);
            }
        } else {
            ItemStack itemStack = this.inventory.func_70301_a(slot);
            if (itemStack == null) {
                item = null;
            } else {
                ItemStack p0 = itemStack;
                boolean bl = false;
                item = new Item(p0);
            }
        }
        return item;
    }

    public final int getWindowId() {
        int n;
        Container container = this.container;
        return container == null ? -1 : (n = container.field_75152_c);
    }

    public final void doAction(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        action.complete();
    }

    public final boolean isItemValidForSlot(int slot, @NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.inventory == null || this.inventory.func_94041_b(slot, item.getItemStack());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Item> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getSize());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p0;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getStackInSlot((int)p0));
        }
        return (List)destination$iv$iv;
    }

    public final boolean contains(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getItems().contains(item);
    }

    public final boolean contains(int id) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getItems();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Item it = (Item)element$iv;
                    boolean bl2 = false;
                    Item item = it;
                    if (!(item == null ? false : item.getID() == id)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int indexOf(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getItems().indexOf(item);
    }

    public final int indexOf(int id) {
        int n;
        block2: {
            List<Item> $this$indexOfFirst$iv = this.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Item> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Item item$iv;
                Item it = item$iv = iterator.next();
                boolean bl = false;
                Item item = it;
                if (item == null ? false : item.getID() == id) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public final boolean isContainer() {
        return this.container != null;
    }

    @JvmOverloads
    @NotNull
    public final Inventory click(int slot, boolean shift, @NotNull String button) {
        Inventory inventory;
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Inventory $this$click_u24lambda_u2d4 = inventory = this;
        boolean bl = false;
        new ClickAction(slot, $this$click_u24lambda_u2d4.getWindowId()).setClickString(button).setHoldingShift(shift).complete();
        return inventory;
    }

    public static /* synthetic */ Inventory click$default(Inventory inventory, int n, boolean bl, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            string = "LEFT";
        }
        return inventory.click(n, bl, string);
    }

    @NotNull
    public final Inventory drop(int slot, boolean ctrl) {
        Inventory inventory;
        Inventory $this$drop_u24lambda_u2d5 = inventory = this;
        boolean bl = false;
        new DropAction(slot, $this$drop_u24lambda_u2d5.getWindowId()).setHoldingCtrl(ctrl).complete();
        return inventory;
    }

    @NotNull
    public final Inventory drag(@NotNull String type, int ... slots) {
        Inventory inventory;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        Inventory $this$drag_u24lambda_u2d8 = inventory = this;
        boolean bl = false;
        DragAction $this$drag_u24lambda_u2d8_u24lambda_u2d7 = new DragAction(-999, $this$drag_u24lambda_u2d8.getWindowId());
        boolean bl2 = false;
        DragAction dragAction = $this$drag_u24lambda_u2d8_u24lambda_u2d7.setStage(DragAction.Stage.BEGIN);
        String string = type.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        dragAction.setClickType(DragAction.ClickType.valueOf(string)).complete();
        $this$drag_u24lambda_u2d8_u24lambda_u2d7.setStage(DragAction.Stage.SLOT);
        int[] $this$forEach$iv = slots;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl3 = false;
            $this$drag_u24lambda_u2d8_u24lambda_u2d7.setSlot(it).complete();
        }
        $this$drag_u24lambda_u2d8_u24lambda_u2d7.setStage(DragAction.Stage.END).setSlot(-999).complete();
        return inventory;
    }

    @NotNull
    public final String getName() {
        String string;
        if (this.container instanceof ContainerChest) {
            String string2 = ((ContainerChest)this.container).func_85151_d().func_70005_c_();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"container.lowerChestInventory.name");
            string = string2;
        } else {
            IInventory iInventory = this.inventory;
            if (iInventory == null) {
                string = "container";
            } else {
                string = iInventory.func_70005_c_();
                if (string == null) {
                    string = "container";
                }
            }
        }
        return string;
    }

    @NotNull
    public final String getClassName() {
        String string;
        String string2;
        IInventory iInventory = this.inventory;
        if (iInventory == null) {
            string2 = null;
        } else {
            Class<?> clazz = iInventory.getClass();
            string2 = string = clazz == null ? null : clazz.getSimpleName();
        }
        if (string2 == null) {
            Container container = this.container;
            Intrinsics.checkNotNull((Object)container);
            String string3 = container.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"container!!.javaClass.simpleName");
            string = string3;
        }
        return string;
    }

    @NotNull
    public String toString() {
        return "Inventory{name=" + this.getName() + ", size=" + this.getSize() + ", type=" + (this.isContainer() ? "container" : "inventory") + '}';
    }

    @Override
    @NotNull
    public String toJSON(@NotNull String key) {
        return JSONImpl.DefaultImpls.toJSON(this, key);
    }

    @JvmOverloads
    @NotNull
    public final Inventory click(int slot, boolean shift) {
        return Inventory.click$default(this, slot, shift, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Inventory click(int slot) {
        return Inventory.click$default(this, slot, false, null, 6, null);
    }
}

