/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.wrappers.entity;

import com.chattriggers.ctjs.minecraft.libs.Tessellator;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.Item;
import com.chattriggers.ctjs.minecraft.wrappers.utils.Vec3i;
import com.chattriggers.ctjs.minecraft.wrappers.world.Chunk;
import com.chattriggers.ctjs.minecraft.wrappers.world.block.BlockPos;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b+\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0011J\u001e\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001bJ\u0006\u0010#\u001a\u00020\u0011J\u0006\u0010$\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0011J\u0006\u0010(\u001a\u00020\u001bJ\u0006\u0010)\u001a\u00020\u0011J\u0006\u0010*\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\nJ\u0006\u0010,\u001a\u00020\nJ\u000e\u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0011J\u0006\u0010.\u001a\u00020\u001bJ\u0006\u0010/\u001a\u00020\nJ\u0006\u00100\u001a\u00020\nJ\u0006\u00101\u001a\u00020\nJ\b\u00102\u001a\u00020!H\u0016J\u0006\u00103\u001a\u00020\nJ\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\nJ\u0006\u00107\u001a\u00020\nJ\u0006\u00108\u001a\u00020\nJ\b\u00109\u001a\u0004\u0018\u00010\u0000J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00000;J\b\u0010<\u001a\u0004\u0018\u00010\u0000J\u0006\u0010=\u001a\u00020\u0011J\u0006\u0010>\u001a\u00020\u001bJ\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u00020\u0011J\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020\nJ\u0006\u0010E\u001a\u00020\nJ\u0006\u0010F\u001a\u00020\nJ\u0006\u0010G\u001a\u00020\nJ\u0006\u0010H\u001a\u00020\u000eJ\u0006\u0010I\u001a\u00020\u000eJ\u0006\u0010J\u001a\u00020\u000eJ\u0006\u0010K\u001a\u00020\u000eJ\u0006\u0010L\u001a\u00020\u000eJ\u0006\u0010M\u001a\u00020\u000eJ\u0006\u0010N\u001a\u00020\u000eJ\u0006\u0010O\u001a\u00020\u000eJ\u0006\u0010P\u001a\u00020\u000eJ\u0006\u0010Q\u001a\u00020\u000eJ\u0006\u0010R\u001a\u00020\u000eJ\u0006\u0010S\u001a\u00020\u000eJ\u0006\u0010T\u001a\u00020\u000eJ\u0006\u0010U\u001a\u00020\u000eJ\u0006\u0010V\u001a\u00020\u000eJ\u0006\u0010W\u001a\u00020\u000eJ\u001e\u0010X\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010Z\u001a\u00020\u001bJ\u0016\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u00112\u0006\u0010]\u001a\u00020\u0011J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u000eJ\u000e\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u000eJ\u000e\u0010b\u001a\u00020\u00002\u0006\u0010c\u001a\u00020\u000eJ\u000e\u0010d\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u000eJ\u000e\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u000eJ\u000e\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u000eJ\u000e\u0010j\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u001bJ\u001e\u0010l\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\b\u0010m\u001a\u00020!H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006n"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/entity/Entity;", "", "entity", "Lnet/minecraft/entity/Entity;", "Lcom/chattriggers/ctjs/utils/kotlin/MCEntity;", "(Lnet/minecraft/entity/Entity;)V", "getEntity", "()Lnet/minecraft/entity/Entity;", "addVelocity", "x", "", "y", "z", "canBeCollidedWith", "", "canBePushed", "distanceTo", "", "other", "blockPos", "Lcom/chattriggers/ctjs/minecraft/wrappers/world/block/BlockPos;", "dropItem", "Lnet/minecraft/entity/item/EntityItem;", "kotlin.jvm.PlatformType", "item", "Lcom/chattriggers/ctjs/minecraft/wrappers/inventory/Item;", "size", "", "extinguish", "getAir", "getChunk", "Lcom/chattriggers/ctjs/minecraft/wrappers/world/Chunk;", "getClassName", "", "getDimension", "getDistanceWalked", "getEyeHeight", "getEyePosition", "Lnet/minecraft/util/Vec3;", "partialTicks", "getFireResistance", "getHeight", "getLastX", "getLastY", "getLastZ", "getLookVector", "getMaxInPortalTime", "getMotionX", "getMotionY", "getMotionZ", "getName", "getPitch", "getPos", "Lcom/chattriggers/ctjs/minecraft/wrappers/utils/Vec3i;", "getRenderX", "getRenderY", "getRenderZ", "getRider", "getRiders", "", "getRiding", "getStepHeight", "getTicksExisted", "getUUID", "Ljava/util/UUID;", "getWidth", "getWorld", "Lnet/minecraft/world/World;", "getX", "getY", "getYaw", "getZ", "hasNoClip", "isAirborne", "isBurning", "isCollided", "isDead", "isEating", "isImmuneToFire", "isInLava", "isInWater", "isInvisible", "isOnGround", "isOutsideBorder", "isSilent", "isSneaking", "isSprinting", "isWet", "move", "setAir", "air", "setAngles", "yaw", "pitch", "setIsEating", "eating", "setIsInvisible", "invisible", "setIsOutsideBorder", "outside", "setIsSilent", "silent", "setIsSneaking", "sneaking", "setIsSprinting", "sprinting", "setOnFire", "seconds", "setPosition", "toString", "ctjs"})
public class Entity {
    @NotNull
    private final net.minecraft.entity.Entity entity;

    public Entity(@NotNull net.minecraft.entity.Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entity = entity;
    }

    @NotNull
    public final net.minecraft.entity.Entity getEntity() {
        return this.entity;
    }

    public final double getX() {
        return this.entity.field_70165_t;
    }

    public final double getY() {
        return this.entity.field_70163_u;
    }

    public final double getZ() {
        return this.entity.field_70161_v;
    }

    @NotNull
    public final Vec3i getPos() {
        return new Vec3i(this.getX(), this.getY(), this.getZ());
    }

    public final double getLastX() {
        return this.entity.field_70142_S;
    }

    public final double getLastY() {
        return this.entity.field_70137_T;
    }

    public final double getLastZ() {
        return this.entity.field_70136_U;
    }

    public final double getRenderX() {
        return this.getLastX() + (this.getX() - this.getLastX()) * (double)Tessellator.getPartialTicks();
    }

    public final double getRenderY() {
        return this.getLastY() + (this.getY() - this.getLastY()) * (double)Tessellator.getPartialTicks();
    }

    public final double getRenderZ() {
        return this.getLastZ() + (this.getZ() - this.getLastZ()) * (double)Tessellator.getPartialTicks();
    }

    public final double getPitch() {
        return MathHelper.func_76142_g((float)this.entity.field_70125_A);
    }

    public final double getYaw() {
        return MathHelper.func_76142_g((float)this.entity.field_70177_z);
    }

    public final double getMotionX() {
        return this.entity.field_70159_w;
    }

    public final double getMotionY() {
        return this.entity.field_70181_x;
    }

    public final double getMotionZ() {
        return this.entity.field_70179_y;
    }

    @Nullable
    public final Entity getRiding() {
        Entity entity;
        net.minecraft.entity.Entity entity2 = this.entity.field_70154_o;
        if (entity2 == null) {
            entity = null;
        } else {
            net.minecraft.entity.Entity p0 = entity2;
            boolean bl = false;
            entity = new Entity(p0);
        }
        return entity;
    }

    @Nullable
    public final Entity getRider() {
        Entity entity;
        net.minecraft.entity.Entity entity2 = this.entity.field_70153_n;
        if (entity2 == null) {
            entity = null;
        } else {
            net.minecraft.entity.Entity p0 = entity2;
            boolean bl = false;
            entity = new Entity(p0);
        }
        return entity;
    }

    @NotNull
    public final List<Entity> getRiders() {
        return CollectionsKt.emptyList();
    }

    public final boolean isDead() {
        return this.entity.field_70128_L;
    }

    public final float getWidth() {
        return this.entity.field_70130_N;
    }

    public final float getHeight() {
        return this.entity.field_70131_O;
    }

    public final float getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @NotNull
    public String getName() {
        String string = this.entity.func_70005_c_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entity.name");
        return string;
    }

    @NotNull
    public final String getClassName() {
        String string = this.entity.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entity.javaClass.simpleName");
        return string;
    }

    @NotNull
    public final UUID getUUID() {
        UUID uUID = this.entity.func_110124_au();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"entity.uniqueID");
        return uUID;
    }

    public final int getAir() {
        return this.entity.func_70086_ai();
    }

    @NotNull
    public final Entity setAir(int air) {
        Entity entity;
        Entity $this$setAir_u24lambda_u2d1 = entity = this;
        boolean bl = false;
        $this$setAir_u24lambda_u2d1.getEntity().func_70050_g(air);
        return entity;
    }

    public final float distanceTo(@NotNull Entity other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.distanceTo(other.entity);
    }

    public final float distanceTo(@NotNull net.minecraft.entity.Entity other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.entity.func_70032_d(other);
    }

    public final float distanceTo(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return (float)this.entity.func_70011_f((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    public final float distanceTo(float x, float y, float z) {
        return (float)this.entity.func_70011_f((double)x, (double)y, (double)z);
    }

    public final boolean isOnGround() {
        return this.entity.field_70122_E;
    }

    public final boolean isCollided() {
        return this.entity.field_70132_H;
    }

    public final float getDistanceWalked() {
        return this.entity.field_70140_Q / 0.6f;
    }

    public final float getStepHeight() {
        return this.entity.field_70138_W;
    }

    public final boolean hasNoClip() {
        return this.entity.field_70145_X;
    }

    public final int getTicksExisted() {
        return this.entity.field_70173_aa;
    }

    public final int getFireResistance() {
        return this.entity.field_70174_ab;
    }

    public final boolean isImmuneToFire() {
        return this.entity.func_70045_F();
    }

    public final boolean isInWater() {
        return this.entity.func_70090_H();
    }

    public final boolean isWet() {
        return this.entity.func_70026_G();
    }

    public final boolean isAirborne() {
        return this.entity.field_70160_al;
    }

    public final int getDimension() {
        return this.entity.field_71093_bK;
    }

    @NotNull
    public final Entity setPosition(double x, double y, double z) {
        Entity entity;
        Entity $this$setPosition_u24lambda_u2d2 = entity = this;
        boolean bl = false;
        $this$setPosition_u24lambda_u2d2.getEntity().func_70107_b(x, y, z);
        return entity;
    }

    @NotNull
    public final Entity setAngles(float yaw, float pitch) {
        Entity entity;
        Entity $this$setAngles_u24lambda_u2d3 = entity = this;
        boolean bl = false;
        $this$setAngles_u24lambda_u2d3.getEntity().func_70082_c(yaw, pitch);
        return entity;
    }

    public final int getMaxInPortalTime() {
        return this.entity.func_82145_z();
    }

    @NotNull
    public final Entity setOnFire(int seconds) {
        Entity entity;
        Entity $this$setOnFire_u24lambda_u2d4 = entity = this;
        boolean bl = false;
        $this$setOnFire_u24lambda_u2d4.getEntity().func_70015_d(seconds);
        return entity;
    }

    @NotNull
    public final Entity extinguish() {
        Entity entity;
        Entity $this$extinguish_u24lambda_u2d5 = entity = this;
        boolean bl = false;
        $this$extinguish_u24lambda_u2d5.getEntity().func_70066_B();
        return entity;
    }

    @NotNull
    public final Entity move(double x, double y, double z) {
        Entity entity;
        Entity $this$move_u24lambda_u2d6 = entity = this;
        boolean bl = false;
        $this$move_u24lambda_u2d6.getEntity().func_70091_d(x, y, z);
        return entity;
    }

    public final boolean isSilent() {
        return this.entity.func_174814_R();
    }

    @NotNull
    public final Entity setIsSilent(boolean silent) {
        Entity entity;
        Entity $this$setIsSilent_u24lambda_u2d7 = entity = this;
        boolean bl = false;
        $this$setIsSilent_u24lambda_u2d7.getEntity().func_174810_b(silent);
        return entity;
    }

    public final boolean isInLava() {
        return this.entity.func_180799_ab();
    }

    @NotNull
    public final Entity addVelocity(double x, double y, double z) {
        Entity entity;
        Entity $this$addVelocity_u24lambda_u2d8 = entity = this;
        boolean bl = false;
        $this$addVelocity_u24lambda_u2d8.getEntity().func_70024_g(x, y, z);
        return entity;
    }

    @NotNull
    public final Vec3 getLookVector(float partialTicks) {
        Vec3 vec3 = this.entity.func_70676_i(partialTicks);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.getLook(partialTicks)");
        return vec3;
    }

    @NotNull
    public final Vec3 getEyePosition(float partialTicks) {
        Vec3 vec3 = this.entity.func_174824_e(partialTicks);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.getPositionEyes(partialTicks)");
        return vec3;
    }

    public final boolean canBeCollidedWith() {
        return this.entity.func_70067_L();
    }

    public final boolean canBePushed() {
        return this.entity.func_70104_M();
    }

    public final EntityItem dropItem(@NotNull Item item, int size) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.entity.func_145779_a(item.getItem(), size);
    }

    public final boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @NotNull
    public final Entity setIsSneaking(boolean sneaking) {
        Entity entity;
        Entity $this$setIsSneaking_u24lambda_u2d9 = entity = this;
        boolean bl = false;
        $this$setIsSneaking_u24lambda_u2d9.getEntity().func_70095_a(sneaking);
        return entity;
    }

    public final boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @NotNull
    public final Entity setIsSprinting(boolean sprinting) {
        Entity entity;
        Entity $this$setIsSprinting_u24lambda_u2d10 = entity = this;
        boolean bl = false;
        $this$setIsSprinting_u24lambda_u2d10.getEntity().func_70031_b(sprinting);
        return entity;
    }

    public final boolean isInvisible() {
        return this.entity.func_82150_aj();
    }

    @NotNull
    public final Entity setIsInvisible(boolean invisible) {
        Entity entity;
        Entity $this$setIsInvisible_u24lambda_u2d11 = entity = this;
        boolean bl = false;
        $this$setIsInvisible_u24lambda_u2d11.getEntity().func_82142_c(invisible);
        return entity;
    }

    public final boolean isEating() {
        return this.entity.func_70113_ah();
    }

    @NotNull
    public final Entity setIsEating(boolean eating) {
        Entity entity;
        Entity $this$setIsEating_u24lambda_u2d12 = entity = this;
        boolean bl = false;
        $this$setIsEating_u24lambda_u2d12.getEntity().func_70019_c(eating);
        return entity;
    }

    public final boolean isOutsideBorder() {
        return this.entity.func_174832_aS();
    }

    @NotNull
    public final Entity setIsOutsideBorder(boolean outside) {
        Entity entity;
        Entity $this$setIsOutsideBorder_u24lambda_u2d13 = entity = this;
        boolean bl = false;
        $this$setIsOutsideBorder_u24lambda_u2d13.getEntity().func_174821_h(outside);
        return entity;
    }

    public final boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @NotNull
    public final World getWorld() {
        World world = this.entity.func_130014_f_();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"entity.entityWorld");
        return world;
    }

    @NotNull
    public final Chunk getChunk() {
        net.minecraft.world.chunk.Chunk chunk = this.getWorld().func_72964_e(this.entity.field_70176_ah, this.entity.field_70164_aj);
        Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getWorld().getChunkFromC\u2026ordX, entity.chunkCoordZ)");
        return new Chunk(chunk);
    }

    @NotNull
    public String toString() {
        return "Entity{name=" + this.getName() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + '}';
    }
}

