/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.wrappers;

import com.chattriggers.ctjs.minecraft.wrappers.Client;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.minecraft.wrappers.entity.Entity;
import com.chattriggers.ctjs.minecraft.wrappers.entity.Particle;
import com.chattriggers.ctjs.minecraft.wrappers.entity.PlayerMP;
import com.chattriggers.ctjs.minecraft.wrappers.entity.TileEntity;
import com.chattriggers.ctjs.minecraft.wrappers.world.Chunk;
import com.chattriggers.ctjs.minecraft.wrappers.world.block.Block;
import com.chattriggers.ctjs.minecraft.wrappers.world.block.BlockPos;
import com.chattriggers.ctjs.minecraft.wrappers.world.block.BlockType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003345B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004H\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0007J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001aH\u0007J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u001cH\u0007J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020#H\u0007J\b\u0010$\u001a\u00020#H\u0007J\b\u0010%\u001a\u00020\u001cH\u0007J\n\u0010&\u001a\u0004\u0018\u00010'H\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u001cH\u0007J\b\u0010*\u001a\u00020)H\u0007J\b\u0010+\u001a\u00020)H\u0007J*\u0010,\u001a\u00020-2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020.H\u0007J \u0010/\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020!H\u0007J\b\u00102\u001a\u00020-H\u0007\u00a8\u00066"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/World;", "", "()V", "getAllEntities", "", "Lcom/chattriggers/ctjs/minecraft/wrappers/entity/Entity;", "getAllEntitiesOfType", "clazz", "Ljava/lang/Class;", "getAllPlayers", "Lcom/chattriggers/ctjs/minecraft/wrappers/entity/PlayerMP;", "getAllTileEntities", "Lcom/chattriggers/ctjs/minecraft/wrappers/entity/TileEntity;", "getAllTileEntitiesOfType", "getBlockAt", "Lcom/chattriggers/ctjs/minecraft/wrappers/world/block/Block;", "pos", "Lcom/chattriggers/ctjs/minecraft/wrappers/world/block/BlockPos;", "x", "", "y", "z", "getBlockStateAt", "Lnet/minecraft/block/state/IBlockState;", "getChunk", "Lcom/chattriggers/ctjs/minecraft/wrappers/world/Chunk;", "", "getDifficulty", "", "getMoonPhase", "getPlayerByName", "name", "getRainingStrength", "", "getSeed", "", "getTime", "getType", "getWorld", "Lnet/minecraft/client/multiplayer/WorldClient;", "hasPlayer", "", "isLoaded", "isRaining", "playRecord", "", "", "playSound", "volume", "pitch", "stopAllSounds", "border", "particle", "spawn", "ctjs"})
public final class World {
    @NotNull
    public static final World INSTANCE = new World();

    private World() {
    }

    @JvmStatic
    @Nullable
    public static final WorldClient getWorld() {
        return Client.Companion.getMinecraft().field_71441_e;
    }

    @JvmStatic
    public static final boolean isLoaded() {
        return INSTANCE.getWorld() != null;
    }

    @JvmStatic
    public static final void playSound(@NotNull String name, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Client.Companion.scheduleTask$default(Client.Companion, 0, (Function0)new Function0<Unit>(name, volume, pitch){
            final /* synthetic */ String $name;
            final /* synthetic */ float $volume;
            final /* synthetic */ float $pitch;
            {
                this.$name = $name;
                this.$volume = $volume;
                this.$pitch = $pitch;
                super(0);
            }

            public final void invoke() {
                EntityPlayerSP entityPlayerSP = Player.getPlayer();
                if (entityPlayerSP != null) {
                    entityPlayerSP.func_85030_a(this.$name, this.$volume, this.$pitch);
                }
            }
        }, 1, null);
    }

    @JvmStatic
    public static final void playRecord(@Nullable String name, double x, double y, double z) {
        Client.Companion.scheduleTask$default(Client.Companion, 0, (Function0)new Function0<Unit>(x, y, z, name){
            final /* synthetic */ double $x;
            final /* synthetic */ double $y;
            final /* synthetic */ double $z;
            final /* synthetic */ String $name;
            {
                this.$x = $x;
                this.$y = $y;
                this.$z = $z;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                WorldClient worldClient = World.getWorld();
                if (worldClient != null) {
                    worldClient.func_175717_a(new net.minecraft.util.BlockPos(this.$x, this.$y, this.$z), this.$name);
                }
            }
        }, 1, null);
    }

    @JvmStatic
    public static final void stopAllSounds() {
        Client.Companion.getMinecraft().func_147118_V().func_147690_c();
    }

    @JvmStatic
    public static final boolean isRaining() {
        boolean bl;
        WorldClient worldClient = INSTANCE.getWorld();
        if (worldClient == null) {
            bl = false;
        } else {
            boolean bl2;
            WorldInfo worldInfo = worldClient.func_72912_H();
            bl = worldInfo == null ? false : (bl2 = worldInfo.func_76059_o());
        }
        return bl;
    }

    @JvmStatic
    public static final float getRainingStrength() {
        float f;
        WorldClient worldClient = INSTANCE.getWorld();
        return worldClient == null ? -1.0f : (f = worldClient.field_73004_o);
    }

    @JvmStatic
    public static final long getTime() {
        long l;
        WorldClient worldClient = INSTANCE.getWorld();
        return worldClient == null ? -1L : (l = worldClient.func_72820_D());
    }

    @JvmStatic
    @NotNull
    public static final String getDifficulty() {
        WorldClient worldClient = INSTANCE.getWorld();
        return String.valueOf(worldClient == null ? null : worldClient.func_175659_aa());
    }

    @JvmStatic
    public static final int getMoonPhase() {
        int n;
        WorldClient worldClient = INSTANCE.getWorld();
        return worldClient == null ? -1 : (n = worldClient.func_72853_d());
    }

    @JvmStatic
    public static final long getSeed() {
        long l;
        WorldClient worldClient = INSTANCE.getWorld();
        return worldClient == null ? -1L : (l = worldClient.func_72905_C());
    }

    @JvmStatic
    @NotNull
    public static final String getType() {
        String string;
        WorldClient worldClient = INSTANCE.getWorld();
        if (worldClient == null) {
            string = null;
        } else {
            WorldType worldType = worldClient.func_175624_G();
            string = worldType == null ? null : worldType.func_77127_a();
        }
        return String.valueOf(string);
    }

    @JvmStatic
    @NotNull
    public static final Block getBlockAt(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return World.getBlockAt(new BlockPos(x, y, z));
    }

    @JvmStatic
    @NotNull
    public static final Block getBlockAt(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        net.minecraft.block.Block block = World.getBlockStateAt(pos).func_177230_c();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlockStateAt(pos).block");
        return new Block(new BlockType(block), pos, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final IBlockState getBlockStateAt(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        WorldClient worldClient = INSTANCE.getWorld();
        Intrinsics.checkNotNull((Object)worldClient);
        IBlockState iBlockState = worldClient.func_180495_p(pos.toMCBlock());
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getWorld()!!.getBlockState(pos.toMCBlock())");
        return iBlockState;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<PlayerMP> getAllPlayers() {
        List list;
        WorldClient worldClient = INSTANCE.getWorld();
        if (worldClient == null) {
            list = null;
        } else {
            List list2 = worldClient.field_73010_i;
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    EntityPlayer entityPlayer = (EntityPlayer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new PlayerMP((EntityPlayer)p0));
                }
                list = (List)destination$iv$iv;
            }
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    @JvmStatic
    @Nullable
    public static final PlayerMP getPlayerByName(@NotNull String name) {
        PlayerMP playerMP;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        WorldClient worldClient = INSTANCE.getWorld();
        if (worldClient == null) {
            playerMP = null;
        } else {
            EntityPlayer entityPlayer = worldClient.func_72924_a(name);
            if (entityPlayer == null) {
                playerMP = null;
            } else {
                EntityPlayer p0 = entityPlayer;
                boolean bl = false;
                playerMP = new PlayerMP(p0);
            }
        }
        return playerMP;
    }

    @JvmStatic
    public static final boolean hasPlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        WorldClient worldClient = INSTANCE.getWorld();
        return (worldClient == null ? null : worldClient.func_72924_a(name)) != null;
    }

    @JvmStatic
    @NotNull
    public static final Chunk getChunk(int x, int y, int z) {
        WorldClient worldClient = INSTANCE.getWorld();
        Intrinsics.checkNotNull((Object)worldClient);
        net.minecraft.world.chunk.Chunk chunk = worldClient.func_175726_f(new net.minecraft.util.BlockPos(x, y, z));
        Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getWorld()!!.getChunkFro\u2026os(x, y, z)\n            )");
        return new Chunk(chunk);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Entity> getAllEntities() {
        List list;
        WorldClient worldClient = INSTANCE.getWorld();
        if (worldClient == null) {
            list = null;
        } else {
            List list2 = worldClient.field_72996_f;
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Entity((net.minecraft.entity.Entity)p0));
                }
                list = (List)destination$iv$iv;
            }
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Entity> getAllEntitiesOfType(@NotNull Class<?> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable $this$filter$iv = INSTANCE.getAllEntities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!clazz.isInstance(it.getEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<TileEntity> getAllTileEntities() {
        List list;
        WorldClient worldClient = INSTANCE.getWorld();
        if (worldClient == null) {
            list = null;
        } else {
            List list2 = worldClient.field_147482_g;
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    net.minecraft.tileentity.TileEntity tileEntity = (net.minecraft.tileentity.TileEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new TileEntity((net.minecraft.tileentity.TileEntity)p0));
                }
                list = (List)destination$iv$iv;
            }
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<TileEntity> getAllTileEntitiesOfType(@NotNull Class<?> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable $this$filter$iv = INSTANCE.getAllTileEntities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileEntity it = (TileEntity)element$iv$iv;
            boolean bl = false;
            if (!clazz.isInstance(it.getTileEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/World$border;", "", "()V", "getCenterX", "", "getCenterZ", "getSize", "", "getTargetSize", "getTimeUntilTarget", "", "ctjs"})
    public static final class border {
        @NotNull
        public static final border INSTANCE = new border();

        private border() {
        }

        @JvmStatic
        public static final double getCenterX() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175723_af().func_177731_f();
        }

        @JvmStatic
        public static final double getCenterZ() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175723_af().func_177721_g();
        }

        @JvmStatic
        public static final int getSize() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175723_af().func_177722_l();
        }

        @JvmStatic
        public static final double getTargetSize() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175723_af().func_177751_j();
        }

        @JvmStatic
        public static final long getTimeUntilTarget() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175723_af().func_177732_i();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/World$spawn;", "", "()V", "getX", "", "getY", "getZ", "ctjs"})
    public static final class spawn {
        @NotNull
        public static final spawn INSTANCE = new spawn();

        private spawn() {
        }

        @JvmStatic
        public static final int getX() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175694_M().func_177958_n();
        }

        @JvmStatic
        public static final int getY() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175694_M().func_177956_o();
        }

        @JvmStatic
        public static final int getZ() {
            WorldClient worldClient = World.getWorld();
            Intrinsics.checkNotNull((Object)worldClient);
            return worldClient.func_175694_M().func_177952_p();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0007J@\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/World$particle;", "", "()V", "getParticleNames", "", "", "spawnParticle", "", "particle", "Lnet/minecraft/client/particle/EntityFX;", "Lcom/chattriggers/ctjs/utils/kotlin/MCParticle;", "Lcom/chattriggers/ctjs/minecraft/wrappers/entity/Particle;", "x", "", "y", "z", "xSpeed", "ySpeed", "zSpeed", "ctjs"})
    public static final class particle {
        @NotNull
        public static final particle INSTANCE = new particle();

        private particle() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final List<String> getParticleNames() {
            void var3_3;
            void $this$mapTo$iv$iv;
            EnumParticleTypes[] $this$map$iv = EnumParticleTypes.values();
            boolean $i$f$map = false;
            EnumParticleTypes[] enumParticleTypesArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var8_8 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name());
            }
            return CollectionsKt.toList((Iterable)((List)var3_3));
        }

        @JvmStatic
        @NotNull
        public static final Particle spawnParticle(@NotNull String particle2, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Intrinsics.checkNotNullParameter((Object)particle2, (String)"particle");
            EnumParticleTypes particleType = EnumParticleTypes.valueOf((String)particle2);
            EntityFX fx = Client.Companion.getMinecraft().field_71438_f.func_174974_b(particleType.func_179348_c(), particleType.func_179344_e(), x, y, z, xSpeed, ySpeed, zSpeed, new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)fx, (String)"fx");
            return new Particle(fx);
        }

        @JvmStatic
        public static final void spawnParticle(@NotNull EntityFX particle2) {
            Intrinsics.checkNotNullParameter((Object)particle2, (String)"particle");
            Client.Companion.getMinecraft().field_71452_i.func_78873_a(particle2);
        }
    }
}

