/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.wrappers;

import com.chattriggers.ctjs.minecraft.wrappers.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraftforge.client.GuiIngameForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0011\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014H\u0007J\b\u0010\u0015\u001a\u00020\tH\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\b\u0010\u0019\u001a\u00020\tH\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0007J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\tH\u0007J\b\u0010#\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/Scoreboard;", "", "()V", "needsUpdate", "", "scoreboardNames", "", "Lcom/chattriggers/ctjs/minecraft/wrappers/Scoreboard$Score;", "scoreboardTitle", "", "getLineByIndex", "index", "", "getLines", "", "descending", "getLinesByScore", "score", "getScoreboard", "Lnet/minecraft/scoreboard/Scoreboard;", "Lcom/chattriggers/ctjs/utils/kotlin/MCScoreboard;", "getScoreboardTitle", "getShouldRender", "getSidebar", "Lnet/minecraft/scoreboard/ScoreObjective;", "getTitle", "resetCache", "", "setLine", "line", "override", "setShouldRender", "shouldRender", "setTitle", "title", "updateNames", "Score", "ctjs"})
public final class Scoreboard {
    @NotNull
    public static final Scoreboard INSTANCE = new Scoreboard();
    private static boolean needsUpdate = true;
    @NotNull
    private static List<Score> scoreboardNames = new ArrayList();
    @NotNull
    private static String scoreboardTitle = "";

    private Scoreboard() {
    }

    @JvmStatic
    @Nullable
    public static final net.minecraft.scoreboard.Scoreboard getScoreboard() {
        WorldClient worldClient = World.getWorld();
        return worldClient == null ? null : worldClient.func_96441_U();
    }

    @JvmStatic
    @Nullable
    public static final ScoreObjective getSidebar() {
        net.minecraft.scoreboard.Scoreboard scoreboard = INSTANCE.getScoreboard();
        return scoreboard == null ? null : scoreboard.func_96539_a(1);
    }

    @JvmStatic
    @NotNull
    public static final String getScoreboardTitle() {
        return INSTANCE.getTitle();
    }

    @JvmStatic
    @NotNull
    public static final String getTitle() {
        if (needsUpdate) {
            INSTANCE.updateNames();
            needsUpdate = false;
        }
        return scoreboardTitle;
    }

    @JvmStatic
    public static final void setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        ScoreObjective scoreObjective = INSTANCE.getSidebar();
        if (scoreObjective != null) {
            scoreObjective.func_96681_a(title);
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Score> getLines(boolean descending) {
        if (needsUpdate) {
            INSTANCE.updateNames();
            needsUpdate = false;
        }
        return descending ? scoreboardNames : CollectionsKt.asReversedMutable(scoreboardNames);
    }

    public static /* synthetic */ List getLines$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return Scoreboard.getLines(bl);
    }

    @JvmStatic
    @NotNull
    public static final Score getLineByIndex(int index) {
        return (Score)Scoreboard.getLines$default(false, 1, null).get(index);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Score> getLinesByScore(int score) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = Scoreboard.getLines$default(false, 1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Score it = (Score)element$iv$iv;
            boolean bl = false;
            if (!(it.getPoints() == score)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setLine(int score, @NotNull String line, boolean override) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        net.minecraft.scoreboard.Scoreboard scoreboard = INSTANCE.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        net.minecraft.scoreboard.Scoreboard scoreboard2 = scoreboard;
        ScoreObjective scoreObjective = INSTANCE.getSidebar();
        if (scoreObjective == null) {
            return;
        }
        ScoreObjective sidebarObjective = scoreObjective;
        Collection collection = scoreboard2.func_96534_i(sidebarObjective);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"scoreboard.getSortedScores(sidebarObjective)");
        Collection scores = collection;
        if (override) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = scores;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                net.minecraft.scoreboard.Score it = (net.minecraft.scoreboard.Score)element$iv$iv;
                boolean bl = false;
                if (!(it.func_96652_c() == score)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                net.minecraft.scoreboard.Score it = (net.minecraft.scoreboard.Score)element$iv;
                boolean bl = false;
                scoreboard2.func_178822_d(it.func_96653_e(), sidebarObjective);
            }
        }
        net.minecraft.scoreboard.Score score2 = scoreboard2.func_96529_a(line, sidebarObjective);
        Intrinsics.checkNotNull((Object)score2);
        net.minecraft.scoreboard.Score theScore = score2;
        theScore.func_96647_c(score);
    }

    @JvmStatic
    public static final void setShouldRender(boolean shouldRender) {
        GuiIngameForge.renderObjective = shouldRender;
    }

    @JvmStatic
    public static final boolean getShouldRender() {
        return GuiIngameForge.renderObjective;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateNames() {
        void $this$mapTo$iv$iv;
        scoreboardNames.clear();
        scoreboardTitle = "";
        net.minecraft.scoreboard.Scoreboard scoreboard = Scoreboard.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        net.minecraft.scoreboard.Scoreboard scoreboard2 = scoreboard;
        ScoreObjective scoreObjective = Scoreboard.getSidebar();
        if (scoreObjective == null) {
            return;
        }
        ScoreObjective sidebarObjective = scoreObjective;
        String string = sidebarObjective.func_96678_d();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sidebarObjective.displayName");
        scoreboardTitle = string;
        Collection collection = scoreboard2.func_96534_i(sidebarObjective);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"scoreboard.getSortedScores(sidebarObjective)");
        Collection scores = collection;
        Iterable $this$map$iv = scores;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            net.minecraft.scoreboard.Score score = (net.minecraft.scoreboard.Score)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new Score((net.minecraft.scoreboard.Score)p0));
        }
        scoreboardNames = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final void resetCache() {
        needsUpdate = true;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Score> getLines() {
        return Scoreboard.getLines$default(false, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\tH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/chattriggers/ctjs/minecraft/wrappers/Scoreboard$Score;", "", "score", "Lnet/minecraft/scoreboard/Score;", "Lcom/chattriggers/ctjs/utils/kotlin/MCScore;", "(Lnet/minecraft/scoreboard/Score;)V", "getScore", "()Lnet/minecraft/scoreboard/Score;", "getName", "", "getPoints", "", "toString", "ctjs"})
    public static final class Score {
        @NotNull
        private final net.minecraft.scoreboard.Score score;

        public Score(@NotNull net.minecraft.scoreboard.Score score) {
            Intrinsics.checkNotNullParameter((Object)score, (String)"score");
            this.score = score;
        }

        @NotNull
        public final net.minecraft.scoreboard.Score getScore() {
            return this.score;
        }

        public final int getPoints() {
            return this.score.func_96652_c();
        }

        @NotNull
        public final String getName() {
            net.minecraft.scoreboard.Scoreboard scoreboard = Scoreboard.getScoreboard();
            Intrinsics.checkNotNull((Object)scoreboard);
            String string = ScorePlayerTeam.func_96667_a((Team)((Team)scoreboard.func_96509_i(this.score.func_96653_e())), (String)this.score.func_96653_e());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPlayerName(\n      \u2026core.playerName\n        )");
            return string;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }
    }
}

