/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.objects.message;

import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.objects.message.Message;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\b\u0016\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0010J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020\u0003H\u0002J\b\u0010-\u001a\u00020\u0003H\u0016R\u001e\u0010\t\u001a\u00060\u0006j\u0002`\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/chattriggers/ctjs/minecraft/objects/message/TextComponent;", "", "text", "", "(Ljava/lang/String;)V", "chatComponent", "Lnet/minecraft/util/IChatComponent;", "Lcom/chattriggers/ctjs/utils/kotlin/MCITextComponent;", "(Lnet/minecraft/util/IChatComponent;)V", "chatComponentText", "getChatComponentText", "()Lnet/minecraft/util/IChatComponent;", "setChatComponentText", "clickAction", "clickValue", "formatted", "", "hoverAction", "hoverValue", "actionBar", "", "chat", "getClickAction", "getClickValue", "getHoverAction", "getHoverValue", "getText", "isFormatted", "reInstance", "reInstanceClick", "reInstanceHover", "setClick", "action", "value", "setClickAction", "setClickValue", "setFormatted", "setHover", "setHoverAction", "setHoverValue", "setText", "stringToComponent", "Lnet/minecraft/util/ChatComponentText;", "Lcom/chattriggers/ctjs/utils/kotlin/MCBaseTextComponent;", "string", "toString", "Companion", "ctjs"})
public final class TextComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public IChatComponent chatComponentText;
    @NotNull
    private String text;
    private boolean formatted;
    @Nullable
    private String clickAction;
    @Nullable
    private String clickValue;
    @Nullable
    private String hoverAction;
    @Nullable
    private String hoverValue;
    @NotNull
    private static final Regex URL_REGEX = new Regex("((?:[a-z\\d]{2,}://)?[-\\w.]+\\.[a-z]{2,}?(?::\\d{1,5})?.*?(?=[!\"\u00a7 \n]|$))");
    @NotNull
    private static final Regex formatRegex = new Regex("[\u00a7&][\\da-fk-or]");

    @NotNull
    public final IChatComponent getChatComponentText() {
        IChatComponent iChatComponent = this.chatComponentText;
        if (iChatComponent != null) {
            return iChatComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chatComponentText");
        return null;
    }

    public final void setChatComponentText(@NotNull IChatComponent iChatComponent) {
        Intrinsics.checkNotNullParameter((Object)iChatComponent, (String)"<set-?>");
        this.chatComponentText = iChatComponent;
    }

    public TextComponent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.formatted = true;
        this.hoverAction = "show_text";
        this.text = text;
        this.reInstance();
    }

    public TextComponent(@NotNull IChatComponent chatComponent) {
        String string;
        String string2;
        HoverEvent hoverEvent;
        String string3;
        ClickEvent clickEvent;
        Intrinsics.checkNotNullParameter((Object)chatComponent, (String)"chatComponent");
        this.formatted = true;
        this.hoverAction = "show_text";
        this.setChatComponentText(chatComponent);
        String string4 = this.getChatComponentText().func_150254_d();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"chatComponentText.formattedText");
        this.text = string4;
        ChatStyle chatStyle = ExtensionsKt.getStyling(chatComponent);
        ClickEvent clickEvent2 = clickEvent = ExtensionsKt.getClick(chatStyle);
        if (clickEvent2 == null) {
            string3 = null;
        } else {
            ClickEvent.Action action = clickEvent2.func_150669_a();
            string3 = action == null ? null : action.func_150673_b();
        }
        this.clickAction = string3;
        ClickEvent clickEvent3 = clickEvent;
        this.clickValue = clickEvent3 == null ? null : clickEvent3.func_150668_b();
        HoverEvent hoverEvent2 = hoverEvent = ExtensionsKt.getHover(chatStyle);
        if (hoverEvent2 == null) {
            string2 = null;
        } else {
            HoverEvent.Action action = hoverEvent2.func_150701_a();
            string2 = action == null ? null : action.func_150685_b();
        }
        this.hoverAction = string2;
        HoverEvent hoverEvent3 = hoverEvent;
        if (hoverEvent3 == null) {
            string = null;
        } else {
            IChatComponent iChatComponent = hoverEvent3.func_150702_b();
            string = iChatComponent == null ? null : iChatComponent.func_150254_d();
        }
        this.hoverValue = string;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextComponent setText(@NotNull String text) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextComponent $this$setText_u24lambda_u2d0 = textComponent = this;
        boolean bl = false;
        $this$setText_u24lambda_u2d0.text = text;
        $this$setText_u24lambda_u2d0.reInstance();
        return textComponent;
    }

    public final boolean isFormatted() {
        return this.formatted;
    }

    @NotNull
    public final TextComponent setFormatted(boolean formatted) {
        TextComponent textComponent;
        TextComponent $this$setFormatted_u24lambda_u2d1 = textComponent = this;
        boolean bl = false;
        $this$setFormatted_u24lambda_u2d1.formatted = formatted;
        $this$setFormatted_u24lambda_u2d1.reInstance();
        return textComponent;
    }

    @NotNull
    public final TextComponent setClick(@NotNull String action, @NotNull String value) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextComponent $this$setClick_u24lambda_u2d2 = textComponent = this;
        boolean bl = false;
        $this$setClick_u24lambda_u2d2.clickAction = action;
        $this$setClick_u24lambda_u2d2.clickValue = value;
        $this$setClick_u24lambda_u2d2.reInstanceClick();
        return textComponent;
    }

    @Nullable
    public final String getClickAction() {
        return this.clickAction;
    }

    @NotNull
    public final TextComponent setClickAction(@NotNull String action) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        TextComponent $this$setClickAction_u24lambda_u2d3 = textComponent = this;
        boolean bl = false;
        $this$setClickAction_u24lambda_u2d3.clickAction = action;
        $this$setClickAction_u24lambda_u2d3.reInstanceClick();
        return textComponent;
    }

    @Nullable
    public final String getClickValue() {
        return this.clickValue;
    }

    @NotNull
    public final TextComponent setClickValue(@NotNull String value) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextComponent $this$setClickValue_u24lambda_u2d4 = textComponent = this;
        boolean bl = false;
        $this$setClickValue_u24lambda_u2d4.clickValue = value;
        $this$setClickValue_u24lambda_u2d4.reInstanceClick();
        return textComponent;
    }

    @NotNull
    public final TextComponent setHover(@NotNull String action, @NotNull String value) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextComponent $this$setHover_u24lambda_u2d5 = textComponent = this;
        boolean bl = false;
        $this$setHover_u24lambda_u2d5.hoverAction = action;
        $this$setHover_u24lambda_u2d5.hoverValue = value;
        $this$setHover_u24lambda_u2d5.reInstanceHover();
        return textComponent;
    }

    @Nullable
    public final String getHoverAction() {
        return this.hoverAction;
    }

    @NotNull
    public final TextComponent setHoverAction(@NotNull String action) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        TextComponent $this$setHoverAction_u24lambda_u2d6 = textComponent = this;
        boolean bl = false;
        $this$setHoverAction_u24lambda_u2d6.hoverAction = action;
        $this$setHoverAction_u24lambda_u2d6.reInstanceHover();
        return textComponent;
    }

    @Nullable
    public final String getHoverValue() {
        return this.hoverValue;
    }

    @NotNull
    public final TextComponent setHoverValue(@NotNull String value) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextComponent $this$setHoverValue_u24lambda_u2d7 = textComponent = this;
        boolean bl = false;
        $this$setHoverValue_u24lambda_u2d7.hoverValue = value;
        $this$setHoverValue_u24lambda_u2d7.reInstanceHover();
        return textComponent;
    }

    public final void chat() {
        Object[] objectArray = new Object[]{this};
        new Message(objectArray).chat();
    }

    public final void actionBar() {
        Object[] objectArray = new Object[]{this};
        new Message(objectArray).actionBar();
    }

    @NotNull
    public String toString() {
        return "TextComponent{text:" + this.text + ", formatted:" + this.formatted + ", hoverAction:" + this.hoverAction + ", hoverValue:" + this.hoverValue + ", clickAction:" + this.clickAction + ", clickValue:" + this.clickValue + '}';
    }

    private final void reInstance() {
        String string = this.formatted ? ChatLib.addColor(this.text) : this.text;
        this.setChatComponentText((IChatComponent)this.stringToComponent(string));
        this.reInstanceClick();
        this.reInstanceHover();
    }

    private final void reInstanceClick() {
        if (this.clickAction == null || this.clickValue == null) {
            return;
        }
        ExtensionsKt.getStyling(this.getChatComponentText()).func_150241_a(new ClickEvent(ClickEvent.Action.func_150672_a((String)this.clickAction), this.formatted ? ChatLib.addColor(this.clickValue) : this.clickValue));
    }

    private final void reInstanceHover() {
        if (this.hoverAction == null || this.hoverValue == null) {
            return;
        }
        ExtensionsKt.getStyling(this.getChatComponentText()).func_150209_a(new HoverEvent(HoverEvent.Action.func_150684_a((String)this.hoverAction), (IChatComponent)new ChatComponentText(this.formatted ? ChatLib.addColor(this.hoverValue) : this.hoverValue)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ChatComponentText stringToComponent(String string) {
        StringBuilder buffer = new StringBuilder();
        ChatComponentText comp = new ChatComponentText("");
        ChatStyle style = null;
        style = new ChatStyle();
        int i = 0;
        while (i < string.length()) {
            block11: {
                ChatComponentText prevText;
                block9: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        ChatComponentText chatComponentText;
                                        if (i >= string.length() - 1) break block9;
                                        String string2 = string;
                                        int n = i + 1;
                                        String string3 = string2.substring(i, n);
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                        if (!formatRegex.matches((CharSequence)string3)) break block9;
                                        ChatComponentText $this$stringToComponent_u24lambda_u2d8 = chatComponentText = new ChatComponentText(buffer.toString());
                                        boolean bl = false;
                                        $this$stringToComponent_u24lambda_u2d8.func_150255_a(style.func_150206_m());
                                        prevText = chatComponentText;
                                        StringsKt.clear((StringBuilder)buffer);
                                        comp.func_150257_a((IChatComponent)prevText);
                                        int n2 = i;
                                        i = n2 + 1;
                                        n2 = string.charAt(i);
                                        boolean bl2 = 48 <= n2 ? n2 < 103 : false;
                                        if (!bl2) break block10;
                                        style.func_150238_a(EnumChatFormatting.values()[CharsKt.digitToInt((char)string.charAt(i), (int)16)]);
                                        break block11;
                                    }
                                    if (string.charAt(i) != 'k') break block12;
                                    style.func_150237_e(Boolean.valueOf(true));
                                    break block11;
                                }
                                if (string.charAt(i) != 'l') break block13;
                                style.func_150227_a(Boolean.valueOf(true));
                                break block11;
                            }
                            if (string.charAt(i) != 'm') break block14;
                            style.func_150225_c(Boolean.valueOf(true));
                            break block11;
                        }
                        if (string.charAt(i) != 'n') break block15;
                        style.func_150228_d(Boolean.valueOf(true));
                        break block11;
                    }
                    if (string.charAt(i) == 'o') {
                        style.func_150217_b(Boolean.valueOf(true));
                        break block11;
                    } else if (string.charAt(i) == 'r') {
                        style = new ChatStyle();
                    }
                    break block11;
                }
                if (URL_REGEX.matchesAt((CharSequence)string, i)) {
                    ChatComponentText chatComponentText;
                    ChatComponentText chatComponentText2;
                    ChatComponentText $this$stringToComponent_u24lambda_u2d9 = chatComponentText2 = new ChatComponentText(buffer.toString());
                    boolean bl = false;
                    $this$stringToComponent_u24lambda_u2d9.func_150255_a(style.func_150206_m());
                    prevText = chatComponentText2;
                    StringsKt.clear((StringBuilder)buffer);
                    comp.func_150257_a((IChatComponent)prevText);
                    MatchResult matchResult = URL_REGEX.matchAt((CharSequence)string, i);
                    Intrinsics.checkNotNull((Object)matchResult);
                    String link = matchResult.getValue();
                    i += link.length() - 1;
                    ChatComponentText $this$stringToComponent_u24lambda_u2d10 = chatComponentText = new ChatComponentText(link);
                    boolean bl3 = false;
                    $this$stringToComponent_u24lambda_u2d10.func_150255_a(style.func_150206_m());
                    try {
                        $this$stringToComponent_u24lambda_u2d10.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, new URI(link).getScheme() == null ? Intrinsics.stringPlus((String)"http://", (Object)link) : link));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    ChatComponentText linkComponent = chatComponentText;
                    comp.func_150257_a((IChatComponent)linkComponent);
                } else {
                    buffer.append(string.charAt(i));
                }
            }
            int n = i;
            i = n + 1;
        }
        if (((CharSequence)buffer).length() > 0) {
            void $this$stringToComponent_u24lambda_u2d11;
            ChatComponentText chatComponentText;
            ChatComponentText link = chatComponentText = new ChatComponentText(buffer.toString());
            ChatComponentText chatComponentText3 = comp;
            boolean bl = false;
            $this$stringToComponent_u24lambda_u2d11.func_150255_a(style.func_150206_m());
            chatComponentText3.func_150257_a((IChatComponent)chatComponentText);
        }
        return comp;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/chattriggers/ctjs/minecraft/objects/message/TextComponent$Companion;", "", "()V", "URL_REGEX", "Lkotlin/text/Regex;", "formatRegex", "ctjs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

