/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.objects.message;

import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.objects.message.TextComponent;
import com.chattriggers.ctjs.minecraft.wrappers.Client;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\b\u0016\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00010\nj\b\u0012\u0004\u0012\u00020\u0001`\u000b\u00a2\u0006\u0002\u0010\fB\u001b\b\u0016\u0012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0001J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0001J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0000J\u001f\u0010\u001f\u001a\u00020\u00192\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u000e\"\u00020\u0000\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u0011J\n\u0010#\u001a\u00060\u0006j\u0002`\u0007J\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160'J\u0006\u0010(\u001a\u00020%J\u0006\u0010)\u001a\u00020\u0014J\u0006\u0010*\u001a\u00020\u0014J\b\u0010+\u001a\u00020\u0019H\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0014J\u0016\u00100\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0001J\b\u00101\u001a\u00020%H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0006j\u0002`\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/chattriggers/ctjs/minecraft/objects/message/Message;", "", "event", "Lnet/minecraftforge/client/event/ClientChatReceivedEvent;", "(Lnet/minecraftforge/client/event/ClientChatReceivedEvent;)V", "component", "Lnet/minecraft/util/IChatComponent;", "Lcom/chattriggers/ctjs/utils/kotlin/MCITextComponent;", "(Lnet/minecraft/util/IChatComponent;)V", "messageParts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)V", "components", "", "([Ljava/lang/Object;)V", "chatLineId", "", "chatMessage", "formatted", "", "", "Lcom/chattriggers/ctjs/minecraft/objects/message/TextComponent;", "recursive", "actionBar", "", "addTextComponent", "index", "chat", "clone", "copy", "edit", "replacements", "([Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "getChatLineId", "getChatMessage", "getFormattedText", "", "getMessageParts", "", "getUnformattedText", "isFormatted", "isRecursive", "parseMessage", "setChatLineId", "id", "setFormatted", "setRecursive", "setTextComponent", "toString", "ctjs"})
public final class Message {
    private IChatComponent chatMessage;
    @NotNull
    private final List<TextComponent> messageParts;
    private int chatLineId;
    private boolean recursive;
    private boolean formatted;

    public Message(@NotNull ClientChatReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IChatComponent iChatComponent = event.message;
        Intrinsics.checkNotNullExpressionValue((Object)iChatComponent, (String)"event.message");
        this(iChatComponent);
    }

    /*
     * WARNING - void declaration
     */
    public Message(@NotNull IChatComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.messageParts = new ArrayList();
        this.chatLineId = -1;
        this.formatted = true;
        if (component.func_150253_a().isEmpty()) {
            if (!(component instanceof ChatComponentTranslation)) {
                this.messageParts.add(new TextComponent(component));
                return;
            }
            Iterable $this$forEach$iv = (Iterable)component;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IChatComponent it = (IChatComponent)element$iv;
                boolean bl = false;
                if (!it.func_150253_a().isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.messageParts.add(new TextComponent(it));
            }
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            String formattedText = component.func_150254_d();
            Intrinsics.checkNotNullExpressionValue((Object)formattedText, (String)"formattedText");
            CharSequence charSequence = formattedText;
            String it = ((IChatComponent)component.func_150253_a().get(0)).func_150254_d();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"component.siblings[0].formattedText");
            String string = formattedText.substring(0, StringsKt.indexOf$default((CharSequence)charSequence, (String)it, (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            ChatComponentText $this$_init__u24lambda_u2d1 = object = new ChatComponentText(string);
            boolean $i$a$-apply-Message$firstComponent$22 = false;
            $this$_init__u24lambda_u2d1.func_150255_a(component.func_150256_b());
            ChatComponentText firstComponent = object;
            this.messageParts.add(new TextComponent((IChatComponent)firstComponent));
            object = component.func_150253_a();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component.siblings");
            object = (Iterable)object;
            List<TextComponent> list = this.messageParts;
            boolean $i$f$map = false;
            void $i$a$-apply-Message$firstComponent$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IChatComponent iChatComponent = (IChatComponent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TextComponent((IChatComponent)p0));
            }
            list.addAll((List)destination$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Message(@NotNull ArrayList<Object> messageParts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        this.messageParts = new ArrayList();
        this.chatLineId = -1;
        this.formatted = true;
        Iterable iterable = messageParts;
        List<TextComponent> list = this.messageParts;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextComponent textComponent;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_12 = it;
            if (var11_12 instanceof String) {
                textComponent = new TextComponent((String)it);
            } else if (var11_12 instanceof TextComponent) {
                textComponent = (TextComponent)it;
            } else if (var11_12 instanceof Item) {
                textComponent = ((Item)it).getTextComponent();
            } else {
                return;
            }
            collection.add(textComponent);
        }
        list.addAll((List)destination$iv$iv);
    }

    public Message(Object ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this(new ArrayList<Object>(ArraysKt.asList((Object[])components)));
    }

    @NotNull
    public final IChatComponent getChatMessage() {
        this.parseMessage();
        IChatComponent iChatComponent = this.chatMessage;
        if (iChatComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
            iChatComponent = null;
        }
        return iChatComponent;
    }

    @NotNull
    public final String getFormattedText() {
        String string = this.getChatMessage().func_150254_d();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChatMessage().formattedText");
        return string;
    }

    @NotNull
    public final String getUnformattedText() {
        String string = this.getChatMessage().func_150260_c();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChatMessage().unformattedText");
        return string;
    }

    @NotNull
    public final List<TextComponent> getMessageParts() {
        return this.messageParts;
    }

    public final int getChatLineId() {
        return this.chatLineId;
    }

    @NotNull
    public final Message setChatLineId(int id) {
        Message message;
        Message $this$setChatLineId_u24lambda_u2d3 = message = this;
        boolean bl = false;
        $this$setChatLineId_u24lambda_u2d3.chatLineId = id;
        return message;
    }

    public final boolean isRecursive() {
        return this.recursive;
    }

    @NotNull
    public final Message setRecursive(boolean recursive) {
        Message message;
        Message $this$setRecursive_u24lambda_u2d4 = message = this;
        boolean bl = false;
        $this$setRecursive_u24lambda_u2d4.recursive = recursive;
        return message;
    }

    public final boolean isFormatted() {
        return this.formatted;
    }

    @NotNull
    public final Message setFormatted(boolean formatted) {
        Message message;
        Message $this$setFormatted_u24lambda_u2d5 = message = this;
        boolean bl = false;
        $this$setFormatted_u24lambda_u2d5.formatted = formatted;
        return message;
    }

    @NotNull
    public final Message setTextComponent(int index, @NotNull Object component) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Message $this$setTextComponent_u24lambda_u2d6 = message = this;
        boolean bl = false;
        Object object = component;
        if (object instanceof String) {
            $this$setTextComponent_u24lambda_u2d6.messageParts.set(index, new TextComponent((String)component));
        } else if (object instanceof TextComponent) {
            $this$setTextComponent_u24lambda_u2d6.messageParts.set(index, (TextComponent)component);
        }
        return message;
    }

    @NotNull
    public final Message addTextComponent(@NotNull Object component) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Message $this$addTextComponent_u24lambda_u2d7 = message = this;
        boolean bl = false;
        Object object = component;
        if (object instanceof String) {
            $this$addTextComponent_u24lambda_u2d7.messageParts.add(new TextComponent((String)component));
        } else if (object instanceof TextComponent) {
            $this$addTextComponent_u24lambda_u2d7.messageParts.add((TextComponent)component);
        }
        return message;
    }

    @NotNull
    public final Message addTextComponent(int index, @NotNull Object component) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Message $this$addTextComponent_u24lambda_u2d8 = message = this;
        boolean bl = false;
        Object object = component;
        if (object instanceof String) {
            $this$addTextComponent_u24lambda_u2d8.messageParts.add(index, new TextComponent((String)component));
        } else if (object instanceof TextComponent) {
            $this$addTextComponent_u24lambda_u2d8.messageParts.add(index, (TextComponent)component);
        }
        return message;
    }

    @NotNull
    public final Message clone() {
        return this.copy();
    }

    @NotNull
    public final Message copy() {
        Object[] objectArray = new Object[]{this.messageParts};
        Message copy = new Message(objectArray).setChatLineId(this.chatLineId);
        copy.recursive = this.recursive;
        copy.formatted = this.formatted;
        return copy;
    }

    public final void edit(Message ... replacements) {
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        ChatLib.editChat(this, Arrays.copyOf(replacements, replacements.length));
    }

    public final void chat() {
        this.parseMessage();
        IChatComponent iChatComponent = this.chatMessage;
        if (iChatComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
            iChatComponent = null;
        }
        if (!ChatLib.INSTANCE.isPlayer(Intrinsics.stringPlus((String)"[CHAT]: ", (Object)iChatComponent.func_150254_d()))) {
            return;
        }
        if (this.chatLineId != -1) {
            GuiNewChat guiNewChat = Client.Companion.getChatGUI();
            if (guiNewChat != null) {
                IChatComponent iChatComponent2 = this.chatMessage;
                if (iChatComponent2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
                    iChatComponent2 = null;
                }
                guiNewChat.func_146234_a(iChatComponent2, this.chatLineId);
            }
            return;
        }
        if (this.recursive) {
            Client.Companion.scheduleTask$default(Client.Companion, 0, (Function0)new Function0<Unit>(this){
                final /* synthetic */ Message this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    NetHandlerPlayClient netHandlerPlayClient = Client.Companion.getConnection();
                    if (netHandlerPlayClient != null) {
                        IChatComponent iChatComponent = Message.access$getChatMessage$p(this.this$0);
                        if (iChatComponent == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
                            iChatComponent = null;
                        }
                        netHandlerPlayClient.func_147251_a(new S02PacketChat(iChatComponent, 0));
                    }
                }
            }, 1, null);
        } else {
            EntityPlayerSP entityPlayerSP = Player.getPlayer();
            if (entityPlayerSP != null) {
                IChatComponent iChatComponent3 = this.chatMessage;
                if (iChatComponent3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
                    iChatComponent3 = null;
                }
                entityPlayerSP.func_145747_a(iChatComponent3);
            }
        }
    }

    public final void actionBar() {
        this.parseMessage();
        IChatComponent iChatComponent = this.chatMessage;
        if (iChatComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
            iChatComponent = null;
        }
        if (!ChatLib.INSTANCE.isPlayer(Intrinsics.stringPlus((String)"[ACTION BAR]: ", (Object)iChatComponent.func_150254_d()))) {
            return;
        }
        NetHandlerPlayClient netHandlerPlayClient = Client.Companion.getConnection();
        if (netHandlerPlayClient != null) {
            IChatComponent iChatComponent2 = this.chatMessage;
            if (iChatComponent2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
                iChatComponent2 = null;
            }
            netHandlerPlayClient.func_147251_a(new S02PacketChat(iChatComponent2, 2));
        }
    }

    @NotNull
    public String toString() {
        return "Message{formatted=" + this.formatted + ", recursive=" + this.recursive + ", chatLineId=" + this.chatLineId + ", messageParts=" + this.messageParts + '}';
    }

    private final void parseMessage() {
        this.chatMessage = (IChatComponent)new ChatComponentText("");
        Iterable $this$forEach$iv = this.messageParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextComponent it = (TextComponent)element$iv;
            boolean bl = false;
            IChatComponent iChatComponent = this.chatMessage;
            if (iChatComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatMessage");
                iChatComponent = null;
            }
            iChatComponent.func_150257_a(it.getChatComponentText());
        }
    }

    public static final /* synthetic */ IChatComponent access$getChatMessage$p(Message $this) {
        return $this.chatMessage;
    }
}

