/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.objects.display;

import com.chattriggers.ctjs.minecraft.objects.display.DisplayHandler;
import com.chattriggers.ctjs.minecraft.objects.display.DisplayLine;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010 \u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001H\u0007J\u001f\u0010$\u001a\u00020\u00002\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010%\"\u00020\u0001\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0000J\u0015\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H \u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020\u0007J\u0006\u0010-\u001a\u00020\tJ\u0006\u0010.\u001a\u00020\u000bJ\u0006\u0010/\u001a\u00020\rJ\u000e\u00100\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001002J\u0006\u00103\u001a\u00020\rJ\u0006\u00104\u001a\u00020\u0013J\u0006\u00105\u001a\u00020\u0015J\u0006\u00106\u001a\u00020\rJ\u0006\u00107\u001a\u00020\rJ\u0006\u00108\u001a\u00020\u001dJ\u0006\u00109\u001a\u00020\u000bJ\u0006\u0010:\u001a\u00020\rJ\u0006\u0010;\u001a\u00020\u0000J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010B\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001J\u0014\u0010C\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100DJ\u000e\u0010E\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0001J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010H\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010I\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010K\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010M\u001a\u00020\u0000J\b\u0010N\u001a\u00020*H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/chattriggers/ctjs/minecraft/objects/display/Display;", "", "config", "Lorg/mozilla/javascript/NativeObject;", "(Lorg/mozilla/javascript/NativeObject;)V", "()V", "align", "Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$Align;", "background", "Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$Background;", "backgroundColor", "", "height", "", "lines", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayLine;", "minWidth", "order", "Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$Order;", "registerType", "Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$RegisterType;", "getRegisterType$ctjs", "()Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$RegisterType;", "setRegisterType$ctjs", "(Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$RegisterType;)V", "renderX", "renderY", "shouldRender", "", "textColor", "width", "addLine", "index", "", "line", "addLines", "", "([Ljava/lang/Object;)Lcom/chattriggers/ctjs/minecraft/objects/display/Display;", "clearLines", "createDisplayLine", "text", "", "createDisplayLine$ctjs", "getAlign", "getBackground", "getBackgroundColor", "getHeight", "getLine", "getLines", "", "getMinWidth", "getOrder", "getRegisterType", "getRenderX", "getRenderY", "getShouldRender", "getTextColor", "getWidth", "hide", "removeLine", "render", "", "setAlign", "setBackground", "setBackgroundColor", "setLine", "setLines", "", "setMinWidth", "setOrder", "setRegisterType", "setRenderLoc", "setRenderX", "setRenderY", "setShouldRender", "setTextColor", "show", "toString", "ctjs"})
public abstract class Display {
    @NotNull
    private CopyOnWriteArrayList<DisplayLine> lines = new CopyOnWriteArrayList();
    private float renderX;
    private float renderY;
    private boolean shouldRender = true;
    @NotNull
    private DisplayHandler.Order order = DisplayHandler.Order.DOWN;
    private long backgroundColor = 0x50000000L;
    private long textColor = 0xFFFFFFFFL;
    @NotNull
    private DisplayHandler.Background background = DisplayHandler.Background.NONE;
    @NotNull
    private DisplayHandler.Align align = DisplayHandler.Align.LEFT;
    private float minWidth;
    private float width;
    private float height;
    @NotNull
    private DisplayHandler.RegisterType registerType = DisplayHandler.RegisterType.RENDER_OVERLAY;

    public Display() {
        DisplayHandler.INSTANCE.registerDisplay(this);
    }

    @NotNull
    public final DisplayHandler.RegisterType getRegisterType$ctjs() {
        return this.registerType;
    }

    public final void setRegisterType$ctjs(@NotNull DisplayHandler.RegisterType registerType) {
        Intrinsics.checkNotNullParameter((Object)((Object)registerType), (String)"<set-?>");
        this.registerType = registerType;
    }

    public Display(@Nullable NativeObject config) {
        this();
        this.setBackgroundColor(Long.parseLong(ExtensionsKt.getOption(config, "backgroundColor", 0x50000000)));
        this.setTextColor(Long.parseLong(ExtensionsKt.getOption(config, "textColor", 0xFFFFFFFFL)));
        this.setBackground(ExtensionsKt.getOption(config, "background", (Object)DisplayHandler.Background.NONE));
        this.setAlign(ExtensionsKt.getOption(config, "align", (Object)DisplayHandler.Align.LEFT));
        this.setOrder(ExtensionsKt.getOption(config, "order", (Object)DisplayHandler.Order.DOWN));
        this.setRenderX(Float.parseFloat(ExtensionsKt.getOption(config, "renderX", Float.valueOf(0.0f))));
        this.setRenderY(Float.parseFloat(ExtensionsKt.getOption(config, "renderY", Float.valueOf(0.0f))));
        this.setShouldRender(Boolean.parseBoolean(ExtensionsKt.getOption(config, "shouldRender", true)));
        this.setMinWidth(Float.parseFloat(ExtensionsKt.getOption(config, "minWidth", Float.valueOf(0.0f))));
        this.setRegisterType(ExtensionsKt.getOption(config, "registerType", (Object)DisplayHandler.RegisterType.RENDER_OVERLAY));
    }

    public final long getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public final Display setBackgroundColor(long backgroundColor) {
        Display display;
        Display $this$setBackgroundColor_u24lambda_u2d0 = display = this;
        boolean bl = false;
        $this$setBackgroundColor_u24lambda_u2d0.backgroundColor = backgroundColor;
        return display;
    }

    public final long getTextColor() {
        return this.textColor;
    }

    @NotNull
    public final Display setTextColor(long textColor) {
        Display display;
        Display $this$setTextColor_u24lambda_u2d1 = display = this;
        boolean bl = false;
        $this$setTextColor_u24lambda_u2d1.textColor = textColor;
        return display;
    }

    @NotNull
    public final DisplayHandler.Background getBackground() {
        return this.background;
    }

    @NotNull
    public final Display setBackground(@NotNull Object background) {
        DisplayHandler.Background background2;
        Display display;
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Display $this$setBackground_u24lambda_u2d2 = display = this;
        boolean bl = false;
        Object object = background;
        if (object instanceof String) {
            String string = ((String)background).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            background2 = DisplayHandler.Background.valueOf(StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null));
        } else {
            background2 = object instanceof DisplayHandler.Background ? (DisplayHandler.Background)((Object)background) : DisplayHandler.Background.NONE;
        }
        $this$setBackground_u24lambda_u2d2.background = background2;
        return display;
    }

    @NotNull
    public final DisplayHandler.Align getAlign() {
        return this.align;
    }

    @NotNull
    public final Display setAlign(@NotNull Object align) {
        DisplayHandler.Align align2;
        Display display;
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        Display $this$setAlign_u24lambda_u2d3 = display = this;
        boolean bl = false;
        Object object = align;
        if (object instanceof String) {
            String string = ((String)align).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            align2 = DisplayHandler.Align.valueOf(string);
        } else {
            align2 = object instanceof DisplayHandler.Align ? (DisplayHandler.Align)((Object)align) : DisplayHandler.Align.LEFT;
        }
        $this$setAlign_u24lambda_u2d3.align = align2;
        return display;
    }

    @NotNull
    public final DisplayHandler.Order getOrder() {
        return this.order;
    }

    @NotNull
    public final Display setOrder(@NotNull Object order) {
        DisplayHandler.Order order2;
        Display display;
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Display $this$setOrder_u24lambda_u2d4 = display = this;
        boolean bl = false;
        Object object = order;
        if (object instanceof String) {
            String string = ((String)order).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            order2 = DisplayHandler.Order.valueOf(string);
        } else {
            order2 = object instanceof DisplayHandler.Order ? (DisplayHandler.Order)((Object)order) : DisplayHandler.Order.DOWN;
        }
        $this$setOrder_u24lambda_u2d4.order = order2;
        return display;
    }

    @NotNull
    public final Display setLine(int index, @NotNull Object line) {
        Display display;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Display $this$setLine_u24lambda_u2d5 = display = this;
        boolean bl = false;
        while ($this$setLine_u24lambda_u2d5.lines.size() - 1 < index) {
            $this$setLine_u24lambda_u2d5.lines.add($this$setLine_u24lambda_u2d5.createDisplayLine$ctjs(""));
        }
        Object object = line;
        $this$setLine_u24lambda_u2d5.lines.set(index, object instanceof String ? $this$setLine_u24lambda_u2d5.createDisplayLine$ctjs((String)line) : (object instanceof DisplayLine ? (DisplayLine)line : $this$setLine_u24lambda_u2d5.createDisplayLine$ctjs("")));
        return display;
    }

    @NotNull
    public final DisplayLine getLine(int index) {
        DisplayLine displayLine = this.lines.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)displayLine, (String)"lines[index]");
        return displayLine;
    }

    @NotNull
    public final List<DisplayLine> getLines() {
        return this.lines;
    }

    @NotNull
    public final Display setLines(@NotNull List<DisplayLine> lines) {
        Display display;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Display $this$setLines_u24lambda_u2d6 = display = this;
        boolean bl = false;
        $this$setLines_u24lambda_u2d6.lines = new CopyOnWriteArrayList(lines);
        return display;
    }

    @JvmOverloads
    @NotNull
    public final Display addLine(int index, @NotNull Object line) {
        DisplayLine toAdd;
        Display display;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Display $this$addLine_u24lambda_u2d7 = display = this;
        boolean bl = false;
        Object object = line;
        DisplayLine displayLine = object instanceof String ? $this$addLine_u24lambda_u2d7.createDisplayLine$ctjs((String)line) : (toAdd = object instanceof DisplayLine ? (DisplayLine)line : $this$addLine_u24lambda_u2d7.createDisplayLine$ctjs(""));
        if (index == -1) {
            $this$addLine_u24lambda_u2d7.lines.add(toAdd);
        } else {
            $this$addLine_u24lambda_u2d7.lines.add(index, toAdd);
        }
        return display;
    }

    public static /* synthetic */ Display addLine$default(Display display, int n, Object object, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addLine");
        }
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return display.addLine(n, object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Display addLines(Object ... lines) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Display display;
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Display $this$addLines_u24lambda_u2d9 = display = this;
        boolean bl = false;
        Object[] objectArray = lines;
        CopyOnWriteArrayList<DisplayLine> copyOnWriteArrayList = $this$addLines_u24lambda_u2d9.lines;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var17_17 = it;
            collection.add(var17_17 instanceof String ? $this$addLines_u24lambda_u2d9.createDisplayLine$ctjs((String)it) : (var17_17 instanceof DisplayLine ? (DisplayLine)it : $this$addLines_u24lambda_u2d9.createDisplayLine$ctjs("")));
        }
        copyOnWriteArrayList.addAll((List)destination$iv$iv);
        return display;
    }

    @NotNull
    public final Display removeLine(int index) {
        Display display;
        Display $this$removeLine_u24lambda_u2d10 = display = this;
        boolean bl = false;
        $this$removeLine_u24lambda_u2d10.lines.remove(index);
        return display;
    }

    @NotNull
    public final Display clearLines() {
        Display display;
        Display $this$clearLines_u24lambda_u2d11 = display = this;
        boolean bl = false;
        $this$clearLines_u24lambda_u2d11.lines.clear();
        return display;
    }

    public final float getRenderX() {
        return this.renderX;
    }

    @NotNull
    public final Display setRenderX(float renderX) {
        Display display;
        Display $this$setRenderX_u24lambda_u2d12 = display = this;
        boolean bl = false;
        $this$setRenderX_u24lambda_u2d12.renderX = renderX;
        return display;
    }

    public final float getRenderY() {
        return this.renderY;
    }

    @NotNull
    public final Display setRenderY(float renderY) {
        Display display;
        Display $this$setRenderY_u24lambda_u2d13 = display = this;
        boolean bl = false;
        $this$setRenderY_u24lambda_u2d13.renderY = renderY;
        return display;
    }

    @NotNull
    public final Display setRenderLoc(float renderX, float renderY) {
        Display display;
        Display $this$setRenderLoc_u24lambda_u2d14 = display = this;
        boolean bl = false;
        $this$setRenderLoc_u24lambda_u2d14.renderX = renderX;
        $this$setRenderLoc_u24lambda_u2d14.renderY = renderY;
        return display;
    }

    public final boolean getShouldRender() {
        return this.shouldRender;
    }

    @NotNull
    public final Display setShouldRender(boolean shouldRender) {
        Display display;
        Display $this$setShouldRender_u24lambda_u2d16 = display = this;
        boolean bl = false;
        $this$setShouldRender_u24lambda_u2d16.shouldRender = shouldRender;
        Iterable $this$forEach$iv = $this$setShouldRender_u24lambda_u2d16.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayLine it = (DisplayLine)element$iv;
            boolean bl2 = false;
            it.setShouldRender$ctjs(shouldRender);
        }
        return display;
    }

    @NotNull
    public final Display show() {
        Display display;
        Display $this$show_u24lambda_u2d17 = display = this;
        boolean bl = false;
        $this$show_u24lambda_u2d17.setShouldRender(true);
        return display;
    }

    @NotNull
    public final Display hide() {
        Display display;
        Display $this$hide_u24lambda_u2d18 = display = this;
        boolean bl = false;
        $this$hide_u24lambda_u2d18.setShouldRender(false);
        return display;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getMinWidth() {
        return this.minWidth;
    }

    @NotNull
    public final Display setMinWidth(float minWidth) {
        Display display;
        Display $this$setMinWidth_u24lambda_u2d19 = display = this;
        boolean bl = false;
        $this$setMinWidth_u24lambda_u2d19.minWidth = minWidth;
        return display;
    }

    @NotNull
    public final DisplayHandler.RegisterType getRegisterType() {
        return this.registerType;
    }

    @NotNull
    public final Display setRegisterType(@NotNull Object registerType) {
        DisplayHandler.RegisterType registerType2;
        Display display;
        Intrinsics.checkNotNullParameter((Object)registerType, (String)"registerType");
        Display $this$setRegisterType_u24lambda_u2d20 = display = this;
        boolean bl = false;
        Object object = registerType;
        if (object instanceof String) {
            String string = ((String)registerType).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            registerType2 = DisplayHandler.RegisterType.valueOf(StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null));
        } else {
            registerType2 = object instanceof DisplayHandler.RegisterType ? (DisplayHandler.RegisterType)((Object)registerType) : DisplayHandler.RegisterType.RENDER_OVERLAY;
        }
        $this$setRegisterType_u24lambda_u2d20.setRegisterType$ctjs(registerType2);
        return display;
    }

    public final void render() {
        Float f;
        if (!this.shouldRender) {
            return;
        }
        Iterable iterable = this.lines;
        Display display = this;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            f = null;
        } else {
            DisplayLine it22 = (DisplayLine)iterator.next();
            boolean bl = false;
            float it22 = it22.getTextWidth();
            while (iterator.hasNext()) {
                DisplayLine it32 = (DisplayLine)iterator.next();
                $i$a$-maxOfOrNull-Display$render$1 = false;
                float it32 = it32.getTextWidth();
                it22 = Math.max(it22, it32);
            }
            f = Float.valueOf(it22);
        }
        Float f2 = f == null ? null : Float.valueOf(RangesKt.coerceAtLeast((float)f.floatValue(), (float)this.minWidth));
        display.width = f2 == null ? this.minWidth : f2.floatValue();
        float i = 0.0f;
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayLine it = (DisplayLine)element$iv;
            boolean bl = false;
            it.draw(this.renderX, this.renderY + i, this.width, this.background, this.backgroundColor, this.textColor, this.align);
            switch (WhenMappings.$EnumSwitchMapping$0[this.order.ordinal()]) {
                case 1: {
                    i += it.getText().getHeight();
                    break;
                }
                case 2: {
                    i -= it.getText().getHeight();
                }
            }
        }
        this.height = i;
    }

    @NotNull
    public abstract DisplayLine createDisplayLine$ctjs(@NotNull String var1);

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Display{shouldRender=").append(this.shouldRender).append(", registerType=").append((Object)this.registerType).append(", renderX=").append(this.renderX).append(", renderY=").append(this.renderY).append(", background=").append((Object)this.background).append(", backgroundColor=").append(this.backgroundColor).append(", textColor=").append(this.textColor).append(", align=").append((Object)this.align).append(", order=").append((Object)this.order).append(", minWidth=").append(this.minWidth).append(", width=").append(this.width).append(", height=");
        stringBuilder.append(this.height).append(", lines=").append(this.lines).append('}');
        return stringBuilder.toString();
    }

    @JvmOverloads
    @NotNull
    public final Display addLine(@NotNull Object line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return Display.addLine$default(this, 0, line, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisplayHandler.Order.values().length];
            nArray[DisplayHandler.Order.DOWN.ordinal()] = 1;
            nArray[DisplayHandler.Order.UP.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

