/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.objects;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.minecraft.wrappers.Client;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.minecraft.wrappers.World;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeObject;
import paulscode.sound.SoundSystem;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0011J\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010%\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/chattriggers/ctjs/minecraft/objects/Sound;", "", "config", "Lorg/mozilla/javascript/NativeObject;", "(Lorg/mozilla/javascript/NativeObject;)V", "isListening", "", "()Z", "setListening", "(Z)V", "sndSystem", "Lpaulscode/sound/SoundSystem;", "source", "", "bootstrap", "", "getPitch", "", "getVolume", "loadSndSystem", "onWorldLoad", "pause", "play", "rewind", "setAttenuation", "model", "", "setCategory", "category", "setPitch", "pitch", "setPosition", "x", "y", "z", "setVolume", "volume", "stop", "ctjs"})
public final class Sound {
    @NotNull
    private final NativeObject config;
    @Nullable
    private SoundSystem sndSystem;
    @NotNull
    private final String source;
    private boolean isListening;

    public Sound(@NotNull NativeObject config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        Object object = this.config.get("source");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        this.source = (String)object;
        if (World.isLoaded()) {
            this.loadSndSystem();
            try {
                this.bootstrap();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.isListening = true;
        }
        CTJS.INSTANCE.getSounds().add(this);
    }

    public final boolean isListening() {
        return this.isListening;
    }

    public final void setListening(boolean bl) {
        this.isListening = bl;
    }

    public final void onWorldLoad() {
        this.isListening = false;
        this.loadSndSystem();
        try {
            this.bootstrap();
        }
        catch (MalformedURLException exc) {
            exc.printStackTrace();
        }
    }

    private final void loadSndSystem() {
        SoundManager sndManager = Client.Companion.getMinecraft().func_147118_V().field_147694_f;
        String[] stringArray = new String[]{"sndSystem", "field_148620_e"};
        this.sndSystem = (SoundSystem)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)sndManager, (String[])stringArray);
    }

    private final void bootstrap() throws MalformedURLException {
        Object object = this.config.get("source");
        String string = object == null ? null : object.toString();
        if (string == null) {
            throw new IllegalArgumentException("Sound source is null.");
        }
        String source = string;
        Boolean bl = this.config.getOrDefault("priority", false);
        if (bl == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean priority = bl;
        Boolean bl2 = this.config.getOrDefault("loop", false);
        if (bl2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean loop = bl2;
        Boolean bl3 = this.config.getOrDefault("stream", false);
        if (bl3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean stream = bl3;
        URL url = new File(CTJS.INSTANCE.getAssetsDir(), source).toURI().toURL();
        Double d = this.config.getOrDefault("x", Player.getX());
        if (d == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        float x = ((Number)d).floatValue();
        Double d2 = this.config.getOrDefault("y", Player.getY());
        if (d2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        float y = ((Number)d2).floatValue();
        Double d3 = this.config.getOrDefault("z", Player.getZ());
        if (d3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        float z = ((Number)d3).floatValue();
        Integer n = this.config.getOrDefault("attenuation", 1);
        if (n == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        int attModel = ((Number)n).intValue();
        int distOrRoll = 16;
        if (stream) {
            SoundSystem soundSystem = this.sndSystem;
            Intrinsics.checkNotNull((Object)soundSystem);
            soundSystem.newStreamingSource(priority, source, url, source, loop, x, y, z, attModel, (float)distOrRoll);
        } else {
            SoundSystem soundSystem = this.sndSystem;
            Intrinsics.checkNotNull((Object)soundSystem);
            soundSystem.newSource(priority, source, url, source, loop, x, y, z, attModel, (float)distOrRoll);
        }
        if (this.config.get("volume") != null) {
            Object object2 = this.config.get("volume");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            this.setVolume(((Number)object2).floatValue());
        }
        if (this.config.get("pitch") != null) {
            Object object3 = this.config.get("pitch");
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            this.setPitch(((Number)object3).floatValue());
        }
        if (this.config.get("category") != null) {
            Object object4 = this.config.get("category");
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            this.setCategory((String)object4);
        }
    }

    @NotNull
    public final Sound setCategory(@NotNull String category) {
        Sound sound2;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Sound $this$setCategory_u24lambda_u2d0 = sound2 = this;
        boolean bl = false;
        String string = category.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        SoundCategory category1 = SoundCategory.func_147154_a((String)string);
        $this$setCategory_u24lambda_u2d0.setVolume(Client.Companion.getMinecraft().field_71474_y.func_151438_a(category1));
        return sound2;
    }

    @NotNull
    public final Sound setVolume(float volume) {
        Sound sound2;
        Sound $this$setVolume_u24lambda_u2d1 = sound2 = this;
        boolean bl = false;
        SoundSystem soundSystem = $this$setVolume_u24lambda_u2d1.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.setVolume($this$setVolume_u24lambda_u2d1.source, volume);
        return sound2;
    }

    public final float getVolume() {
        SoundSystem soundSystem = this.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        return soundSystem.getVolume(this.source);
    }

    @NotNull
    public final Sound setPosition(float x, float y, float z) {
        Sound sound2;
        Sound $this$setPosition_u24lambda_u2d2 = sound2 = this;
        boolean bl = false;
        SoundSystem soundSystem = $this$setPosition_u24lambda_u2d2.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.setPosition($this$setPosition_u24lambda_u2d2.source, x, y, z);
        return sound2;
    }

    @NotNull
    public final Sound setPitch(float pitch) {
        Sound sound2;
        Sound $this$setPitch_u24lambda_u2d3 = sound2 = this;
        boolean bl = false;
        SoundSystem soundSystem = $this$setPitch_u24lambda_u2d3.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.setPitch($this$setPitch_u24lambda_u2d3.source, pitch);
        return sound2;
    }

    public final float getPitch() {
        SoundSystem soundSystem = this.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        return soundSystem.getPitch(this.source);
    }

    @NotNull
    public final Sound setAttenuation(int model) {
        Sound sound2;
        Sound $this$setAttenuation_u24lambda_u2d4 = sound2 = this;
        boolean bl = false;
        SoundSystem soundSystem = $this$setAttenuation_u24lambda_u2d4.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.setAttenuation($this$setAttenuation_u24lambda_u2d4.source, model);
        return sound2;
    }

    public final void play() {
        SoundSystem soundSystem = this.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.play(this.source);
    }

    public final void pause() {
        SoundSystem soundSystem = this.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.pause(this.source);
    }

    public final void stop() {
        SoundSystem soundSystem = this.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.stop(this.source);
    }

    public final void rewind() {
        SoundSystem soundSystem = this.sndSystem;
        Intrinsics.checkNotNull((Object)soundSystem);
        soundSystem.rewind(this.source);
    }
}

